
STRINGS = GLOBAL.STRINGS
RECIPETABS = GLOBAL.RECIPETABS
Ingredient = GLOBAL.Ingredient
TECH = GLOBAL.TECH
Recipe = GLOBAL.Recipe
TUNING = GLOBAL.TUNING

--prefabs names and descriptions
modimport("init/init_names")
modimport("init/init_descriptions")

--prefabs assets
modimport("init/init_prefabs")
modimport("init/init_assets")
modimport("init/minimap_icons")

local require = GLOBAL.require
local AllRecipes = GLOBAL.AllRecipes
local GetValidRecipe = GLOBAL.GetValidRecipe
local RECIPETABS = GLOBAL.RECIPETABS
local GROUND = GLOBAL.GROUND
local SpawnPrefab = GLOBAL.SpawnPrefab

--crafting and crock pot
modimport("init/init_recipes")
modimport("init/init_cookpotrecipes")

--tuning
TUNING.CHERRYLING_CANSPAWN = GetModConfigData("cherryling_spawn")
TUNING.CHERRYPETALS = GetModConfigData("cherrytree_petals")
TUNING.CHERRYTREE_SIZE = GetModConfigData("cherrytree_size")

--cherry turf
local MOD_GROUND_TURFS = {
	[GROUND.CHERRY] = "turf_cherry",
}

local Terraformer = require("components/terraformer")
local OldTerraform = Terraformer.Terraform or function() return false end

local function SpawnTurf(turf, pt)
if turf ~= nil then
local loot = SpawnPrefab(turf)

if loot.components.inventoryitem ~= nil then
loot.components.inventoryitem:InheritMoisture(GLOBAL.TheWorld.state.wetness, GLOBAL.TheWorld.state.iswet)
end

loot.Transform:SetPosition(pt:Get())

if loot.Physics ~= nil then
local angle = math.random() * 2 * GLOBAL.PI
loot.Physics:SetVel(2 * math.cos(angle), 10, 2 * math.sin(angle))
end
end
end

function Terraformer:Terraform(pt, spawnturf)
local Map = GLOBAL.TheWorld.Map

if not Map:CanTerraformAtPoint(pt:Get()) then
return false
end

local original_tile_type = Map:GetTileAtPoint(pt:Get())

if OldTerraform(self, pt, spawnturf) then
local turfPrefab = MOD_GROUND_TURFS[original_tile_type]

if spawnturf and turfPrefab ~= nil then
SpawnTurf(turfPrefab, pt)
end

return true
end

return false
end