modimport("tile_adder.lua")

local grasscherry = (GetModConfigData("turf_style")=="grasscherry")
local pinkcherry = (GetModConfigData("turf_style")=="pinkcherry")

if grasscherry then

	AddTile(
	"CHERRY",
	95,
	"cherry",
	{
		noise_texture = "levels/textures/noise_grasscherry.tex",
		runsound = "dontstarve/movement/walk_grass",
		walksound = "dontstarve/movement/walk_grass",
		snowsound = "dontstarve/movement/run_snow",
		mudsound = "dontstarve/movement/run_mud",
	},
		{noise_texture = "levels/textures/mini_noise_grasscherry.tex"}
)

end

if pinkcherry then

	AddTile(
	"CHERRY",
	95,
	"cherry",
	{
		noise_texture = "levels/textures/noise_pinkcherry.tex",
		runsound = "dontstarve/movement/walk_grass",
		walksound = "dontstarve/movement/walk_grass",
		snowsound = "dontstarve/movement/run_snow",
		mudsound = "dontstarve/movement/run_mud",
	},
		{noise_texture = "levels/textures/mini_noise_pinkcherry.tex"}
)

end

modimport("scripts/map/rooms/new_rooms")

local function LevelPreInit1(level)
	
	if level.location ~= "forest" then
		return
	end
	
	table.insert(level.tasks, "CherryBiome")
end

AddLevelPreInitAny(LevelPreInit1)

local tiny = (GetModConfigData("biome_size")=="tiny")
local lil = (GetModConfigData("biome_size")=="lil")
local normal = (GetModConfigData("biome_size")=="normal")
local large = (GetModConfigData("biome_size")=="large")

if tiny then
	AddTask("CherryBiome", {
		locks= LOCKS.NONE,
		keys_given={KEYS.TIER1, KEYS.TIER2, KEYS.TIER3},
			room_choices={ 
				["cherrybiome_forest"] = 1,
				["cherrybiome_plains"] = 1,
				["cherrybiome_fruitbat"] = 1,
			}, 
		room_bg=GROUND.CHERRY,
		background_room="cherrybiome_background",
		colour={r=1,g=0.6,b=1,a=1},
	})
end

if tiny then
	AddTask("CherryBiome", {
		locks= LOCKS.NONE,
		keys_given={KEYS.TIER1, KEYS.TIER2, KEYS.TIER3},
			room_choices={ 
				["cherrybiome_forest"] = 1,
				["cherrybiome_plains"] = 1,
				["cherrybiome_fruitbat"] = 1,
				["cherrybiome_village"] = 1,
			}, 
		room_bg=GROUND.CHERRY,
		background_room="cherrybiome_background",
		colour={r=1,g=0.6,b=1,a=1},
	})
end

if lil then
	AddTask("CherryBiome", {
		locks= LOCKS.NONE,
		keys_given={KEYS.TIER1, KEYS.TIER2, KEYS.TIER3},
			room_choices={ 
				["cherrybiome_forest"] = 2,
				["cherrybiome_plains"] = 2,
				["cherrybiome_fruitbat"] = 1,
				["cherrybiome_village"] = 1,
			}, 
		room_bg=GROUND.CHERRY,
		background_room="cherrybiome_background",
		colour={r=1,g=0.6,b=1,a=1},
	})
end

if normal then
	AddTask("CherryBiome", {
		locks= LOCKS.NONE,
		keys_given={KEYS.TIER1, KEYS.TIER2, KEYS.TIER3},
			room_choices={ 
				["cherrybiome_forest"] = 3,
				["cherrybiome_plains"] = 3,
				["cherrybiome_fruitbat"] = 1,
				["cherrybiome_village"] = 1,
			}, 
		room_bg=GROUND.CHERRY,
		background_room="cherrybiome_background",
		colour={r=1,g=0.6,b=1,a=1},
	})
end

if large then
	AddTask("CherryBiome", {
		locks= LOCKS.NONE,
		keys_given={KEYS.TIER1, KEYS.TIER2, KEYS.TIER3},
			room_choices={ 
				["cherrybiome_forest"] = 5,
				["cherrybiome_plains"] = 4,
				["cherrybiome_fruitbat"] = 2,
				["cherrybiome_village"] = 1,
			}, 
		room_bg=GROUND.CHERRY,
		background_room="cherrybiome_background",
		colour={r=1,g=0.6,b=1,a=1},
	})
end