local assets =
{
	Asset("IMAGE", "images/inventoryimages/cherry.tex"),
	Asset("ATLAS", "images/inventoryimages/cherry.xml"),
	
	Asset("IMAGE", "images/inventoryimages/cooked.tex"),
	Asset("ATLAS", "images/inventoryimages/cooked.xml"),
	
	Asset("ANIM", "anim/cherry.zip"),
}

local prefabs =
{
	"cherry_cooked",
    "spoiled_food",
	"cherry_sapling",
}

local function plant(inst, growtime)
	local sapling = SpawnPrefab("cherry_sapling")
	sapling:StartGrowing()
	sapling.Transform:SetPosition(inst.Transform:GetWorldPosition())
	sapling.SoundEmitter:PlaySound("dontstarve/wilson/plant_tree")
	inst:Remove()
end

local function ondeploy(inst, pt)
    inst = inst.components.stackable:Get()
    inst.Transform:SetPosition(pt:Get())
    local timeToGrow = GetRandomWithVariance(580, 680)
    plant(inst, timeToGrow)
end

local function OnLoad(inst, data)
    if data and data.growtime then
        plant(inst, data.growtime)
    end
end

local function fn()

    local inst = CreateEntity()
        inst.entity:AddTransform()
        inst.entity:AddAnimState()
        inst.entity:AddNetwork()
        MakeInventoryPhysics(inst)

        inst.AnimState:SetBank("cherry")
        inst.AnimState:SetBuild("cherry")
        inst.AnimState:PlayAnimation("idle")
	
	inst:AddTag("icebox_valid")
	inst:AddTag("show_spoilage")
	inst:AddTag("cookable")
	
    inst.entity:SetPristine()

    if not TheWorld.ismastersim then
        return inst
    end

    inst:AddComponent("edible")
    inst.components.edible.hungervalue = 9.375
	inst.components.edible.foodtype = FOODTYPE.VEGGIE
	inst.components.edible.healthvalue = 3
	inst.components.edible.sanityvalue = 0

    inst:AddComponent("stackable")
    inst.components.stackable.maxsize = TUNING.STACK_SIZE_SMALLITEM

    inst:AddComponent("inspectable")

	inst:AddComponent("cookable")
    inst.components.cookable.product = "cherry_cooked"

    inst:AddComponent("tradable")
	
    inst:AddComponent("perishable")
    inst.components.perishable:SetPerishTime(TUNING.PERISH_MED)
    inst.components.perishable:StartPerishing()
    inst.components.perishable.onperishreplacement = "spoiled_food"

    inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.imagename = "cherry"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/cherry.xml"
	
	inst:AddComponent("deployable")
    inst.components.deployable:SetDeployMode(DEPLOYMODE.PLANT)
    inst.components.deployable.ondeploy = ondeploy
	
	inst:AddComponent("bait")
	
	inst.OnLoad = OnLoad
	
    MakeHauntableLaunchAndPerish(inst)

    return inst
end


local function cooked()
	local inst = CreateEntity()

	inst.entity:AddTransform()
	inst.entity:AddAnimState()
	inst.entity:AddSoundEmitter()
	inst.entity:AddNetwork()

	MakeInventoryPhysics(inst)

	inst.AnimState:SetBank("cherry")
	inst.AnimState:SetBuild("cherry")
	inst.AnimState:PlayAnimation("cooked")

	inst.entity:SetPristine()

	if not TheWorld.ismastersim then
		return inst
	end

	inst:AddComponent("edible")
	inst.components.edible.hungervalue = 12.5
	inst.components.edible.foodtype = FOODTYPE.VEGGIE
	inst.components.edible.healthvalue = 8
	inst.components.edible.sanityvalue = 0

	inst:AddComponent("perishable")
	inst.components.perishable:SetPerishTime(TUNING.PERISH_FAST)
	inst.components.perishable:StartPerishing()
	inst.components.perishable.onperishreplacement = "spoiled_food"

	inst:AddComponent("stackable")
	inst.components.stackable.maxsize = TUNING.STACK_SIZE_SMALLITEM

	inst:AddComponent("inspectable")

	inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.imagename = "cooked"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/cooked.xml"

	MakeHauntableLaunch(inst)

	return inst
end

return Prefab("cherry", fn, assets, prefabs),
		Prefab("cherry_cooked", cooked, assets),
		MakePlacer("cherry_placer", "cherry", "cherry", "idle_planted")