local assets =
{
	Asset("IMAGE", "images/inventoryimages/cherry_cake.tex"),
	Asset("ATLAS", "images/inventoryimages/cherry_cake.xml"),
	Asset("ANIM", "anim/cherry_cake.zip"),
}

local prefabs =
{
    "spoiled_food",
}

local function fn()

    local inst = CreateEntity()
        inst.entity:AddTransform()
        inst.entity:AddAnimState()
        inst.entity:AddNetwork()
        MakeInventoryPhysics(inst)

        inst.AnimState:SetBank("cherry_cake")
        inst.AnimState:SetBuild("cherry_cake")
        inst.AnimState:PlayAnimation("idle")
	
    inst.entity:SetPristine()

    if not TheWorld.ismastersim then
        return inst
    end

    inst:AddComponent("edible")
    inst.components.edible.hungervalue = 37.5
	inst.components.edible.healthvalue = 20
	inst.components.edible.sanityvalue = 20
	inst.components.edible.foodtype = FOODTYPE.VEGGIE

    inst:AddComponent("stackable")
    inst.components.stackable.maxsize = TUNING.STACK_SIZE_SMALLITEM

    inst:AddComponent("tradable")

    inst:AddComponent("inspectable")

    inst:AddComponent("perishable")
    inst.components.perishable:SetPerishTime(TUNING.PERISH_MED)
    inst.components.perishable:StartPerishing()
    inst.components.perishable.onperishreplacement = "spoiled_food"

    inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.atlasname = "images/inventoryimages/cherry_cake.xml"
	
    MakeHauntableLaunchAndPerish(inst)

    return inst
end

return Prefab("cherry_cake", fn, assets, prefabs)