local assets =
{
    Asset("ANIM", "anim/cherry_leaves.zip"),
}

local names = {"f1","f2","f3"}

local function onsave(inst, data)
    data.anim = inst.animname
end

local function onload(inst, data)
    if data and data.anim then
        inst.animname = data.anim
        inst.AnimState:PlayAnimation(inst.animname)
    end
end

local function fn()
    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddSoundEmitter()
    inst.entity:AddNetwork()

    MakeInventoryPhysics(inst)

    inst.AnimState:SetBank("cherry_leaves")
    inst.AnimState:SetBuild("cherry_leaves")
	inst.AnimState:SetOrientation(ANIM_ORIENTATION.OnGround)
    inst.AnimState:SetLayer(LAYER_BACKGROUND)
    inst.AnimState:SetSortOrder(3)

    inst:SetDeployExtraSpacing(2)
	
	inst.Transform:SetScale(2.5, 2.5, 2.5)

    inst.entity:SetPristine()

    if not TheWorld.ismastersim then
        return inst
    end

	inst:AddTag("FX")

    inst.animname = names[math.random(#names)]
    inst.AnimState:PlayAnimation(inst.animname)

	

    MakeHauntableLaunchAndSmash(inst)

    inst.OnSave = onsave 
    inst.OnLoad = onload 
    return inst
end

return Prefab("cherry_leaves", fn, assets)
