local assets =
{
	Asset("IMAGE", "images/inventoryimages/cherrygem.tex"),
	Asset("ATLAS", "images/inventoryimages/cherrygem.xml"),
	
	Asset("IMAGE", "images/inventoryimages/cooked.tex"),
	Asset("ATLAS", "images/inventoryimages/cooked.xml"),
	
	Asset("ANIM", "anim/cherrygem.zip"),
}

local prefabs =
{
	"cherrygem_sapling",
}

local function plant(inst, growtime)
	local sapling = SpawnPrefab("cherrygem_sapling")
	sapling:StartGrowing()
	sapling.Transform:SetPosition(inst.Transform:GetWorldPosition())
	sapling.SoundEmitter:PlaySound("dontstarve/wilson/plant_tree")
	inst:Remove()
end

local function ondeploy(inst, pt)
    inst = inst.components.stackable:Get()
    inst.Transform:SetPosition(pt:Get())
    local timeToGrow = GetRandomWithVariance(5800, 6800)
    plant(inst, timeToGrow)
end

local function OnLoad(inst, data)
    if data and data.growtime then
        plant(inst, data.growtime)
    end
end

local function fn()

    local inst = CreateEntity()
        inst.entity:AddTransform()
        inst.entity:AddAnimState()
        inst.entity:AddNetwork()
        MakeInventoryPhysics(inst)

        inst.AnimState:SetBank("cherrygem")
        inst.AnimState:SetBuild("cherrygem")
        inst.AnimState:PlayAnimation("idle")

	inst:AddTag("molebait")
	inst:AddTag("quakedebris")
		
    inst.entity:SetPristine()

    if not TheWorld.ismastersim then
        return inst
    end

    inst:AddComponent("edible")
    inst.components.edible.hungervalue = 1
	inst.components.edible.foodtype = FOODTYPE.ELEMENTAL

    inst:AddComponent("stackable")
    inst.components.stackable.maxsize = TUNING.STACK_SIZE_SMALLITEM

    inst:AddComponent("inspectable")

    inst:AddComponent("tradable")

    inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.imagename = "cherrygem"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/cherrygem.xml"
	
	inst:AddComponent("deployable")
    inst.components.deployable:SetDeployMode(DEPLOYMODE.PLANT)
    inst.components.deployable.ondeploy = ondeploy
	
	inst:AddComponent("bait")
	
	inst.OnLoad = OnLoad
	
    MakeHauntableLaunchAndPerish(inst)

    return inst
end

return Prefab("cherrygem", fn, assets, prefabs),
		MakePlacer("cherrygem_placer", "cherrygem", "cherrygem", "idle_planted")