local default_callback = function(book, screen)
	--properly close the screen
	GLOBAL.TheFrontEnd:PopScreen(screen)
	if not screen.was_paused then
		GLOBAL.SetPause(false)
	end
	GLOBAL.GetWorld():PushEvent("continuefrompause")
end

local function SpawnNear(prefab, target)
	local inst = GLOBAL.SpawnPrefab(prefab)
	if inst and inst.Transform then
		local theta = math.random() * 2 * GLOBAL.PI
		local pt = target:GetPosition()
		local radius = math.random() * 1.5 + 1
		local offset = GLOBAL.FindWalkableOffset(pt, theta, radius, 12, true)
		if offset then
			pt = pt + offset
		end
		inst.Transform:SetPosition(pt:Get())
		if inst.components.follower then
			inst.components.follower:SetLeader(target)
		end
		return inst
	end
end

local function getowner(book)
	return book and book.components.inventoryitem
	and book.components.inventoryitem.owner or GLOBAL.GetPlayer()
end

--TODO change so these dont grab the owner unnecessarily
local function GetOwnerShadowiness(book)
	local wilfre = getowner(book)
	if wilfre and wilfre.components.shadowable then
		return wilfre.components.shadowable.current
	end
end

local function GetOwnerSanity(book)
	local wilfre = getowner(book)
	if wilfre and wilfre.components.sanity then
		return wilfre.components.sanity.current
	end
end

local function GetOwnerHasItem(book, item, num)
	local wilfre = getowner(book)
	if wilfre and wilfre.components.inventory then
		return wilfre.components.inventory:Has(item, num or 1)
	end
end

local function DoOwnerSanityDelta(book, val)
	local wilfre = getowner(book)
	if wilfre and wilfre.components.sanity then
		wilfre.components.sanity:DoDelta(val)
	end
end

local function DoOwnerShadowinessDelta(book, val)
	local wilfre = getowner(book)
	if wilfre and wilfre.components.shadowable then
		wilfre.components.shadowable:DoDelta(val)
	end
end

local function DoOwnerConsumeItem(book, item, num)
	local wilfre = getowner(book)
	if wilfre and wilfre.components.inventory then
		wilfre.components.inventory:ConsumeByName(item, num or 1)
	end
end

GLOBAL.WILFRE_PAGE_DATA = {
	
	SPIDER = {
		-- Callback
		function(book, screen)
			local wilfre = getowner(book)
			local minion = SpawnNear("spider_wilfre",wilfre)
			minion.sg:GoToState("born")
			GLOBAL.SpawnAt("statue_transition_2", minion)
			DoOwnerSanityDelta(book, -TUNING.SANITY_MED)
			default_callback(book, screen)
		end,
		-- Condition
		function(book)
			local sanity = GetOwnerSanity(book)
			return sanity >= TUNING.SANITY_MED
		end
	},
	
	RESEARCHLAB = {
		-- Callback
		function(book, screen)
			local wilfre = getowner(book)
			local minion = SpawnNear("researchlab_wilfre",wilfre)
			minion:PushEvent("onbuilt")
			DoOwnerSanityDelta(book, -TUNING.SANITY_SMALL)
			DoOwnerConsumeItem(book, "nightmarefuel", 1)
			default_callback(book, screen)
		end,
		-- Condition
		function(book)
			return GetOwnerHasItem(book, "nightmarefuel", 1)
		end
	},
	
	MULTITOOL = {
		-- Callback
		function(book, screen)
			local wilfre = getowner(book)
			local minion = GLOBAL.SpawnAt("multitool_wilfre",wilfre)
			if wilfre.components.inventory then
				wilfre.components.inventory:GiveItem(minion)
			end
			minion:PushEvent("onbuilt")
			DoOwnerShadowinessDelta(book, -TUNING.SHADOWINESS.SMALL)
			DoOwnerConsumeItem(book, "nightmarefuel", 1)
			default_callback(book, screen)
		end,
		-- Condition
		function(book)
			local shadowiness = GetOwnerShadowiness(book)
			return GetOwnerHasItem(book, "nightmarefuel", 1)
			and shadowiness >= TUNING.SHADOWINESS.SMALL
		end
	},
	
	BAT = {
		-- Callback
		function(book, screen)
			local wilfre = getowner(book)
			local minion = SpawnNear("bat_wilfre",wilfre)
			minion.sg:GoToState("born")
			GLOBAL.SpawnAt("statue_transition_2", minion)
			
			DoOwnerConsumeItem(book, "nightmarefuel", 1)
			DoOwnerSanityDelta(book, -TUNING.SANITY_SMALL)
			DoOwnerShadowinessDelta(book, TUNING.SHADOWINESS.TINY)
			
			default_callback(book, screen)
		end,
		-- Condition
		function(book)
			return GetOwnerHasItem(book, "nightmarefuel", 1)
		end
	},
	
	TURRET = {
		-- Callback
		function(book, screen)
			local wilfre = getowner(book)
			local minion = GLOBAL.SpawnAt("turret_wilfre",wilfre)
			--minion.components.follower:SetLeader(wilfre)
			GLOBAL.SpawnAt("statue_transition_2", minion)
			
			DoOwnerConsumeItem(book, "nightmarefuel", 2)
			DoOwnerSanityDelta(book, -TUNING.SANITY_TINY)
			
			default_callback(book, screen)
		end,
		-- Condition
		function(book)
			local wilfre = getowner(book)
			local ent = GLOBAL.FindEntity(wilfre,2,nil,{"turret_wilfre"})
			return GetOwnerHasItem(book, "nightmarefuel", 2)
			and not ent
		end
	},
	
}
