-- PRE-AMBLE
-------------------------------------------------------

-- This modification, created by "Mobbstar",
-- for the game "Don't Starve", created by "Klei Entertainment",
-- does not use assets (such as images) created by "5th Cell Media".
-- Some images are created by Agustin Val

-- PRE-LOAD
-------------------------------------------------------

local require = GLOBAL.require
local STRINGS = GLOBAL.STRINGS

local PersistentData = require("persistentdata")
local ModDependency = require("moddependency")

ModDependency.AddDependency(modname, "tok")
ModDependency.SetAltName("Tomes of Knowledge","tok")

if not ModDependency.IsModReady(modname) then return end

local assert = GLOBAL.assert
local io = GLOBAL.io
local scheduler = GLOBAL.scheduler
local Lerp = GLOBAL.Lerp
local json = GLOBAL.json
local ImageButton = require("widgets/imagebutton")
local WilfrePageListDialog = require("screens/wilfrepagelistdialog")
local GuideScreen = require("screens/modguide_screen")

--modimport("strings.lua")
--modimport("tuning.lua")
--modimport("lifepages.lua")

-- ASSETS
-------------------------------------------------------

PrefabFiles = {
	"wilfre",
	"wilfre_page",
	"spider_wilfre",
	"researchlab_wilfre",
	"multitool_wilfre",
	"worm_wilfre",
	"bat_wilfre",
	"marbletree_wilfre",
	"turret_wilfre",
	--"shadowgoofx",
}

Assets = {
    Asset( "IMAGE", "images/saveslot_portraits/wilfre.tex" ),
    Asset( "ATLAS", "images/saveslot_portraits/wilfre.xml" ),
    Asset( "IMAGE", "images/selectscreen_portraits/wilfre.tex" ),
    Asset( "ATLAS", "images/selectscreen_portraits/wilfre.xml" ),
    Asset( "IMAGE", "images/selectscreen_portraits/wilfre_silho.tex" ),
    Asset( "ATLAS", "images/selectscreen_portraits/wilfre_silho.xml" ),
    Asset( "IMAGE", "bigportraits/wilfre.tex" ),
    Asset( "ATLAS", "bigportraits/wilfre.xml" ),
	Asset( "IMAGE", "images/map_icons/wilfre.tex" ),
	Asset( "ATLAS", "images/map_icons/wilfre.xml" ),
	
	Asset( "IMAGE", "images/colour_cubes/wilfre_cc.tex" ),
	
	Asset( "IMAGE", "images/wilfre_book.tex" ),
	Asset( "ATLAS", "images/wilfre_book.xml" ),
	Asset( "IMAGE", "images/wilfre_book_big.tex" ),
	Asset( "ATLAS", "images/wilfre_book_big.xml" ),
	
	Asset( "SOUND", "sound/wilfre.fsb" ),
	Asset( "SOUNDPACKAGE", "sound/wilfre.fev" ),
}

-- BOOK/PAGES OF LIFE
-------------------------------------------------------

local DataContainer = PersistentData("wilfre")
--GLOBAL.WilfrePagesUnlocked = {SPIDER = true}

--AddGamePostInit(function()
	DataContainer:Load()
	GLOBAL.WilfrePagesUnlocked = DataContainer:GetValue("pages") or {SPIDER = true}
	
	--write file for worldgen workaround
	local file = assert(io.open(MODROOT .."temp-wilfrepages.txt", "w"))
    file:write(json.encode(GLOBAL.WilfrePagesUnlocked))
	file:close()
--end)

-- Imports all assets for us
GLOBAL.MakeTome("wilfre_book",nil,"wilfre_book","wilfre_book",false,nil,{},false,true)

local function AddEntryToBook(inst,entry)
	if GLOBAL.WILFRE_PAGE_DATA[entry] then
		table.insert(inst.toc,{
			name = GLOBAL.STRINGS.WILFRE_PAGES[entry],
			hover = function(inst, enabled)
				return not enabled and GLOBAL.STRINGS.WILFRE_PAGE_HINTS[entry]
			end,
			cb = GLOBAL.WILFRE_PAGE_DATA[entry][1],
			condition = GLOBAL.WILFRE_PAGE_DATA[entry][2],
		})
	else
		print("Undefined Page of Life!",entry)
	end
end

local function book_OnSave(inst,data)
	-- In case of several instances, no harm is done
	DataContainer:SetValue("pages", GLOBAL.WilfrePagesUnlocked)
	DataContainer:Save()
end

local function book_OnLoad(inst,data)
	-- This adds the global entries to the individual instance
	if #inst.toc < 1 then
		for k,v in pairs(GLOBAL.WilfrePagesUnlocked) do
			AddEntryToBook(inst,k)
		end
	end
end

local function TryUnlockAll(inst, player)
	if player and player.prefab == "wilfre" then
		local items = player.components.inventory:FindItems(function(item) 
			return item:HasTag("wilfre_page")
		end)
		for k,v in pairs(items) do
			if v.pagename and not GLOBAL.WilfrePagesUnlocked[ v.pagename ] then
				GLOBAL.WilfrePagesUnlocked[ v.pagename ] = true
				AddEntryToBook(inst, v.pagename)
			end
			player.components.inventory:RemoveItem(v)
			v:Remove()
		end
	end
end

AddPrefabPostInit("wilfre_book",function(inst)
	
	-- Do not override the original function, who knows how important it may be
	local old_OnSave = inst.OnSave
	inst.OnSave = function(inst,data)
		old_OnSave(inst,data)
		book_OnSave(inst,data)
	end
	book_OnLoad(inst,data) -- This happens after load anyways
	
	inst.AddEntry = AddEntryToBook
	
	inst.components.inventoryitem:SetOnPutInInventoryFn(TryUnlockAll)
	
	--local old_onusefn = inst.components.useableitem.onusefn
	inst.components.useableitem.onusefn = function(inst)
		local owner = inst.components.inventoryitem:GetGrandOwner()
		if owner then
			owner.sg:GoToState("wilfrebook")
			owner.sg.statemem.book = inst
		end
		--return old_onusefn(inst)
	end
	inst.components.useableitem.caninteractfn = function()
		local player = inst.components.inventoryitem.owner or GLOBAL.GetPlayer()
		return player and player.prefab == "wilfre"
	end
	
    inst:AddComponent("characterspecific")
	inst.components.characterspecific:SetOwner("wilfre")
end)

AddStategraphState("wilson", GLOBAL.State{
	name = "wilfrebook",
	tags = {"doing"},
	
	onenter = function(inst)
		inst.components.locomotor:Stop()
		inst.AnimState:PlayAnimation("book")
		
		inst.AnimState:OverrideSymbol("book_open", "player_actions_uniqueitem", "book_open")
		inst.AnimState:OverrideSymbol("book_closed", "wilfre_book", "book_closed")
		inst.AnimState:OverrideSymbol("book_open_pages", "player_actions_uniqueitem", "book_open_pages")
		
		inst.AnimState:Show("ARM_normal")
		inst.SoundEmitter:PlaySound("dontstarve/common/use_book", "book")
	end,
	
	onexit = function(inst)
		inst.SoundEmitter:KillSound("book")
		if inst.components.inventory:GetEquippedItem(GLOBAL.EQUIPSLOTS.HANDS) then
			inst.AnimState:Show("ARM_carry") 
			inst.AnimState:Hide("ARM_normal")
		end
	end,
	
	timeline=
	{
		GLOBAL.TimeEvent(58 * GLOBAL.FRAMES, function(inst)
			if inst.HUD then
				GLOBAL.TheFrontEnd:PushScreen(GuideScreen(inst.sg.statemem.book))
				inst.sg.statemem.book = nil
			end
		end),

		GLOBAL.TimeEvent(62 * GLOBAL.FRAMES, function(inst) 
			inst.SoundEmitter:PlaySound("dontstarve/common/use_book_close")
		end),
	},
	
	events=
	{
		GLOBAL.EventHandler("animover", function(inst)
			inst.sg:GoToState("idle")
		end),
	},
})

-- OTHER CODE
-------------------------------------------------------

local function ShadowAura(val)
	return function(inst)
		inst:AddComponent("shadowaura")
		inst.components.shadowaura:SetAura(val)
	end
end

local function AuraBySanity(inst,player)
	local percent = player.components.sanity:GetPercent()
	if percent < .6 then
		return Lerp(TUNING.SHADOWAURA.MED, 0, percent * .6 )
	end
	return 0
end

local function AuraByFueled(inst,player)
	return TUNING.SHADOWAURA.LARGE * inst.components.fueled:GetPercent()
end

AddPrefabPostInit("crawlinghorror", ShadowAura(AuraBySanity))
AddPrefabPostInit("terrorbeak", ShadowAura(AuraBySanity))
AddPrefabPostInit("crawlingnightmare", ShadowAura(TUNING.SHADOWAURA.SMALL))
AddPrefabPostInit("nightmarebeak", ShadowAura(TUNING.SHADOWAURA.MED))
AddPrefabPostInit("shadowhand", ShadowAura(TUNING.SHADOWAURA.MED))
AddPrefabPostInit("flower_evil", ShadowAura(TUNING.SHADOWAURA.TINY))
AddPrefabPostInit("armor_sanity", ShadowAura(TUNING.SHADOWAURA.TINY))
AddPrefabPostInit("nightsword", ShadowAura(TUNING.SHADOWAURA.TINY))
AddPrefabPostInit("nightlight", ShadowAura(AuraByFueled))

AddComponentPostInit("edible",function(self)
    self.shadowvalue = 0
	function self:GetShadow(eater)
		local multiplier = 1
		local ignore_spoilage = eater and eater.components.eater and eater.components.eater.ignoresspoilage
		
		if self.inst.components.perishable and not ignore_spoilage then
			if self.inst.components.perishable:IsStale() then
				multiplier = (eater and eater.components.eater and eater.components.eater.stale_shadow)
					or self.stale_shadow
					or .7
			elseif self.inst.components.perishable:IsSpoiled() then
				multiplier = (eater and eater.components.eater and eater.components.eater.spoiled_shadow)
					or self.spoiled_shadow
					or .3
			end
		end
		
		return multiplier * self.shadowvalue
	end
end)
AddComponentPostInit("eater",function(self)
	local old_Eat = self.Eat
	function self:Eat(food,...)
		if self:CanEat(food) then
			if self.inst.components.shadowable then
				self.inst.components.shadowable:DoDelta(food.components.edible:GetShadow(self.inst))
			end
		end
		return old_Eat(self,food,...)
	end
end)

AddPrefabPostInit("nightmarefuel", function(inst)
	inst:AddComponent("edible")
	inst.components.edible.foodtype = "NIGHTMARE"
	inst.components.edible.healthvalue = 0
	inst.components.edible.hungervalue = 0
	inst.components.edible.sanityvalue = -TUNING.SANITY_LARGE
	inst.components.edible.shadowvalue = TUNING.SHADOWINESS.LARGE
end)
AddPrefabPostInit("petals_evil", function(inst)
	if inst.components.edible then
		inst.components.edible.shadowvalue = TUNING.SHADOWINESS.SMALL
	end
end)
AddPrefabPostInit("durian_cooked", function(inst)
	if inst.components.edible then
		inst.components.edible.shadowvalue = -TUNING.SHADOWINESS.TINY
	end
end)

AddClassPostConstruct("screens/mainscreen", function(self)
	self.wilfrebook = self.right_col:AddChild(ImageButton( "images/wilfre_book_big.xml", "wilfre_book_big.tex", "wilfre_book_big.tex", "wilfre_book_big.tex" ))
	self.wilfrebook:SetScale(.9,.9,.9)
	self.wilfrebook:SetPosition(-50, 380) -- As yucky as fixed values are, the screen uses them.
    
    self.wilfrebook.OnGainFocus = function()
		--self.wilfrebook.image:SetTexture(self.wilfrebook.atlas, self.wilfrebook.image_normal)
		self.wilfrebook:SetScale(.95,.95,.95)
	end
	self.wilfrebook.OnLoseFocus = function()
		--self.wilfrebook.image:SetTexture(self.wilfrebook.atlas, self.wilfrebook.image_normal)
		self.wilfrebook:SetScale(.9,.9,.9)
	end
	self.wilfrebook:SetOnClick(function()
		GLOBAL.TheFrontEnd:PushScreen(WilfrePageListDialog())
	end)
end)

table.insert(GLOBAL.CHARACTER_GENDERS.MALE, "wilfre")

RemapSoundEvent( "dontstarve/characters/wilfre/death_voice", "wilfre/wilfre/death" )
RemapSoundEvent( "dontstarve/characters/wilfre/hurt", "wilfre/wilfre/hurt" )
RemapSoundEvent( "dontstarve/characters/wilfre/talk_LP", "wilfre/wilfre/talk_LP" )

RemapSoundEvent( "dontstarve/characters/shadowwilfre/death_voice", "wilfre/shadowwilfre/death" )
RemapSoundEvent( "dontstarve/characters/shadowwilfre/hurt", "wilfre/shadowwilfre/hurt" )
RemapSoundEvent( "dontstarve/characters/shadowwilfre/talk_LP", "wilfre/shadowwilfre/talk_LP" )

AddMinimapAtlas("images/map_icons/wilfre.xml")
AddModCharacter("wilfre")
