-- PRE-LOAD
-------------------------------------------------------

modimport("strings.lua")
modimport("tuning.lua")
modimport("lifepages.lua")

local require = GLOBAL.require
local assert = GLOBAL.assert
local io = GLOBAL.io
local json = GLOBAL.json

--local PersistentData = require("persistentdata")
--local DataContainer = PersistentData("wilfre")

--DataContainer:Load()
--GLOBAL.WilfrePagesUnlocked = DataContainer:GetValue("pages") or {SPIDER = true}

local file = io.open(MODROOT .."temp-wilfrepages.txt", "r")
if file then
	GLOBAL.WilfrePagesUnlocked = json.decode(file:read()) or {SPIDER = true}
	file:close()
else
	GLOBAL.WilfrePagesUnlocked = {SPIDER = true}
end

-- LOAD
-------------------------------------------------------

require("constants")
require("map/tasks")
require("map/level")
require("map/levels")
local Layouts = require("map/layouts").Layouts
local StaticLayout = require("map/static_layout")

local LAYOUT = GLOBAL.LAYOUT
local LAYOUT_POSITION = GLOBAL.LAYOUT_POSITION
local PLACE_MASK = GLOBAL.PLACE_MASK
local GROUND = GLOBAL.GROUND
local LEVELTYPE = GLOBAL.LEVELTYPE
local GetTypeForLevelID = GLOBAL.GetTypeForLevelID
local tasklist = GLOBAL.tasks.sampletasks
local task_names = {}

for _, task in pairs(tasklist) do
	-- Leave the usual starting task out
	if task.id ~= "Make a pick" then
		table.insert(task_names, task.id)
	end
end

-- SETPIECES
-------------------------------------------------------

Layouts["multitoolpagewilfre"] = StaticLayout.Get("map/static_layouts/wormtrap_wilfre")
Layouts["multitoolpagewilfre"].fill_mask = PLACE_MASK.IGNORE_IMPASSABLE_BARREN --_RESERVED
Layouts["batpagewilfre"] = StaticLayout.Get("map/static_layouts/marbletrees_wilfre")
Layouts["batpagewilfre"].fill_mask = PLACE_MASK.IGNORE_IMPASSABLE_BARREN --_RESERVED
Layouts["turretpagewilfre"] = StaticLayout.Get("map/static_layouts/bishopspiral_wilfre")
Layouts["turretpagewilfre"].fill_mask = PLACE_MASK.IGNORE_BARREN --_RESERVED
Layouts["turretpagewilfre"].disable_transform = true -- To prevent placement bugs
Layouts["turretpagewilfre"].layout_position = LAYOUT_POSITION.RANDOM

local ringlayout = {
	wilfre_page = {{ x=0, y=0, properties={ data={ pagename="RESEARCHLAB" } },  }},
	sanityrock = {},
	insanityrock = {},
}
for i = 1, 42 do
	local a = (math.pi/21) * i
	table.insert(ringlayout["sanityrock"], {x=math.sin(a)*2.8, y=math.cos(a)*2.8})
end
for i = 1, 30 do
	local a = (math.pi/15) * i
	table.insert(ringlayout["insanityrock"], {x=math.sin(a)*2, y=math.cos(a)*2})
end
for i = 1, 18 do
	local a = (math.pi/9) * i
	table.insert(ringlayout["sanityrock"], {x=math.sin(a)*1.2, y=math.cos(a)*1.2})
end

Layouts["researchlabpagewilfre"] = {
	type = LAYOUT.STATIC,
	start_mask = PLACE_MASK.NORMAL,
	fill_mask = PLACE_MASK.IGNORE_IMPASSABLE_BARREN, --_RESERVED,
	--layout_position = LAYOUT_POSITION.CENTER,
	ground_types = {GROUND.CARPET, GROUND.CHECKER},
	ground = {
		{0, 0, 2, 2, 2, 0, 0},
		{0, 2, 2, 2, 2, 2, 0},
		{2, 2, 1, 1, 1, 2, 2},
		{2, 2, 1, 1, 1, 2, 2},
		{2, 2, 1, 1, 1, 2, 2},
		{0, 2, 2, 2, 2, 2, 0},
		{0, 0, 2, 2, 2, 0, 0},
	},
	layout = ringlayout,
	scale = 1.0,
}

-- PICK SETPIECES
-------------------------------------------------------

local validsetpieces = {}

for k, v in pairs(GLOBAL.WILFRE_PAGE_DATA) do
	if not GLOBAL.WilfrePagesUnlocked[k] then
		table.insert(validsetpieces, string.lower(k).."pagewilfre")
	end
end

AddLevelPreInitAny(function(level)
	
	if GetTypeForLevelID(level.id) == LEVELTYPE.SURVIVAL and #validsetpieces > 0 then
		if not level.set_pieces then
			level.set_pieces = {}
		end
		local choice = validsetpieces[math.random(#validsetpieces)]
		print("Placing Wilfre Page:", choice)
		level.set_pieces[choice] = { count = 1, tasks = task_names }
	end
end)
