require "behaviours/standstill"
require "behaviours/faceentity"
require "behaviours/follow"
require "behaviours/wander"
require "behaviours/chaseandram"

local MIN_FOLLOW_DIST = 2
local TARGET_FOLLOW_DIST = 6
local MAX_FOLLOW_DIST = 9
local MAX_RAM_TIME = 5
local GIVE_UP_RAM_DIST = 10
local MAX_RAM_DIST = 16

local BatBrain = Class(Brain, function(self, inst)
	Brain._ctor(self, inst)
end)

local function GetFaceTargetFn(inst)
	return inst.components.follower.leader
end

local function KeepFaceTargetFn(inst, target)
	return inst.components.follower.leader == target
end

function BatBrain:OnStart()
	local root = PriorityNode(
	{
		ChaseAndRam(self.inst, MAX_RAM_TIME, GIVE_UP_RAM_DIST, MAX_RAM_DIST),
		Follow(self.inst, function() return self.inst.components.follower.leader end, MIN_FOLLOW_DIST, TARGET_FOLLOW_DIST, MAX_FOLLOW_DIST),
		IfNode(function() return self.inst.components.follower.leader ~= nil end, "HasLeader",
			FaceEntity(self.inst, GetFaceTargetFn, KeepFaceTargetFn )),
		StandStill(self.inst),

	}, .3)
	
	self.bt = BT(self.inst, root)
end

return BatBrain