require "behaviours/chaseandattack"
require "behaviours/wander"

local MIN_FOLLOW_DIST = 2
local TARGET_FOLLOW_DIST = 5
local MAX_FOLLOW_DIST = 8
local MAX_CHASE_TIME = 8

local SpiderBrain = Class(Brain, function(self, inst)
    Brain._ctor(self, inst)
end)

local function GetFaceTargetFn(inst)
    return inst.components.follower.leader
end

local function KeepFaceTargetFn(inst, target)
    return inst.components.follower.leader == target
end

function SpiderBrain:OnStart()
    local root = PriorityNode(
	{
		ChaseAndAttack(self.inst, MAX_CHASE_TIME),
		Follow(self.inst, function() return self.inst.components.follower.leader end, MIN_FOLLOW_DIST, TARGET_FOLLOW_DIST, MAX_FOLLOW_DIST),
		IfNode(function() return self.inst.components.follower.leader ~= nil end, "HasLeader",
			FaceEntity(self.inst, GetFaceTargetFn, KeepFaceTargetFn )),
		Wander(self.inst)
	},1)
    
    self.bt = BT(self.inst, root)
end

return SpiderBrain
