require "behaviours/standandattack"
require "behaviours/useshield"

local START_FACE_DIST = 10
local KEEP_FACE_DIST = 15
local DAMAGE_UNTIL_SHIELD = TUNING.EYETURRET_HEALTH * .06
local SHIELD_TIME = 2.5

local EyeTurretBrain = Class(Brain, function(self, inst)
    Brain._ctor(self, inst)
end)

function EyeTurretBrain:OnStart()
    local root = PriorityNode(
    {
        UseShield(self.inst, DAMAGE_UNTIL_SHIELD, SHIELD_TIME, true),
        StandAndAttack(self.inst),

    }, .25)
    
    self.bt = BT(self.inst, root)
end

return EyeTurretBrain