require "behaviours/standstill"
require "behaviours/wander"
require "behaviours/standandattack"
require "behaviours/leash"

local WormBrain = Class(Brain, function(self, inst)
    Brain._ctor(self, inst)
end)

local function StartLure(inst)
    if inst.lastluretime and GetTime() - inst.lastluretime < TUNING.WORM_LURE_COOLDOWN then
        return
    end
	
    inst:PushEvent("dolure")
end

function WormBrain:OnStart()
    local root = PriorityNode(
    {
        -- Don't do anything while in the lure state.
        WhileNode(function() return self.inst.sg:HasStateTag("lure") end, "Lure"),
		-- Movability is handled in the prefab.
        StandAndAttack(self.inst),
		DoAction(self.inst, StartLure), -- Give up and wait for their return.      

    }, .25)
    
    self.bt = BT(self.inst, root)
end

return WormBrain