local Shadowable = Class(function(self, inst)
    self.inst = inst
	self.min = 0
    self.max = 100
    self.current = self.min
	
	self.shadowpoint = 70
	self.unshadowpoint = 0
	
	self.rate = 0
	self.shadowform = false
	self.decayrate = -TUNING.SHADOWAURA.SMALL

	self.inst:StartUpdatingComponent(self)
	self:Recalc(0)
end)


function Shadowable:IsShadow()
	return self.shadowform
end

function Shadowable:SetLimits(top, bottom)
	self.shadowpoint = top
	self.unshadowpoint = bottom
end

function Shadowable:SetOnShadow(fn)
	assert(fn and type(fn) == "function")
	self.onshadow = fn
end
function Shadowable:SetOnUnshadow(fn)
	assert(fn and type(fn) == "function")
	self.onunshadow = fn
end
function Shadowable:SetRateFn(fn)
	assert(fn and type(fn) == "function")
	self.custom_rate_fn = fn
end

function Shadowable:OnSave()
	return {
		current = self.current, 
		shadowform = self.shadowform,
	}
end

function Shadowable:OnLoad(data)
	
	if data.shadowform then
		self.shadowform = data.shadowform
	end
	
    if data.current then
        self.current = data.current
        self:DoDelta(0)
    end
    
	if self.shadowform then
		if self.onshadow then
			self.onshadow(self.inst, true)
		end
		self.inst:PushEvent("shadowform", {isshadow=true} )
	end
    
end

function Shadowable:GetPercent()
	return (self.current - self.min) / (self.max - self.min)
end

function Shadowable:SetPercent(per)
    local target = Lerp(self.min, self.max, per)
    local delta = target - self.current
    self:DoDelta(delta)
end

function Shadowable:GetDebugString()
    return string.format("%2.2f / %2.2f at %2.4f.", self.current, self.max, self.rate)
end

function Shadowable:SetMax(amount)
    self.max = amount
    self.current = amount
	self.min = math.min(self.min, amount)
end

function Shadowable:GetRate()
	return self.rate
end


function Shadowable:DoDelta(delta, overtime)

    if self.redirect then
        self.redirect(self.inst, delta, overtime)
        return
    end

    if self.ignore then return end


    local old = self.current
    local oldpercent = self:GetPercent()
	
    self.current = self.current + delta
	
	self.current = math.min(self.max, self.current)
	self.current = math.max(self.min, self.current)
    
    local newpercent = self:GetPercent()
    
    self.inst:PushEvent("shadowdelta", {oldpercent = oldpercent, newpercent = newpercent, overtime=overtime})

    if self.shadowform and old > self.unshadowpoint and self.current <= self.unshadowpoint then
		self.shadowform = false
		
		if self.onunshadow then
			self.onunshadow(self.inst)
		end
	    self.inst:PushEvent("shadowform", {isshadow=false} )
		
    elseif not self.shadowform and old < self.shadowpoint and self.current >= self.shadowpoint then
		self.shadowform = true
		
		if self.onshadow then
			self.onshadow(self.inst)
		end
	    self.inst:PushEvent("shadowform", {isshadow=true} )
	end
end


function Shadowable:OnUpdate(dt)
	if self.inst.components.health.invincible == true or self.inst.is_teleporting == true then
		return
	end
	
	self:Recalc(dt)
end

function Shadowable:Recalc(dt)
	
	local aura_delta = 0
	local x,y,z = self.inst.Transform:GetWorldPosition()
	local range = TUNING.SANITY_EFFECT_RANGE
	local ents = TheSim:FindEntities(x,y,z, range, nil, {"FX", "NOCLICK", "DECOR","INLIMBO"} )
    for k,v in pairs(ents) do 
		if v.components.shadowaura and v ~= self.inst then
			local distsq = self.inst:GetDistanceSqToInst(v)
			local aura_val = v.components.shadowaura:GetAura(self.inst)
			aura_val = aura_val / math.max(1, distsq) -- Surely there's a nicer way to do this
			aura_delta = aura_delta + aura_val
		end
    end
	
	local inv_delta = 0
	for k,v in pairs (self.inst.components.inventory.equipslots) do
		if v.components.shadowaura then
			local per_item = v.components.shadowaura:GetAura(self.inst)
			--if v.components.stackable then
			--	inv_delta = inv_delta + per_item * v.components.stackable:GetSize()
			--else
				inv_delta = inv_delta + per_item
			--end
		end		
	end

	self.rate = self.decayrate + aura_delta + inv_delta
	
	if self.custom_rate_fn then
		self.rate = self.rate + self.custom_rate_fn(self.inst, self.rate)
	end

	self:DoDelta(self.rate*dt, true)
end

function Shadowable:LongUpdate(dt)
	self:OnUpdate(dt)
end

return Shadowable
