--[[

------------------------------
Copyright (c) 2016 Mobbstar

Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
------------------------------
TL;DR just leave this header in and you are good to copy and modify it as you need to.

Please contact the original author "Mobbstar" and consider placing a notice if modifying this file.
file version: 1.0

------------------------------
NOTICE FOR USAGE IN OTHER MODS
------------------------------

Place the following code in modmain.lua to make this file do its magic:


local ModDependency = GLOBAL.require("moddependency")
ModDependency.AddDependency(modname, "INSERT_ID_OR_NAME_OF_REQUIRED_MOD_HERE")

]]

local BigPopupDialogScreen = require("screens/bigpopupdialog")


-- All mods set to load (regardless of success)
local selected_mods = {}
-- All mods installed
local available_mods = {}
-- All dependencies set
local dependencies = {}
-- All dependencies not enabled (installed or not)
local missing_deps = {}
-- Names for when this module can't figure them out
local altnames = {}
-- Array for the pop-ups to work through in order
local popups = {}

-- Declare function names right away, so they can be used at all time
local ClosePopUp
local DoNextPopUp

local AddDependency
local SetAltName
local IsModReady
local GetModList


-- Enabled mods are listed here for later use
for k,v in pairs(ModManager.mods) do
	if v.modinfo then
		-- Ideally we want unique IDs rather than arbitrary names
		if v.modinfo.id then
			selected_mods[v.modinfo.id] = v.modname or ""
		elseif v.modinfo.name then
			selected_mods[v.modinfo.name] = v.modname or ""
		end
	end
end

-- All known mods are listed here for later use
for k,v in pairs(KnownModIndex.savedata.known_mods) do
	if v.modinfo then
		-- Ideally we want unique IDs rather than arbitrary names
		if v.modinfo.id then
			available_mods[v.modinfo.id] = k or ""
		elseif v.modinfo.name then
			available_mods[v.modinfo.name] = k or ""
		end
	end
end

ClosePopUp = function()
	TheFrontEnd:PopScreen()
	table.remove(popups,1)
	DoNextPopUp()
end

DoNextPopUp = function()
	-- Is there any popups outstanding?
	if #popups > 0 then
		
		-- If available, ask whether to enable that mod or disable this mod
		if popups[1].dep_name then
			TheFrontEnd:PushScreen(BigPopupDialogScreen(
			"Enable required mod!",
			"The mod \"".. popups[1].depfancy .."\" is needed to play the mod \"".. popups[1].thisfancy .."\". Do you want to enable it now?",
			{{text = "Enable required",
			cb = function()
				KnownModIndex:Enable(popups[1].dep_name)
				ClosePopUp()
			end},
			{text = popups[1].disablethisfancy,
			cb = function()
				KnownModIndex:Disable(popups[1].modname)
				ClosePopUp()
			end}}))
			
		-- Else, warn the player and disable this mod
		else
			TheFrontEnd:PushScreen(BigPopupDialogScreen(
			"Install required mod!",
			"The mod \"".. popups[1].depfancy .."\" is needed to play the mod \"".. popups[1].thisfancy .."\". \"".. popups[1].thisfancy .."\" will disable itself until you install \"".. popups[1].depfancy .."\".",
			{{text = popups[1].disablethisfancy,
			cb = function()
				KnownModIndex:Disable(popups[1].modname)
				ClosePopUp()
			end},
			{text = "Quit",
			cb = function()
				KnownModIndex:Save()
				TheFrontEnd:Fade(false, 1, function()
					RequestShutdown()
				end)
			end}}))
		end
		
	else
		KnownModIndex:Save()
		TheFrontEnd:Fade(false, 1, function()
			StartNextInstance()
		end)
	end
end

-- Wait for all mods to load
scheduler:ExecuteInTime(0, function()
	--print("TESTING MOD DEPENDENCIES--------------------------------------")
	local dopopup -- blergh, but necessary
	
	for modname, t_deps in pairs(dependencies) do
		--print("TESTING MOD",modname)
		for i, dep_id in ipairs(t_deps) do
			if not selected_mods[dep_id] then
				dopopup = true
				-- The mod is not going to load, do something!
				if not missing_deps[modname] then
					missing_deps[modname] = {}
				end
				
				-- If available, ask whether to enable that mod or disable this mod
				if available_mods[dep_id] then
					print("dep",dep_id,"is DISABLED")
					missing_deps[modname][dep_id] = available_mods[dep_id]
				-- Else, warn the player and disable this mod
				else
					print("dep",dep_id,"is MISSING")
					missing_deps[modname][dep_id] = false
				end
			end
		end
	end
	
	if dopopup then
		local thisfancy
		local disablethisfancy
		local depfancy
		for modname, deps in pairs(missing_deps) do
			thisfancy = "UNKNOWN"
			if KnownModIndex.savedata.known_mods[modname] then
				thisfancy = KnownModIndex.savedata.known_mods[modname].modinfo.name
			end
			if string.len(thisfancy) > 7 then
				disablethisfancy = "Disable ".. string.sub(thisfancy,1,6) ..".."
			else
				disablethisfancy = "Disable ".. thisfancy
			end
			for dep_id, dep_name in pairs(deps) do
				depfancy = altnames[dep_id] or dep_id
				
				if dep_name then
					if KnownModIndex.savedata.known_mods[dep_name] then
						depfancy = KnownModIndex.savedata.known_mods[dep_name].modinfo.name or depfancy
					end
				end
				table.insert(popups,{
					modname = modname,
					dep_name = dep_name,
					thisfancy = thisfancy,
					disablethisfancy = disablethisfancy,
					depfancy = depfancy,
				})
			end
		end
		DoNextPopUp()
	end
	
end, "dependencypopup")

-- You can get the modname by using "modname" in mod environment
AddDependency = function(source_modname, target_id)
	print("Adding dependency",source_modname,target_id)
	assert(source_modname ~= nil)
	assert(type(source_modname) == "string")
	assert(target_id ~= nil)
	assert(type(target_id) == "string")
	
	if not dependencies[source_modname] then
		dependencies[source_modname] = {}
	end
	table.insert(dependencies[source_modname], target_id)
end

SetAltName = function(name, id)
	assert(name == nil or type(name) == "string")
	assert(id ~= nil)
	assert(type(id) == "string")
	
	altnames[id] = name
end

-- You can get the modname by using "modname" in mod environment
IsModReady = function(modname)
	assert(modname ~= nil)
	assert(type(modname) == "string")
	
	-- Simple check because details do not matter
	for i, dep_id in ipairs(dependencies[modname]) do
		if not selected_mods[dep_id] then
			return false
		end
	end
	
	return true
end

GetModList = function(available)
	return available and available_mods or selected_mods
end

return {
	AddDependency = AddDependency,
	SetAltName = SetAltName,
	IsModReady = IsModReady,
	GetModList = GetModList,
}