require "brains/batwilfrebrain"
require "stategraphs/SGbatwilfre"

local assets=
{
	Asset("ANIM", "anim/shadowbat.zip"),
	Asset("SOUND", "sound/bat.fsb"),
}

local MAX_CHASEAWAY_DIST = 80
local MAX_TARGET_SHARES = 5
local SHARE_TARGET_DIST = 40

local function KeepTarget(inst, target)
	return target
		and target.components.combat
		and target.components.health
		and not target.components.health:IsDead()
		and inst.components.follower.leader ~= target
end

local function OnAttacked(inst, data)
	local attacker = data and data.attacker
	if attacker and attacker ~= inst.components.follower.leader then
		inst.components.combat:SetTarget(attacker)
		inst.components.combat:ShareTarget(attacker, SHARE_TARGET_DIST, function(dude)
			return dude:HasTag("bat")
		end, MAX_TARGET_SHARES)
	end
end

local function Disappear(inst, data)
	inst.components.health:Kill()
end

local function onhitother(inst, target, damage)
	local recoil = (damage + inst.components.combat.defaultdamage) / 2
	inst.components.health:DoDelta(-recoil)
end

local function fn()
	local inst = CreateEntity()
	inst.entity:AddTransform()
	inst.entity:AddAnimState()
	inst.entity:AddSoundEmitter()
	local shadow = inst.entity:AddDynamicShadow()
	
	inst.Transform:SetFourFaced()
	MakeGhostPhysics(inst, 1, .5)
	RemovePhysicsColliders(inst)
	--MakeInventoryPhysics(inst)

	shadow:SetSize( 1.5, .75 )
	local scaleFactor = 0.6
	inst.Transform:SetScale(scaleFactor, scaleFactor, scaleFactor)

	inst.AnimState:SetBank("bat")
	inst.AnimState:SetBuild("shadowbat")
	inst.AnimState:PlayAnimation("fly_loop")
	
	--inst:AddTag("monster")
	--inst:AddTag("hostile")
	inst:AddTag("bat")
	inst:AddTag("scarytoprey")
	inst:AddTag("wilfrecreation")
	inst:AddTag("companion")
	inst:AddTag("notraptrigger")
	inst:AddTag("flying")
	
 	inst:AddComponent("locomotor")
	inst.components.locomotor:SetSlowMultiplier( 1 )
	inst.components.locomotor:SetTriggersCreep(false)
	inst.components.locomotor.pathcaps = { ignorecreep = true }
	inst.components.locomotor.walkspeed = 8
	
	inst:AddComponent("follower")
	
	inst:AddComponent("health")
	inst.components.health:SetMaxHealth(TUNING.GUNPOWDER_DAMAGE)

	inst:AddComponent("combat")
	inst.components.combat:SetDefaultDamage(TUNING.GUNPOWDER_DAMAGE/5)
	inst.components.combat:SetAttackPeriod(1)
	inst.components.combat:SetRange(1.8)
	inst.components.combat:SetHurtSound("dontstarve/sanity/creature1/attack") --silent
	inst.components.combat.hiteffectsymbol = "bat_body"
	--inst.components.combat:SetRetargetFunction(3, Retarget)
	inst.components.combat:SetKeepTargetFunction(KeepTarget)
	inst.components.combat.onhitotherfn = onhitother
	
	inst:AddComponent("shadowaura")
	inst.components.shadowaura.aura = TUNING.SHADOWAURA.SMALL
	
	inst:AddComponent("inspectable")
	
	inst:SetStateGraph("SGbatwilfre")

	local brain = require "brains/batwilfrebrain"
	inst:SetBrain(brain)

	inst:ListenForEvent("attacked", OnAttacked)
	inst:ListenForEvent("stopfollowing", Disappear)
	
	return inst
end

return Prefab("forest/monsters/bat_wilfre", fn, assets) 
