assets = 
{
	Asset("ANIM", "anim/marble_trees.zip"),
}

local prefabs =
{
	"wilfre_page",
}

local function onsave(inst, data)
	data.anim = inst.animnumber
end

local function onload(inst, data)
	if data and data.anim then
		inst.animnumber = data.anim
		inst.AnimState:PlayAnimation("full_"..inst.animnumber)
	end
end

local function onfinish(inst, worker)
	inst.SoundEmitter:PlaySound("dontstarve/common/destroy_pot")
	SpawnAt("collapse_small", inst)
	
	if inst.components.workable.action == ACTIONS.MINE then
		inst.components.workable:SetWorkAction(ACTIONS.HAMMER)
		inst.components.workable:SetWorkLeft(4)
		inst.AnimState:PlayAnimation("med_"..inst.animnumber)
	elseif inst.components.workable.action == ACTIONS.HAMMER then
		inst.components.workable:SetWorkAction(ACTIONS.DIG)
		inst.components.workable:SetWorkLeft(4)
		inst.AnimState:PlayAnimation("low_"..inst.animnumber)
	else
		SpawnAt("wilfre_page", inst).pagename = "BAT"
		inst:Remove()
	end
end

local function fn()
	local inst = CreateEntity()
	local trans = inst.entity:AddTransform()
	local anim = inst.entity:AddAnimState()	
	inst.entity:AddSoundEmitter()

	MakeObstaclePhysics(inst, 0.1)

	inst.animnumber = math.random(1, 4)
	anim:SetBank("marble_trees")
	anim:SetBuild("marble_trees")
	anim:PlayAnimation("full_"..inst.animnumber)

	inst.entity:AddMiniMapEntity()
	inst.MiniMapEntity:SetIcon( "marbletree.png" )
	inst.MiniMapEntity:SetPriority(-1)

	inst:AddComponent("inspectable")
	
	inst:AddComponent("workable")
	inst.components.workable:SetWorkAction(ACTIONS.MINE)
	inst.components.workable:SetWorkLeft(4)
	--inst.components.workable:SetOnWorkCallback()
	inst.components.workable:SetOnFinishCallback(onfinish)

	MakeSnowCovered(inst, 0.1)

	inst.OnSave = onsave
	inst.OnLoad = onload

	return inst
end

return Prefab("forest/objects/marbletree_wilfre", fn, assets, prefabs)
