local assets=
{
	Asset("ANIM", "anim/multitool_wilfre.zip"),
	Asset("ANIM", "anim/swap_multitool_wilfre.zip"),
	
	Asset( "IMAGE", "images/inventoryimages/multitool_wilfre.tex" ),
	Asset( "ATLAS", "images/inventoryimages/multitool_wilfre.xml" ),
}

local function onfinished(inst)
	inst:Remove()
end

local function onequip(inst, owner) 
	owner.AnimState:OverrideSymbol("swap_object", "swap_multitool_wilfre", "swap_object")
	owner.AnimState:Show("ARM_carry") 
	owner.AnimState:Hide("ARM_normal") 
end

local function onunequip(inst, owner) 
	owner.AnimState:Hide("ARM_carry") 
	owner.AnimState:Show("ARM_normal") 
end

local function fn(Sim)
	local inst = CreateEntity()
	inst.entity:AddTransform()
	local anim = inst.entity:AddAnimState()
	inst.entity:AddSoundEmitter()
	MakeInventoryPhysics(inst)
	
	anim:SetBank("multitool_wilfre")
	anim:SetBuild("multitool_wilfre")
	anim:PlayAnimation("idle")
    --anim:SetMultColour(0, 0, 0, 0.8)
	
	inst:AddTag("sharp")
    inst:AddTag("show_spoilage")
	inst:AddTag("wilfrecreation")
	inst:AddTag("scarytoprey")
	
	----
	inst:AddComponent("inspectable")
	inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.atlasname = "images/inventoryimages/multitool_wilfre.xml"
	--inst.components.inventoryitem.imagename = "multitool_axe_pickaxe"
	----
	inst:AddComponent("weapon")
	inst.components.weapon:SetDamage(TUNING.MULTITOOL_DAMAGE)
	----
	inst:AddComponent("tool")
	inst.components.tool:SetAction(ACTIONS.DIG, 1.0)
	inst.components.tool:SetAction(ACTIONS.MINE, 0.9)
	----
	inst:AddComponent("perishable")
	inst.components.perishable:SetPerishTime(TUNING.PERISH_ONE_DAY /2)
	inst.components.perishable:StartPerishing()
	inst.components.perishable.onperishreplacement = "nightmarefuel"
	----
	inst:AddComponent("shadowaura")
	inst.components.shadowaura:SetAura(TUNING.SHADOWAURA.TINY)
	----
	inst:AddComponent("equippable")
	inst.components.equippable:SetOnEquip( onequip )
	inst.components.equippable:SetOnUnequip( onunequip )
	
	return inst
end

return Prefab( "common/inventory/multitool_wilfre", fn, assets)