local assets = 
{
	Asset("ANIM", "anim/researchlab.zip"),
}

local function Disappear(inst)
	local player = GetPlayer()
	inst.components.prototyper:TurnOff()
	inst:RemoveComponent("prototyper")
	if player and player.components.builder then
		player.components.builder:EvaluateTechTrees()
	end
	
	inst.AnimState:PlayAnimation("use")
	inst:DoTaskInTime(FRAMES * 16, function()
		inst.SoundEmitter:PlaySound("dontstarve/sanity/creature1/die")
	end)
    inst:DoTaskInTime(FRAMES * 47, function()
		local fx = SpawnPrefab("explode_small")
		fx.Transform:SetPosition(inst:GetPosition():Get())
		fx.AnimState:SetMultColour(0,0,0,1)
		
		inst:Remove()
	end)
end
	
local function onturnon(inst)
	inst.AnimState:PlayAnimation("proximity_loop", true)
	inst.SoundEmitter:PlaySound("dontstarve/common/researchmachine_lvl4_idle_LP","idlesound")
end

local function onturnoff(inst)
	inst.AnimState:PushAnimation("idle", true)
	inst.SoundEmitter:KillSound("idlesound")
end

local function onbuilt(inst)
	inst.components.prototyper.on = true
	inst.AnimState:PlayAnimation("place")
	inst.AnimState:PushAnimation("idle")
	inst.AnimState:PushAnimation("proximity_loop", true)
	inst.SoundEmitter:PlaySound("dontstarve/common/researchmachine_lvl4_idle_LP","idlesound")
end

local function getstatus(inst)
	if inst:HasTag("level2") then
		return "HIGHSCIENCE"
	elseif inst:HasTag("level4") then
		return "HIGHMAGIC"
	end
end


local function fn(Sim)
	local inst = CreateEntity()
	inst.entity:AddTransform()
	inst.entity:AddAnimState()
	inst.entity:AddSoundEmitter()
	
	local minimap = inst.entity:AddMiniMapEntity()
	minimap:SetPriority( 5 )
	minimap:SetIcon( "researchlab.png" )
	
	MakeObstaclePhysics(inst, .4)
	
	inst.AnimState:SetBank("researchlab")
	inst.AnimState:SetBuild("researchlab")
	inst.AnimState:PlayAnimation("idle")
	inst.AnimState:SetMultColour(0,0,0,1)

	inst:AddTag("prototyper")
	--inst:AddTag("structure")
	inst:AddTag("wilfrecreation")
	inst:AddTag("scarytoprey")
	
	inst:AddComponent("inspectable")
	inst.components.inspectable.getstatus = getstatus
	
	inst:AddComponent("prototyper")
	inst.components.prototyper.onturnon = onturnon
	inst.components.prototyper.onturnoff = onturnoff
	inst.components.prototyper.onactivate = function()
		inst.AnimState:PlayAnimation("use")
		inst.AnimState:PushAnimation("idle")
		inst.AnimState:PushAnimation("proximity_loop", true)
		inst.SoundEmitter:PlaySound("dontstarve/common/researchmachine_lvl1_run","sound")

		inst:DoTaskInTime(FRAMES * 45, function() 
			inst.SoundEmitter:KillSound("sound")
			inst.SoundEmitter:PlaySound("dontstarve/common/researchmachine_lvl3_ding","sound")
		end)
	end
	
	inst:AddComponent("sanityaura")
	inst.components.sanityaura.aura = -TUNING.SANITYAURA_SMALL
	
	inst:AddComponent("shadowaura")
	inst.components.shadowaura.aura = TUNING.SHADOWAURA.SMALL
	
	inst:ListenForEvent("onbuilt", onbuilt)
	inst:DoTaskInTime(math.random(TUNING.SEG_TIME, TUNING.SEG_TIME * 2), Disappear)
	
	MakeSnowCovered(inst, .01)
	
	local ran = math.random()
	if ran < .15 then
		inst:AddTag("level2")
		inst.components.prototyper.trees = TUNING.PROTOTYPER_TREES.ALCHEMYMACHINE
	elseif ran < .4 then
		inst:AddTag("level4")
		inst.components.prototyper.trees = TUNING.PROTOTYPER_TREES.PRESTIHATITATOR
	else
		inst:AddTag("level1")
		inst.components.prototyper.trees = TUNING.PROTOTYPER_TREES.SCIENCEMACHINE
	end
		
	return inst
end

return Prefab( "common/objects/researchlab_wilfre", fn, assets)
