--WARNING invisible for some reason, reenable in the respective prefabs if getting fixed

local texture = resolvefilepath( "fx/torchfire.tex" )
local shader = resolvefilepath( "shaders/particle.ksh" )
local colour_envelope_name = "shadowgoocolourenvelope"
local scale_envelope_name = "shadowgooscaleenvelope"

local assets =
{
	Asset( "IMAGE", texture ),
	Asset( "SHADER", shader ),
}

local max_scale = 2

local init = false
local function InitEnvelope()
	if EnvelopeManager and not init then
		init = true
		EnvelopeManager:AddColourEnvelope(
			colour_envelope_name,
			{	{ 0,	{ 1, 1, 1, 1 } },
				--{ .8,	{ 1, 1, 1, 1 } },
				--{ 1,	{ 1, 1, 1, 0 ) },
			} )

		EnvelopeManager:AddVector2Envelope(
			scale_envelope_name,
			{
				{ 0,	{ 0, 0 } },
				{ .1,	{ max_scale, max_scale } },
				{ .6,	{ max_scale * 0.8, max_scale * 0.8 } },
				{ 1,	{ 0, 0 } },
			} )
	end
end

local ground_height = 0.25
local max_num_particles = 4
local max_lifetime = .9

local function fn(Sim)
	local inst = CreateEntity()
	inst.entity:AddTransform()
	local emitter = inst.entity:AddParticleEmitter()

	inst:AddTag("FX")
	inst.persists = false
	
	InitEnvelope()

	emitter:SetRenderResources( texture, shader )
	emitter:SetMaxNumParticles( max_num_particles)
	emitter:SetMaxLifetime( max_lifetime )
	emitter:SetColourEnvelope( colour_envelope_name )
	emitter:SetScaleEnvelope( scale_envelope_name )
	
	--TODO
	emitter:SetBlendMode( BLENDMODE.AlphaBlended )
	--emitter:EnableBloomPass( true )
	emitter:SetUVFrameSize( 1.0 , 1.0 )
	--emitter:SetRotationStatus( true )
	--emitter:SetDragCoefficient( 0.2 )
	--emitter:EnableDepthTest( true )
	
	-----------------------------------------------------
	-- desired particles per second * tick in seconds
	local particles_per_tick = 3.5 * TheSim:GetTickTime()

	local num_particles_to_emit = 1.5

	local sphere_emitter = CreateSphereEmitter( 0.05 )
	
	
	--local angle = 0
	--local dx = math.cos( angle * PI / 180 )
	emitter:SetAcceleration( 0, 0.8, 0 )
	
	local towards_other_side = false
	
	local emit_fn = function()
		--TODO reroll initial velocity everytime you spawn something
		-- inbetween 45 to either side
		--  or calculate with owner's transform width?
		-- switch side after every spawn
		
		local vx, vy, vz = 1 * UnitRand(), 0.01 * UnitRand(), 0
		if towards_other_side then
			vx = -vx
		end
		
		local lifetime = max_lifetime * ( 0.9 + UnitRand() * 0.1 )
		
		local px, py, pz = sphere_emitter()
		px = px - 0.1
		py = py + ground_height

		local uv_offset = math.random( 0, 3 ) * 0.25

		emitter:AddParticleUV(
			lifetime,			-- lifetime
			px, py, pz,			-- position
			vx, vy, vz,			-- velocity
			uv_offset, 0		-- uv offset
		)
		
		towards_other_side = not towards_other_side
	end
	
	local updateFunc = function()
		while num_particles_to_emit > 1 do
			emit_fn( emitter )
			num_particles_to_emit = num_particles_to_emit - 1
		end

		num_particles_to_emit = num_particles_to_emit + particles_per_tick
	end

	EmitterManager:AddEmitter( inst, nil, updateFunc )
	
	return inst
end

return Prefab( "common/fx/shadowgoofx", fn, assets)
