require "brains/spiderwilfrebrain"
require "stategraphs/SGspiderwilfre"

local assets =
{
	Asset("ANIM", "anim/ds_spider_basic.zip"),
	Asset("ANIM", "anim/spider_shadow.zip"),
	--Asset("SOUND", "sound/spider.fsb"),
}

--local prefabs = {"",}

local function NormalRetarget(inst)
	return FindEntity(inst, TUNING.SPIDER_TARGET_DIST, function(guy) 
		if inst.components.combat:CanTarget(guy)
		and inst.components.follower.leader ~= guy then
			return guy
		end
	end)
end

local function keeptargetfn(inst, target)
	return target
		and target.components.combat
		and target.components.health
		and not target.components.health:IsDead()
		and inst.components.follower.leader ~= target
end

local function OnAttacked(inst, data)
	if data.attacker and data.attacker ~= inst.components.follower.leader then
		inst.components.combat:SetTarget(data.attacker)
	end
	--[[inst.components.combat:ShareTarget(data.attacker, 30, function(dude)
		return dude:HasTag("spider")
			and not dude.components.health:IsDead()
			and dude.components.follower
			and dude.components.follower.leader == inst.components.follower.leader
	end, 10)]]
end

local function Disappear(inst, data)
	inst.components.health:Kill()
end

local function fn()
	local inst = CreateEntity()
	inst.entity:AddTransform()
	inst.entity:AddAnimState()
	inst.entity:AddSoundEmitter()
	
	local shadow = inst.entity:AddDynamicShadow()
	shadow:SetSize( 1.5, .5 )
	
	inst.Transform:SetFourFaced()
	
	MakeCharacterPhysics(inst, 10, .5)
	
	--inst.goofx = SpawnPrefab( "shadowgoofx" )
	--inst:AddChild(inst.goofx)
	
	----------
	
	--inst:AddTag("monster")
	--inst:AddTag("canbetrapped")
	inst:AddTag("scarytoprey")
	--inst:AddTag("shadow")
	inst:AddTag("wilfrecreation")
	inst:AddTag("companion")
	inst:AddTag("notraptrigger")

	inst.AnimState:SetBank("spider")
	inst.AnimState:SetBuild("spider_shadow")
	inst.AnimState:PlayAnimation("idle")
	
	-- locomotor must be constructed before the stategraph!
	inst:AddComponent("locomotor")
	--inst.components.locomotor:SetSlowMultiplier( 1 )
	inst.components.locomotor:SetTriggersCreep(false)
	inst.components.locomotor.pathcaps = { ignorecreep = true }
	
	inst.components.locomotor.walkspeed = TUNING.SPIDER_WALK_SPEED
	inst.components.locomotor.runspeed = TUNING.SPIDER_RUN_SPEED
	
	inst:AddComponent("follower")
	
	------------------
	
	inst:AddComponent("health")
	inst.components.health:SetMaxHealth(TUNING.SPIDER_HEALTH * .3)

	------------------
	
	inst:AddComponent("combat")
	inst.components.combat.hiteffectsymbol = "body"
	inst.components.combat:SetHurtSound("dontstarve/sanity/creature1/attack") --silent
	
	--inst.components.combat:SetRetargetFunction(1, NormalRetarget)
	inst.components.combat:SetKeepTargetFunction(keeptargetfn)
	--inst.components.combat:SetOnHit()

	inst.components.combat:SetDefaultDamage(TUNING.SPIDER_DAMAGE * .75)
	inst.components.combat:SetAttackPeriod(TUNING.SPIDER_ATTACK_PERIOD)
	
	------------------
	
	inst:AddComponent("inspectable")
	
	------------------
	
	inst:AddComponent("shadowaura")
	inst.components.shadowaura.aura = TUNING.SHADOWAURA.TINY
	
	inst:SetStateGraph( "SGspiderwilfre" )
	inst:SetBrain(require( "brains/spiderwilfrebrain" ))

	inst:ListenForEvent("attacked", OnAttacked)
	inst:ListenForEvent("stopfollowing", Disappear)

	return inst
end


return Prefab( "forest/monsters/spider_wilfre", fn, assets)
