require "brains/turretwilfrebrain"
require "stategraphs/SGturretwilfre"

local assets=
{
	Asset("ANIM", "anim/teleporter_worm.zip"),
	Asset("ANIM", "anim/shadowwormhole.zip"),
	Asset("ANIM", "anim/shadowball.zip"),
}

local prefabs = {}

local function retargetfn(inst)
    local newtarget = FindEntity(inst, 12, function(guy)
		return guy.components.combat and 
			inst.components.combat:CanTarget(guy) and
			(guy.components.combat.target == GetPlayer() or GetPlayer().components.combat.target == guy)
    end)

    return newtarget
end

local function shouldKeepTarget(inst, target)
    if target and target:IsValid() and
        (target.components.health and not target.components.health:IsDead()) then
        local distsq = target:GetDistanceSqToInst(inst)
        return distsq < 12*12
    else
        return false
    end
end


local function LaunchProjectile(inst, data)
	local target = data and data.target
	if target then
		local projectile = SpawnPrefab("turret_wilfre_projectile")
		projectile.owner = inst
		projectile.Transform:SetPosition(inst.Transform:GetWorldPosition())
		projectile.components.complexprojectile:Launch(target:GetPosition())
	end
end

local function canBeAttacked(inst, attacker)
	return not inst.sg:HasStateTag("shield") or attacker == GetPlayer()
end

local function Disappear(inst, data)
	if data.attacker and data.attacker == GetPlayer() then
		inst.components.health:Kill()
	end
end


local function fn(Sim)
	local inst = CreateEntity()
	inst.entity:AddTransform()
	inst.entity:AddAnimState()
 	inst.entity:AddSoundEmitter()

    MakeInventoryPhysics(inst)

    --inst:AddTag("eyeturret")
    inst:AddTag("companion")
    inst:AddTag("turret_wilfre")
	inst:AddTag("scarytoprey")
	--inst:AddTag("shadow")
	inst:AddTag("wilfrecreation")

    inst.AnimState:SetBank("teleporter_worm")
    inst.AnimState:SetBuild("shadowwormhole")
    inst.AnimState:PlayAnimation("idle_loop", true)
	--inst.AnimState:SetLayer(LAYER_BACKGROUND)
	--inst.AnimState:SetSortOrder(3)

    inst:AddComponent("health")
    inst.components.health:SetMaxHealth(TUNING.EYETURRET_HEALTH * .2)
    
    inst:AddComponent("combat")
    inst.components.combat:SetHurtSound("dontstarve/sanity/creature1/taunt") -- silent
    inst.components.combat:SetRange(12)
    inst.components.combat:SetDefaultDamage(TUNING.EYETURRET_DAMAGE * .5)
    inst.components.combat:SetAttackPeriod(3)
    inst.components.combat:SetRetargetFunction(1, retargetfn)
    inst.components.combat:SetKeepTargetFunction(shouldKeepTarget)
    inst.components.combat.canbeattackedfn = canBeAttacked

    --inst:AddComponent("sanityaura")
    --inst.components.sanityaura.aura = -TUNING.SANITYAURA_TINY
	inst:AddComponent("shadowaura")
	inst.components.shadowaura.aura = TUNING.SHADOWAURA.TINY
    
    inst:AddComponent("inspectable")
    inst:AddComponent("lootdropper")
    
    inst:ListenForEvent("onattackother", LaunchProjectile)
    inst:ListenForEvent("attacked", Disappear)

    inst:SetStateGraph("SGturretwilfre")
    local brain = require "brains/turretwilfrebrain"
    inst:SetBrain(brain)

    return inst
end

-------------------------------------------------------------------

local function OnHit(inst, dist)
	inst.SoundEmitter:PlaySound("dontstarve/common/teleportworm/sick_splat")
	local fx = SpawnAt("splash", inst)
	fx.AnimState:SetMultColour(0,0,0,1)
	if inst.owner and inst.owner.components.combat then
		inst.owner.components.combat:DoAreaAttack(inst, 1.5)
	end
	inst:Remove()
end

local function projectile_fn()
	local inst = CreateEntity()
	inst.entity:AddTransform()
	inst.entity:AddAnimState()
	inst.entity:AddSoundEmitter()
    
    inst.entity:AddPhysics()
    inst.Physics:SetMass(1)
    inst.Physics:SetCapsule(0.2, 0.2)
    inst.Physics:SetFriction(10)
    inst.Physics:SetDamping(5)
    inst.Physics:SetCollisionGroup(COLLISION.CHARACTERS)
    inst.Physics:ClearCollisionMask()
    inst.Physics:CollidesWith(COLLISION.WORLD)

	inst.AnimState:SetBank("firefighter_projectile")
	inst.AnimState:SetBuild("shadowball")
	inst.AnimState:PlayAnimation("spin_loop", true)

    inst.persists = false

	inst:AddComponent("locomotor")
	inst:AddComponent("complexprojectile")
	inst.components.complexprojectile:SetOnHit(OnHit)
	--inst.components.complexprojectile.onmissfn = OnHit
	inst.components.complexprojectile.hoizontalSpeed = 3.5

	return inst
end

return Prefab( "forest/monsters/turret_wilfre", fn, assets, prefabs),
	Prefab( "forest/monsters/turret_wilfre_projectile", projectile_fn, assets, prefabs)
