local MakePlayerCharacter = require("prefabs/player_common")
local ShadowableBadge = require("widgets/shadowablebadge")

local assets = {
	Asset( "ANIM", "anim/player_basic.zip" ),
	Asset( "ANIM", "anim/player_idles_shiver.zip" ),
	Asset( "ANIM", "anim/player_actions.zip" ),
	Asset( "ANIM", "anim/player_actions_axe.zip" ),
	Asset( "ANIM", "anim/player_actions_pickaxe.zip" ),
	Asset( "ANIM", "anim/player_actions_shovel.zip" ),
	Asset( "ANIM", "anim/player_actions_blowdart.zip" ),
	Asset( "ANIM", "anim/player_actions_eat.zip" ),
	Asset( "ANIM", "anim/player_actions_item.zip" ),
	Asset( "ANIM", "anim/player_actions_uniqueitem.zip" ),
	Asset( "ANIM", "anim/player_actions_bugnet.zip" ),
	Asset( "ANIM", "anim/player_actions_fishing.zip" ),
	Asset( "ANIM", "anim/player_actions_boomerang.zip" ),
	Asset( "ANIM", "anim/player_bush_hat.zip" ),
	Asset( "ANIM", "anim/player_attacks.zip" ),
	Asset( "ANIM", "anim/player_idles.zip" ),
	Asset( "ANIM", "anim/player_rebirth.zip" ),
	Asset( "ANIM", "anim/player_jump.zip" ),
	Asset( "ANIM", "anim/player_amulet_resurrect.zip" ),
	Asset( "ANIM", "anim/player_teleport.zip" ),
	Asset( "ANIM", "anim/wilson_fx.zip" ),
	Asset( "ANIM", "anim/player_one_man_band.zip" ),
	Asset( "ANIM", "anim/shadow_hands.zip" ),
	--Asset( "ANIM", "anim/beard.zip" ),
	Asset( "SOUND", "sound/sfx.fsb" ),
	Asset( "SOUND", "sound/wilson.fsb" ),

	Asset( "ANIM", "anim/shadowablebadge.zip" ),
	Asset( "ANIM", "anim/wilfre.zip" ),
	Asset( "ANIM", "anim/wilfre_shadow.zip" ),
}

local prefabs = {
	"wilfre_book",
}

-- Custom starting items
local start_inv = {
	"wilfre_book",
	"nightmarefuel",
}

local function updateBadge(inst, data)
	if inst.HUD.controls.shadowbadge:IsVisible() then
		inst.HUD.controls.shadowbadge:SetPercent(inst.components.shadowable:GetPercent())
		if data and not data.overtime then
			if data.newpercent > data.oldpercent then
				inst.HUD.controls.shadowbadge:PulseGreen()
				--TheFrontEnd:GetSound():PlaySound("dontstarve/HUD/health_up")
			elseif data.newpercent < data.oldpercent then
				--TheFrontEnd:GetSound():PlaySound("dontstarve/HUD/health_down")
				inst.HUD.controls.shadowbadge:PulseRed()
			end
		end
	end
end

local function updateStats(inst)
	local health_per = inst.components.health:GetPercent()
	local hunger_per = inst.components.hunger:GetPercent()
	local sanity_per = inst.components.sanity:GetPercent()
	local shadow_per = inst.components.shadowable:GetPercent()
	
	-- Insanity from being well fed
	if hunger_per > .4 then
		inst.components.sanity.dapperness = -TUNING.SANITYAURA_MED * (hunger_per - .4) / .6
	else
		inst.components.sanity.dapperness = 0
	end
	
	-- Health regeneration from insanity
	if inst.components.health.regen then
		if sanity_per < .8 then
			inst.components.health.regen.amount = 1 - sanity_per * 1.25
		else
			inst.components.health.regen.amount = 0
		end
	end
	
	-- Share damage with shadowiness from sanity
	if sanity_per > .2 then
		inst.components.health.redirect_percent = ((sanity_per - .2)/.8) * .5
	else
		inst.components.health.redirect_percent = 0
	end
	
	-- Strength from injury
	if health_per < .5 then
		inst.components.combat.damagemultiplier = 2 * (1 - health_per)
	else
		inst.components.combat.damagemultiplier = 1
	end
	
	-- Speed from shadowiness
	--Remap(shadow_per,0,1,.75,1.1)
	inst.components.locomotor.runspeed = TUNING.WILSON_RUN_SPEED * (shadow_per * .35 + .75)
end

-- Mostly copy from health.lua
local function redirectHealth(inst, amount, overtime, cause)
	local health = inst.components.health
	
	if health.invincible or health.inst.is_teleporting == true then
        return
    end
	
    if amount < 0 then
        amount = amount - (amount * health.absorb)
		
		if health.redirect_percent and health.redirect_percent > 0 then
			local amount_blocked = amount * health.redirect_percent
			amount = amount - amount_blocked
			inst.components.shadowable:DoDelta(amount_blocked, overtime)
		end
    end

    local old_percent = health:GetPercent()
    health:SetVal(health.currenthealth + amount, cause)
	local new_percent = health:GetPercent()

    health.inst:PushEvent("healthdelta",
		{oldpercent = old_percent, newpercent = new_percent, overtime=overtime, cause=cause})

    if METRICS_ENABLED and health.inst == GetPlayer() and cause and cause ~= "debug_key" then
        if amount > 0 then
            ProfileStatsAdd("healby_" .. cause, math.floor(amount))
            FightStat_Heal(math.floor(amount))
        end
    end

    if health.ondelta then
		health.ondelta(health.inst, old_percent, new_percent)
    end
end

local function PostShadowTransform(inst)
	--[[if not inst.goofx then
		inst.goofx = SpawnPrefab( "shadowgoofx" )
		inst:AddChild(inst.goofx)
	end]]
	
	inst.sg:GoToState("idle")
	SpawnAt("statue_transition_2", inst)
	
	inst.AnimState:SetBuild("wilfre_shadow")
	inst.soundsname = "shadowwilfre"
	
	GetWorld().components.colourcubemanager:SetOverrideColourCube(
		resolvefilepath("images/colour_cubes/wilfre_cc.tex"))

	if inst.HUD and inst.HUD.controls.shadowbadge then
		inst.HUD.controls.shadowbadge:Show()
		inst.HUD.controls.shadowbadge:StartUpdating()
		updateBadge(inst)
	end

	inst.components.health:StartRegen(0, 2)
	inst.components.health.redirect = redirectHealth
	inst.components.health.redirect_percent = 0
	
	if not inst.statsTask then
		inst.statsTask = inst:DoPeriodicTask(.65, updateStats)
	end	
end
local function BecomeShadow(inst, onload)
	
	if onload then
		PostShadowTransform(inst)
	else
		inst.sg:GoToState("powerup")
		inst.AnimState:PlayAnimation("hide")
		inst.SoundEmitter:PlaySound("wilfre/wilfre/transform")
		
		inst:DoTaskInTime(.5,PostShadowTransform)
	end
end

local function BecomeNormal(inst)
	
	inst.sg:GoToState("powerdown")
	inst.AnimState:PlayAnimation("hide")
	inst.SoundEmitter:PlaySound("wilfre/wilfre/transform")
	
	inst:DoTaskInTime(.5,function()
		
		if inst.goofx then
			inst:RemoveChild(inst.goofx)
			inst.goofx:Remove()
			inst.goofx = nil
		end
		
		inst.sg:GoToState("idle")
		SpawnAt("statue_transition_2", inst)
		
		inst.AnimState:SetBuild("wilfre")
		inst.soundsname = "wilfre"
		
		GetWorld().components.colourcubemanager:SetOverrideColourCube()
		
		if inst.HUD and inst.HUD.controls.shadowbadge then
			inst.HUD.controls.shadowbadge:Hide()
			inst.HUD.controls.shadowbadge:StopUpdating()
		end
		
		if inst.statsTask then
			inst.statsTask:Cancel()
		end
		
		inst.components.health:StopRegen()
		inst.components.health.redirect = nil
		inst.components.health.redirect_percent = 0
		
		inst.components.locomotor.runspeed = TUNING.WILSON_RUN_SPEED
		inst.components.combat.damagemultiplier = 1
		inst.components.sanity.dapperness = 0
		
	end)
end

local fn = function(inst)
	
	-- which sounds this character will play
	inst.soundsname = "wilfre"

	-- Minimap icon
	inst.MiniMapEntity:SetIcon( "wilfre.tex" )
	
	-- Main stats	
	--inst.components.health:SetMaxHealth(150)
	--inst.components.hunger:SetMax(150)
	--inst.components.sanity:SetMax(200)
	
	-- Combat damage
    --inst.components.combat.damagemultiplier = 1
	--inst.components.combat:SetDefaultDamage(TUNING.UNARMED_DAMAGE)
	
	-- Hunger rate
	--inst.components.hunger.hungerrate = 1 * TUNING.WILSON_HUNGER_RATE
	
	-- Movement speed
	--inst.components.locomotor.walkspeed = 4
	--inst.components.locomotor.runspeed = TUNING.WILSON_RUN_SPEED
	
	-- Shadowiness by consumables
	table.insert(inst.components.eater.foodprefs, "NIGHTMARE")
	
	-- Shadow Badge
	inst:DoTaskInTime(0, function() -- Let HUD be created first
		inst.HUD.controls.shadowbadge = inst.HUD.controls.sidepanel:AddChild(ShadowableBadge(inst))
		inst.HUD.controls.shadowbadge:SetPosition(-100,-40,0)
		inst.HUD.controls.shadowbadge:SetPercent(0)
		if not inst.components.shadowable:IsShadow() then
			inst.HUD.controls.shadowbadge:Hide()
		end
		inst:ListenForEvent("shadowdelta", updateBadge)
	end)
	
	-- Shadow Form
	inst:AddComponent("shadowable")
	inst.components.shadowable:SetOnShadow(BecomeShadow)
	inst.components.shadowable:SetOnUnshadow(BecomeNormal)
	
	if inst.components.kramped and inst.components.temperature then -- For shadow form
		local old_OnNaughtyAction = inst.components.kramped.OnNaughtyAction
		function inst.components.kramped:OnNaughtyAction(val,...)
			if inst.components.shadowable and inst.components.shadowable:IsShadow() and val then
				inst.components.temperature:SetTemperature(
					inst.components.temperature:GetCurrent() - 4 * val )
			end
			return old_OnNaughtyAction(self,val,...)
		end
	end
	
end

return MakePlayerCharacter("wilfre", prefabs, assets, fn, start_inv)
