local assets =
{
	Asset("ANIM", "anim/papyrus.zip"),
}

local prefabs = {}

local function TryUnlock(inst, player)
	if player and player.prefab == "wilfre" then
		local book = player.components.inventory:FindItem(function(item)
			return item.prefab == "wilfre_book"
		end)
		if book then
			if inst.pagename and not WilfrePagesUnlocked[ inst.pagename ] then
				WilfrePagesUnlocked[ inst.pagename ] = true
				book.AddEntry(book, inst.pagename)
			end
			inst:DoTaskInTime(0,function() -- Let the tile update first
				player.components.inventory:RemoveItem(inst)
				inst:Remove()
			end)
		end
	end
end

local function onload(inst, data)
	if data and data.pagename then
		inst.pagename = data.pagename
	end
end

local function onsave(inst, data)
	if data then
		data.pagename = inst.pagename
	end
end

local function fn()
	local inst = CreateEntity()
	inst.entity:AddTransform()
	inst.entity:AddAnimState()
    MakeInventoryPhysics(inst)
	
	if IsDLCEnabled(CAPY_DLC) then
		MakeInventoryFloatable(inst, "idle_water", "idle")
	end
	
	inst.AnimState:SetBank("papyrus")
	inst.AnimState:SetBuild("papyrus")
	inst.AnimState:PlayAnimation("idle")
    
    inst:AddTag("irreplaceable") -- Prevents this item from being lost
    inst:AddTag("wilfre_page")
	
	-------
	
    inst:AddComponent("inspectable")
	inst.components.inspectable.nameoverride = "wilfre_page"
	inst.components.inspectable.getstatus = function() return inst.pagename end
    
    inst:AddComponent("inventoryitem")
	--inst.components.inventoryitem.atlasname = "images/inventoryimages/.xml"
	inst.components.inventoryitem.imagename = "papyrus"
	inst.components.inventoryitem:SetOnPutInInventoryFn(TryUnlock)
	
    inst:AddComponent("characterspecific")
	inst.components.characterspecific:SetOwner("wilfre")
	
	inst.OnLoad = onload
	inst.OnSave = onsave
	
    return inst
end

return Prefab( "common/inventory/wilfre_page", fn, assets, prefabs)
