--This isn't a follower like the rest, instead it is a boss.

require "brains/wormwilfrebrain"
require "stategraphs/SGwormwilfre"

local TARGET_DIST_SQ = 10 -- you are a lure, so lure the target to you and not other way around
local CHASE_DIST_SQ = TUNING.WORM_CHASE_DIST * TUNING.WORM_CHASE_DIST

local assets=
{
	Asset("ANIM", "anim/worm.zip"),
	Asset("ANIM", "anim/papyrus.zip"),
	--Asset("SOUND", "sound/worm.fsb"),
	Asset("ANIM", "anim/shadowworm.zip"),
}

local prefabs =
{
	"wilfre_page",
	"nightmarefuel",
}

local function retargetfn(inst)

	if inst.sg:HasStateTag("lure") then
		return
	end

	local wilfre = GetPlayer()
	
	if wilfre and wilfre.components.health and not wilfre.components.health:IsDead()
	and inst:GetDistanceSqToInst(wilfre) < TARGET_DIST_SQ then
		return wilfre
	end
	
	--[[return FindEntity(inst, TUNING.WORM_TARGET_DIST, function(guy) 
		if guy.components.combat and guy.components.health and not guy.components.health:IsDead() then
			return guy:HasTag("character")
		end
	end)]]
end

local function shouldKeepTarget(inst, target)

	if inst.sg:HasStateTag("lure") then
		return false
	end
	
	if target and target:IsValid() and target.components.health and not target.components.health:IsDead() then
		local distsq = target:GetDistanceSqToInst(inst)
		return distsq < CHASE_DIST_SQ
	end
	
	return false
end

local function AmbushTarget(inst)
	local target = inst.components.combat.target
	--print("AMBUSH", target)
	if target and target:IsValid() and target.entity:IsVisible() and target ~= inst
	and target.components.health and not target.components.health:IsDead()
	and not inst.sg:HasStateTag("attack") and not inst.sg:HasStateTag("lure")
	and not inst.components.health:IsDead() then
		--print("Triangulating targets position")
		local pt = target:GetPosition()
		
		if target.Physics then
			local angle = (target.Transform:GetRotation() + 90) * DEGREES
			local vel = target.Physics:GetMotorVel()
			
			local x, z = math.sin(angle) * vel, math.cos(angle) * vel
			
			--print("\\/",target.Transform:GetRotation(),x/vel,z/vel)
			
			pt = pt + {x = x * .8, y = 0, z = z * .8}
		end
		
		inst.Transform:SetPosition(pt.x,pt.y,pt.z)
	end
end

local function onpickedfn(inst, target)
	target = target or GetPlayer()
	if target then
		inst.components.combat:SetTarget(target)
		inst:FacePoint(target:GetPosition())
		inst.components.combat:TryAttack(target)
	end

	if inst.attacktask then
		inst.attacktask:Cancel()
		inst.attacktask = nil
	end
end

local function canbeattackedfn(inst, attacker)
	return not inst.sg:HasStateTag("invisible")
end

local function displaynamefn(inst)
	if inst.sg:HasStateTag("lure") then
		return STRINGS.NAMES.WILFRE_PAGE
	end
	return STRINGS.NAMES.WORM_WILFRE 
end

local function playernear(inst)
	if not inst.attacktask and inst.sg:HasStateTag("lure") then
		inst.attacktask = inst:DoTaskInTime(4, onpickedfn)
	end
end

local function playerfar(inst)
	if inst.attacktask then
		inst.attacktask:Cancel()
		inst.attacktask = nil
	end
end

local function onattacked(inst, data)
	if data.attacker then
		--inst.components.combat:SetTarget(data.attacker)
		inst.components.combat:ShareTarget(data.attacker, 40, function(dude) return dude:HasTag("worm") and not dude.components.health:IsDead() end, 3)
	end
end

local function droppage(inst, data)
	--if data.cause then
		local pt = inst:GetPosition()
		local page = SpawnAt("wilfre_page", inst)
		inst.Transform:SetPosition(pt.x, pt.y + .05, pt.z)
		--page.components.inventoryitem:OnDropped(true) -- bounce
		page.pagename = "MULTITOOL"
	--end
end

local function fn()
	local inst = CreateEntity()
	inst.entity:AddTransform()
	inst.entity:AddAnimState()
	inst.entity:AddSoundEmitter()
	
	inst.Transform:SetFourFaced()
	--MakeCharacterPhysics(inst, 1000, .5)
	MakeInventoryPhysics(inst)
	
	-- marker of sorts for debugging
	--[[local light = inst.entity:AddLight()
	light:SetRadius(2)
	light:SetIntensity(1)
	light:SetFalloff(1)
	light:SetColour(1,0,1)]]
	
	inst.AnimState:SetBank("worm")
	inst.AnimState:SetBuild("shadowworm")
	inst.AnimState:PlayAnimation("idle_loop")

	inst:AddTag("scarytoprey")
	inst:AddTag("shadow")
	inst:AddTag("hostile")
	inst:AddTag("notraptrigger")
	
	inst:AddComponent("health")
	inst.components.health:SetMaxHealth(TUNING.WORM_HEALTH)
	inst.components.health.vulnerabletoheatdamage = false
	
	inst:AddComponent("combat")
	inst.components.combat:SetRange(TUNING.WORM_ATTACK_DIST)
	inst.components.combat:SetDefaultDamage(TUNING.WORM_DAMAGE)
	inst.components.combat:SetAttackPeriod(TUNING.WORM_ATTACK_PERIOD)
	inst.components.combat:SetRetargetFunction(.8, retargetfn)
	inst.components.combat:SetKeepTargetFunction(shouldKeepTarget)
	inst.components.combat.canbeattackedfn = canbeattackedfn
	-- move to predicted player position when launching an attack
	--local TryAttack_ = inst.components.combat.TryAttack
	--inst.components.combat.TryAttack = function(cmp, target, ...)
	--	AmbushTarget(inst, target or inst.components.combat.target)
	--	TryAttack_(cmp, target, ...)
	--end
	inst:DoPeriodicTask(1,AmbushTarget)
	

	-- I don't think this thing even needs to walk
	--[[inst:AddComponent("locomotor")
	inst.components.locomotor.walkspeed = 4
	inst.components.locomotor:SetSlowMultiplier( 1 )
	inst.components.locomotor:SetTriggersCreep(false)
	inst.components.locomotor.pathcaps = { ignorecreep = true }]]

	inst:AddComponent("pickable")
	inst.components.pickable.canbepicked = false
	inst.components.pickable.quickpick = true
	inst.components.pickable.onpickedfn = onpickedfn

	-- To attack the player anyways if they are hesitant
	inst:AddComponent("playerprox")
	inst.components.playerprox:SetDist(3, 5)
	inst.components.playerprox:SetOnPlayerNear(playernear)
	inst.components.playerprox:SetOnPlayerFar(playerfar)
	
	inst:AddComponent("sanityaura")
	inst.components.sanityaura.aurafn = function(inst)
		if inst.sg:HasStateTag("lure") then
			return 0
		end
		return -TUNING.SANITYAURA_SMALL
	end
	inst:AddComponent("shadowaura")
	inst.components.shadowaura:SetAura(function(inst)
		if inst.sg:HasStateTag("lure") then
			return 0
		end
		return TUNING.SHADOWAURA.HUGE
	end)

	--inst:AddComponent("inventory")
	--inst:AddComponent("inspectable") -- handled by SG because only lure form allows for examining
	
	inst:AddComponent("lootdropper")
	inst.components.lootdropper:SetLoot({"nightmarefuel"})
	inst:ListenForEvent("droppage", droppage)
	
	inst:ListenForEvent("attacked", onattacked)
	--inst:ListenForEvent("ambush", AmbushTarget)
	
    inst.displaynamefn = displaynamefn  --Handles the changing names.

	inst:SetStateGraph("SGwormwilfre")
	local brain = require"brains/wormwilfrebrain"
	inst:SetBrain(brain)


	return inst
end

return Prefab( "common/monsters/worm_wilfre", fn, assets, prefabs) 
