chestfunctions = require("scenarios/chestfunctions")
local loot =
{
    {
        item = "wilfre_page",
        count = 1,
		initfn = function(item) item.pagename = "TURRET" end,
    },
    {
        item = "nightmarefuel",
        count = 1,
    },
    {
        item = "marble",
        count = 4,
    },
}

local function OnTrap(inst, data)
    local pt = inst:GetPosition()

	inst.SoundEmitter:PlaySound("dontstarve/common/book_spell")

	GetPlayer():DoTaskInTime(1, function(inst)
		inst.components.talker:Say(GetString(inst.prefab, "ANNOUNCE_TRAP_WENT_OFF"))
	end)
		
    --[[local particle = SpawnPrefab("poopcloud")
    particle.Transform:SetScale(1.5, 1.5, 1.5)
    particle.Transform:SetPosition(pt.x, pt.y, pt.z)]]
	
	-- Spawn Bishops right away to prevent Save/Quit cheating
	local ents = TheSim:FindEntities(pt.x,pt.y,pt.z, 16)
	local trees = {}
	local bishops = {}
	
	for k,v in pairs(ents) do
		if v.prefab == "marbletree" then
			table.insert(trees,v)
			--RemovePhysicsColliders(v)
			local bishop = SpawnAt("bishop", v)
			bishop:RemoveFromScene()
			table.insert(bishops, bishop)
		end
	end
	
	-- Wait a bit, then turn the marble trees into bishops if they are still there
	-- Do this with slight delay inbetween for epicness and less bulletspam
	local AwakenBishop
	AwakenBishop = function(inst)
		SpawnAt("collapse_big", trees[1])
		trees[1]:Remove()
		bishops[1]:ReturnToScene()
		bishops[1].SoundEmitter:PlaySound("dontstarve/common/chesspile_repair")
		bishops[1].SoundEmitter:PlaySound("dontstarve/common/ancienttable_repair")
		bishops[1].sg:GoToState("wake")
		table.remove(bishops, 1)
		table.remove(trees, 1)
		if #bishops > 0 then
			inst:DoTaskInTime(.3,AwakenBishop)
		end
	end
	
	inst:DoTaskInTime(1.3,AwakenBishop)
end

local function OnCreate(inst, scenariorunner)
	chestfunctions.AddChestItems(inst, loot)
end


local function OnLoad(inst, scenariorunner)
	-- Custom function to avoid chance
	inst.scene_triggerfn = function(inst, data)
		OnTrap(inst, data)
		scenariorunner:ClearScenario()
	end
	inst:ListenForEvent("onopen", inst.scene_triggerfn)
	inst:ListenForEvent("worked", inst.scene_triggerfn)
end

local function OnDestroy(inst)
    chestfunctions.OnDestroy(inst)
end


return
{
    OnCreate = OnCreate,
    OnLoad = OnLoad,
    OnDestroy = OnDestroy
}