local Screen = require "widgets/screen"
local Button = require "widgets/button"
local ImageButton = require "widgets/imagebutton"
local Menu = require "widgets/menu"
local Text = require "widgets/text"
local Image = require "widgets/image"
local UIAnim = require "widgets/uianim"
local Widget = require "widgets/widget"

local ThisScreen = Class(Screen, function(self)
	Screen._ctor(self, "WilfrePageListDialog")
	
	self.itemlist = {}
	for k, _ in pairs(WilfrePagesUnlocked) do
		if STRINGS.WILFRE_PAGES[k] then
			table.insert(self.itemlist, STRINGS.WILFRE_PAGES[k])
		else
			table.insert(self.itemlist, k)
		end
	end
	--TODO sort alphabetically because its nice
	
	--darken everything behind the dialog
	self.black = self:AddChild(Image("images/global.xml", "square.tex"))
	self.black:SetVRegPoint(ANCHOR_MIDDLE)
	self.black:SetHRegPoint(ANCHOR_MIDDLE)
	self.black:SetVAnchor(ANCHOR_MIDDLE)
	self.black:SetHAnchor(ANCHOR_MIDDLE)
	self.black:SetScaleMode(SCALEMODE_FILLSCREEN)
	self.black:SetTint(0,0,0,.75)	
	
	self.proot = self:AddChild(Widget("ROOT"))
	self.proot:SetVAnchor(ANCHOR_MIDDLE)
	self.proot:SetHAnchor(ANCHOR_MIDDLE)
	self.proot:SetPosition(0,0)
	self.proot:SetScaleMode(SCALEMODE_PROPORTIONAL)

	--throw up the background
	self.bg = self.proot:AddChild(Image("images/fepanels.xml", "panel_saveslots.tex"))
	self.bg:SetVRegPoint(ANCHOR_MIDDLE)
	self.bg:SetHRegPoint(ANCHOR_MIDDLE)
	--self.bg:SetScale(1.2,1.2,1.2)
	
	-- title	
	self.title = self.proot:AddChild(Text(TITLEFONT, 60))
	self.title:SetPosition( 0, 200)
	self.title:SetRegionSize(250,70)
	self.title:SetString("Life Pages")
	self.title:SetVAlign(ANCHOR_MIDDLE)
	
	-- text
	self.text = self.proot:AddChild(Text(BODYTEXTFONT, 48))
	self.text:SetPosition(0, -5)
	self.text:SetRegionSize(300, 350)
	--self.text:EnableWordWrap(true)
	
	--left arrow should point upwards, right one downwards
	
	--[[self.lbtn = ImageButton(nil,"next_arrow.tex","next_arrow_over.tex","next_arrow.tex")
	self.lbtn:SetScale(-.8,.8,.8)
	--TODO how to rotate?
	self.lbtn:SetOnClick(function()
		self.pagenum = self.pagenum - 1
		self:ShowEntries()
	end)
	
	self.rbtn = ImageButton(nil,"next_arrow.tex","next_arrow_over.tex","next_arrow.tex")
	self.rbtn:SetScale(.8,.8,.8)
	self.rbtn:SetOnClick(function()
		self.pagenum = self.pagenum + 1
		self:ShowEntries()
	end)]]
	
	local menuitems = {
		--{widget = self.lbtn},
		{text = STRINGS.UI.OPTIONS.CLOSE, cb = function()
			TheFrontEnd:PopScreen(self)
		end},
		--{widget = self.rbtn},
	}
	self.menu = self.proot:AddChild(Menu(menuitems, 120, true))
	--self.menu:SetPosition(-120, -235, 0) -- The first item is centre, so we have to move one over
	self.menu:SetPosition(0, -235, 0) -- W/out arrows
	
	self.default_focus = self.menu
	
	self.pagenum = 0
	self:ShowEntries()
end)

function ThisScreen:ShowEntries()
    local pastentries = self.pagenum * 5
	--[[local t = { }
	for i = pastentries + 1, math.min(pastentries + 5, #self.itemlist) do
		t[#t+1] = tostring(self.itemlist[i])
	end]]
	local s = table.concat(self.itemlist,"\n", pastentries + 1, math.min(pastentries + 5, #self.itemlist))
	print(s)
	self.text:SetString( s )
	
	--[[if self.pagenum < 1 then
		self.lbtn:Disable()
	else
		self.lbtn:Enable()
	end
	if pastentries + 6 > #self.itemlist then
		self.rbtn:Disable()
	else
		self.rbtn:Enable()
	end]]
end

function ThisScreen:OnControl(control, down)
	if Screen.OnControl(self, control, down) then return true end
	if not down and control == CONTROL_CANCEL then
		TheFrontEnd:PopScreen(self)
		return true
	end
end

function ThisScreen:GetHelpText()
	local controller_id = TheInput:GetControllerID()
	return TheInput:GetLocalizedControl(controller_id, CONTROL_CANCEL) .. " " .. STRINGS.UI.HELP.BACK
end

return ThisScreen