require("stategraphs/commonstates")

local function WingDown(inst)
	inst.SoundEmitter:PlaySound("dontstarve/creatures/bat/flap")
end

local actionhandlers = {}

local events=
{
	CommonHandlers.OnLocomote(false, true),
	CommonHandlers.OnAttack(),
	CommonHandlers.OnAttacked(),
	CommonHandlers.OnDeath(),
}

local states =
{
	State{
		
		name = "idle",
		tags = {"idle", "canrotate"},
		onenter = function(inst, playanim)
			inst.Physics:Stop()
			if playanim then
				inst.AnimState:PlayAnimation(playanim)
				inst.AnimState:PushAnimation("fly_loop", true)
			else
				inst.AnimState:PlayAnimation("fly_loop", true)
			end
		end,
		
		timeline = 
		{
			TimeEvent(7*FRAMES, function(inst) WingDown(inst) end ),
			TimeEvent(17*FRAMES, function(inst) WingDown(inst) end ),
		},
		
		events=
		{
			EventHandler("animover", function(inst) inst.sg:GoToState("idle") end),
		},
	},
	
	State{
		
		name = "action",
		onenter = function(inst, playanim)
			inst.Physics:Stop()
			inst.AnimState:PlayAnimation("fly_loop", true)
			inst:PerformBufferedAction()
		end,
		events=
		{
			EventHandler("animover", function (inst)
				inst.sg:GoToState("idle")
			end),
		}
	},

	State{
		name = "taunt",
		tags = {"busy"},
		
		onenter = function(inst)
			inst.Physics:Stop()
			inst.AnimState:PlayAnimation("taunt")
		end,

		timeline = 
		{
			TimeEvent(1*FRAMES, function(inst) inst.SoundEmitter:PlaySound("dontstarve/sanity/creature2/attack_grunt", nil, 1) end ),
			TimeEvent(7*FRAMES, function(inst) WingDown(inst)  end ),
			TimeEvent(18*FRAMES, function(inst) WingDown(inst)  end ),
			TimeEvent(28*FRAMES, function(inst) WingDown(inst)  end ),
			TimeEvent(43*FRAMES, function(inst) WingDown(inst)  end ),
		},
		
		events=
		{
			EventHandler("animover", function(inst) inst.sg:GoToState("idle") end),
		},
	},
	
	State{
		name = "attack",
		tags = {"attack", "moving", "busy"},
		
		onenter = function(inst, target)
			inst.components.combat:StartAttack()
			inst.AnimState:PlayAnimation("atk")
			--inst.sg.statemem.target = target
		end,
		
		timeline = 
		{
			TimeEvent(8*FRAMES, function(inst) inst.SoundEmitter:PlaySound("dontstarve/sanity/creature1/taunt", nil, 1) end),
			TimeEvent(11*FRAMES, function(inst) 
				inst.components.combat:DoAttack()
				WingDown(inst)
			end),
		},
		
		events=
		{
			EventHandler("animover", function(inst)
				inst.sg.statemem.overshoot = 1
				inst.sg:GoToState("overshoot")
			end),
		},
	},
	
	State{
		name = "overshoot",
		tags = {"moving"},
		
		onenter = function(inst)
			inst.AnimState:PlayAnimation("fly_loop")
		end,
		timeline = 
		{
			TimeEvent(7*FRAMES, function(inst) WingDown(inst)  end ),
			TimeEvent(17*FRAMES, function(inst) WingDown(inst)  end ),
		},
		events=
		{   
			EventHandler("animover", function(inst)
				if inst.sg.statemem.overshoot and inst.sg.statemem.overshoot > 0 then
					inst.sg.statemem.overshoot = inst.sg.statemem.overshoot - 1
					inst.sg:GoToState("overshoot")
				else
					inst.sg:GoToState("idle")
				end
			end),
		},
	},
	
	State{
		name = "hit",
		tags = {"hit", "busy"},
		
		onenter = function(inst, cb)
			inst.components.locomotor:StopMoving()
			inst.AnimState:PlayAnimation("hit")
		end,
		
		timeline =
		{
			--TimeEvent(1*FRAMES, function(inst) inst.SoundEmitter:PlaySound("dontstarve/creatures/bat/hurt") end),
			TimeEvent(7*FRAMES, function(inst) WingDown(inst)  end ),
		},
		
		events =
		{
			EventHandler("animover", function(inst) inst.sg:GoToState("idle") end),
		},
	},
	
	State{
		name = "death",  
		tags = {"busy"},
		
		onenter = function(inst)
			inst.AnimState:PlayAnimation("death")
			inst.components.locomotor:StopMoving()
			inst.Physics:ClearCollisionMask()   
		end,
		
		timeline =
		{
			TimeEvent(1*FRAMES, function(inst) inst.SoundEmitter:PlaySound("dontstarve/sanity/creature1/attack_grunt", nil, 1) end),
			TimeEvent(4*FRAMES, function(inst) WingDown(inst)  end ),
		},
	},
}


local walkanims = 
{
	startwalk = "fly_loop",
	walk = "fly_loop",
	stopwalk = "fly_loop",
}

CommonStates.AddWalkStates(states,
{
	starttimeline =
	{
		TimeEvent(7*FRAMES, function(inst) WingDown(inst)  end ),
		TimeEvent(17*FRAMES, function(inst) WingDown(inst)  end ),
	},

	walktimeline = 
	{
		TimeEvent(7*FRAMES, function(inst) WingDown(inst)  end ),
		TimeEvent(17*FRAMES, function(inst) WingDown(inst)  end ),
	},

	endtimeline =
	{
		TimeEvent(7*FRAMES, function(inst) WingDown(inst)  end ),
		TimeEvent(17*FRAMES, function(inst) WingDown(inst)  end ),
	},

},  walkanims, true)

CommonStates.AddSimpleState(states, "born", "sleep_pst", {"busy", "waking"})


return StateGraph("bat_wilfre", states, events, "idle", actionhandlers)