require("stategraphs/commonstates")

local events=
{
	EventHandler("attacked", function(inst) 
		if not inst.components.health:IsDead() then
			inst.sg:GoToState("hit_stunlock")  -- can't attack during hit reaction
		end 
	end),
	EventHandler("doattack", function(inst, data) 
		if not inst.components.health:IsDead() and not inst.sg:HasStateTag("busy")
		and data and data.target then
			inst.sg:GoToState("attack", data.target) 
		end 
	end),
	EventHandler("death", function(inst) inst.sg:GoToState("death") end),
	
	EventHandler("locomote", function(inst) 
		if not inst.sg:HasStateTag("busy") then
			
			local is_moving = inst.sg:HasStateTag("moving")
			local wants_to_move = inst.components.locomotor:WantsToMoveForward()
			if not inst.sg:HasStateTag("attack") and is_moving ~= wants_to_move then
				if wants_to_move then
					inst.sg:GoToState("premoving")
				else
					inst.sg:GoToState("idle")
				end
			end
		end
	end),    
}

local states =
{
	State{
		name = "death",
		tags = {"busy"},
		
		onenter = function(inst)
			inst.SoundEmitter:PlaySound("dontstarve/sanity/creature1/attack", nil, 1)
			inst.AnimState:PlayAnimation("death")
			inst.Physics:Stop()
			RemovePhysicsColliders(inst)       
		end,
	},

	State{
		name = "premoving",
		tags = {"moving", "canrotate"},
		
		onenter = function(inst)
			inst.components.locomotor:WalkForward()
			inst.AnimState:PlayAnimation("walk_pre")
		end,
		
		timeline=
		{
			TimeEvent(3*FRAMES, function(inst) inst.SoundEmitter:PlaySound("dontstarve/creatures/spider/walk_spider", nil, 1) end),
		},
		
		events=
		{
			EventHandler("animover", function(inst) inst.sg:GoToState("moving") end),
		},
	},

	State{
		name = "moving",
		tags = {"moving", "canrotate"},
		
		onenter = function(inst)
			inst.components.locomotor:RunForward()
			inst.AnimState:PushAnimation("walk_loop")
		end,
		
		timeline=
		{
			TimeEvent(0*FRAMES, function(inst) inst.SoundEmitter:PlaySound("dontstarve/creatures/spider/walk_spider") end),
			TimeEvent(3*FRAMES, function(inst) inst.SoundEmitter:PlaySound("dontstarve/creatures/spider/walk_spider") end),
			TimeEvent(7*FRAMES, function(inst) inst.SoundEmitter:PlaySound("dontstarve/creatures/spider/walk_spider") end),
			TimeEvent(12*FRAMES, function(inst) inst.SoundEmitter:PlaySound("dontstarve/creatures/spider/walk_spider") end),
		},
		
		events=
		{
			EventHandler("animover", function(inst) inst.sg:GoToState("moving") end),
		},
		
	},    

	State{
		name = "idle",
		tags = {"idle", "canrotate"},
		
		ontimeout = function(inst)
			inst.sg:GoToState("taunt")
		end,
		
		onenter = function(inst, start_anim)
			inst.Physics:Stop()
			
			if math.random() < .3 then
				inst.sg:SetTimeout(math.random()*2 + 2)
			end
			
			if start_anim then
				inst.AnimState:PlayAnimation(start_anim)
				inst.AnimState:PushAnimation("idle", true)
			else
				inst.AnimState:PlayAnimation("idle", true)
			end
		end,
	},

	State{
		name = "born",
		tags = {"busy"},
		
		onenter = function(inst)
			inst.AnimState:PlayAnimation("sleep_pst")
		end,
		
		events=
		{
			EventHandler("animover", function(inst) inst.sg:GoToState("idle") end),
		},
	},

	State{
		name = "taunt",
		tags = {"busy"},
		
		onenter = function(inst)
			inst.Physics:Stop()
			inst.AnimState:PlayAnimation("taunt")
			inst.SoundEmitter:PlaySound("dontstarve/sanity/creature1/idle", nil, 1)
		end,
		
		events=
		{
			EventHandler("animover", function(inst) inst.sg:GoToState("idle") end),
		},
	},
	
	State{
		name = "attack",
		tags = {"attack", "busy"},
		
		onenter = function(inst, target)
			inst.Physics:Stop()
			inst.components.combat:StartAttack()
			inst.AnimState:PlayAnimation("atk")
			inst.sg.statemem.target = target
		end,
		
		timeline=
		{
			TimeEvent(10*FRAMES, function(inst)
				inst.SoundEmitter:PlaySound("dontstarve/sanity/creature1/attack", nil, 1)
				inst.SoundEmitter:PlaySound("dontstarve/creatures/spider/attack_grunt")
			end),
			TimeEvent(25*FRAMES, function(inst) inst.components.combat:DoAttack(inst.sg.statemem.target) end),
		},
		
		events=
		{
			EventHandler("animover", function(inst) inst.sg:GoToState("idle") end),
		},
	},

	State{
		name = "hit_stunlock",
		tags = {"busy"},
		
		onenter = function(inst)
			--inst.SoundEmitter:PlaySound("dontstarve/creatures/spider/hit_response")
			inst.AnimState:PlayAnimation("hit")
			inst.Physics:Stop()
		end,
		
		events=
		{
			EventHandler("animover", function(inst) inst.sg:GoToState("idle") end ),
		},
	},
}

return StateGraph("spider_wilfre", states, events, "idle")

