require("stategraphs/commonstates")

local events=
{
	CommonHandlers.OnDeath(),
	CommonHandlers.OnAttack(),
	EventHandler("entershield", function(inst) 
		if not inst.components.health:IsDead() and not 
			inst.sg:HasStateTag("attack") and not 
			inst.sg:HasStateTag("busy") then
			inst.sg:GoToState("shield_start") 
		end 
	end),
	EventHandler("exitshield", function(inst) 
		if not inst.components.health:IsDead() and
			inst.sg:HasStateTag("shield") and not 
			inst.sg:HasStateTag("busy") then
			inst.sg:GoToState("shield_end") 
		end 
	end),
}

local states=
{   
	State{
		name = "idle",
		tags = {"idle"},
		onenter = function(inst)
			inst.AnimState:PlayAnimation("idle_loop", true)
		end, 
		events=
		{
			EventHandler("animover", function(inst) inst.sg:GoToState("idle") end),
		},
	},
	

	State{
		name = "shield_start",
		tags = {"busy", "shield"},
		onenter = function(inst)
			inst.AnimState:PlayAnimation("open_pre")
			inst.SoundEmitter:PlaySound("dontstarve/sanity/creature1/hit_response", nil, 1)
		end,

		events=
		{
			EventHandler("animover", function(inst)
				inst.sg:GoToState("shield")
			end),
		},
	},
	
	State{
		name = "shield",
		tags = {"idle", "shield"},
		onenter = function(inst)
			inst.AnimState:PlayAnimation("open_loop")
            inst.sg:SetTimeout(2)
		end,

		events=
		{
			EventHandler("animover", function(inst)
				inst.sg:GoToState("shield")
			end),
		},
	},
	
	State{
		name = "shield_end",
		tags = {"busy", "shield"},
		onenter = function(inst)
			inst.AnimState:PlayAnimation("open_pst")
			inst.SoundEmitter:PlaySound("dontstarve/sanity/creature1/appear", nil, 1)
		end,

		events=
		{
			EventHandler("animover", function(inst)
				inst.sg:GoToState("idle")
			end),
		},
	},
	
	
	State{
		name = "death",
		tags = {"busy"},
		
		onenter = function(inst)
			inst.AnimState:PlayAnimation("open_pre")    
		end,

		timeline = 
		{
			TimeEvent(7*FRAMES, function(inst) inst.SoundEmitter:PlaySound("dontstarve/sanity/creature1/dissappear", nil, 1) end)
		},
	},

	State
	{
		name = "attack",
		tags = {"attack"},
		onenter = function(inst)
			inst.AnimState:PlayAnimation("cough")
			inst.SoundEmitter:PlaySound("dontstarve/sanity/creature1/idle", nil, 1)
			inst.components.combat:StartAttack()
		end,        
		timeline=
		{
			TimeEvent(10*FRAMES, function(inst)
				inst.SoundEmitter:PlaySound("dontstarve/common/teleportworm/sick_cough")
				local dmg = inst.components.combat.defaultdamage
				inst.components.combat:SetDefaultDamage(0) -- This is so it just shoots w/out magically instant damage
				inst.components.combat:DoAttack()
				inst.components.combat:SetDefaultDamage(dmg)
			end),
		},
		
		events=
		{
			EventHandler("animover", function(inst) inst.sg:GoToState("idle") end),
		},
	},
}

return StateGraph("turret_wilfre", states, events, "idle")
