require("stategraphs/commonstates")

local actionhandlers = {}

local events =
{
	CommonHandlers.OnLocomote(false, true),
	CommonHandlers.OnDeath(),
	EventHandler("doattack", function(inst, data)
		if not inst.components.health:IsDead() and not inst.sg:HasStateTag("busy") then
			inst.sg:GoToState("attack")
		end
	end),
	EventHandler("attacked", function(inst, data)
		if not inst.components.health:IsDead() and not inst.sg:HasStateTag("busy")
		and not inst.sg:HasStateTag("invisible") and not inst.sg:HasStateTag("nohit") then
			inst.sg:GoToState("hit")
		end
	end),
	EventHandler("dolure", function(inst) inst.sg:GoToState("lure") end)
}

local states =
{

	State{
		name = "idle",
		tags = {"idle", "invisible"},
		onenter = function(inst)
			--inst.Physics:Stop()
			inst.AnimState:PlayAnimation("mound_idle")
			--inst.SoundEmitter:KillAllSounds()
		end,
		
		events = 
		{
			EventHandler("animover", function(inst) inst.sg:GoToState("idle") end)
		},
	},
	
	State{ 
		name = "attack",
		tags = {"attack", "nohit"},
		onenter = function(inst)
			inst:PushEvent("ambush")
			inst:FacePoint(inst.components.combat.target.Transform:GetWorldPosition())
			inst.AnimState:PlayAnimation("atk")
			inst.components.combat:StartAttack()
			inst.SoundEmitter:PlaySound("dontstarve/creatures/worm/emerge")
		end,
		
		timeline=
		{
			--TimeEvent(20*FRAMES, function(inst) inst.sg:AddStateTag("nohit") end),
			TimeEvent(25*FRAMES, function(inst)
				inst.components.combat:DoAttack()
				inst.SoundEmitter:PlaySound("dontstarve/sanity/creature1/taunt", nil, 1)
			end),
			TimeEvent(40*FRAMES, function(inst) inst.SoundEmitter:PlaySound("dontstarve/creatures/worm/retract") end), 

		},
		
		events=
		{
			EventHandler("animover", function(inst) inst.sg:GoToState("idle") end),
		},
	},
	
	
	State{
		name = "death",
		tags = {"busy"},
		
		onenter = function(inst)
			inst.AnimState:PlayAnimation("death")
			RemovePhysicsColliders(inst)            
			inst.components.lootdropper:DropLoot(Vector3(inst.Transform:GetWorldPosition()))            
		end,   
		timeline=
		{           
			TimeEvent(1*FRAMES, function(inst)
				inst.SoundEmitter:PlaySound("dontstarve/creatures/worm/retract")
				inst.SoundEmitter:PlaySound("dontstarve/sanity/creature2/die", nil, 1)
			end),
			TimeEvent(25*FRAMES, function(inst) inst:PushEvent("droppage") end),
		},
	},
		
	State{ -- This solely serves as failsafe, as the conditions are never met at the time
		name = "hit",
		tags = {"busy", "hit"},
		
		onenter = function(inst)
			inst.AnimState:PlayAnimation("hit")
		end,          
		timeline=
		{           
			TimeEvent(20*FRAMES, function(inst) inst.SoundEmitter:PlaySound("dontstarve/creatures/worm/retract") end), 
			TimeEvent(1*FRAMES, function(inst) inst.SoundEmitter:PlaySound("dontstarve/creatures/worm/hurt") end),
		},         
		events=
		{
			EventHandler("animover", function(inst) inst.sg:GoToState("idle") end),
		},        
	},  

	State{
		name = "lure",
		tags = {"invisible", "lure"},
		onenter = function(inst)
			--inst.Physics:Stop()
			inst.AnimState:SetBuild("papyrus")
			inst.AnimState:SetBank("papyrus")
			inst.AnimState:PlayAnimation("idle")
			inst.SoundEmitter:KillAllSounds()
			inst.components.pickable.canbepicked = true
			--ChangeToInventoryPhysics(inst)
			inst:AddComponent("inspectable")
			inst.sg:SetTimeout(2)
		end,

		ontimeout = function(inst)
			inst.sg:GoToState("lure")
		end,

		onexit = function(inst)
			inst.AnimState:SetBuild("shadowworm")
			inst.AnimState:SetBank("worm")
			inst.lastluretime = GetTime()
			inst.components.pickable.canbepicked = false
			--ChangeToCharacterPhysics(inst)
			inst:RemoveComponent("inspectable") -- Or just disable it for performance reasons?
		end,
	},

}
	
return StateGraph("worm_wilfre", states, events, "idle", actionhandlers)
