local Badge = require "widgets/badge"
local UIAnim = require "widgets/uianim"

local ShadowableBadge = Class(Badge, function(self, owner)
	Badge._ctor(self, "shadowablebadge", owner)
	
	self.sanityarrow = self.underNumber:AddChild(UIAnim())
	self.sanityarrow:GetAnimState():SetBank("sanity_arrow")
	self.sanityarrow:GetAnimState():SetBuild("sanity_arrow")
	self.sanityarrow:GetAnimState():PlayAnimation("neutral")
	self.sanityarrow:SetClickable(false)

	self:StartUpdating()
end)

function ShadowableBadge:OnUpdate(dt)
	if self:IsVisible() then
		local rate = self.owner.components.shadowable:GetRate()
		local anim = "neutral"
		
		if rate > 0 and self.owner.components.shadowable:GetPercent() < 1 then
			if rate > TUNING.SHADOWAURA.LARGE then
				anim = "arrow_loop_increase_most"
			elseif rate > TUNING.SHADOWAURA.SMALL then
				anim = "arrow_loop_increase_more"
			elseif rate > TUNING.SHADOWAURA.TINY then
				anim = "arrow_loop_increase"
			end
		elseif rate < -TUNING.SHADOWAURA.TINY and self.owner.components.shadowable:GetPercent() > 0 then
			if rate <= -TUNING.SHADOWAURA.SMALL then
				anim = "arrow_loop_decrease_more"
			else
				anim = "arrow_loop_decrease"
			end
		end
		
		if self.arrowdir ~= anim then
			self.arrowdir = anim
			self.sanityarrow:GetAnimState():PlayAnimation(anim, true)
		end
	end
end

return ShadowableBadge