
local MakePlayerCharacter = require "prefabs/player_common"

local assets = {Asset("SCRIPT", "scripts/prefabs/player_common.lua")}

local prefabs = {}

local start_inv = {"houndstooth", "bedroll_furry", "sewing_kit"}

local function onbecamehuman(inst)

	inst.components.locomotor:SetExternalSpeedMultiplier(inst, "kagerou_speed_mod", 1)
	
end

local function onbecameghost(inst)

   inst.components.locomotor:RemoveExternalSpeedMultiplier(inst, "kagerou_speed_mod")
   
end

local function onload(inst)

    inst:ListenForEvent("ms_respawnedfromghost", onbecamehuman)
    inst:ListenForEvent("ms_becameghost", onbecameghost)

    if inst:HasTag("playerghost") then
	
        onbecameghost(inst)
		
    else
	
        onbecamehuman(inst)
		
    end
end

local function perkstats(inst)

	if TheWorld.state.phase == "day" then
	
		inst.components.sanity.neg_aura_mult = 0.90
		inst.components.sanity.night_drain_mult = 0.90
		
		inst.components.temperature.inherentinsulation = ( TUNING.INSULATION_PER_BEARD_BIT * 4.50 )
		
		inst.components.locomotor.walkspeed = ( TUNING.WILSON_WALK_SPEED * 0.90 )
		inst.components.locomotor.runspeed = ( TUNING.WILSON_RUN_SPEED * 0.90 )
		
		inst.components.combat.damagemultiplier = 0.90
		
		inst.components.hunger.hungerrate = ( TUNING.WILSON_HUNGER_RATE * 0.90 )

	elseif TheWorld.state.phase == "dusk" then

		inst.components.sanity.neg_aura_mult = 0.60
		inst.components.sanity.night_drain_mult = 0.60
		
		inst.components.temperature.inherentinsulation = ( TUNING.INSULATION_PER_BEARD_BIT * 6.00 )
		
		inst.components.locomotor.walkspeed = ( TUNING.WILSON_WALK_SPEED * 1.20 )
		inst.components.locomotor.runspeed = ( TUNING.WILSON_RUN_SPEED * 1.20 )
		
		inst.components.combat.damagemultiplier = 1.20
		
		inst.components.hunger.hungerrate = ( TUNING.WILSON_HUNGER_RATE * 1.20 )
		
	elseif TheWorld.state.phase == "night" then
	
		inst.components.talker:Say("Night Huntress", 3.0)

		inst.components.sanity.neg_aura_mult = 0.30
		inst.components.sanity.night_drain_mult = 0.30
		
		inst.components.temperature.inherentinsulation = ( TUNING.INSULATION_PER_BEARD_BIT * 7.50 )
		
		inst.components.locomotor.walkspeed = ( TUNING.WILSON_WALK_SPEED * 1.80 )
		inst.components.locomotor.runspeed = ( TUNING.WILSON_RUN_SPEED * 1.80 )
		
		inst.components.combat.damagemultiplier = 1.80
		
		inst.components.hunger.hungerrate = ( TUNING.WILSON_HUNGER_RATE * 1.50 )
	
	elseif tempCaveVar == true and TheWorld.state.phase == "caveday" then
		
		inst.components.sanity.neg_aura_mult = 0.90
		inst.components.sanity.night_drain_mult = 0.90
		
		inst.components.temperature.inherentinsulation = ( TUNING.INSULATION_PER_BEARD_BIT * 4.50 )
		
		inst.components.locomotor.walkspeed = ( TUNING.WILSON_WALK_SPEED * 0.90 )
		inst.components.locomotor.runspeed = ( TUNING.WILSON_RUN_SPEED * 0.90 )
		
		inst.components.combat.damagemultiplier = 0.90
		
		inst.components.hunger.hungerrate = ( TUNING.WILSON_HUNGER_RATE * 0.90 )
		
	elseif tempCaveVar == true and TheWorld.state.phase == "cavedusk" then

		inst.components.sanity.neg_aura_mult = 0.60
		inst.components.sanity.night_drain_mult = 0.60
		
		inst.components.temperature.inherentinsulation = ( TUNING.INSULATION_PER_BEARD_BIT * 6.00 )
		
		inst.components.locomotor.walkspeed = ( TUNING.WILSON_WALK_SPEED * 1.20 )
		inst.components.locomotor.runspeed = ( TUNING.WILSON_RUN_SPEED * 1.20 )
		
		inst.components.combat.damagemultiplier = 1.20
		
		inst.components.hunger.hungerrate = ( TUNING.WILSON_HUNGER_RATE * 1.20 )
		
	elseif tempCaveVar == true and TheWorld.state.phase == "cavenight" then
	
		inst.components.talker:Say("Night Huntress", 3.0)

		inst.components.sanity.neg_aura_mult = 0.30
		inst.components.sanity.night_drain_mult = 0.30
		
		inst.components.temperature.inherentinsulation = ( TUNING.INSULATION_PER_BEARD_BIT * 7.50 )
		
		inst.components.locomotor.walkspeed = ( TUNING.WILSON_WALK_SPEED * 1.80 )
		inst.components.locomotor.runspeed = ( TUNING.WILSON_RUN_SPEED * 1.80 )
		
		inst.components.combat.damagemultiplier = 1.80
		
		inst.components.hunger.hungerrate = ( TUNING.WILSON_HUNGER_RATE * 1.50 )
		
	end
	
end

local common_postinit = function(inst) 

	inst.MiniMapEntity:SetIcon( "kagerou.tex" )
	
end

local master_postinit = function(inst)

	inst.soundsname = "willow"

	inst.components.health:SetMaxHealth(150)
	inst.components.hunger:SetMax(150)
	inst.components.sanity:SetMax(300)
	
	inst.components.sanity.neg_aura_mult = 0.90
	inst.components.sanity.night_drain_mult = 0.90
		
	inst.components.temperature.inherentinsulation = ( TUNING.INSULATION_PER_BEARD_BIT * 4.50 )
		
	inst.components.locomotor.walkspeed = ( TUNING.WILSON_WALK_SPEED * 0.90 )
	inst.components.locomotor.runspeed = ( TUNING.WILSON_RUN_SPEED * 0.90 )
		
	inst.components.combat.damagemultiplier = 0.90
		
	inst.components.hunger.hungerrate = ( TUNING.WILSON_HUNGER_RATE * 0.90 )
	
	inst.OnLoad = onload
    inst.OnNewSpawn = onload

	inst:WatchWorldState( "startday", function(inst) perkstats(inst) end )
	inst:WatchWorldState( "startdusk", function(inst) perkstats(inst) end )
	inst:WatchWorldState( "startnight", function(inst) perkstats(inst) end )
	inst:WatchWorldState( "startcaveday", function(inst) perkstats(inst) end )
	inst:WatchWorldState( "startcavedusk", function(inst) perkstats(inst) end )
	inst:WatchWorldState( "startcavenight", function(inst) perkstats(inst) end )
	perkstats(inst)
	return inst

end

return MakePlayerCharacter("kagerou", prefabs, assets, common_postinit, master_postinit, start_inv)

--Current Mod Version: [1.3.8]
--DST Character Mod created by: Senshimi [https://steamcommunity.com/id/Senshimi/]
--Touhou Project Collection: [http://steamcommunity.com/sharedfiles/filedetails/?id=701414094]
