--[[	Copyright (c) 2015 Kzisor/Ysovuka	]]

local SPAWNTYPE =
{
	RANDOM = 0,
	STATIC = 1,
}

local function GetAmount( count, chance )

	-- Set chance to chance or 100 to ensure it spawns.
	chance = chance or 100

	-- Set count to count or 1 to ensure it spawns.
	count = count or 1

	-- Localized return variable.
	local _count = 0

	-- Iterate through the amount of potential spawns.
    for i = 0, count do

    	-- Ensure that we are lucky enough to spawn.
        if (chance * 10) >= math.random(1, 1000) then

        	-- Increase spawn count.
            
            _count = _count + 1
        
        end

    end

    -- Return the amount which will spawn.
    return _count

end

local function AddRandom( room, prefab_name, count )

	-- Ensure that we have a variable to store our data.
    if not room.contents.distributeprefabs then
        room.contents.distributeprefabs = {}
    end

    --	Add out prefab to the room prefabs.
    room.contents.distributeprefabs[prefab_name] = count

end

local function AddStatic( room, prefab_name, count, chance )

	-- Ensure that we have a variable to store our data.
    if not room.contents.countprefabs then
        room.contents.countprefabs = {}
    end

    count = GetAmount( count, chance )

    if count >= 1 then

    	--	Add out prefab to the room prefabs.
    	room.contents.countprefabs[prefab_name] = count

    end

end

--[[
	This function acts as a wrapper which we will use to add our custom prefab to the room.
	----------------------------------------------------------------------------------------
	room_id			-	Room Identification (ex. Badlands or BGGrass)
	spawn_type 		-	Spawn Type (SPAWNTYPE.RANDOM, SPAWNTYPE.STATIC) Default is SPAWNTYPE.STATIC.
	prefab_name		-	The name of the prefab which we want to spawn.
	count 			-	The amount of prefbs you want to spawn. Default is 1.
	chance			-	The percentages chance the prefab has to spawn. Default is 100.
--]]
local function CreateRoomPrefab( room_id, spawn_type, prefab_name, count, chance )

	if spawn_type == SPAWNTYPE.RANDOM then

		AddRoomPreInit( room_id, function( room )

			AddRandom( room, prefab_name, count )

		end)

	else

		AddRoomPreInit( room_id, function( room )

			AddStatic( room, prefab_name, count, chance )

		end)

	end

end

env.Map.CreateRoomPrefab = CreateRoomPrefab
env.Map.SPAWNTYPE = SPAWNTYPE
