PrefabFiles = {
	"wicklee",
	"gardenofshadows",
}

Assets = {
	Asset("IMAGE", "images/saveslot_portraits/wicklee.tex"),
	Asset("ATLAS", "images/saveslot_portraits/wicklee.xml"),
	
	Asset( "IMAGE", "images/selectscreen_portraits/wicklee.tex" ),
    Asset( "ATLAS", "images/selectscreen_portraits/wicklee.xml" ),
	
    Asset( "IMAGE", "images/selectscreen_portraits/wicklee_silho.tex" ),
    Asset( "ATLAS", "images/selectscreen_portraits/wicklee_silho.xml" ),
    
    Asset( "IMAGE", "bigportraits/wicklee.tex" ),
    Asset( "ATLAS", "bigportraits/wicklee.xml" ),
    
    Asset( "IMAGE", "bigportraits/wicklee_none.tex" ),
    Asset( "ATLAS", "bigportraits/wicklee_none.xml" ),
	
	Asset( "IMAGE", "images/map_icons/wicklee.tex" ),
	Asset( "ATLAS", "images/map_icons/wicklee.xml" ),
	
	Asset( "IMAGE", "images/map_icons/gardenofshadows.tex" ),
	Asset( "ATLAS", "images/map_icons/gardenofshadows.xml" ),
	
	Asset( "IMAGE", "images/names_wicklee.tex" ),
    Asset( "ATLAS", "images/names_wicklee.xml" ),	
	
	Asset( "IMAGE", "images/avatars/avatar_wicklee.tex" ),
    Asset( "ATLAS", "images/avatars/avatar_wicklee.xml" ),
    
    Asset( "IMAGE", "images/avatars/self_inspect_wicklee.tex" ),
    Asset( "ATLAS", "images/avatars/self_inspect_wicklee.xml" ),
	
	Asset( "IMAGE", "images/avatars/avatar_ghost_wicklee.tex" ),
    Asset( "ATLAS", "images/avatars/avatar_ghost_wicklee.xml" ),

}

local require = GLOBAL.require
local STRINGS = GLOBAL.STRINGS
local Action = GLOBAL.Action
local ACTIONS = GLOBAL.ACTIONS
local ActionHandler = GLOBAL.ActionHandler
local COLLISION = GLOBAL.COLLISION
local TUNING = GLOBAL.TUNING

GLOBAL.TUNING.WICKLEE = {}
GLOBAL.TUNING.WICKLEE.KEY = GetModConfigData("wicklee_key") or 122

-- The character select screen lines
STRINGS.CHARACTER_TITLES.wicklee = "The Silver Fox"
STRINGS.CHARACTER_NAMES.wicklee = "Wicklee"
STRINGS.CHARACTER_DESCRIPTIONS.wicklee = "*Quick runner\n*Not very strong..?\n*Bound in mortal bones."
STRINGS.CHARACTER_QUOTES.wicklee = "\"Let's play in my Garden of Shadows...\""

-- Custom speech strings
STRINGS.CHARACTERS.WICKLEE = require "speech_wicklee"

-- Custom items
STRINGS.NAMES.GARDENOFSHADOWS = "Garden of Shadows"
STRINGS.CHARACTERS.WICKLEE.DESCRIBE.GARDENOFSHADOWS = "I can sense the Spirits"

-- The character's name as appears in-game 
STRINGS.NAMES.WICKLEE = "Wicklee"

-- The default responses of examining the character
STRINGS.CHARACTERS.GENERIC.DESCRIBE.WICKLEE = 
{
	GENERIC = "It's Wicklee!",
	ATTACKER = "What a sly fox!",
	MURDERER = "You're evil!",
	REVIVER = "Wicklee, the ghost whisperer.",
	GHOST = "Wicklee could use a heart.",
}

TUNING.WICKLEE_HEALTH = 200
TUNING.WICKLEE_HUNGER = 150
TUNING.WICKLEE_SANITY = 100
TUNING.WICKLEE_HEALTH_SPIRIT = 100
TUNING.WICKLEE_DAMAGE_MULT = .75
TUNING.WICKLEE_SPIRIT_DAMAGE_MULT = 20
TUNING.WICKLEE_SPEED_MULT = 1.25
TUNING.WICKLEE_SPIRIT_SPEED_MULT = .75
TUNING.WICKLEE_NIGHT_DRAIN_MULT = 1
TUNING.WICKLEE_SPIRIT_NIGHT_DRAIN_MULT = -0.5
TUNING.WICKLEE_TRANSFORMATION_COOLDOWN = 5

local function AttuneSpiritual(act)

	if act.doer ~= nil and act.doer:HasTag("spiritualattuner") then
	
		return act.target.components.attunable_spiritual:LinkToPlayer(act.doer)

	end
	
	return false

end

local function DropItems( inst )
	for _, slot in pairs(GLOBAL.EQUIPSLOTS) do	
		local item = inst.components.inventory:Unequip( slot )
		inst.components.inventory:DropItem( item )
	end
end

local function Transformation( inst )

	if inst:HasTag("spiritual") and inst.cantransform ~= false then
		
		if inst.transformed then
		
			inst.AnimState:SetBuild("wicklee")
			inst.transformed = false
			
			local phys = inst.Physics
			phys:SetCollisionGroup(COLLISION.CHARACTERS)
    		phys:ClearCollisionMask()
    		phys:CollidesWith(COLLISION.WORLD)
    		phys:CollidesWith(COLLISION.OBSTACLES)
    		phys:CollidesWith(COLLISION.CHARACTERS)
    		
    		if GLOBAL.TheSim:GetGameID() == "DST" then
    			phys:CollidesWith(COLLISION.SMALLOBSTACLES)
    			phys:CollidesWith(COLLISION.GIANTS)
    		end
    					
			inst:RemoveTag("monster")
			
			if inst.spirit_task ~= nil then
				inst.spirit_task:Cancel()
				inst.spirit_task = nil
			end
			
			if GLOBAL.TheSim:GetGameID() == "DST" then
			
				if GLOBAL.TheWorld.ismastersim then
					inst.components.hunger:Resume()
					inst.components.sanity.night_drain_mult = TUNING.WICKLEE_NIGHT_DRAIN_MULT
					inst.components.combat.damagemultiplier = TUNING.WICKLEE_DAMAGE_MULT
					inst.components.locomotor:SetExternalSpeedMultiplier( inst, "base", TUNING.WICKLEE_SPEED_MULT )
					
					local percent = inst.components.health:GetPercent()
					inst.components.health.maxhealth = TUNING.WICKLEE_HEALTH
					inst.components.health:SetPercent(percent)
					
					if inst._Eat == nil then
						inst._Eat = inst.components.eater.Eat
					end
					
					function inst.components.eater:Eat( food )
						return inst._Eat( self, food )
					end
				end
			else
				inst.components.hunger:Resume()
				inst.components.sanity.night_drain_mult = TUNING.WICKLEE_NIGHT_DRAIN_MULT
				inst.components.combat.damagemultiplier = TUNING.WICKLEE_DAMAGE_MULT
				inst.components.locomotor.runspeed = TUNING.WILSON_RUN_SPEED * TUNING.WICKLEE_SPEED_MULT
	
				
				local percent = inst.components.health:GetPercent()
				inst.components.health.maxhealth = TUNING.WICKLEE_HEALTH
				inst.components.health:SetPercent(percent)
				
				if inst._Eat == nil then
					inst._Eat = inst.components.eater.Eat
				end
				
				function inst.components.eater:Eat( food )
					return inst._Eat( self, food )
				end
			end
			
			inst.cantransform = false			
			inst:DoTaskInTime(TUNING.WICKLEE_TRANSFORMATION_COOLDOWN, function(inst) inst.cantransform = true end)
			
		else
		
			inst.AnimState:SetBuild("wicklee_spirit")
			inst.transformed = true
			
			inst:AddTag("monster")
			
			local phys = inst.Physics
			phys:SetCollisionGroup(COLLISION.CHARACTERS)
    		phys:ClearCollisionMask()
    		phys:CollidesWith(COLLISION.WORLD)
			
			
			inst.spirit_task = inst:DoPeriodicTask( 1, function( inst )
				if GLOBAL.TheSim:GetGameID() == "DST" then			
					if GLOBAL.TheWorld.ismastersim then
						inst.components.health:DoDelta( -(inst.components.health.maxhealth / GLOBAL.TUNING.TOTAL_DAY_TIME), true)
					end
				else
					inst.components.health:DoDelta( -(inst.components.health.maxhealth / GLOBAL.TUNING.TOTAL_DAY_TIME), true)
				end
			end)
			
			if GLOBAL.TheSim:GetGameID() == "DST" then
			
				if GLOBAL.TheWorld.ismastersim then
					inst.components.hunger:Pause()
					inst.components.sanity.night_drain_mult = TUNING.WICKLEE_SPIRIT_NIGHT_DRAIN_MULT
					inst.components.combat.damagemultiplier = TUNING.WICKLEE_SPIRIT_DAMAGE_MULT									
					inst.components.locomotor:SetExternalSpeedMultiplier( inst, "base", TUNING.WICKLEE_SPIRIT_SPEED_MULT )
					
					local percent = inst.components.health:GetPercent()
					inst.components.health.maxhealth = TUNING.WICKLEE_HEALTH_SPIRIT
					inst.components.health:SetPercent(percent)
					
					if inst._Eat == nil then
						inst._Eat = inst.components.eater.Eat
					end
					
					function inst.components.eater:Eat( food )
						return false
					end
					
					DropItems(inst)
				end
			else
				inst.components.hunger:Pause()
				inst.components.sanity.night_drain_mult = TUNING.WICKLEE_SPIRIT_NIGHT_DRAIN_MULT
				inst.components.combat.damagemultiplier = TUNING.WICKLEE_SPIRIT_DAMAGE_MULT		
				inst.components.locomotor.runspeed = TUNING.WILSON_RUN_SPEED * TUNING.WICKLEE_SPIRIT_SPEED_MULT			
				
				local percent = inst.components.health:GetPercent()
				inst.components.health.maxhealth = TUNING.WICKLEE_HEALTH_SPIRIT
				inst.components.health:SetPercent(percent)
				
				if inst._Eat == nil then
					inst._Eat = inst.components.eater.Eat
				end
				
				function inst.components.eater:Eat( food )
					return false
				end
			
				DropItems(inst)
			end
		
			inst.cantransform = false			
			inst:DoTaskInTime(TUNING.WICKLEE_TRANSFORMATION_COOLDOWN, function(inst) inst.cantransform = true end)
		end
	
	end

end

if GLOBAL.TheSim:GetGameID() == "DST" then
	table.insert(PrefabFiles, "wicklee_none")

	AddAction("ATTUNESPIRITUAL", "Spiritual Attunment", AttuneSpiritual )
	
	AddComponentAction( "SCENE", "attunable_spiritual", function ( inst, doer, actions, right )
		if right then
			if doer:HasTag("spiritualattuner") and not inst:HasTag(doer.userid) then
				table.insert( actions, ACTIONS.ATTUNESPIRITUAL )
			end
		end
	end)

	AddStategraphActionHandler("wilson_client", ActionHandler(ACTIONS.ATTUNESPIRITUAL, "dolongaction"))
else
	local Attune = Action(0)
	Attune.str = "Spiritual Attunement"
	Attune.id = "ATTUNESPIRITUAL"
	Attune.fn = AttuneSpiritual
	
	AddAction(Attune)
	
	
	
	local function __index_lower(t, k)
	    return GLOBAL.rawget(t, string.lower(k))
	end
	
	local function __newindex_lower(t, k, v)
	   GLOBAL.rawset(t, string.lower(k), v)
	end
	
	local function setmetadata( tab )
	    GLOBAL.setmetatable(tab, { __index = __index_lower, __newindex = __newindex_lower })
	end
	
	GLOBAL.MOD_RPC = {}
	GLOBAL.MOD_RPC_HANDLERS = {}
	 
	setmetadata(GLOBAL.MOD_RPC)
	setmetadata(GLOBAL.MOD_RPC_HANDLERS)
	
	function AddModRPCHandler( namespace, name, fn )
		if GLOBAL.MOD_RPC[namespace] == nil then
			GLOBAL.MOD_RPC[namespace] = {}
			GLOBAL.MOD_RPC_HANDLERS[namespace] = {}
	
	        setmetadata(GLOBAL.MOD_RPC[namespace])
	        setmetadata(GLOBAL.MOD_RPC_HANDLERS[namespace])
		end
		
	
		table.insert(GLOBAL.MOD_RPC_HANDLERS[namespace], fn)
	    GLOBAL.MOD_RPC[namespace][name] = { namespace = namespace, id = #GLOBAL.MOD_RPC_HANDLERS[namespace] }
	
	    setmetadata(GLOBAL.MOD_RPC[namespace][name])
		
		setmetadata(GLOBAL.MOD_RPC[namespace][name])
	end
end

AddStategraphActionHandler("wilson", ActionHandler(ACTIONS.ATTUNESPIRITUAL, "dolongaction"))

AddMinimapAtlas("images/map_icons/wicklee.xml")
AddMinimapAtlas("images/map_icons/gardenofshadows.xml")
AddModCharacter("wicklee")

AddModRPCHandler( "wicklee", "Transformation", Transformation )