return Class(function(self, inst)
	self.inst = inst
	
	inst:AddTag("ATTUNABLE_ID_"..tostring(inst.GUID))
	    
    if TheSim:GetGameID() == "DST" then
    	self.attuned_players = {} --attuned and online
    	self.attuned_userids = {} --attuned but not online
    	self.attuned_timeremaining = {} -- attuned and time remaining
    else
    	self.attuned = nil
    	self.attuned_timeremaining = 0
    end

    --Tag specifies what group this belongs to since you
    --can only attune to one entity at a time per group.
    --e.g. Players can only attune one remoteresurrector
    --     at a time.
    --Tag can also be used in Attuner:HasAttunement(tag)
    self.attunable_tag = nil

    self.onattunecostfn = nil
    self.onlinkfn = nil
    self.onunlinkfn = nil
    
    inst:StartUpdatingComponent(self)

    self.onplayerattuned = function(player, data)
        if data.prefab == inst.prefab then
            --Player has attuned to another of the same prefab
            self:UnlinkFromPlayer(player, data.isloading)
        end
    end

    self.onplayerremoved = function(player)
        self.attuned_userids[player.userid] = true
        self.attuned_players[player] = nil
    end

    self.onplayerjoined = function(world, player)
        if self.attuned_userids[player.userid] then
            self.attuned_userids[player.userid] = nil
            self:LinkToPlayer(player, true)
        end
    end

	if TheSim:GetGameID() == "DST" then
    	self.inst:ListenForEvent("ms_playerjoined", self.onplayerjoined, TheWorld)
   	else
   		self.inst:ListenForEvent("ms_playerjoined", self.onplayerjoined, GetWorld())
   	end
   	
   	function self:OnRemoveEntity()
	    self.inst:RemoveTag("ATTUNABLE_ID_"..tostring(self.inst.GUID))
	    
	    if TheSim:GetGameID() == "DST" then
	    	self.inst:RemoveEventCallback("ms_playerjoined", self.onplayerjoined, TheWorld)
	   	else
	   		self.inst:RemoveEventCallback("ms_playerjoined", self.onplayerjoined, GetWorld())
	   	end
	   	
	    local toremove = {}
	    for k, v in pairs(self.attuned_players) do
	        table.insert(toremove, k)
	    end
	    for i, v in ipairs(toremove) do
	        self:UnlinkFromPlayer(v)
	    end
	end
   	self.OnRemoveFromEntity = self.OnRemoveEntity
   	
   	function self:GetAttunableTag()
	    return self.attunable_tag
	end
	
	function self:SetAttunableTag(tag)
	    self.attunable_tag = tag
	end
	
	function self:SetOnAttuneCostFn(fn)
	    self.onattunecostfn = fn
	end
	
	function self:SetOnLinkFn(fn)
	    self.onlinkfn = fn
	end
	
	function self:SetOnUnlinkFn(fn)
	    self.onunlinkfn = fn
	end
	
	function self:IsAttuned(player)
		if TheSim:GetGameID() == "DST" then
			return self.attuned_players[player] ~= nil and self.attuned_timeremaining[player.userid] ~= nil
		else
	    	return self.attuned and self.attuned_timeremaining ~= nil
	    end
	end
	
	function self:CanAttune(player)
		if TheSim:GetGameID() == "DST" then
	    	return player.userid ~= nil and string.len(player.userid) > 0 and player.components.attuner_spiritual ~= nil and not self:IsAttuned(player)
	    else
	    	return player.components.attuner_spiritual ~= nil and not self:IsAttuned(player)
	    end
	end
	
	function  self:LinkToPlayer(player, isloading)
	    if not self:CanAttune(player) then
	        return false
	    end
	
	    if not isloading and self.onattunecostfn ~= nil then
	        local success, reason = self.onattunecostfn(self.inst, player)
	        if not success then
	            return false, reason
	        end
	    end
	    	    
	    if TheSim:GetGameID() == "DST" then
	    	self.attuned_players[player] = SpawnPrefab("attunable_classified")
	    	if self.attunable_tag ~= nil then
	        	self.attuned_players[player]:AddTag(self.attunable_tag)
	    	end
	    	self.attuned_players[player]:AttachToPlayer(player, self.inst)
	    
	    	if self.attuned_timeremaining[player.userid] == nil then
	    		self.attuned_timeremaining[player.userid] = TUNING.TOTAL_DAY_TIME * 3
	    	end
	    	
	    	self.inst:AddTag(player.userid)
	    else
	    	self.attuned = true
	    	
	    	if self.attuned_timeremaining == nil then
	    		self.attuned_timeremaining = TUNING.TOTAL_DAY_TIME * 3
	    	end
	    end
	    	
	    player:PushEvent("attuned", { prefab = self.inst.prefab, isloading = isloading })
	    self.inst:ListenForEvent("onremove", self.onplayerremoved, player)
	    self.inst:ListenForEvent("attuned", self.onplayerattuned, player)
	
	    if self.onlinkfn ~= nil then
	        self.onlinkfn(self.inst, player, isloading)
	    end
	    
	    return true
	end
	
	function self:UnlinkFromPlayer(player, isloading)
	    if not self:IsAttuned(player) then
	        return
	    end
	
		if TheSim:GetGameID() == "DST" then
			self.attuned_players[player]:Remove()
	    	self.attuned_players[player] = nil
			self.attuned_timeremaining[player.userid] = nil
			
			self.inst:RemoveTag(player.userid)
		else
			self.attuned = nil
			self.attuned_timeremaining = nil
		end
		
	    self.inst:RemoveEventCallback("onremove", self.onplayerremoved, player)
	    self.inst:RemoveEventCallback("attuned", self.onplayerattuned, player)
	
	    if self.onunlinkfn ~= nil then
	        self.onunlinkfn(self.inst, player, isloading)
	    end
	end
	
	function self:OnSave()
	   	if TheSim:GetGameID() == "DST" then
	   		local userids = {}
	    	local time_remaining = {}
	    	for k, v in pairs(self.attuned_players) do
	        	table.insert(userids, k.userid)
	    	end
	    	for k, v in pairs(self.attuned_userids) do
	        	table.insert(userids, k)
	    	end
	    	for k, v in pairs(self.attuned_timeremaining) do
	    		table.insert(time_remaining, { userid = k, time = v })
	    	end
	    	
	    	return #userids > 0 and { links = userids, time_remaining = time_remaining } or nil
	    else
	    	return { attuned = self.attuned, time = self.attune_timeremaining }
	    end
	    
	end
	
	function self:OnLoad(data)
	    if TheSim:GetGameID() == "DST" then
	    	if data ~= nil and data.links ~= nil and #data.links > 0 then
	        	local available_players = {}
	        	for i, v in ipairs(AllPlayers) do
	            	if v.userid ~= nil and string.len(v.userid) > 0 then
	                	available_players[v.userid] = v
	            	end
	        	end
	        	for i, v in ipairs(data.links) do
	            	if available_players[v] ~= nil then
	                	self:LinkToPlayer(available_players[v], true)
	            	else
	                	self.attuned_userids[v] = true
	            	end
	        	end
	    	end
	    	    
	    	if data.time_remaining ~= nil and #data.time_remaining > 0 then
	    		for _, v in ipairs(data.time_remaining) do
	    			self.attuned_timeremaining[v.userid] = v.time
	    		end
	    	end
	    else    	
	    	if data.attuned then
	    		self.attuned_timeremaining = data.time_remaining
	    		self:LinkToPlayer(GetPlayer(), true)
	    	end
	    end
	end
	
	function self:OnUpdate(dt)
	
		if TheSim:GetGameID() == "DST" then
			for id, time in pairs(self.attuned_timeremaining) do
				
				if self.attuned_timeremaining[id] > 0 then
					self.attuned_timeremaining[id] = time - dt
				end
						
				if self.attuned_timeremaining[id] < 0 then
					for _, p in ipairs(AllPlayers) do
						if id == p.userid then
							p.components.talker:Say(STRINGS.CHARACTERS[string.upper(p.prefab)].ANNOUNCE_SPIRITUAL_LOST)
							self:UnlinkFromPlayer( p )
						end
					end
				end
			end
		else
			if self.attuned then
				if self.attuned_timeremaining ~= nil then
					if self.attuned_timeremaining > 0 then
						self.attuned_timeremaining = self.attuned_timeremaining - dt
					end	
			
					if self.attuned_timeremaining < 0 then
						GetPlayer().components.talker:Say(STRINGS.CHARACTERS[string.upper(GetPlayer().prefab)].ANNOUNCE_SPIRITUAL_LOST)
						self:UnlinkFromPlayer( GetPlayer() )
					end
				end
			end
		end
	
	end
	
	function self:LongUpdate(dt)
	
		if TheSim:GetGameID() == "DST" then
			for id, time in pairs(self.attuned_timeremaining) do
		
				if self.attuned_timeremaining[id] > 0 then
					self.attuned_timeremaining[id] = time - dt
				end
						
				if self.attuned_timeremaining[id] < 0 then
					for _, p in ipairs(AllPlayers) do
						if id == p.userid then
							p.components.talker:Say(STRINGS.CHARACTERS[string.upper(p.prefab)].ANNOUNCE_SPIRITUAL_LOST)
							self:UnlinkFromPlayer( p )
						end
					end
				end
			end
		else
			if self.attuned_timeremaining ~= nil then
				if self.attuned_timeremaining > 0 then
					self.attuned_timeremaining = self.attuned_timeremaining - dt
				end
			
				if self.attuned and self.attuned_timeremaining < 0 then
					GetPlayer().components.talker:Say(STRINGS.CHARACTERS[string.upper(GetPlayer().prefab)].ANNOUNCE_SPIRITUAL_LOST)
					self:UnlinkFromPlayer( GetPlayer() )
				end
			end
		end
	
	end
	
	function self:GetDebugString()
	    local str = "\n          online:"
	    if next(self.attuned_players) ~= nil then
	        for k, v in pairs(self.attuned_players) do
	            str = str.."\n               "..k.name.." ("..tostring(k)..")"
	        end
	    end
	    str = str.."\n          offline:"
	    if next(self.attuned_userids) ~= nil then
	        for k, v in pairs(self.attuned_userids) do
	            str = str.."\n               "..k
	        end
	    end
	    return str
	end
	
	if TheSim:GetGameID() ~= "DST" then
		function self:CollectSceneActions( inst, actions, right )
			if right then
				local player = GetPlayer()
				if player:HasTag("spiritualattuner") and not self.attuned then
					table.insert( actions, ACTIONS.ATTUNESPIRITUAL )
				end
			end
		end
	end
   	
end)