return Class(function(self, inst)
 	self.inst = inst
    self.attuned = {}
    
    if TheSim:GetGameID() == "DST" then
    	self.ismastersim = TheWorld.ismastersim
   	else
   		self.ismastersim = true
   	end
	--------------------------------------------------------------------------
	--Common (but for clients, will only work for local player)
	
	function self:IsAttunedTo(target)
	    if self.ismastersim then
	        return self.attuned[target.GUID] ~= nil
	    end
	
	    for k, v in pairs(self.attuned) do
	        if target:HasTag("ATTUNABLE_ID_"..tostring(k)) then
	            return true
	        end
	    end
	    return false
	end
	
	function self:HasAttunement(tag)
	    for k, v in pairs(self.attuned) do
	        if v:HasTag(tag) then
	            return true
	        end
	    end
	    return false
	end
	
	--------------------------------------------------------------------------
	--Server only
	
	function self:GetAttunedTarget(tag)
	    if self.ismastersim then
	        for k, v in pairs(self.attuned) do
	            if v:HasTag(tag) then
	                return Ents[k]
	            end
	        end
	    end
	end
	
	--------------------------------------------------------------------------
	--proxy is attunable_classifed
	--proxy is always available to the attuned player, even on clients
	--the actual entity may not be available on clients if it's far away
	--proxy:IsAttunableType(tag) can be used on clients at any distance
	
	--NOTE: On clients, the order for dispatching gotnewattunement
	--      and attunementlost from the same frame is not reliable
	
	function self:RegisterAttunedSource(proxy)
	    if not self.attuned[proxy.source_guid:value()] then
	        self.attuned[proxy.source_guid:value()] = proxy
	        self.inst:PushEvent("gotnewattunement", { proxy = proxy })
	    end
	end
	
	function self:UnregisterAttunedSource(proxy)
	    if self.attuned[proxy.source_guid:value()] then
	        self.attuned[proxy.source_guid:value()] = nil
	        self.inst:PushEvent("attunementlost", { proxy = proxy })
	    end
	end
	
	--------------------------------------------------------------------------
	--Debug
	
	function self:GetDebugString()
	    local str = ""
	    if self.ismastersim then
	        for k, v in pairs(self.attuned) do
	            str = str.."\n          "..tostring(Ents[k])
	        end
	    else
	        for k, v in pairs(self.attuned) do
	            str = str.."\n          "..tostring(k)
	        end
	    end
	    return str
	end

end)