require "prefabutil"

local assets = {
	Asset("ANIM", "anim/gardenofshadows.zip"),
}

local function onattunecost(inst, player)
	return true
end

local function onlink(inst, player, isloading)
	if not isloading then
		if player:HasTag("spiritualattuner") then
			player:AddTag("spiritual")
			inst.SoundEmitter:PlaySound("dontstarve/cave/meat_effigy_attune_on")
		end
	else
		if player:HasTag("spiritualattuner") then
			player:AddTag("spiritual")
		end
	end
end

local function onunlink(inst, player, isloading)
	if not isloading then
		player:RemoveTag("spiritual")
		inst.SoundEmitter:PlaySound("dontstarve/cave/meat_effigy_attune_off")
	else
		player:RemoveTag("spiritual")
	end
end

local function fn()
	local inst = CreateEntity()
	inst.entity:AddTransform()
	inst.entity:AddAnimState()
	inst.entity:AddSoundEmitter()
	inst.entity:AddMiniMapEntity()
	
	-- Minimap icon
	inst.MiniMapEntity:SetIcon( "gardenofshadows.tex" )
	
	MakeObstaclePhysics( inst, .5 )
	
	inst:AddTag("structure")
	inst:AddTag("spiritual")
	
	inst.AnimState:SetBank("gardenofshadows")
	inst.AnimState:SetBuild("gardenofshadows")
	inst.AnimState:PlayAnimation("idle")
		
	if TheSim:GetGameID() == "DST" then
		inst.entity:AddNetwork()
		MakeSnowCoveredPristine(inst)
		inst.entity:SetPristine()		
		if not TheWorld.ismastersim then
			return inst
		end
	end
	
	inst:AddComponent("inspectable")
	
	inst:AddComponent("attunable_spiritual")
	inst.components.attunable_spiritual:SetAttunableTag("remotespirit")
	inst.components.attunable_spiritual:SetOnAttuneCostFn(onattunecost)
	inst.components.attunable_spiritual:SetOnLinkFn(onlink)
	inst.components.attunable_spiritual:SetOnUnlinkFn(onunlink)
	
	MakeSnowCovered(inst)
		
	return inst
end

return Prefab("gardenofshadows", fn, assets)
