local MakePlayerCharacter = require "prefabs/player_common"

local assets = {
		Asset( "ANIM", "anim/wicklee.zip"),
        Asset( "ANIM", "anim/wicklee_spirit.zip" ),
        Asset( "ANIM", "anim/ghost_wicklee_build.zip" ),
}

local prefabs = {}

local starting_inv = {}

local function common_postinit(inst)
	inst:AddTag("wicklee")
	inst:AddTag("spiritualattuner")
	
	-- Minimap icon
	inst.MiniMapEntity:SetIcon( "wicklee.tex" )
	
	inst.soundsname = "wilson"
	
	if not inst.components.keyhandler then
		inst:AddComponent("keyhandler")
	end

	inst.components.keyhandler:AddActionListener("wicklee", TUNING.WICKLEE.KEY, "Transformation")

end

local function master_postinit(inst)

	inst:AddComponent("attuner_spiritual")
			
	inst.transformed = false
	
	local _Equip = inst.components.inventory.Equip
	
	function inst.components.inventory:Equip(item, old_to_active)
		if self.inst.transformed then
			return false
		else
			return _Equip( self, item, old_to_active )
		end
	end
	
	inst.components.health:SetMaxHealth(TUNING.WICKLEE_HEALTH)
	inst.components.hunger:SetMax(TUNING.WICKLEE_HUNGER)
	inst.components.sanity:SetMax(TUNING.WICKLEE_SANITY)
	
	if TheSim:GetGameID() == "DST" then
		inst.components.locomotor:SetExternalSpeedMultiplier( inst, "base", TUNING.WICKLEE_SPEED_MULT )
	else
		inst.components.locomotor.runspeed = TUNING.WILSON_RUN_SPEED * TUNING.WICKLEE_SPEED_MULT
	end
	inst.components.combat.damagemultiplier = TUNING.WICKLEE_DAMAGE_MULT
		
end

if TheSim:GetGameID() == "DST" then
	return MakePlayerCharacter("wicklee", prefabs, assets, common_postinit, master_postinit, starting_inv)
else
	local function fn(inst)
		common_postinit(inst)
		master_postinit(inst)
	end
	
	return MakePlayerCharacter("wicklee", prefabs, assets, fn, starting_inv)
end