
var config = require('./config.json');
const accounting = require("accounting");
let utils = require("./utils.js");
var edge = require('electron-edge-js');

const path = require('path');
const fs = require('fs');
const urlpath = path.resolve(__dirname, '../../../uretailurl');
const configPath = `${urlpath}/config.json`;
fs.exists(urlpath, function (exists) {
       fs.exists(configPath, function (existss) {
           if (existss) {
            config = require(configPath)
           }
       });
});

/**
 * Description:Sand支付接口
 * @author zhaozhe
 * @date 2018年7月21日  上午10:24:07
 * @param paytype 支付方式
 * @param balamoney 支付金额
 * @param orderid 订单号
 * @param res 异步请求的response
 */
//{"paytype":"2","CardType": "01", "TransType": "40", "Money": "0.01", "storeCode": "0002","operatorCode": "0003","ReferenceCode":"072723437501","VoucherCode":"000958"}
var Sandpay = function(resolve, data){
	/*res.status(200).json({code:200});
	return*/
    let response;
    let keys;
    if(data.body!= null){  
        keys = data.body;
    } else 
    if(data != null){  
        keys = data;
    }  

  	if(keys != null){ 
        let paytype = keys["paytype"];
        if(paytype == 11){
            let orderid = 'SDLS' + utils.getNowNotFormatData() + utils.getRandomNum(0,9999);
            keys['TradeCode']=orderid;
            keys['com']=config.COM;
            response = SDpaybind(JSON.stringify(keys));  
        }else
        if(paytype == 2 || paytype == 12 || paytype == 13 || paytype == 14){
            let orderid = 'YLLS' + utils.getNowNotFormatData() + utils.getRandomNum(0,9999);
            keys['TradeCode']=orderid;
            keys['com']=config.COM; 
            response = YLpaybind(JSON.stringify(keys));  
        }else
        if(paytype == 15 || paytype == 16){
            let orderid = 'YLLS' + utils.getNowNotFormatData() + utils.getRandomNum(0,9999);
            keys['TradeCode']=orderid;
            keys['com']=config.COM; 
            response = PApaybind(JSON.stringify(keys));  
        }
        else if(paytype == 50){
            let orderid = 'YLLS' + utils.getNowNotFormatData() + utils.getRandomNum(0,9999);
            keys['TradeCode']=orderid;
            keys['com']=config.COM; 
            response = abcScanPay(JSON.stringify(keys));  
        }
        else if(paytype == 51 || paytype == 52){
            let orderid = 'YLLS' + utils.getNowNotFormatData() + utils.getRandomNum(0,9999);
            keys['TradeCode']=orderid;
            keys['com']=config.COM; 
            response = COMMPay(JSON.stringify(keys));  
        }
        else
        //工商银行pos支付
        if(paytype == 23 || paytype == 24){

        	response = ICBCPosPay(JSON.stringify(keys));
        }else
        //稻香村卡
        if(paytype == 32){

            response = DXCPrePay(JSON.stringify(keys));
        }
		if(paytype == 33 || paytype == 34 || paytype == 35 || paytype == 36){
            // let orderid = 'GYLS' + utils.getNowNotFormatData() + utils.getRandomNum(0,9999);
            // keys['TradeCode']=orderid;
            // keys['com']=config.COM; 
            response = IsportICBCPosPay(JSON.stringify(keys));  
        }
		//诺仕达支付
		if(paytype == 47){
			let orderid = 'NSD' + utils.getNowNotFormatData() + utils.getRandomNum(0,999);
            keys['VoucherCode']=orderid;
            response = NSDPay(JSON.stringify(keys));  
        }
        
        resolve(response);
  	}else{ 
  		response = {
		  	code:999,
		    message: "传入的参数不能为空"
		};	
	    resolve(response);
  	}
}

var SDpaybind = function(data){
    let posresult
    try{
        var dllPath=__dirname + '/Print/Print.dll';
        var getPrinter = edge.func({
        //assemblyFile:"D:/Print.dll",
        assemblyFile:dllPath,
        typeName:"print.Print",
        methodName: "SandPosPay"
        });

        var input =data;
        getPrinter(input,function(err,result)
        {
            if (err) {
                response = {
                    code:999,
                    message: err
                };	
            }else
            {
                response = result;
            }
            console.log(result);
        });
    }catch(e){

        response = {
            code:999,
        message: "调用杉德pos出错"+e.message
        };	
    }
    return response;
}

var YLpaybind = function(data){
    let posresult
    try{
        var dllPath=__dirname + '/Print/Print.dll';
        var getPrinter = edge.func({
        //assemblyFile:"D:/Print.dll",
        assemblyFile:dllPath,
        typeName:"print.Print",
        methodName: "BankPosPay"
        });

        var input =data;
        getPrinter(input,function(err,result)
        {
            if (err) {
                response = {
                    code:999,
                    message: err
                };	
            }else
            {
                response = result;
            }
            console.log(result);
        });
    }catch(e){

        response = {
            code:999,
        message: "调用银联pos出错"+e.message
        };	
    }
    return response;
}

//平安支付
var PApaybind = function(data){
    let posresult
    try{
        var dllPath=__dirname + '/Print/Print.dll';
        var getPrinter = edge.func({
        assemblyFile:dllPath,
        typeName:"print.Print",
        methodName: "PingAnPay"
        });

        var input =data;
        getPrinter(input,function(err,result)
        {
            if (err) {
                response = {
                    code:999,
                    message: err
                };	
            }else
            {
                response = result;
            }
            console.log(result);
        });
    }catch(e){

        response = {
            code:999,
        message: "调用平安pos出错"+e.message
        };	
    }
    return response;
}

//农业银行
var abcScanPay = function(data){
    let posresult
    try{
        var dllPath=__dirname + '/Print/Print.dll';
        var getPrinter = edge.func({
        assemblyFile:dllPath,
        typeName:"print.Print",
        methodName: "ABCPay"
        });

        var input =data;
        getPrinter(input,function(err,result)
        {
            if (err) {
                response = {
                    code:999,
                    message: err
                };	
            }else
            {
                response = result;
            }
            console.log(result);
        });
    }catch(e){

        response = {
            code:999,
        message: "调用农业银行接口出错"+e.message
        };	
    }
    return response;
}

//交通银行支付
var COMMPay = function(data){
    let posresult
    try{
        var dllPath=__dirname + '/Print/Print.dll';
        var getPrinter = edge.func({
        assemblyFile:dllPath,
        typeName:"print.Print",
        methodName: "COMMPay"
        });

        var input =data;
        getPrinter(input,function(err,result)
        {
            if (err) {
                response = {
                    code:999,
                    message: err
                };	
            }else
            {
                response = result;
            }
            console.log(result);
        });
    }catch(e){

        response = {
            code:999,
        message: "调用交通银行支付接口出错"+e.message
        };	
    }
    return response;
}

//工商银行
var ICBCPosPay = function(data){
	let posresult
    try{
        var dllPath=__dirname + '/Print/Print.dll';
        var getPrinter = edge.func({
        assemblyFile:dllPath,
        typeName:"print.Print",
        methodName: "ICBCPosPay"
        });

        var input =data;
        getPrinter(input,function(err,result)
        {
            if (err) {
                response = {
                    code:999,
                    message: err
                };	
            }else
            {
                response = result;
            }
            console.log(result);
        });
    }catch(e){

        response = {
            code:999,
        message: "调用工商银行pos出错"+e.message
        };	
    }
    return response;
}

//稻香村卡
var DXCPrePay = function(data){
	let posresult
    try{
        var dllPath=__dirname + '/Print/Print.dll';
        var getPrinter = edge.func({
        assemblyFile:dllPath,
        typeName:"print.Print",
        methodName: "DXCPrePay"
        });

        var input =data;
        getPrinter(input,function(err,result)
        {
            if (err) {
                response = {
                    code:999,
                    message: err
                };	
            }else
            {
                response = result;
            }
            console.log(result);
        });
    }catch(e){

        response = {
            code:999,
        message: "调用稻香村卡pos出错"+e.message
        };	
    }
    return response;
}

//工银澳门
var IsportICBCPosPay = function(data){
    let posresult
    try{
        var dllPath=__dirname + '/Print/Print.dll';
        var getPrinter = edge.func({
        assemblyFile:dllPath,
        typeName:"print.Print",
        methodName: "IsportICBCPosPay"
        });

        var input =data;
        getPrinter(input,function(err,result)
        {
            if (err) {
                response = {
                    code:999,
                    message: err
                };	
            }else
            {
                response = result;
            }
            console.log(result);
        });
    }catch(e){

        response = {
            code:999,
        message: "调用工银pos出错"+e.message
        };	
    }
    return response;
}

//诺仕达支付
var NSDPay = function(data){
    let posresult
    try{
        var dllPath=__dirname + '/Print/Print.dll';
        var getPrinter = edge.func({
        assemblyFile:dllPath,
        typeName:"print.Print",
        methodName: "NSDPay"
        });

        var input =data;
        getPrinter(input,function(err,result)
        {
            if (err) {
                response = {
                    code:999,
                    message: err
                };	
            }else
            {
                response = result;
            }
            console.log(result);
        });
    }catch(e){

        response = {
            code:999,
        message: "调用工银pos出错"+e.message
        };	
    }
    return response;
}

module.exports = {
    SDpaybind : SDpaybind,
    YLpaybind : YLpaybind,
    PApaybind : PApaybind,
    Sandpay : Sandpay,
    ICBCPosPay : ICBCPosPay,
    DXCPrePay : DXCPrePay,
	IsportICBCPosPay : IsportICBCPosPay
}