let utils = require("./utils.js");
var edge = require('electron-edge-js');
var dllPath=__dirname + '/Card/Card.dll';
var config = require('./config.json');

var fs = require('fs');

const path = require('path');
const urlpath = path.resolve(__dirname, '../../../uretailurl');
const configPath = `${urlpath}/config.json`;
fs.exists(urlpath, function (exists) {
       fs.exists(configPath, function (existss) {
           if (existss) {
            config = require(configPath)
           }
       });
});

// 记录开单读卡定时器
let interval = null;
let lastReadCard = null;

// 停止定时器
var stopGetCardnum = function () {
    clearInterval(interval);
    interval = null;
    lastReadCard = null;
}

/* 开始定时器 */
var startGetCardnum = function (callback) {
    stopGetCardnum();
    if(config.bCard) {
        interval = setInterval(function () { getCardnum(callback, config.bCard); }, 1000);
    } else {
        callback ({bCard: false, cardnum: null});
    }
}

/* 是否调回调 */
var getCardnum = function (callback, bCard) {
    let cardnum = readCardnumFromDevice();
    // let cardnum = 'czk00001';
    if (cardnum && cardnum !== lastReadCard){
        callback({bCard: bCard, cardnum});
    }
    lastReadCard = cardnum;
}

/* 返回卡号 */
var readCardnumFromDevice = function(){
    let cardnum = null;
    let response = readCardInfo();
    if (response && response !== '' && response.code != 999) {
        try{
            cardnum = JSON.parse(response).cardNumber;
        } catch (err){
            cardnum = null;
        }
    }
    return cardnum;
}


//打开储值卡设备 
var openCard = function (resolve) {
	var input="";
	var methodValue="RFCardOpen";
    var getPrinter = edge.func({
        assemblyFile:dllPath,
        typeName:"Card.Card",
        methodName: methodValue
        });
    getPrinter(input,function(err,result)
    {
        console.log(result);
     });
    let response

    response = {
        code: 200,
        message: '打开成功',
        data: null
    };

    resolve(response);
}


var readCard = function (resolve) {
     let response;
     response = readCardInfo();  
     resolve(response);  
}

//读储值卡
var readCardInfo = function(){
    let response
    try{
        //var methodValue="ReadCard";
        //if(config.cardtype=="AxCard")
        var methodValue="";
        if(config.cardtype=="1")
        {
            methodValue="ReadCard";
        }
        if(config.cardtype=="2")
        {
            methodValue="ReadAxCard";
        }
        else if(config.cardtype=="3")
        {
            methodValue="ReadNatecCard";
        }
        else if(config.cardtype=="4")
        {
            methodValue="ReadEastCard";
        }
        var getPrinter = edge.func({
           assemblyFile:dllPath,
           typeName:"Card.Card",
           methodName: methodValue
           });

        var input =config.cCardSerialPortNum;
        getPrinter(input,function(err,result)
        {
            if (err) {
                response = {
                    code:999,
                    message: err
                };	
            }else
            {
                response = result;
            }
            console.log(result);
        });
    }catch(e){

        response = {
            code:999,
        message: "读卡出错"+e.message
        };	
    }
    return response;
}

var readCardWithParam = function (resolve, data) {
     let response;
     response = readCardWithParamInfo(data);  
     resolve(response);  
}

//读储值卡
var readCardWithParamInfo = function(data){
    let response
    try{
        var methodValue="";
        if(config.cardtype=="5")
        {
            methodValue="readCardForNSD";
        }
        var getPrinter = edge.func({
           assemblyFile:dllPath,
           typeName:"Card.Card",
           methodName: methodValue
           });

        var input =data;
        getPrinter(input,function(err,result)
        {
            if (err) {
                response = {
                    code:999,
                    message: err
                };	
            }else
            {
                response = result;
            }
            console.log(result);
        });
    }catch(e){

        response = {
            code:999,
        message: "读卡出错"+e.message
        };	
    }
    return response;
}

/* 不采用callback回调方式
var readCard = function (resolve,callback) {
    var input="";
    var methodValue="ReadCard";
    var getPrinter = edge.func({
       assemblyFile:dllPath,
       typeName:"Card.Card",
       methodName: methodValue
       });
       

       getPrinter(input,function(err,result)
       {
          let data=JSON.parse(result);
           callback(JSON.stringify(data));
        });
       
}*/




//写储值卡
var writeCard = function (resolve,cardNumber) {
    let response;
    response = writeCardInfo(cardNumber);  
    resolve(response);  
    
    /*
    var methodValue="WriteCard";
    var getPrinter = edge.func({
        assemblyFile:dllPath,
        typeName:"Card.Card",
        methodName: methodValue
        });
        getPrinter(cardNumber,function(err,result)
        {
            console.log(result);
         });

         
    let response

    response = {
        code: 200,
        message: '写卡成功',
        data: null
    };

    resolve(response);*/
}


//写储值卡
var writeCardInfo = function(cardNumber){
    let response
    try{
        //var methodValue="WriteCard";
        //if(config.cardtype=="AxCard")
        var methodValue="";
        if(config.cardtype=="1")
        {
            methodValue="WriteCard";
        }
        else if(config.cardtype=="2")
        {
            methodValue="WriteAxCard";
        }
        else if(config.cardtype=="3")
        {
            methodValue="WriteNatecCard";
        }
            var getPrinter = edge.func({
                assemblyFile:dllPath,
                typeName:"Card.Card",
                methodName: methodValue
                });
        getPrinter(cardNumber,function(err,result)
        {
            if (err) {
                response = {
                    code:999,
                    message: err
                };	
            }else
            {
                response = result;
            }
            console.log(result);
        });
    }catch(e){

        response = {
            code:999,
        message: "写卡出错"+e.message
        };	
    }
    return response;
}


//关闭储值卡设备
var closeCard = function (resolve) {
	var input="";
	var methodValue="RFCardClose";
    var getPrinter = edge.func({
        assemblyFile:dllPath,
        typeName:"Card.Card",
        methodName: methodValue
        });
        getPrinter(input,function(err,result)
        {
            console.log(result);
		 });
		 

    if (!resolve) return;
    let response

    response = {
        code: 200,
        message: '关闭成功',
        data: null
    };

    resolve(response);
}



//打印储值卡
var printCard = function (resolve,cardNumber,discount,balance,points,duedate) {
    let response;
    response = printCardInfo(cardNumber,discount,balance,points,duedate);  
    resolve(response);  
}


//打印储值卡
var printCardInfo = function(cardNumber,discount,balance,points,duedate){
    let response
    try{
        var methodValue="";
        if(config.cardtype=="3")
        {
            methodValue="PrintNatecCard";
        }
        var input = [cardNumber,discount,balance,points,duedate];
            var getPrinter = edge.func({
                assemblyFile:dllPath,
                typeName:"Card.Card",
                methodName: methodValue
                });
        getPrinter(input,function(err,result)
        {
            if (err) {
                response = {
                    code:999,
                    message: err
                };	
            }else
            {
                response = result;
            }
            console.log(result);
        });
    }catch(e){

        response = {
            code:999,
        message: "打印卡出错"+e.message
        };	
    }
    return response;
}



var cardCshPrint = function (resolve,cardNumber,discount,balance,points,duedate) {
    let response;
    response = cardCshPrintInfo(cardNumber,discount,balance,points,duedate);  
    resolve(response);  
}

//储值卡打印初始化
var cardCshPrintInfo = function(cardNumber,discount,balance,points,duedate){
   let response
   try{

       var methodValue="NatecCardCshPrint";
       var getPrinter = edge.func({
          assemblyFile:dllPath,
          typeName:"Card.Card",
          methodName: methodValue
          });

       //var input ="";
       var input = [cardNumber,discount,balance,points,duedate];
       getPrinter(input,function(err,result)
       {
           if (err) {
               response = {
                   code:999,
                   message: err
               };	
           }else
           {
               response = result;
           }
           console.log(result);
       });
   }catch(e){

       response = {
           code:999,
       message: "读卡出错"+e.message
       };	
   }
   return response;
}


module.exports = {
    openCard:  openCard,
    closeCard : closeCard,
    readCard:  readCard,
    writeCard: writeCard,
    printCard: printCard,
    cardCshPrint: cardCshPrint,
    startGetCardnum: startGetCardnum,
    stopGetCardnum: stopGetCardnum,
	readCardWithParam: readCardWithParam
}



