﻿var SerialPort = require('serialport');
var COMPORT = "com2"
const CHECKSUM = "00077148"
var BAUDRATE = 19200
var PARITY = 'even'
var DATABITS = 8
var STOPBITS = 1

var scaleconfig = require('./scaleconfig.json');

SerialPort.prototype.close = function(callback, disconnectError) {
  disconnectError = disconnectError || null;

  if (!this.isOpen) {
   // debug('close attempted, but port is not open');
   // return this._asyncError(new Error('Port is not open'), callback);
  }

  this.closing = true;
  //debug('#close');
  this.binding.close().then(() => {
    this.closing = false;
   // debug('binding.close', 'finished');
    this.emit('close', disconnectError);
    if (callback) { callback.call(this, disconnectError) }
  }, (err) => {
    this.closing = false;
   // debug('binding.close', 'had an error', err);
    return this._error(err, callback);
  });
};





if(typeof(scaleconfig.configurations)!="undefined")
{
    COMPORT= scaleconfig.configurations[0].cPort;
    STOPBITS = parseInt(scaleconfig.configurations[0].cStopBits);
    DATABITS = parseInt(scaleconfig.configurations[0].iDataBits);
    BAUDRATE = parseInt(scaleconfig.configurations[0].iBaudRate);
    PARITY= scaleconfig.configurations[0].cParity.toLowerCase();
}
function createAd2kScale(oSerialPort) {

    var DC1 = '\x11';
    var DC3 = '\x13';
    var XON = DC1;
    var XOFF = DC3;

    var CMD_W_VLD_CHKSUM = 'd';
    var CMD_W = 'W';
    var CMD_R = 'R';
    var STX = '\x02';
    var ETX = '\x03';

    var LEN_RW_SPEC_DATA = 40
    var LEN_RW_SPAN_DATA = 28
    var LEN_R_AD_VER = 3
    var CMD_W_INT_MODE = 'I'  //Internal count mode
    var CMD_W_OTCH_TARE = 'T'	 //One Touch Tare
    var CMD_W_DIGI_TARE = 'U'  //Digital tare

    var CMD_W_ZERO_RST = 'Z'  //Zero reset
    var CMD_W_WGT_MODE = 'N'  //Weighing mode
    var CMD_W_ZRST_PWR_ON = 'z'  //Zero reset when power on

    var RSP_RW_OK = '0'  //Affirmative response

    var LEN_NI_DATA = 27 //General weight data, N: Weight mode data, I: Internal mode data

    //var interval = null;
    var INTERVALTIME = 50;


    var currentMacAddress = '';
    var connected = false;

    function padding1(num, length) {
        for (var len = (num + "").length; len < length; len = num.length) {
            num = "0" + num;
        }
        return num;
    }


    function logArray(str) {
        var icnt = 0;
        var lout = '';
        var lineindex = 1;
        for (var ich in str) {
            var ch = str[ich];
            icnt += 1;
            lout += padding1(ch.charCodeAt(0).toString(16).toUpperCase(), 2) + ' ';
            if (icnt >= 16) {
                icnt = 0;
                //lout += '\r\n';
                console.log(lineindex.toString() + ": " + lout);
                lineindex++;
                lout = '';
            }
        }
        if (lout != '')
            console.log(lineindex.toString() + ": " + lout);
//			console.log(lineindex.toString() + ": ",  lout);

        //console.log(str);
    }


    function arrayBufferToString(buffer) {
        var arr = new Uint8Array(buffer);
        var str = String.fromCharCode.apply(String, arr);
        if (/[\u0080-\uffff]/.test(str)) {
            throw new Error("this string seems to contain (still encoded) multibytes");
        }

        return str;
    }


    function range(start, stop, step) {

        if (typeof stop == 'undefined') {
            // one param defined
            stop = start;
            start = 0;
        }

        if (typeof step == 'undefined') {
            step = 1;
        }

        if ((step > 0 && start >= stop) || (step < 0 && start <= stop)) {
            return [];
        }

        var result = [];
        for (var i = start; step > 0 ? i < stop : i > stop; i += step) {
            result.push(i);
        }

        return result;
    }

    function getBCCData(data) {
        var bcc = 0;
        for (var d in data)
            bcc ^= data.charCodeAt(d);


        if (bcc == 0x00
            || bcc == 0x11
            || bcc == 0x13
            || bcc == 0x02
            || bcc == 0x03) {
            bcc += 0x20;
        }
        return bcc;
    }


    var oScale = {
        btScale: null,
        funcGetWeight: null, //外部设置重量回调
        cmd: '',
        resp: null,
        buffer: '',
        portName: COMPORT,
        baudRate: BAUDRATE,
        parity: PARITY,
        dataBits: DATABITS,
        stopBits: STOPBITS,
    }

    timeoutCommand = null;
    timeoutInterval = null;
    timeoutData = null;

    //启动时置零回调
    cbPowerOnReset = null;

    oScale.reopenScale = function () {
        //console.log("restart connection");
        console.log("重新连接秤");

        oScale.closeScale(function () {
            oScale.openScale(currentMacAddress);
        })
    }

    var clearTimeoutData = function () {
//        clearTimeout(timeoutData);
    }

    var restartTimeoutData = function (force) {
        return;

//	    force = force || false;

//	    initScaleObject();

//	    if (oScale.btScale.isConnected(function() {
//            clearTimeoutData();
//            if (force || connected)
//                timeoutData = setTimeout(oScale.reopenScale, 5000);
//	    }, function() {
//	        if (force)
//	            timeoutData = setTimeout(oScale.reopenScale, 5000);
//	    }));
        //
    }

    //命令响应正常的处理
    var resolve_response = function () {
        if (oScale.resp && oScale.resp.result == RSP_RW_OK && timeoutCommand) {
            clearTimeout(timeoutCommand);
        }

        if (cbPowerOnReset != null) {
            setTimeout(function () {
                if (cbPowerOnReset != null)
                    cbPowerOnReset();
                cbPowerOnReset = null;
            }, 100);

        } else {
            oScale.btScale.write(XON);
        }

    }

    var setCommandData = function (cmd, data, cbTimeout, timeout) {

        if (!oScale.btScale) {
            console.error("Unavailable Scale Object");
            return;
        }

        timeout = timeout || 1000;

        var part = CMD_W + cmd + (data || "");
        var bcc = getBCCData(part);
        var entire = STX + part + ETX + String.fromCharCode(bcc);

        //校验
        oScale.resp = null;
        oScale.cmd = cmd;

        clearTimeoutData();
        //先发送XOFF，之后过100ms之后发送命令，再过1s判断是否成功，再发送XON，开始收重量
        oScale.btScale.write(XOFF, function (err) {
            setTimeout(function () {
                oScale.btScale.write(entire, function (err) {

                    timeoutCommand = setTimeout(function (err) {
                        oScale.btScale.write(XON);

                        if (cbTimeout) cbTimeout();

                        restartTimeoutData();

                        oScale.resp = null;
                        oScale.cmd = '';

                    }, timeout);

                })

            }, 120);
        })
    }

    oScale.setOneTouchTare = function () {
        setCommandData(CMD_W_OTCH_TARE, null, function () {
            console.log("实物去皮失败");
        }, 3000)
    }

    oScale.digitalTare = function (tare) {
        var strTare = padding1(tare.toString(), 8);
        //console.log(strTare);
        setCommandData(CMD_W_DIGI_TARE, strTare, function () {
            console.log("数字去皮失败");
        }, 3000)
    }

    oScale.zeroResetOnPower = function () {
        setCommandData(CMD_W_ZRST_PWR_ON, null, function () {
            console.log("启动清零失败");
        }, 5000)
    }

    oScale.zeroReset = function () {
        setCommandData(CMD_W_ZERO_RST, null, function () {
            console.log("清零失败");
        }, 3000)
    }

    oScale.print = function (printstr) {
        setCommandData(CMD_W_PRINT, printstr, function () {
            console.log("打印失败");
        }, 3000)
    }

    oScale.validateChkSumStr = function (chksum) {

        setCommandData(CMD_W_VLD_CHKSUM, chksum, function () {
            console.log("校验失败");
        })

        //校验成功后启动清零
        cbPowerOnReset = oScale.zeroResetOnPower;
    }

    var getNIData = function (content) {

        var buf = '';
        var NIdata = {};

        if (content[0] == '0' && content[10] == '4') {
            //weight mode
            NIdata.mode = CMD_W_WGT_MODE;
        } else if (content[0] == 'a' && content[10] == 'i') {
            //internal mode
            NIdata.mode = CMD_W_INT_MODE;
        } else {
            return;
        }

        //logArray(content);

        NIdata.sec1Str = content.substr(2, 2 + 7);
        NIdata.sec1 = parseFloat(NIdata.sec1Str.replace(/,/g, '.'));

        NIdata.sec2Str = content.substr(12, 12 + 7);
        NIdata.sec2 = parseFloat(NIdata.sec2Str.replace(/,/g, '.'));

        //console.log('sec2Str: ' + NIdata.sec2Str);;
        //console.log(NIdata.sec2Str);

        //console.log(NIdata.sec2);

        NIdata.status = '';

        for (var i in range(3)) {
            NIdata.status += String.fromCharCode(parseInt(content.slice(21 + i * 2, 21 + i * 2 + 2), 16));
        }

        return NIdata;
    }


    var NIDataToScaleData = function (NIdata) {

        var scaleData = {};

        var status;

        //logArray(NIdata.status);
        //console.log("sec1Str");
        //console.log(NIdata.sec1Str);
        //console.log("sec1Str ok");
        status = NIdata.status.charCodeAt(0);
        //byte 0, bit 0
        if (status & 0x01) {
            scaleData.tareFg = true;
        } else {
            scaleData.tareFg = false;
        }
        status >>= 3;

        //byte 0, bit 3
        if (status & 0x01) {
            scaleData.zeroPointFg = true;
        } else {
            scaleData.zeroPointFg = false;
        }
        status >>= 1;


        //byte 0, bit 4
        if (status & 0x01) {
            scaleData.stabilizeFg = true;
        } else {
            scaleData.stabilizeFg = false;
        }
        status >>= 2;


        //byte 0, bit 6-7
        scaleData.underOverFlowFg = (status & 0x03) & 0xff;

        status = NIdata.status.charCodeAt(1);
        status >>= 3;

        //byte 1, bit 3
        if (status & 0x01) {
            scaleData.spanSwFg = true;
        } else {
            scaleData.spanSwFg = false;
        }

        scaleData.sec1Str = NIdata.sec1Str;
        scaleData.sec2Str = NIdata.sec2Str;

        if (NIdata.mode == CMD_W_WGT_MODE) {
            if (scaleData.underOverFlowFg == 0) {
                scaleData.weight = NIdata.sec1;
            } else {
                scaleData.weight = 0;
            }
            scaleData.tare = NIdata.sec2;
            scaleData.irFg = false;
        } else if (NIdata.mode == CMD_W_INT_MODE) {
            scaleData.adCount = NIdata.sec1;
            scaleData.irCount = NIdata.sec2;
            scaleData.irFg = true;
        }

        return scaleData;
    }

    var getResponse = function (content) {
        resp = {
            cmd: oScale.cmd,
            type: content[0],
            result: content[1],
        }

        //console.log(JSON.stringify(resp));

        //resp.cmd = cmd_saved;  // is this OK?
        //resp.cmd = oScale.cmd;
        //resp.type = content[0];
        //resp.result = content[1];
        //if (resp.type == CMD_R && resp.result == RSP_RW_OK)
        if (resp.type == CMD_W && resp.result == RSP_RW_OK) {
            resp.data = content.substr(2);
            //memcpy(resp->data, &content[2], n - 2);
            //resp->data_len = n - 2;
            //console.log(JSON.stringify(resp));
        } else {
            //console.log("c p 202");
            resp.data = '';
            //memset(resp->data, 0, sizeof(resp->data));
            //resp->data_len = 0;
        }

        return resp;
    }

    var processResponse = function (resp) {

        g_response = resp;
        if (g_response.type == CMD_R && g_response.result == RSP_RW_OK) {
            if (g_response.cmd == CMD_RW_SPEC_DATA
                && g_response.data_len == LEN_RW_SPEC_DATA) {

                g_specData = '';
                //respDataToSpecData(&g_specData, g_response.data);
                //pcFuncs->ad2000_spec(pcFuncs->lpObj, (WPARAM) &g_specData, (LPARAM) g_response.data);

            } else if (g_response.cmd == CMD_RW_SPAN_DATA
                && g_response.data_len == LEN_RW_SPAN_DATA) {

                g_spanData = '';
                //respDataToSpanData(&g_spanData, g_response.data);
                //pcFuncs->ad2000_span(pcFuncs->lpObj, (WPARAM) &g_spanData, (LPARAM)0);

            } else if (g_response.cmd == CMD_R_AD_VER
                && g_response.data_len == LEN_R_AD_VER) {

                g_adVer = '';
                //respDataToADVerStr(g_adVer, g_response.data);
                //pcFuncs->ad2000_adver(pcFuncs->lpObj, (WPARAM) g_adVer, (LPARAM)0);
            }
        } else {
            //pcFuncs->ad2000_resp(pcFuncs->lpObj, (WPARAM) &g_response, (LPARAM)0);
        }
    }

    var processBuffer = function () {

        lastScaleData = null;
        while (true) {
            //console.log("c p 110");
            //logArray(oScale.buffer);
            var match_result = oScale.buffer.match(/\x02([^\0]*?)\x03([^\0])/);
            if (match_result) {

                //var content = cur_buffer_data[d_i];

                oScale.buffer = oScale.buffer.substr(match_result.index + match_result[0].length);

                //截取的内容: STX+DATA+ETX+BCC
                var content = match_result[1];

                //接收到的校验值BCC
                var recv_bcc = match_result[2];

                //本地计算出来的校验BCC
                var calc_bcc = getBCCData(content);

                if (calc_bcc != recv_bcc.charCodeAt(0)) {
                    console.error("Checksum Error:");
                    logArray(match_result[0]);
                    console.log(padding1(recv_bcc.charCodeAt(0).toString(16), 2));
                    console.log(padding1(calc_bcc.toString(16), 2));
                    continue;
                }

                //console.log(content.length);

                switch (content.length) {
                    case 2:
                    case 2 + LEN_R_AD_VER:
                    case 2 + LEN_RW_SPEC_DATA:
                    case 2 + LEN_RW_SPAN_DATA:
                        //memset(&resp, 0, sizeof(resp));

                        //console.log("c p 199: " + content.length);
                        //console.log("c p 200: " + oScale.cmd);
                        //logArray(content);
                        oScale.resp = getResponse(content);
                        resolve_response();
                        //oScale.processResponse(resp);
                        break;

                    case LEN_NI_DATA:
                        //memset(&NIdata, 0, sizeof(NIdata));
                        //getNIData(&NIdata, content);
                        //processNIData(hWnd, &NIdata);
                        //processNIData(pcFuncs, &NIdata);
                        //console.log("c p 197: " + content.length);
                        //logArray(content);

                        //console.log(JSON.stringify(scaleData));
                        var niData = getNIData(content);
                        //var scaleData = oScale.NIDataToScaleData(niData);
                        if (niData)
                            lastScaleData = NIDataToScaleData(niData);


                        break;

                    default:
                        break;
                }


            } else {
                //console.error('not matched');
                //logArray(oScale.buffer);
                break;
            }

            if (lastScaleData) {
                //$("#edt_weight").val(lastScaleData.weight.toFixed(3));
                //$("#edt_tare").val(lastScaleData.tare.toFixed(3));
                if (oScale.funcGetWeight != null)
                    oScale.funcGetWeight(lastScaleData);
                //$("#edt_weight").val(lastScaleData.underOverFlowFg ? "UF" : lastScaleData.weight.toFixed(3));
                //$("#edt_tare").val(lastScaleData.tare.toFixed(3));
            }


        }

    }

//	var scaleInterval = function() {
//		if (connected) {
//		    oScale.btScale.available(function(numBytes) {
//		        if (numBytes > 0) {
//		            oScale.btScale.read(function(data) {
//		                oScale.buffer = oScale.buffer.substr(-3000).concat(data);
//                        //收不到秤数据时，重新连接
//                        restartTimeoutData();
//		            })
//		        }
//		    })
//		    processBuffer();
//		    timeoutInterval = setTimeout(scaleInterval, INTERVALTIME);
//		}
//	}

    var initScaleObject = function () {
        if (!oScale.btScale) {
            oScale.btScale = new SerialPort(oScale.portName, {
                baudRate: oScale.baudRate,
                parity: oScale.parity,
                dataBits: oScale.dataBits,
                stopBits: oScale.stopBits,
                autoOpen: false
            });
        }
    }

    oScale.openScale = function (portName,
                                 baudRate,
                                 parity,
                                 dataBits,
                                 stopBits,
                                 openCallback) {

        oScale.portName = portName;
        oScale.baudRate = baudRate;
        oScale.parity = parity;
        oScale.dataBits = dataBits;
        oScale.stopBits = stopBits;
        initScaleObject();

        oScale.btScale.open(function (err) {
            if (err) {
                console.log(err);
                //连接失败后，强制重新连接秤
                restartTimeoutData(true);
            } else {
                //connected = true;
                oScale.btScale.on('data', function (data) {
                    oScale.buffer = oScale.buffer.substr(-3000).concat(data);
                    processBuffer();
                    //收不到秤数据时，重新连接
                    restartTimeoutData();
                });
                oScale.validateChkSumStr(CHECKSUM);
            }

            if (openCallback) {
                openCallback(err);
            }
        });

    }

    oScale.closeScale = function (closeCallback) {
        initScaleObject();
        var cbCloseIt = function (done) {
            clearTimeoutData();
            oScale.btScale.close(done);
            //connected = false;
        }
        cbCloseIt(closeCallback);

    }

    return oScale;

}


setTimeout(function () {
    //console.log('zeroReset');
    //oScale.zeroReset();
    //oScale.setOneTouchTare();
    //oScale.digitalTare(20);
    //oScale.closeScale(function(err) {
    //process.exit();
    //})
}, 10000);


//声明成全局变量  否则去皮 置零不好用
var oScale = createAd2kScale();
var weightOld = 0;
var beginTime =null;
var time = 0;
var isSendUF=0;
var isSendstabilizeFg=true;
var getWeight = function (callback) {
    var _timeout = null;
    
    oScale.openScale(COMPORT, BAUDRATE, PARITY, DATABITS, STOPBITS, function (err) {
        // 取重
        oScale.funcGetWeight = function (weightData) {
	    if(beginTime ==null) beginTime = new Date().valueOf();
	    var time1 = new Date().valueOf();
	    time = time1 - beginTime;

            var weight = weightData.weight.toFixed(3);
            if (weightData.underOverFlowFg == "UF" || weightData.underOverFlowFg == 1) {
                weight = weightData.tare.toFixed(3);

                if(isSendUF==0)
                {
                callback(JSON.stringify(weightData));
                isSendUF=1;
                }
            }
		//logger(time)
         
               //logger(JSON.stringify(weightData));
            if (weightData.stabilizeFg == true) {
                if(isSendstabilizeFg==false)
                {
                callback(JSON.stringify(weightData));
                isSendstabilizeFg=true;
                }
            }

            if (Math.abs(weight - weightOld) >= 0.001 && time > 300) {
		       time = 0;
		       beginTime = null;
                // res.send('electronicBalance-change', JSON.stringify(weightData));
                callback(JSON.stringify(weightData));
                weightOld = weight ;
                isSendUF=0;
                isSendstabilizeFg=false;
		        return;
            }
            
        }
    });
}



var match = function (res, json, callback) {
   var weightOld = 0;
   var isMatch=false;

   //logger(JSON.stringify(json));
  //oScale.openScale(json.cPort.toString(), json.iBaudRate.toString(), json.cParity.toString(),
   // json.iDataBits.toString(), json.cStopBits.toString(), function (err) {
    var cStopBits = parseInt(json.cStopBits.toString());
var iDataBits = parseInt(json.iDataBits.toString());
var iBaudRate = parseInt(json.iBaudRate.toString());
var cParity= json.cParity.toString().toLowerCase( );

   //logger(cParity);

    oScale.openScale(json.cPort.toString(), iBaudRate, cParity, iDataBits,  cStopBits , function (err) {

        if (err) {
            oScale=null;
            oScale = createAd2kScale();
            let response = {
                code: 999,
                message: "适配失败"+err.message,
                data: null
            };
            res(response);
           // oScale.closeScale();
        }
        else {
            // 取重
       
                oScale.funcGetWeight = function (weightData) {
                    var weight = weightData.weight.toFixed(3);
                    if (weightData.underOverFlowFg == "UF") {
                        weight = weightData.tare.toFixed(3);
                    }

           
                 
                         isMatch=true;

                        // res.send('electronicBalance-change', JSON.stringify(weightData));
                        callback(JSON.stringify(weightData))
                        weightOld = weight;

                           let response = {
                           code: 200,
                           message: "开始适配",
                           data: null
                         };
                         res(response);
                        
                     
        

            }

   setTimeout(function () {
if(isMatch==false)
{
                oScale.closeScale();
              oScale=null;
              oScale = createAd2kScale();
            let response = {
                code: 999,
              message: "适配失败",
                data: null
           };
           res(response);
}
            }, 3000);



        }
    });


}




function logger(json) {
    const fs = require('fs');
    fs.appendFile(__dirname + '/log.txt', json,'utf8', function (err) {
        if (err) {
            console.log(err);
        } else {
            console.log("JSON saved suceess");
        }
    });
}

function saveConfig(jsonObject) {
    scaleconfig = {
        "configurations": [
            {
                "cElectronicBalanceBrand": jsonObject.cElectronicBalanceBrand,
                "cElectronicBalanceModel": jsonObject.cElectronicBalanceModel,
                "cType": jsonObject.cType,
                "cPort": jsonObject.cPort,
                "iBaudRate": jsonObject.iBaudRate,
                "iDataBits": jsonObject.iDataBits,
                "cStopBits": jsonObject.cStopBits,
                "cParity": jsonObject.cParity,
                "iDataLength": jsonObject.iDataLength,
                "iDataSplite": jsonObject.iDataSplite,
                "cDataReadSequence": jsonObject.cDataReadSequence,
                "iDataReadLength": jsonObject.iDataReadLength,
                "iDataReadStart": jsonObject.iDataReadStart,
                "iDataAccuracy": jsonObject.iDataAccuracy,
                "bPeelingButton": jsonObject.bPeelingButton,
                "bContinuedDataRead": jsonObject.bContinuedDataRead,
                "bMatch": jsonObject.bMatch
            }
        ]
    }

    const fs = require('fs');
    fs.writeFile(__dirname + '/scaleconfig.json', JSON.stringify(scaleconfig), function (err) {
        if (err) {
            console.log(err);
        } else {
            console.log("JSON saved suceess");
        }
    });
}


//电子秤配置文件保存
//电子秤配置文件保存
var save = function (resolve,jsonObject) {
    //logger("电子秤配置文件保存");
  // logger(JSON.stringify(json));
   // saveConfig(json);


  scaleconfig = {
        "configurations": [
            {
                "cElectronicBalanceBrand": jsonObject.cElectronicBalanceBrand,
                "cElectronicBalanceModel": jsonObject.cElectronicBalanceModel,
                "cType": jsonObject.cType,
                "cPort": jsonObject.cPort,
                "iBaudRate": jsonObject.iBaudRate,
                "iDataBits": jsonObject.iDataBits,
                "cStopBits": jsonObject.cStopBits,
                "cParity": jsonObject.cParity,
                "iDataLength": jsonObject.iDataLength,
                "iDataSplite": jsonObject.iDataSplite,
                "cDataReadSequence": jsonObject.cDataReadSequence,
                "iDataReadLength": jsonObject.iDataReadLength,
                "iDataReadStart": jsonObject.iDataReadStart,
                "iDataAccuracy": jsonObject.iDataAccuracy,
                "bPeelingButton": jsonObject.bPeelingButton,
                "bContinuedDataRead": jsonObject.bContinuedDataRead,
                "bMatch": "true"
            }
        ]
    }

    const fs = require('fs');
    fs.writeFile(__dirname + '/scaleconfig.json', JSON.stringify(scaleconfig), function (err) {
        if (err) {
              oScale.closeScale();
              oScale=null;
              oScale = createAd2kScale();
               let response

               response = {
              code: 999,
                message: err.path+"需要获得管理员权限",
                 data: null
               };

               resolve(response);
     
        } else {
              oScale.closeScale();
              oScale=null;
              oScale = createAd2kScale();
              let response

              response = {
               code: 200,
               message: '适配成功',
               data: null
               };

               resolve(response);
        }
    });
}


//电子秤配置文件清空
var clear = function (resolve) {
    delete scaleconfig["configurations"];
    const fs = require('fs');
    fs.writeFile(__dirname + '/scaleconfig.json', JSON.stringify(scaleconfig), function (err) {
        console.log(err);
    });
    let response

    response = {
        code: 200,
        message: '清除成功',
        data: null
    };

    resolve(response);
}


//实物去皮  
var tare = function (resolve) {
    oScale.setOneTouchTare();
    let response

    response = {
        code: 200,
        message: '去皮成功',
        data: null
    };

    resolve(response);
}

//清零
var zeroReset = function (resolve) {
    oScale.zeroReset();
    let response

    response = {
        code: 200,
        message: '清零成功',
        data: null
    };

    resolve(response);
}


//关称
var close = function (resolve) {
    oScale.closeScale();
    oScale=null;
    oScale = createAd2kScale();
    let response

    response = {
        code: 200,
        message: '关称成功',
        data: null
    };

    resolve(response);
}

//数字去皮  
var digitalTare = function (resolve,tare) {
    tare=tare * 1000;
    oScale.digitalTare(tare);
    let response

    response = {
        code: 200,
        message: '去皮成功',
        data: null
    };

    resolve(response);
}

module.exports = {
    getWeight:  getWeight,
    match: match,
    clear: clear,
    zeroReset: zeroReset,
    tare: tare,
    close: close,
    save: save,
    digitalTare : digitalTare
}



