﻿var scaleconfig = require('./scaleconfig.json');
let utils = require("./utils.js");
var edge = require('electron-edge-js');
var dllPath=__dirname + '/Print/Print.dll';
var qr = require('qr-image');
var fs = require('fs');

var config ;
const path = require('path');
const urlpath = path.resolve(__dirname, '../../../uretailurl');
const configPath = `${urlpath}/config.json`;
fs.exists(urlpath, function (exists) {
       fs.exists(configPath, function (existss) {
           if (existss) {
            config = require(configPath)
           }
       });
});


var weightOld = 0;
var beginTime =null;
var time = 0;
var isSendUF=0;
var isSendstabilizeFg=true;
var isGetWeight=false;
var isSendUF=0;
var isSendOF=0;
var interval;

var getWeight = function (callback) {
    isGetWeight=true;
    interval=setInterval(function () {weight(callback,config.devicetype); },300); 
}

function weight(callback,devicetype)
{
    if(isGetWeight)
        {
	 var input="";
	 var methodValue="FreshWayOpen";
	 if(devicetype=="顶尖")
	 {
		 methodValue="AclasOpen";
	 }
	 else if(devicetype=="中崎")
	 {
		 methodValue="ZonerichOpen";
	 }
	 else if(devicetype=="寺冈")
	 {
		 methodValue="digitalOpen";
	 }
     var getPrinter = edge.func({
        assemblyFile:dllPath,
        typeName:"print.Print",
        methodName: methodValue
        });
        getPrinter(input,function(err,result)
        {
           let data=JSON.parse(result);
		   var weightNew = data.weight.toFixed(3);

		   if (data.underOverFlowFg == 1 ) {
			//weightNew = data.tare.toFixed(3);
			weightNew = -0.001; //欠载的时候重量传负数

			if(isSendUF==0)
			{
			callback(JSON.stringify(data));
			isSendUF=1;
			}
		}

		if (data.underOverFlowFg == 2 ) {
			weightNew = data.tare.toFixed(3);

			if(isSendOF==0)
			{
			callback(JSON.stringify(data));
			isSendOF=1;
			}
		}

           if (data.stabilizeFg == true) {
                if(isSendstabilizeFg==false)
                {
                callback(result);
                isSendstabilizeFg=true;
                }
            }

           if (Math.abs(weightNew - weightOld) >= 0.001)
           {
		
               callback(result);
			   weightOld = weightNew ;
			   isSendUF=0;
			   isSendOF=0;
			   isSendstabilizeFg=false;
			
           }
         });
        }
}




var match = function (res, json, callback) {
   weightOld = 0;
   isGetWeight=true;
   interval=setInterval(function () {weight(callback,json.cDeviceBrand); },200); 
   
   let response = {
	code: 200,
	message: "开始适配",
	data: null
  };
  res(response);
}

function saveConfig(jsonObject) {
    scaleconfig = {
        "configurations": [
            {
                "cElectronicBalanceBrand": jsonObject.cElectronicBalanceBrand,
                "cElectronicBalanceModel": jsonObject.cElectronicBalanceModel,
                "cType": jsonObject.cType,
                "cPort": jsonObject.cPort,
                "iBaudRate": jsonObject.iBaudRate,
                "iDataBits": jsonObject.iDataBits,
                "cStopBits": jsonObject.cStopBits,
                "cParity": jsonObject.cParity,
                "iDataLength": jsonObject.iDataLength,
                "iDataSplite": jsonObject.iDataSplite,
                "cDataReadSequence": jsonObject.cDataReadSequence,
                "iDataReadLength": jsonObject.iDataReadLength,
                "iDataReadStart": jsonObject.iDataReadStart,
                "iDataAccuracy": jsonObject.iDataAccuracy,
                "bPeelingButton": jsonObject.bPeelingButton,
                "bContinuedDataRead": jsonObject.bContinuedDataRead,
                "bMatch": "true"
            }
        ]
    }

    const fs = require('fs');
    fs.writeFile(__dirname + '/scaleconfig.json', JSON.stringify(scaleconfig), function (err) {
        if (err) {
            console.log(err);
        } else {
            console.log("JSON saved suceess");
        }
    });
}


//电子秤配置文件保存
//电子秤配置文件保存
var save = function (resolve,jsonObject) {
    //logger("电子秤配置文件保存");
  // logger(JSON.stringify(json));
   // saveConfig(json);


  scaleconfig = {
        "configurations": [
            {
                "cElectronicBalanceBrand": jsonObject.cElectronicBalanceBrand,
                "cElectronicBalanceModel": jsonObject.cElectronicBalanceModel,
                "cType": jsonObject.cType,
                "cPort": jsonObject.cPort,
                "iBaudRate": jsonObject.iBaudRate,
                "iDataBits": jsonObject.iDataBits,
                "cStopBits": jsonObject.cStopBits,
                "cParity": jsonObject.cParity,
                "iDataLength": jsonObject.iDataLength,
                "iDataSplite": jsonObject.iDataSplite,
                "cDataReadSequence": jsonObject.cDataReadSequence,
                "iDataReadLength": jsonObject.iDataReadLength,
                "iDataReadStart": jsonObject.iDataReadStart,
                "iDataAccuracy": jsonObject.iDataAccuracy,
                "bPeelingButton": jsonObject.bPeelingButton,
                "bContinuedDataRead": jsonObject.bContinuedDataRead,
                "bMatch": jsonObject.bMatch
            }
        ]
    }

	const txtPath = `${urlpath}/scaleconfig.json`;

    const fs = require('fs');
   // fs.writeFile(__dirname + '/scaleconfig.json', JSON.stringify(scaleconfig), function (err) {
	fs.writeFile(txtPath, JSON.stringify(scaleconfig), function (err) {
        if (err) {
               close(resolve);
               let response

               response = {
              code: 999,
                message: err.path+"需要获得管理员权限",
                 data: null
               };

               resolve(response);
     
        } else {
              close(resolve);
              let response

              response = {
               code: 200,
               message: '适配成功',
               data: null
               };

               resolve(response);
        }
    });
}


//电子秤配置文件清空
var clear = function (resolve) {
    delete scaleconfig["configurations"];
    const fs = require('fs');
    fs.writeFile(__dirname + '/scaleconfig.json', JSON.stringify(scaleconfig), function (err) {
        console.log(err);
    });
    let response

    response = {
        code: 200,
        message: '清除成功',
        data: null
    };

    resolve(response);
}


//实物去皮  
var tare = function (resolve) {
	var input="";
	var methodValue="FreshWayTouchTare";
	if(config.devicetype=="顶尖")
	{
		methodValue="AclasTouchTare";
	}
	else if(config.devicetype=="中崎")
	{
		methodValue="ZonerichTare";
	}
	else if(config.devicetype=="寺冈")
	{
		methodValue="digitalTare";
	}

    var getPrinter = edge.func({
        assemblyFile:dllPath,
        typeName:"print.Print",
        methodName: methodValue
        });
    getPrinter(input,function(err,result)
    {
        console.log(result);
     });
    let response

    response = {
        code: 200,
        message: '去皮成功',
        data: null
    };

    resolve(response);
}




//清皮  
var clearTare = function (resolve) {
	var input="";
	var methodValue="FreshWayClearTare";
	 if(config.devicetype=="中崎")
	{
		methodValue="ZonerichClearTare";
	}


    var getPrinter = edge.func({
        assemblyFile:dllPath,
        typeName:"print.Print",
        methodName: methodValue
        });
    getPrinter(input,function(err,result)
    {
        console.log(result);
     });
    let response

    response = {
        code: 200,
        message: '清皮成功',
        data: null
    };

    resolve(response);
}

//清零
var zeroReset = function (resolve) {
	var input="";
	var methodValue="FreshWayZeroReset";
	if(config.devicetype=="顶尖")
	{
		methodValue="AclasZeroReset";
	} 
	else 	if(config.devicetype=="中崎")
	{
		methodValue="ZonerichReset";
	} 
	else 	if(config.devicetype=="寺冈")
	{
		methodValue="digitalReset";
	} 
    var getPrinter = edge.func({
        assemblyFile:dllPath,
        typeName:"print.Print",
        methodName: methodValue
        });
        getPrinter(input,function(err,result)
        {
            console.log(result);
		 });
		 

    if (!resolve) return;
    let response

    response = {
        code: 200,
        message: '清零成功',
        data: null
    };

    resolve(response);
}


//关称
var close = function (resolve) {
    /*var input="";
    var getPrinter = edge.func({
     assemblyFile:dllPath,
     typeName:"print.Print",
     methodName: "FreshWayClose"
     });
     getPrinter(input,function(err,result)
     {
         console.log(result);
      });*/
     
    if(interval!=null)  
    {
       clearInterval(interval );
    }

    isGetWeight=false;
    let response

    response = {
        code: 200,
        message: '关称成功',
        data: null
    };

    resolve(response);
}

//数字去皮  
var digitalTare = function (resolve,tare) {
  
	var methodValue="FreshWayDigitalTare";
	if(config.devicetype=="顶尖")
	{
		methodValue="AclasDigitalTare";
	}
	else 	if(config.devicetype=="中崎")
	{
		methodValue="ZonerichDigitaTare";
	}
	else 	if(config.devicetype=="寺冈")
	{
		methodValue="digitalDigitaTare";
	}

    var getPrinter = edge.func({
        assemblyFile:dllPath,
        typeName:"print.Print",
        methodName: methodValue
        });
        getPrinter(tare,function(err,result)
        {
            console.log(result);
         });

         
    let response

    response = {
        code: 200,
        message: '去皮成功',
        data: null
    };

    resolve(response);
}

//打开钱箱  
var openCashDrawNoCheck = function (resolve,devicetype) {
	var input="";
	var methodValue="FreshWayOpenCashDrawer";
	if(devicetype=="顶尖")
	{
		methodValue="AclasOpenCashDrawer";
	}
	else  if(devicetype=="海信")
	{
		methodValue="HisenceOpenCashDrawer";
	}
	else  if(devicetype=="中崎")
	{
		methodValue="ZonerichOpenCashDrawer";
	}
	else  if(devicetype=="寺冈")
	{
		methodValue="digitalOpenCashDrawer";
	}

    var getPrinter = edge.func({
        assemblyFile:dllPath,
        typeName:"print.Print",
        methodName: methodValue
        });
        getPrinter(input,function(err,result)
        {
            console.log(result);
         });

         
    let response

    response = {
        code: 200,
        message: '打开钱箱成功',
        data: null
    };

    resolve(response);
}

//需要验证用户名和密码 开启钱箱
var openCashDraw = function (resolve,keys) {
	let response;
	try{
	    //要发送的数据
	    var password;
		var contents = JSON.stringify({     	
	    	"password":keys.password,
	    	"username":keys.username
	    });
	    //发送请求的参数  
	    var reqOptions = { 
	    	host:'uretailserver.yonyouup.com',
	    	path:'/uretail/user/operation/check/opencashbox?token='+req.query.token,
	    	method:'POST',
	    	headers:{ 
	    		'Content-Type':'application/x-www-form-urlendcoded',
	    		'Content-Length':contents.length
	    	}
	    };
	    var req = http.request(reqOptions,function(resu){
	    	resu.setEncoding('utf-8');
	    	resu.on('data',function(data){ 
	    		//处理返回的数据，进行开钱箱操作
	    		var result = JSON.parse(data);
	    		if(result.code == 200){ 
                   // doOpenCashbox(resolve,5,response);
                   openCashDrawNoCheck(resolve,config.devicetype);
	    		}else{
	    			resolve(result);
	    		}
	    	})
	    });
	    req.write(contents);
	    req.end();
		
	}catch(e){
		response = {
            code:999,
            message: "钱箱设备未连接或未开启",
            data: null
		};
		return resolve(response);
	}
	
}


function isContains(str,substr){ 
	if(str)
	{
		if((typeof(str)=='string')&&(str.constructor==String))
		{
			return str.indexOf(substr) >= 0;
		}
		else
		{
		return  false;
		}
	}
	else
	{
		return false;
	}
}

function getDetailFontSizeStr(temp,index,isnewline)
{	
    let fontSize=parseInt(temp.font);
	if(config.devicetype=="托利多" || config.devicetype=="寺冈" || config.devicetype=="中崎" || config.devicetype=="爱普生" || config.devicetype=="滢浦通" || config.devicetype=="芯烨")
	{
		let content = new Object();
		content.fontSize = temp.font+'';
		content.fontName = temp.fontName;
		content.top=temp.top;
        content.left=temp.left;
		content.index=index;
		content.width=temp.width;
		content.isnewline=isnewline;
		content.HorAlignment = temp.Alignment;
		content.VertAligment = temp.VertAligment;
		if(temp.barcodeType)
		{
			content.printtype="barcode";
		}
		else
		{
			content.printtype="text";
		}
		return  JSON.stringify(content);
	}
	else if(config.devicetype=="海信")
	{
	if(fontSize > 14){ 
	   return "\x1b\x21\x30";	
      }else{ 
	    return "\x1b\x21\x00";
	 }
	}
	else
	{
	return "!"+fontSize+"^";
	}
}

function getValueFontSizeStr(temp,isnewline)
{	
    let fontSize=parseInt(temp.font);
	if(config.devicetype=="托利多" || config.devicetype=="寺冈" || config.devicetype=="中崎" || config.devicetype=="爱普生" || config.devicetype=="滢浦通" || config.devicetype=="芯烨")
	{
		let content = new Object();
		content.fontSize = temp.font+'';
		content.fontName = temp.fontName;
		content.top=temp.top;
		content.left=temp.left;
		content.width=temp.width;
		content.height=temp.height;
		content.isnewline=isnewline;
		content.HorAlignment = temp.Alignment;
		content.VertAligment = temp.VertAligment;
		if(temp.barcodeType)
		{
			content.printtype="barcode";
		}
		else
		{
			content.printtype="text";
		}
		return  JSON.stringify(content);
	}
	else
	{
	return "";
	}
}

function getDetailValueFontSizeStr(temp,left,top,index,isnewline,width,Alignment,VertAligment)
{	
    let fontSize=parseInt(temp.font);
	if(config.devicetype=="托利多" || config.devicetype=="寺冈" || config.devicetype=="中崎" || config.devicetype=="爱普生" || config.devicetype=="滢浦通" || config.devicetype=="芯烨")
	{
		let content = new Object();
		content.fontSize = temp.font+'';
		content.fontName = temp.fontName;
		content.top=top;
        content.left=left;
		content.index=index;
		content.isnewline=isnewline;
		content.width=width;
		content.height=temp.height;
		content.HorAlignment = Alignment;
		content.VertAligment = VertAligment;
		if(temp.barcodeType)
		{
			content.printtype="barcode";
		}
		else
		{
			content.printtype="text";
		}
		return  JSON.stringify(content);
	}
	else
	{
	return "";
	}
}


function getFontSizeStr(temp)
{	
	let fontSize=parseInt(temp.font);
	if(config.devicetype=="托利多" || config.devicetype=="寺冈" || config.devicetype=="中崎" || config.devicetype=="爱普生" || config.devicetype=="滢浦通" || config.devicetype=="芯烨")
	{
		let content = new Object();
		content.fontSize = temp.font+'';
		content.fontName = temp.fontName;
		content.top=temp.top;
		content.left=temp.left;
		content.width=temp.width;
		content.height=temp.height;
		content.HorAlignment = temp.Alignment;
		content.VertAligment = temp.VertAligment;
		if(temp.barcodeType)
		{
			content.printtype="barcode";
		}
		else
		{
			content.printtype="text";
		}
		return  JSON.stringify(content);
	}
	else if(config.devicetype=="海信")
	{
	if(fontSize > 14){ 
	   return "\x1b\x21\x30";	
      }else{ 
	    return "\x1b\x21\x00";
	 }
	}
	else
	{
	return "!"+fontSize+"^";
	}
}

function getImageStr(temp)
{	
	let fontSize=parseInt(temp.font);
	if(config.devicetype=="托利多" || config.devicetype=="寺冈" || config.devicetype=="中崎" || config.devicetype=="爱普生" || config.devicetype=="滢浦通" || config.devicetype=="芯烨")
	{
		let content = new Object();
		content.top=temp.top;
		content.left=temp.left;
		content.width=temp.width;
		content.height=temp.height;
		if(temp.barcodeType)
		{
			content.printtype="barcode";
		}else if(temp.ImageType == "Image"){
			content.printtype="Image";
		}
		else
		{
			content.printtype="text";
		}
		return  JSON.stringify(content);
	}
}

//托利多打印
var print_for_temp = function(dir,tempArr,data,resolve,pagewidth,supMidOfPrint){ 
 	var text = "";
    utils.checkNull(data);
	var newLineArray = new Array();
	var previousValue="";
	var imageContent="";
	
		for(var i = 0 ; i < tempArr.length ; i ++ ) { 
				//打印图片
				if(tempArr[i].isprint == undefined){ 
					if(tempArr[i].ImageType != undefined){ 
						text += getImageStr(tempArr[i]) + tempArr[i].Image;
						continue;
					}
				}
			if( i > 0){ 			
				if(tempArr[i].isprint == undefined){ 
					// if(tempArr[i].ImageType != undefined){ 
					// 	imageContent=tempArr[i].Image;
					// 	continue;
					// }
					var value = tempArr[i].text;
					if(utils.isContains(value,"{")){ 
						//当前不支持没有实体的参数 
						if(value.split("{")[1].split("}")[0].split(".").length == 1){

							if(value=="{当前时间}")
							{

								for(let k = 0; k < newLineArray.length ; k ++){
									//先换行
									if(k == 0){
										text += '\n';
										for(let l = 0; l < Math.ceil(newLineArray[k].left * 6.8) ;l ++ ){
											text+= ' ';
										}
									}else{
										for(let l = 0; l < Math.ceil(newLineArray[k].left * 6.8) - Math.ceil(newLineArray[k-1].left * 6.8); l++ ){
											text += ' ';
										}
									}
									
									if(Math.ceil(utils.getLength(newLineArray[k].value)) > Math.ceil(newLineArray[k].width * 6.8)){
										//目前行要输出的值
										var subStrCN = utils.subStringCN(newLineArray[k].value,Math.ceil(newLineArray[k].width * 6.8)-3);
										let value1 = subStrCN.str;
										//let value1 = newLineArray[k].value.substring(0,Math.ceil(newLineArray[k].width * 6.8));
										text += value1;
										text += '\n';
										for(let l = 0; l < Math.ceil(newLineArray[k].left * 6.8) ;l ++ ){
											text+= ' ';
										}
										let txt=newLineArray[k].value.replace(value1,'');
										if(Math.ceil(utils.getLength(txt)) > Math.ceil(newLineArray[k].width * 6.8)){
											var subStrCN1 = utils.subStringCN(txt,Math.ceil(newLineArray[k].width * 6.8)-3);
											let value2 = subStrCN1.str;
											text += value2;
											text += '\n';
											for(let l = 0; l < Math.ceil(newLineArray[k].left * 6.8) ;l ++ ){
												text+= ' ';
											}
											text += txt.replace(value2,'');
										}
										else
										{
										text += newLineArray[k].value.replace(value1,'');
										}
									}else{
										text += newLineArray[k].value;
										newLineArray[k].value = '';
										//newLineArray.splice(0,1);
									}
								}
								newLineArray.splice(0,newLineArray.length);

								

								for(var j = 0 ; j < data.length ; j ++ ){
													if(data[j].name == value.split("{")[1].split("}")[0] ){ 
														text=text+ '\n';
														if(tempArr[i].font > 14){ 
															//text += "\x1b\x21\x30";	
															text += getFontSizeStr(tempArr[i]);
														}else{ 
															//text += "\x1b\x21\x00";
															text += getFontSizeStr(tempArr[i]);
														}
														text=text+data[j].value;
							
							}
							}
							previousValue="";
							//text=+utils.getNowFormatDate();
							}

							continue;
						}
						
						value = value.split("{")[1].split("}")[0].split(".")[1];
						var flag1 = 0;
						//判断是否有上一行长度过长需要换行打印的
						if(tempArr[i].neednewline == true){
							do{
								tempArr[i].neednewline = false;
								for(let k = 0; k < newLineArray.length ; k ++){
									//先换行
									if(k == 0){
										text += '\n';
										for(let l = 0; l < Math.ceil(newLineArray[k].left * 6.8) ;l ++ ){
											text+= ' ';
										}
									}else{
										for(let l = 0; l < Math.ceil(newLineArray[k].left * 6.8) - Math.ceil(newLineArray[k-1].left * 6.8); l++ ){
											text += ' ';
										}
									}
									
									if(Math.ceil(utils.getLength(newLineArray[k].value)) > Math.ceil(newLineArray[k].width * 6.8)){
										tempArr[i].neednewline = true;
										//目前行要输出的值
										var subStrCN = utils.subStringCN(newLineArray[k].value,Math.ceil(newLineArray[k].width * 6.8)-3);
										let value1 = subStrCN.str;
										//let value1 = newLineArray[k].value.substring(0,Math.ceil(newLineArray[k].width * 6.8));
										//下一行要输出的值
										let value2 = newLineArray[k].value.substring(subStrCN.index,utils.getLength(newLineArray[j].value));
										
										text += value1;
										newLineArray[k].value = value2;
									}else{
										text += newLineArray[k].value;
										newLineArray[k].value = '';
										//newLineArray.splice(0,1);
									}
								}
							}
							while(tempArr[i].neednewline == true)
							newLineArray.splice(0,newLineArray.length);
						}
						for(var j = 0 ; j < data.length ; j ++ ){
							//判断是否是子表
							if(tempArr[i].text.split("{")[1].split("}")[0].split(".").length == 2){ 
								if(data[j].name == value ){ 
									if(tempArr[i].barcodeType)
									{
										if(!isContains(data[j].value+'','$'))
										{
											continue;
										}
									}
									else
									{
									 if(isContains(data[j].value+'','$'))
									 {
										 continue;
									 }
									}
									var textlength = Math.ceil(utils.getLength(data[j].value));
									//如果值长度大于限制范围，在下一行同样距离左边的位置继续输出
									if(textlength > Math.ceil(tempArr[i].width * 6.8)){
										if(config.devicetype=="海信")
										{
										//目前行要输出的值
										var subStrCN = utils.subStringCN(data[j].value,Math.ceil(tempArr[i].width * 6.8)-3);
										let value1 = subStrCN.str;
										//let value1 = data[j].value.substring(0,Math.ceil(tempArr[i].width * 6.8));
										//下一行要输出的值
										let value2 = data[j].value.substring(subStrCN.index+1,textlength);
										var obj = new Object();
										obj.left = tempArr[i].left;
										obj.width = tempArr[i].width;
										obj.value = value2;
										newLineArray.push(obj);
										for(var k = i+1; k< tempArr.length; k ++ ){
											if(tempArr[k].top - tempArr[i].top > 0.2){
												tempArr[k].neednewline = true;
												break;
											}
										}
										data[j].value = value1;
									 }
									}
									//判断同行,离顶点距离差异小于0.2默认为同一行
									if(tempArr[i].top - tempArr[i-1].top < 0.2){ 
										if(isContains(tempArr[i-1].text,"{")){ 
										if(previousValue=="")
										{
										for( var k = 0; k < Math.ceil(tempArr[i].left * 6.8) - Math.ceil(tempArr[i-1].left * 6.8) -utils.getLength(tempArr[i-1].text) ; k ++){ 
											text += " ";
										}
									   }
									   else
									   {
										for( var k = 0; k < Math.ceil(tempArr[i].left * 6.8) - Math.ceil(tempArr[i-1].left * 6.8) -utils.getLength(previousValue) ; k ++){ 
											text += " ";
										}
									   }
									}
									else
									{
										for( var k = 0; k < Math.ceil(tempArr[i].left * 6.8) - Math.ceil(tempArr[i-1].left * 6.8) -utils.getLength(tempArr[i-1].text) ; k ++){ 
											text += " ";
										}
									}
									   previousValue="";
									   text += getValueFontSizeStr(tempArr[i],false);
										text += data[j].value;
										previousValue=data[j].value;
										flag1 = 1;
										break;
									}else{ 
										//设置字体，为标准或者两倍
										if(parseInt(tempArr[i].font ) > 14){ 
											text += "\n";
											//text += "\x1b\x21\x30";	
											text += getFontSizeStr(tempArr[i]);
											for(var k = 0 ; k < Math.ceil(tempArr[i].left * 6.8 / 2); k ++ ){ 
												text += " ";
											}
										}else{ 
											text += "\n";
											//text += "\x1b\x21\x00";
											text += getFontSizeStr(tempArr[i]);
											for(var k = 0 ; k < Math.ceil(tempArr[i].left * 6.8); k ++ ){ 
												text += " ";
											}
										}
								
										
										text += data[j].value;
										flag1 = 1;
										break;
									}
								}
							}else{ 
								value = tempArr[i].text.split("{")[1].split("}")[0].split(".")[2]
								//获取要打印的子表所处的单据数据的位置
								var index = 0;
								var isExits=false;
								for(index ; index < data.length;index ++ ){
									if(data[index].length != undefined && data[index].isPrint == undefined && data[index][0]!= undefined && data[index][0][0]!= undefined ){
										if(data[index][0][0].name == value){
											isExits=true;
											break;
										}
										
									}
								}
								if(isExits==false)
								{
									//data里面没有对应字段数据信息
									continue;
								}
								//循环子表第k行
								for( var k = 0 ; k < data[index].length ; k ++ ){ 
									//子表循环要打印的列数，从拿到判断到时子表数据的第i行模板数据开始，接下来的子表列循环打印出来，并标志为已打印
									for( var m = i ; m < i + data[index][0].length ; m ++ ){ 
										//
										var value1 = tempArr[m].text.split("{")[1].split("}")[0].split(".")[2];
										//子表具体行的列循环打印
										for(var l = 0 ; l < data[index][k].length; l ++ ){
											if(utils.isContains(tempArr[m].text,"{")){ 
												
												if(value1 == data[index][k][l].name){ 
													//判断是否有上一行长度过长需要换行打印的
													if(tempArr[m].neednewline == true){
														do{
															tempArr[m].neednewline = false;
															for(let k = 0; k < newLineArray.length ; k ++){
																//先换行
																if(k == 0){
																	text += '\n';
																	for(let l = 0; l < Math.ceil(newLineArray[k].left * 6.8) ;l ++ ){
																		text+= ' ';
																	}
																}else{
																	for(let l = 0; l < Math.ceil(newLineArray[k].left * 6.8) - Math.ceil(newLineArray[k-1].left * 6.8); l++ ){
																		text += ' ';
																	}
																}
																
																if(Math.ceil(utils.getLength(newLineArray[k].value)) > Math.ceil(newLineArray[k].width * 6.8)){
																	tempArr[m].neednewline = true;
																	//目前行要输出的值
																	var subStrCN = utils.subStringCN(newLineArray[k].value,Math.ceil(newLineArray[k].width * 6.8)-3);
																	let value1 = subStrCN.str;
																	//let value1 = newLineArray[k].value.substring(0,Math.ceil(newLineArray[k].width * 6.8));
																	//下一行要输出的值
																	let value2 = newLineArray[k].value.substring(subStrCN.index,utils.getLength(newLineArray[j].value));
																	text += getValueFontSizeStr(tempArr[i],true);
																	text += value1;
																	newLineArray[k].value = value2;
																}else{
																	text += getValueFontSizeStr(tempArr[i],true);
																	text += newLineArray[k].value;
																	newLineArray[k].value = '';
																	//newLineArray.splice(0,1);
																}
															}
														}
														while(tempArr[m].neednewline == true)
														newLineArray.splice(0,newLineArray.length);
													}
													tempArr[m].isprint = 1;
													
													var textlength = Math.ceil(utils.getLength(data[index][k][l].value));
													//如果值长度大于限制范围，在下一行同样距离左边的位置继续输出
													if(textlength > Math.ceil(tempArr[i].width * 6.8)){
														//目前行要输出的值
														var subStrCN = utils.subStringCN(data[index][k][l].value,Math.ceil(tempArr[i].width * 6.8)-3);
														let value2 = subStrCN.str;
														//let value2 = data[index][k][l].value.substring(0,Math.ceil(tempArr[i].width * 6.8));
														//下一行要输出的值
														//let value3 = data[index][k][l].value.substring(Math.ceil(tempArr[i].width * 6.8),textlength);
														let value3 = data[index][k][l].value.substring(subStrCN.index+1,textlength);
														var obj = new Object();
														obj.left = tempArr[i].left;
														obj.width = tempArr[i].width;
														obj.value = value3;
														newLineArray.push(obj);

														tempArr[m].neednewline = true;
														
														//子表有可能循环，所以换行输出与主表的不一样
														
														for(var n = m+1; n< tempArr.length; n ++ ){
															if(tempArr[n].top - tempArr[i].top > 0.2){
																tempArr[n].neednewline = true;
																break;
															}
														}
														data[index][k][l].value = value2;
													}
													
													if(m > 0){
														//判断同行,离顶点距离差异小于0.2默认为同一行
														if( tempArr[m].top - tempArr[m-1].top < 0.2 ){ 
															//
															if( l >= 1){
																var dataIndex=l-1;
																if(dataIndex<0)
																   dataIndex=0;
																if( (utils.getLength(data[index][k][dataIndex].value.toString()) *(tempArr[m-1].font > 14 ? 2 : 1)) > Math.ceil(tempArr[m].left * 6.8) ){ 
																	text += getValueFontSizeStr(tempArr[i]);
																	text += data[index][k][l].value;
																}else{ 
																	/*for(var o = 0 ; o < Math.ceil(tempArr[m].left * 6.8) - (utils.getLength(data[index][k][l-1].value) *(tempArr[m-1].font > 14 ? 2 : 1)); o++){ 
																		text += " ";
																	}*/
																	for(var o = 0 ; o < Math.ceil(tempArr[m].left * 6.8) - Math.ceil(tempArr[m-1].left * 6.8) - (utils.getLength(data[index][k][dataIndex].value.toString()) *(tempArr[m-1].font > 14 ? 2 : 1)); o++){  
																		text += " ";
																	}
																	text += getDetailValueFontSizeStr(tempArr[i],tempArr[m].left,tempArr[m].top,k,false,tempArr[m].width,tempArr[m].Alignment,tempArr[m].VertAligment);
																	text += data[index][k][l].value;
																	previousValue=data[index][k][l].value;
																}
															}else{ 
																for( var o = 0 ; o < Math.ceil(tempArr[m].left * 6.8) ; o ++){ 
																	text += " ";
																}
																text += getDetailValueFontSizeStr(tempArr[i],tempArr[m].left,tempArr[m].top,k,false,tempArr[m].width,tempArr[m].Alignment,tempArr[m].VertAligment);
																text += data[index][k][l].value;
																previousValue=data[index][k][l].value;
															}
														
														}else{ 
															//判断出不同行的话，自动换行	
															text += "\n";
															text += getDetailFontSizeStr(tempArr[i+l],k,false);
															for( var n = 0; n < Math.ceil(tempArr[i+l].left * 6.8); n ++ ){ 
																text += " ";
															}
															text += data[index][k][l].value;
															previousValue=data[index][k][l].value;
															break;
														}
													}else{ 
														text += "\n";
														text += getDetailFontSizeStr(tempArr[i+l],k,false);
														for( var n = 0; n < Math.ceil(tempArr[i+l].left * 6.8); n ++ ){ 
															text += " ";
														}
														text += data[index][k][l].value;
														previousValue=data[index][k][l].value;
														break;
													}
												}
											}
										}
									}
								}
								break;
							}
						}
					}else{ 
						//判断是否有上一行长度过长需要换行打印的
						if(tempArr[i].neednewline == true){
							do{
								tempArr[i].neednewline = false;
								for(let j = 0; j < newLineArray.length ; j ++){
									//先换行
									if(j == 0){
										text += '\n';
										for(let k = 0; k < Math.ceil(newLineArray[j].left * 6.8) ;k ++ ){
											text+= ' ';
										}
									}else{
										for(let k = 0; k < Math.ceil(newLineArray[j].left * 6.8) - Math.ceil(newLineArray[j-1].left * 6.8); k++ ){
											text += ' ';
										}
									}
									//如果换行长度还不够打，则需要继续换行，neednewline继续为true
									if(Math.ceil(utils.getLength(newLineArray[j].value)) > Math.ceil(newLineArray[j].width * 6.8)){
										tempArr[i].neednewline = true;
										//目前行要输出的值
										var subStrCN = utils.subStringCN(newLineArray[j].value,Math.ceil(newLineArray[j].width * 6.8)-3);
										let value1 = subStrCN.str;
										//let value1 = newLineArray[j].value.substring(0,Math.ceil(newLineArray[j].width * 6.8));
										//下一行要输出的值
										let value2 = newLineArray[j].value.substring(subStrCN.index,utils.getLength(newLineArray[j].value));
										
										text += getValueFontSizeStr(tempArr[i],true);
										text += value1;
										newLineArray[j].value = value2;
									}else{
										text += getValueFontSizeStr(tempArr[i],true);
										text += newLineArray[j].value;
										newLineArray[j].value = '';
										//newLineArray.splice(0,1);
									}
								}
							}
							while(tempArr[i].neednewline == true)
							newLineArray.splice(0,newLineArray.length);
						}
						//判断同行,离顶点距离差异小于0.2默认为同一行
						if( tempArr[i].top - tempArr[i-1].top < 0.2){
							var font = parseInt(tempArr[i].font);
							if(font > 14){ 
								//text += "\x1b\x21\x30";	
								text += getFontSizeStr(tempArr[i]);		
								for(var j = 0 ; j < Math.ceil(Math.ceil((tempArr[i].left * 6.8) - utils.getLength(tempArr[i-1].text))/2) ; j ++){ 
									text += " ";
								}
							}else{
								//text += "\x1b\x21\x00";
								text += getFontSizeStr(tempArr[i]);
								for(var j = 0 ; j < Math.ceil(tempArr[i].left * 6.8) - utils.getLength(tempArr[i-1].text) ; j ++){ 
									text += " ";
								}
							}
							text += value;
						//不同一行
						}else{ 
							text += "\n";
							for(var j = 0 ; j < Math.ceil(tempArr[i].left * 6.8); j ++ ){ 
								text += " ";
							}
							if(tempArr[i].font > 14){ 
								//text += "\x1b\x21\x30";		
								text += getFontSizeStr(tempArr[i]);	
							}else{ 
								//text += "\x1b\x21\x00";
								text += getFontSizeStr(tempArr[i]);
							}
							text += value;
						}
					}
				}else{ 
					continue;
				}
			}else{ 
				var font = parseInt(tempArr[i].font);
				var left = Math.ceil(tempArr[i].left * 6.8);
				//判断字体大小，并且空行
				if(font > 14){
					//text += "\x1b\x21\x30";
					text += getFontSizeStr(tempArr[i]);	
					for(var j = 0 ; j < Math.ceil(left/2) ; j ++ ) {
						text += " ";
					}
				}else{ 
					//text += "\x1b\x21\x00";
					text += getFontSizeStr(tempArr[i]);	
					for(var j = 0 ; j < left ; j ++ ) {
						text += " ";
					}
				}
				
				
				
				var value = tempArr[i].text;
				if(utils.isContains(value,"{")){ 
					value = value.split("{")[1].split("}")[0].split(".")[1];
					flag1 = 0;
					for(var j = 0 ; j < data.length ; j ++ ){ 
						if(data[j].length == undefined){ 
							if(data[j].name == value ){ 
								text += data[j].value;
								flag1 = 1;
								break;
							}
						}else{ 
	
							for( var k = 0 ; k < data[j].length ; k ++ ){ 
								for(var l = 0 ; l < data[j][k].length; l ++ ){ 
									for( var m = i ; m < tempArr.length ; m ++ ){ 
										
										if(utils.isContains(tempArr[m].text,"{")){ 
											value1 = tempArr[m].text.split("{")[1].split("}")[0].split(".")[2];
											if(value1 == data[j][k][l].name){ 
												tempArr[m].isprint = 1;
												if(m > 0){ 
													//判断同行,离顶点距离差异小于0.2默认为同一行
													if( tempArr[m].top - tempArr[m-1].top < 0.2 ){ 
														if( (utils.getLength(data[j][k][l-1].value) *(tempArr[m-1].font > 14 ? 2 : 1)) > Math.ceil(tempArr[m].left * 6.8) ){ 
															text += getValueFontSizeStr(tempArr[i],false);
															text += data[j][k][l].value;
														}else{ 
															for(var o = 0 ; o < Math.ceil(tempArr[m].left * 6.8) - (utils.getLength(data[j][k][l-1].value) *(tempArr[m-1].font > 14 ? 2 : 1)); o++){ 
																text += " ";
															}
															text += getDetailValueFontSizeStr(tempArr[i],tempArr[m].left,tempArr[m].top,k,false,tempArr[m].width,tempArr[m].Alignment,tempArr[m].VertAligment);
															text += data[j][k][l].value;
														}
													}
												}else{ 
													text += "\n";
													for( var n = 0; n < Math.ceil(tempArr[i].left * 6.8); n ++ ){ 
														text += " ";
													}
													text += getValueFontSizeStr(tempArr[i],false);
													text += data[j][k][l].value;
													break;
												}
	
											}
											
										}
									}
								}
								
							}
						}
					}
				}else{ 
					text += tempArr[i].text;	
				}
				
	
			}
		}

	  //表头最后一行超长处理
     
                    for(let k = 0; k < newLineArray.length ; k ++){
                        //先换行
                        if(k == 0){
                            text += '\n';
                            for(let l = 0; l < Math.ceil(newLineArray[k].left * 6.8) ;l ++ ){
                                text+= ' ';
                            }
                        }else{
                            for(let l = 0; l < Math.ceil(newLineArray[k].left * 6.8) - Math.ceil(newLineArray[k-1].left * 6.8); l++ ){
                                text += ' ';
                            }
                        }
                        
                        if(Math.ceil(utils.getLength(newLineArray[k].value)) > Math.ceil(newLineArray[k].width * 6.8)){
                            //目前行要输出的值
                            var subStrCN = utils.subStringCN(newLineArray[k].value,Math.ceil(newLineArray[k].width * 6.8)-3);
                            let value1 = subStrCN.str;
                            //let value1 = newLineArray[k].value.substring(0,Math.ceil(newLineArray[k].width * 6.8));
							text += value1;
							text += '\n';
							for(let l = 0; l < Math.ceil(newLineArray[k].left * 6.8) ;l ++ ){
								text+= ' ';
							}
							let txt=newLineArray[k].value.replace(value1,'');
							if(Math.ceil(utils.getLength(txt)) > Math.ceil(newLineArray[k].width * 6.8)){
								var subStrCN1 = utils.subStringCN(txt,Math.ceil(newLineArray[k].width * 6.8)-3);
								let value2 = subStrCN1.str;
								text += value2;
								text += '\n';
								for(let l = 0; l < Math.ceil(newLineArray[k].left * 6.8) ;l ++ ){
									text+= ' ';
								}
								text += txt.replace(value2,'');
							}
							else
							{
							text += newLineArray[k].value.replace(value1,'');
							}
                      
                        }else{
                            text += newLineArray[k].value;
                            newLineArray[k].value = '';
                            //newLineArray.splice(0,1);
                        }
                    }
		
		text += "\n";
	var reg = new RegExp( '!0' , "g" )
		var text1 =text.replace( reg , '' );


		var reg1 = new RegExp( '!' , "g" )
		var text2 =text1.replace( reg1 , '' );

		// var reg1 = new RegExp( '\n' , "g" )
      // var text3 =text2.replace( reg1 , '@' );
      var text3 =text2;
//var array=text3.split('@');
var array=text3.split('\n');

var methodValue="FreshWayPrintLine";
if(config.devicetype=="顶尖")
{
	methodValue="AclasPrintLine";
}
else if(config.devicetype=="海信")
{
	methodValue="HisencePrintLine";
}
else if(config.devicetype=="中崎")
{
	methodValue="ZonerichPrintLine";
}
else if(config.devicetype=="寺冈")
{
	methodValue="digitalPrintLine";
}
else if(config.devicetype=="爱普生")
{
	methodValue="EpsonPrintImage";
}
else if(config.devicetype=="滢浦通")
{
	methodValue="winposPrintImage";
}
else if(config.devicetype=="芯烨")
{
	methodValue="xprinterPrintImage";
}
if(config.devicetype=="芯烨")
{
	methodValue="xprinterPrintImage";
	var cDeviceModel=config.cDeviceModel;
	var input = [text3,pagewidth,cDeviceModel];
	var getPrinter = edge.func({
		assemblyFile:dllPath,
		typeName:"print.Print",
		methodName: methodValue
		});
		getPrinter(input,function(err,result)
		{
			console.log(result);
		});
}
if(config.devicetype=="滢浦通")
{
	methodValue="winposPrintImage";
	var input = [text3,pagewidth];
	var getPrinter = edge.func({
		assemblyFile:dllPath,
		typeName:"print.Print",
		methodName: methodValue
		});
		getPrinter(input,function(err,result)
		{
			console.log(result);
		});
}
if(config.devicetype=="爱普生")
{
	if(config.devicetype=="爱普生")
	{
		methodValue="EpsonPrintImage";
		var input = [text3,pagewidth];
		var getPrinter = edge.func({
			assemblyFile:dllPath,
			typeName:"print.Print",
			methodName: methodValue
			});
			getPrinter(input,function(err,result)
			{
				console.log(result);
			 });
	}
}

if(config.devicetype=="海信")
{

	var array=text3.split('$');
	if(array.length==1)
	{
	if(imageContent!="")
	{

		var text4=array[0];
		printImageAndText(imageContent,text4,methodValue);
	}
	else
	{

		var text4=array[0];
	var getPrinter = edge.func({
        assemblyFile:dllPath,
        typeName:"print.Print",
        methodName: methodValue
        });
        getPrinter(text4,function(err,result)
        {
            console.log(result);
		 });
	}
	}
	else
	{

		if(utils.isContains(array[1],"undefined"))
		{

			var text4=array[0]+array[2];
			var getPrinter = edge.func({
				assemblyFile:dllPath,
				typeName:"print.Print",
				methodName: methodValue
				});
				getPrinter(text4,function(err,result)
				{
					console.log(result);
				 });
		}
		else
		{

			printqrcode(array[1],array[0],array[2],"HisencePrintLineAndCode");
		}


	}
}
else if(config.devicetype=="中崎")
{
	methodValue="ZonerichImagePrint";
	var input = [text3,pagewidth];
	var getPrinter = edge.func({
		assemblyFile:dllPath,
		typeName:"print.Print",
		methodName: methodValue
		});
		getPrinter(input,function(err,result)
		{
			console.log(result);
		 });
}
else if(config.devicetype=="托利多")
{
	methodValue="FreshWayPrintImage";
	var input = [text3,pagewidth,supMidOfPrint];
	var getPrinter = edge.func({
		assemblyFile:dllPath,
		typeName:"print.Print",
		methodName: methodValue
		});
		getPrinter(input,function(err,result)
		{
			console.log(result);
		 });
}
else if(config.devicetype=="寺冈")
{
	methodValue="digitalImagePrint";
	var input = [text3,pagewidth,supMidOfPrint];
	var getPrinter = edge.func({
		assemblyFile:dllPath,
		typeName:"print.Print",
		methodName: methodValue
		});
		getPrinter(input,function(err,result)
		{
			console.log(result);
		 });
}
else
{
	var getPrinter = edge.func({
        assemblyFile:dllPath,
        typeName:"print.Print",
        methodName: methodValue
        });
        getPrinter(array,function(err,result)
        {
            console.log(result);
		 });
}

  global.isPrinting=0;
    let response

    response = {
        code: 200,
        message: '打印成功',
        data: null
    };

    resolve(response);
}


function printaipushengqrcode(code,text,tail,methodValue){
   var img = qr.image(code,{size :6});
   
   img.pipe(require('fs').createWriteStream(__dirname +'/Print/qr.png').on('finish', function(){
       
    var input = [text,tail,code,__dirname +'/Print/qr.png'];
    var dllPath=__dirname + '/Print/Print.dll';
       var getPrinter = edge.func({
           assemblyFile:dllPath,
           typeName:"print.Print",
           methodName: methodValue
           });
           getPrinter(input,function(err,result)
           {
               console.log(result);
            });

         }))
   
 };

function printqrcode(code,text,tail,methodValue){
	var img = qr.image(code,{size :6});
	
	img.pipe(require('fs').createWriteStream(__dirname +'/Print/qr.png').on('finish', function(){
		
		var input = [text,tail,code];
		var getPrinter = edge.func({
			assemblyFile:dllPath,
			typeName:"print.Print",
			methodName: methodValue
			});
			getPrinter(input,function(err,result)
			{
				console.log(result);
			 });

		  }))
	
  };

  function printqrcodebmp(code,text,tail,methodValue){
	//var img = qr.image(code,{size :6});
	
	//img.pipe(require('fs').createWriteStream(__dirname +'/Print/qr.bmp').on('finish', function(){
		

		utils.logger(code);
		var input = [text,tail,code,__dirname +'/Print/QR-Code.bmp'];
		var getPrinter = edge.func({
			assemblyFile:dllPath,
			typeName:"print.Print",
			methodName: methodValue
			});
			getPrinter(input,function(err,result)
			{
				console.log(result);
			 });

		//  }))
	
  };


//打印图片和文本
function printImageAndText(img,text,methodValue){
	//img = 'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAIIAAACCAQAAAACieC1QAAAABGdBTUEAALGPC/xhBQAAACBjSFJNAAB6JgAAgIQAAPoAAACA6AAAdTAAAOpgAAA6mAAAF3CculE8AAAAAmJLR0QAAd2KE6QAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAAHdElNRQfhBwMIJAanwQRSAAAEmUlEQVRIS82VT2hcRRzHf7OTMBsLmU0RzSHkxVhIsQiilxyW7KaIij1UqhIkSC7Skoq0J4mw5L0QYVMvrQerBiSIQpr0UC9N8bQv1EsRUcQgKppJLFTw0Em08SV5O+PvN/M2+yoIHn2X9/Yzv9/392d+Mwv2H08M/v2NtWv3E3wt30eSQmjXTuaJGgjt/FqexF2hvfF6nkRQsZPzeQLvLtjLK2GbGICKOfX5RJuk8NCCbZxr5EgHTJjJNxfaJIHj0nx061yOsM6J5spb63kbCMyJXxbbRLNLQ+bDxe9zBDovNt+4PtQmCo6P7T3/41jeBmTz+o2rLXLHKvbYmearj4/ZfU9+JRuxt/ztkt315KZVRXh4e/zsuN32hKHNM/XdT9c+sSp0BDDW4Rd3JtHmVoWIgRB1Du1efm/RxsEBGTy2/fJLizZyJIUK2pzYXb5wxvZKIgkEuhCJew8ced98LDyRCbBHbn/307MGHNFEoL7VdXYsPVr3RKTwYM+90x9c2wOeEfRi6kku9ClGZANYCjC0c+G1c3+CI8oRvnV6Tm56EgMzUF26DU81VMmTDpiGAv/tlaeDeBS8DRJg2z2D4Qy0SAVgRh2+UrlSapEAoGfn7cGwcGATRAW2+UIXOkPYItClOqu1YuRjFUFEwDYvzaVQzLyqAnPCRPeiakuH40/FerBxka/Ckc3nRvXRVl3ORcEh+soI6ALbOPLoFxlBb8AGqQERlXzHsKUwRcoYEbLOV6FMOhKYJ9guJD2qhNWB2y8ceOgnGyK0pwsW83Kkr0CHIYY6HhyQEZIylZ5UXQYk6olVVawEUxRkM0UJRiSGCfGYqSKmKnBXgPbYEYZEUnIRN9DBFFfo11GhIlENSmSBBJCgF1Swg5orHtMiPhEEuJgwLeYABZwNR+kprrD9QhdI2Y1GmWvprYlAiGRUYaGVKCMoPcJ1v5sIiIkI7ATXI8ATRzAmfslZXcN5LAFzBAwSlZI3Ecq7EsmbOqEIRLA+jCqQMOov90RqfmcrccIZYSn/Y19LFCjgptHmgGX7fykSBpmRyqq1G67wIAbj3ltIaK2KxK3w1NqvSbg1mbgH7vYAP73+w90YufnB6xDPPZSKB7OBE2B9CCLOWlq3wrL75641d/HVtO0bKf/8C/n5h6UAlecbGdkd8LFIuXfiIJ/QWldONr0ZiVokzdd1ML2ciG7lbHzKXtrdY9aH8tKVVl2hIxGAzQjz6aoWUV6YpLkniRcmaeGJyWRQOsgq3cgAXbT/vT//K7JuG9dso7n+u71q15sr+zGeMiGMTOUq/m/gAUloPySSRCrLDI7ueYBZT0SMRAKNt3BeWqgQTDeMH3hprqfB9Aurq9haImoWSdov3R+XcWRVT5dqfY7Mko7YWE1GHHFzQTarcVIuTZVdLE9mVVIeHkZy3k0REZ32Dg/XvE0H2cxUa73lJ2p0e2JdRAAccbHqVjgyArWSJy7nbiTFGqSSchZW8LS787MAbw0jrNeZSbqDNMDzaQr73iuCviCVYJjNuiFjGM5IRBnWrdQwFRgRYVsVkUV7sSlMaE9+Zb+05p1m9W9t/7dAjOLrOgAAACV0RVh0ZGF0ZTpjcmVhdGUAMjAxNy0wNy0wM1QwODozNjowNiswMjowMHtwZqwAAAAldEVYdGRhdGU6bW9kaWZ5ADIwMTctMDctMDNUMDg6MzY6MDYrMDI6MDAKLd4QAAAAAElFTkSuQmCC';
	var imgType="png";
	if(img.indexOf("data:image/jpeg;base64") >= 0)
	{
		imgType="jpg";
	}
	else if(img.indexOf("data:image/jpg;base64") >= 0)
	{
		imgType="jpg";
	}
	else if(img.indexOf("data:image/png;base64") >= 0)
	{
		imgType="png";
	}
	else if(img.indexOf("data:image/bmp;base64") >= 0)
	{
		imgType="bmp";
	}
	else if(img.indexOf("data:image/gif;base64") >= 0)
	{
		imgType="gif";
	}

	var base64Data = img.replace(/^data:image\/\w+;base64,/, "");
    var dataBuffer = new Buffer(base64Data, 'base64');
    fs.writeFile(__dirname +"qr."+imgType, dataBuffer, function(err) {
        if(err){
        
        }else{
			
			var getPrinter = edge.func({
				assemblyFile:dllPath,
				typeName:"print.Print",
				methodName: methodValue
				});
				getPrinter(text,function(err,result)
				{
					console.log(result);
				 });



        }
	});

  };


var printtest = function(resolve,json){ 
	var str = "  测试打印成功@";
    var methodValue="FreshWayPrintLine";
	if(json.cDeviceBrand=="顶尖")
	{
		methodValue="AclasPrintLine";
	}
	else if(json.cDeviceBrand=="海信")
	{
		methodValue="HisencePrintLine";
	}
	else if(json.cDeviceBrand=="中崎")
	{
		methodValue="ZonerichPrintLine";
	}
	else if(json.cDeviceBrand=="寺冈")
	{
		methodValue="digitalPrintLine";
	}
	//var array=str.split('@');
    var getPrinter = edge.func({
        assemblyFile:dllPath,
        typeName:"print.Print",
        methodName: methodValue
        });
        getPrinter(str,function(err,result)
        {
            console.log(result);
         });

         
    let response

    response = {
        code: 200,
        message: '打印成功',
        data: null
    };

    resolve(response);
}

module.exports = {
    print_for_temp:  print_for_temp,
    printtest : printtest,
    getWeight:  getWeight,
    match: match,
    clear: clear,
    zeroReset: zeroReset,
    tare: tare,
    close: close,
    save: save,
    digitalTare : digitalTare,
    openCashDrawNoCheck : openCashDrawNoCheck,
	openCashDraw : openCashDraw,
	clearTare : clearTare
}



