﻿const isOnline = require('is-online');
const electron = require('electron')
const regedit = require('regedit')
const scale = require('./renderer.js')
const SandPos = require('./SandPos.js')
const config = require('./config.json')
const scaleconfig = require('./scaleconfig.json')
const macaddress = require('macaddress');
const childProcess = require('child_process');
const os = require('os');
const path = require('path');
const fs = require('fs');
const request = require('request');
const unzip = require('unzipper');
const utils = require('./utils');
const programConfig = require('./program.config.json');
const card = require('./card.js');
const payment = require("./payment.js");
const scan = require('./scan.js');
const electronUpdater = require("electron-updater");
const process = require('process');

const isOpenScan = false;
const isReadingCard = false;

const newWindows = {};
let isUpdatingApp = false;
let isCacheFileSuccess = false;


//截获异常
process.on('uncaughtException', function (err) {

});

process.on('exit', (code) => {

});

const downloadFile = function (vbaseUrl, cachedir, type) {
    let unzipPath = '';
    switch (type) {
        case 'files':
            unzipPath = path.resolve(cachedir, 'app/temp');
            break;
        case 'images':
            unzipPath = path.resolve(cachedir, 'styles/default');
            break;
    }
    if (!unzipPath) return;
    const patchUrl = `${vbaseUrl}/package/downloadFile?type=${type}`;
    const req = request({
        method: 'GET',
        uri: patchUrl
    });
    const filePath = path.join(cachedir, `${type}.zip`);
    const out = fs.createWriteStream(filePath);
    out.on('finish', function () {
        fs.createReadStream(filePath).pipe(unzip.Extract({ path: unzipPath }));
    });
    req.pipe(out);
}
macaddress.one(function (err, mac) {
    global.sharedObj = {
        programConfig: programConfig,
        scaleConfig: scaleconfig,
        config: config,
        macAddress: mac,
        sandPay: SandPos.Sandpay,
        isOpenScan: isOpenScan,
        isReadingCard: isReadingCard
    };
});

// Module to control application life.
const app = electron.app
const shell = electron.shell
const protocol = electron.protocol;
const session = electron.session;
// Module to create native browser window.
const BrowserWindow = electron.BrowserWindow
const ipcMain = electron.ipcMain

const autoUpdater = electronUpdater.autoUpdater;
app.disableHardwareAcceleration(); //禁止硬件渲染，软渲染优先。   19.12.24  yl
// Keep a global reference of the window object, if you don't, the window will
// be closed automatically when the JavaScript object is garbage collected.
let mainWindow
const oskName = `${os.homedir().substr(0, 1)}:/windows/sysnative/osk.exe`;
let baseUrl = 'https://uretail.yonyoucloud.com';
const urlpath = path.resolve(__dirname, '../../../uretailurl');
const txtPath = `${urlpath}/url.txt`;
const configPath = `${urlpath}/config.json`;
const scaleConfigPath = `${urlpath}/scaleconfig.json`;
const app_source = path.resolve(urlpath, 'app_source');
const sougoukb = `${__dirname}/opensougoukb.vbs`;
fs.exists(urlpath, function (exists) {
    if (exists) {
        fs.exists(txtPath, function (existss) {
            if (existss) {
                let fileContent = fs.readFileSync(txtPath, 'utf-8');
                if (fileContent && fileContent.trim().length > 0) {
                    // baseUrl = fileContent;
                    baseUrl = fileContent.endsWith("/") ? fileContent.substring(0, fileContent.length - 1) : fileContent;
                }
            } else {
                fs.writeFileSync(txtPath, '', function (error) { });
            }
        });

        fs.exists(configPath, function (existss) {
            if (existss) {
                global.sharedObj.config = require(configPath)
            }
        });

        fs.exists(scaleConfigPath, function (existss) {
            if (existss) {
                global.sharedObj.scaleConfig = require(scaleConfigPath)
            }
        });
        fs.exists(app_source, function (existss) {
            if (!existss) {
                fs.mkdir(app_source, function (err) { });
            }
        });
    } else {
        fs.mkdir(urlpath, function (err) {
            if (err) {
                return;
            }
            fs.writeFileSync(txtPath, '', function (error) { });
            fs.mkdir(app_source, function (err) { });
        });
    }
});

function createWindow() {
    // Create the browser window.
    mainWindow = new BrowserWindow({
        fullscreen: true,
        webPreferences: {
            // Disable node integration in remote page
            nodeIntegration: true
        }
    })

    const cacheWebContent = function (contents) {
        contents.savePage(`${app_source}/index.html`, 'HTMLComplete', function (error) {
            if (error) {
                sendUpdateMessage({ status: 2, msg: 'save page,' + error })
            } else {
                const appendScript = "<script>const modalMask = document.getElementsByClassName('ant-modal-mask') || [];if (!(_.every(modalMask, mask => !!mask.classList.toString().match('ant-modal-mask-hidden') || !!mask.classList.toString().match('uretail-loading-bg')))) {for(var g=0;g<modalMask.length;g++){modalMask[g].parentElement.remove()}}</script>";
                fs.appendFile(`${app_source}/index.html`, appendScript, (error) => {
                    if (error) console.log(error.message);
                });
                fs.appendFile(`${app_source}/offdata.txt`, '{status:0}', (error) => {
                    if (error) console.log(error.message);
                });
                fs.exists(`${app_source}/PaymentAPI.dll.config`, function (exists) {
                    if (!exists) {//不存在文件时创建默认工银澳门动态库的配置文件
                        fs.appendFile(`${app_source}/PaymentAPI.dll.config`, "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<Configure>\n<SN>192DCA04038219201d</SN>\n<type>2</type>\n<portConfigure>\n<PortName>COM1</PortName>\n<BaudRate>115200</BaudRate>\n</portConfigure>\n<IPConfigure>\n<IP>192.168.0.158</IP>\n<Port>9999</Port>\n</IPConfigure>\n<TimeoutConfigure>\n<ConnectTimeout>5</ConnectTimeout>\n<RecvTimeout>60</RecvTimeout>\n</TimeoutConfigure>\n</Configure>", (error) => {
                            if (error) {
                                console.log(error.message);
                            } else {
                                copyIt(`${app_source}` + '\\PaymentAPI.dll.config', __dirname.split('\\resources')[0] + '\\PaymentAPI.dll.config');
                            }
                        });
                    } else {
                        copyIt(`${app_source}` + '\\PaymentAPI.dll.config', __dirname.split('\\resources')[0] + '\\PaymentAPI.dll.config');
                    }

                });
            }
        });
    }
    /**
     * 从from拷贝文件到to
     * @param {String} from 
     * @param {String} to 
     */
    const copyIt = function (from, to) {
        fs.writeFileSync(to, fs.readFileSync(from));
    }

    const openExternal = function (resolve, url) {
        shell.openExternal(url);
    }

    const openWindow = function (resolve, data) {
        utils.logger('openwindow1: ' + data.url);
        const oldWindow = newWindows[data.menuId];
        if (oldWindow && !oldWindow.isDestroyed()) {
            oldWindow.show();
            resolve();
            return;
        }
        const options = {
            show: false,
            fullscreen: true,
            webPreferences: {
                nodeIntegration: false
            }
        };
        if (parseInt(data.width) && parseInt(data.height)) {
            delete options.fullscreen;
            options.width = parseInt(data.width);
            options.height = parseInt(data.height);
        }
        if (data.needNative === true) {
            options.webPreferences.nodeIntegration = true
        }
        const newWindow = new BrowserWindow(options);
        newWindow.once('ready-to-show', function () {
            utils.logger('openwindow3: ' + data.url);
            newWindow.show();
            resolve();
        });
        newWindow.on('closed', function () {
            delete newWindows[data.menuId];
        });
        utils.logger('openwindow2: ' + data.url);
        newWindow.loadURL(data.url);
        newWindows[data.menuId] = newWindow;
    }

    const closeWindow = function (resolve, menuIds) {
        utils.logger('closewindow1: ' + menuIds.join(','));
        menuIds.forEach(function (menuId) {
            utils.logger('closewindow2: ' + menuIds.join(','));
            const oldWindow = newWindows[menuId];
            if (!oldWindow) return;
            utils.logger('closewindow3: ' + menuIds.join(','));
            oldWindow.close();
        });
    }

    const oskOpen = function () {
        // utils.logger('-----------------读取注册表1--------------');
        try {
            regedit.list(['HKLM\\SOFTWARE\\WOW6432Node\\SogouInput'], function (err, data) {
                if (err) {
                    console.log('err' + err)
                    utils.logger("读取注册表失败");
                    shell.openItem(oskName);
                }
                // for (item in data) {
                //     utils.logger("data[item].values:" + data[item].values + "  ");
                //     for (ii in data[item].values) {
                //         utils.logger("data[item].values.proprety:" + data[item].values[ii].value + "  ")
                //     }
                // }
                if (data) {
                    shell.openItem(sougoukb);
                    return false;
                }
                shell.openItem(oskName);
            })
        } catch (e) {
            console.log(e.message);
        }
    }

    const oskClose = function () {
        try {
            childProcess.execSync('taskkill /IM osk.exe');
        } catch (e) {
            console.log(e.message);
        }
    }

    const open = function (resolve, data) {
        scale.getWeight(function (weightData) {
            mainWindow.webContents.send('electronicBalance-change', weightData)
        })
        resolve()
    }

    const match = function (resolve, data) {
        scale.match(resolve, data, function (weightData) {
            mainWindow.webContents.send('electronicBalance-change', weightData)
        })
    }

    const startGetCardnum = function (resolve, data) {
        card.startGetCardnum(function (data) {
            mainWindow.webContents.send('afterGetCardnumFromDevice', data);
        })
        resolve()
    }

    const stopGetCardnum = function (resolve, data) {
        card.stopGetCardnum();
        resolve();
    }

    const sendPrice = function (resolve, data) {
        payment.sendPrice(data);
    }

    const openScan = function (resolve, data) {
        scan.openScan(function (data) {
            mainWindow.webContents.send('afterGetScan', data);
        })
        resolve()
    }

    const interceptProtocol = function (request, callback) {
        const url = request.url;
        if (url.endsWith('/login')) {
            callback(`${app_source}/index.html`);
        } else if (url.endsWith(".js") || url.endsWith(".css") || url.endsWith(".png") || url.endsWith(".jpg") || url.endsWith(".jpeg")) {
            const turl = new URL(url);
            callback(`${app_source}/${turl.pathname}`);
        } else if (url.endsWith(".map")) {
            callback(`${app_source}/offdata.txt`);//离线返回数据都为status 0
        } else {
            callback(0);
        }
    }

    // 注册的指令事件推入事件集合集中处理
    const orderCollection = {
        openExternal: openExternal,
        openWindow: openWindow,
        closeWindow: closeWindow,
        oskOpen: oskOpen,
        oskClose: oskClose,
        clear: scale.clear,
        match: match,
        zeroReset: scale.zeroReset,
        digitalTare: scale.digitalTare,
        tare: scale.tare,
        close: scale.close,
        save: scale.save,
        print: scale.print,
        showOnSecondaryScreen: scale.showOnSecondaryScreen,
        closeSecondaryScreen: scale.closeSecondaryScreen,
        refreshSecondaryScreen: scale.refreshSecondaryScreen,
        openCashDrawNoCheck: scale.openCashDrawNoCheck,
        openCashDraw: scale.openCashDraw,
        openCashDrawTest: scale.openCashDrawTest,
        printtest: scale.printtest,
        open: open,
        openCard: scale.openCard,
        closeCard: scale.closeCard,
        readCard: scale.readCard,
        writeCard: scale.writeCard,
        printCard: scale.printCard,
        cardCshPrint: scale.cardCshPrint,
        startGetCardnum: startGetCardnum,
        stopGetCardnum: stopGetCardnum,
        sendPrice: sendPrice,
        openScan: openScan,
        readCardWithParam: scale.readCardWithParam
    }
    // 通用指令注册（类似ajax的通信机制）
    ipcMain.on('electronic-order', (event, orderID, order, data) => {
        console.log(`收到指令${order}, 参数为${data}, 开始执行...`)  // prints "ping"
        if (typeof orderCollection[order] === 'function') {
            const p = new Promise(function (resolve) {
                orderCollection[order](resolve, data)
            })
            p.then(function (result) {
                console.log(`指令${order}已经执行, 结果: ${result}`)
                event.sender.send('electronic-order-reply', orderID, result)
            })
        }

    })
    ipcMain.on('open-devtools', () => {
        mainWindow.webContents.openDevTools()
    })
    // scaleconfig['Sandpay'] = SandPos.Sandpay;

    // global.sharedObj = scaleconfig

    // 离线状态下加载本地静态html
    isOnline().then(online => {
        if (!online) {
            protocol.interceptFileProtocol('http', (request, callback) => {
                interceptProtocol(request, callback);
            }, (error) => {
                if (error) sendUpdateMessage({ status: 500, msg: 'failed to register protocal,' + error })
            });

            protocol.interceptFileProtocol('https', (request, callback) => {
                interceptProtocol(request, callback);
            }, (error) => {
                if (error) sendUpdateMessage({ status: 500, msg: 'failed to register protocal,' + error })
            });

        } else {
            mainWindow.webContents.on('did-finish-load', () => {
                if (!isCacheFileSuccess) {
                    isCacheFileSuccess = true;
                    cacheWebContent(mainWindow.webContents);
                    downloadFile(baseUrl, app_source, 'images');
                }
                // downloadFile(baseUrl, 'files');
            });
        }
        mainWindow.loadURL(`${baseUrl}/login`);
        scale.showOnSecondaryScreen(function () { }, `${baseUrl}/billing/second`);
        // mainWindow.loadURL(online ? `${baseUrl}/login` : `file://${__dirname}/BrokenNet/index.html`);
        // scale.showOnSecondaryScreen(function () { }, online ? `${baseUrl}/billing/second` : `file://${__dirname}/BrokenNet/index.html`);
        return;
    })

    //mainWindow.loadURL('http://localhost:3003/portal')
    // mainWindow.loadURL('http://10.6.211.248:3003')
    // Open the DevTools.
    // mainWindow.webContents.openDevTools()
    // Emitted when the window is closed.
    mainWindow.on('closed', function () {
        isUpdatingApp = false;
        // Dereference the window object, usually you would store windows
        // in an array if your app supports multi windows, this is the time
        // when you should delete the corresponding element.
        mainWindow = null
        scale.closeSecondaryScreen(function () { });
    })

    function handleUpdate() {
        const updatePendingPath = path.join(autoUpdater.app.baseCachePath, 'uretail-updater', 'pending');
        delDir(updatePendingPath);
        const returnData = {
            error: { status: -1, msg: '检测更新查询异常' },
            checking: { status: 0, msg: '正在检查应用程序更新' },
            updateAva: { status: 1, msg: '检测到最新版本,是否需要下载？' },
            downloading: { status: 2, msg: '' },
            updateNotAva: { status: -1, msg: '您现在使用的版本为最新版本,无需更新!' },
            downloaded: { status: 3, msg: '最新版本已下载完成，是否安装？' },
        };
        autoUpdater.autoDownload = false;
        autoUpdater.autoInstallOnAppQuit = false;
        //和之前package.json配置的一样
        autoUpdater.setFeedURL('http://resources.yonyoucloud.com/packages');
        //更新错误
        autoUpdater.on('error', function (error) {
            returnData.error.msg = error;
            sendUpdateMessage(returnData.error)
        });
        //检查中
        autoUpdater.on('checking-for-update', function () {
            sendUpdateMessage(returnData.checking)
        });
        //发现新版本
        autoUpdater.on('update-available', function (info) {
            if (isUpdatingApp) {
                return;
            }
            sendUpdateMessage(returnData.updateAva)
        });
        //当前版本为最新版本
        autoUpdater.on('update-not-available', function (info) {
            sendUpdateMessage(returnData.updateNotAva)
        });
        // 更新下载进度事件
        autoUpdater.on('download-progress', function (progressObj) {
            isUpdatingApp = true;
            returnData.downloading.msg = progressObj;
            sendUpdateMessage(returnData.downloading);
        });
        autoUpdater.on('update-downloaded', function (event, releaseNotes, releaseName, releaseDate, updateUrl, quitAndUpdate) {
            isUpdatingApp = false;
            sendUpdateMessage(returnData.downloaded)
            // ipcMain.on('isUpdateNow', (e, arg) => {
            //     autoUpdater.quitAndInstall()
            //     mainWindow.destroy()
            // });
            // mainWindow.webContents.send('isUpdateNow')
        });
    }
    handleUpdate();
    // 通过main进程发送事件给renderer进程，提示更新信息
    function sendUpdateMessage(text) {
        mainWindow.webContents.send('message', text)
    }
    ipcMain.on("checkForUpdate", (event, data) => {
        autoUpdater.checkForUpdates();
    });
    ipcMain.on('downloadUpdate', () => {
        autoUpdater.downloadUpdate()
    })
    ipcMain.on('updateNow', (e, arg) => {
        autoUpdater.quitAndInstall()
        mainWindow.destroy()
    });
    ipcMain.on('renameUpdateFile', (e, data) => {
        const updatePendingPath = path.join(autoUpdater.app.baseCachePath, 'uretail-updater', 'pending');
        delDir(updatePendingPath);
    });
    ipcMain.on('online-status-changed', (event, status) => {
        if (!status) {
            protocol.interceptFileProtocol('http', (request, callback) => {
                interceptProtocol(request, callback);
            }, (error) => {
                if (error) sendUpdateMessage({ status: 500, msg: 'failed to register protocal,' + error })
            });

            protocol.interceptFileProtocol('https', (request, callback) => {
                interceptProtocol(request, callback);
            }, (error) => {
                if (error) sendUpdateMessage({ status: 500, msg: 'failed to register protocal,' + error })
            });
        } else {
            protocol.uninterceptProtocol("http");
            protocol.uninterceptProtocol("https");
        }
    });
}

function delDir(path) {
    return;
    let files = [];
    if (fs.existsSync(path)) {
        files = fs.readdirSync(path);
        files.forEach((file, index) => {
            let curPath = path + "/" + file;
            if (fs.statSync(curPath).isDirectory()) {
                delDir(curPath); //递归删除文件夹
            } else {
                fs.unlinkSync(curPath); //删除文件
            }
        });
        fs.rmdirSync(path);
    }
}

// 控制只能打开一个app实例
// var shouldQuit = app.makeSingleInstance(function (commandLine, workingDirectory) {
//     // Someone tried to run a second instance, we should focus our window.
//     if (mainWindow) {
//         if (mainWindow.isMinimized()) mainWindow.restore();
//         mainWindow.focus();
//     }
// });

// if (shouldQuit) {
//     app.quit();
//     return;
// }

const gotTheLock = app.requestSingleInstanceLock()
if (!gotTheLock) {
    app.quit()
} else {
    app.on('second-instance', (event, commandLine, workingDirectory) => {
        // 当运行第二个实例时,将会聚焦到myWindow这个窗口
        if (mainWindow) {
            if (mainWindow.isMinimized()) mainWindow.restore()
            mainWindow.focus()
        }
    })
}


// This method will be called when Electron has finished
// initialization and is ready to create browser windows.
// Some APIs can only be used after this event occurs.
app.on('ready', createWindow)

// Quit when all windows are closed.
app.on('window-all-closed', function () {
    // On OS X it is common for applications and their menu bar
    // to stay active until the user quits explicitly with Cmd + Q
    app.quit()
    isUpdatingApp = false;
})

app.on('activate', function () {
    // On OS X it's common to re-create a window in the app when the
    // dock icon is clicked and there are no other windows open.
    if (mainWindow === null) {
        createWindow()
    }
})

// In this file you can include the rest of your app's specific main process
// code. You can also put them in separate files and require them here.
