﻿let utils = require("./utils.js");
var config = require('./config.json');
const escpos = require('escpos');
let device  = new escpos.USB('0x'+config.VID,'0x'+config.PID);
const printer = new escpos.Printer(device);
const accounting = require("accounting");
var qr = require('qr-image');
var fs = require('fs');


var formatOptions = {
	symbol: "￥",
	decimal: ".",
	thousand: ",",
	precision: 2,
	format: "%s%v"
};

var formatOptionsWhthoutSymbol = {
	symbol: "",
	decimal: ".",
	thousand: ",",
	precision: 2,
	format: "%s%v"
};

var formatNumOptions = {
	decimal: ".",
	thousand: ",",
	precision: 2,
};

function isContains(str,substr){ 
	return str.indexOf(substr) >= 0;
}

//商品信息打印
function getGoods(orderb,shopinfo){ 
	var text = "";
	formatOptionsWhthoutSymbol.precision = shopinfo.priceBitNum;
	
	for(var i = 0; i < orderb.length ; i ++ ){ 
		

		//商品编码及商品名称,编码长度超过16位时自动换行,不省略，当商品长度超过时省略超过部分
		if(orderb[i].code.toString().length <= 16 ){ 
			text += orderb[i].code.toString();
			for(var j = 0 ; j < 16 - orderb[i].code.toString().length ; j++){ 
				text += " ";
			}
			
			if(utils.getLength(orderb[i].name) > 16 ){ 
				var name = orderb[i].name.toString().slice(0,16 - utils.getnumsOfCN(orderb[i].name.toString().slice(0,16)));
				text += name + "\n";
			}else{ 
				text += orderb[i].name.toString() + "\n";
			}

		}else{ 
			text += orderb[i].code.toString() + "\n";
			if(utils.getLength(orderb[i].name) > 32){ 
				var name = orderb[i].name.toString().slice(0,32 - utils.getnumsOfCN(orderb[i].name.toString().slice(0,32)));
				text += name + "\n";
			}else{ 
				text += orderb[i].name.toString()+ "\n";
			}
			
		}

		//加入商品数量并格式化
		//text += orderb[i].retailnum.toString();
		var formatretail = accounting.formatNumber(orderb[i].retailnum,formatNumOptions);
		text += formatretail;
		for(var j = 0 ; j < 9 - utils.getLength(formatretail) ; j++){ 
			text += " ";
		}
		
		//加入商品单价并格式化
		var formatreprice = accounting.formatMoney(orderb[i].retailprice,formatOptionsWhthoutSymbol);
		text += formatreprice;
		for(var j = 0 ; j < 11 - utils.getLength(formatreprice) ; j++){ 
			text += " ";
		}
		
		//加入商品金额并格式化
		var formatsaprice = accounting.formatMoney(orderb[i].salemoney,formatOptionsWhthoutSymbol);
		text += formatsaprice;
		for(var j = 0 ; j < 12 - utils.getLength(formatsaprice) ; j++){ 
			text += " ";
		}
		//显示折扣率及折扣额
		text += "折扣额";
		for(var j = 0 ; j < 10 ; j++){ 
			text += " ";
		}
		text += ("-" + accounting.formatMoney(orderb[i].discountMoney,formatOptionsWhthoutSymbol) + "\n");			
	}	
	return text;
};
//小票尾部
function gettail(tail){ 
	var text = "";
	for(var i = 0 ; i < tail.length ; i ++ ){ 
		text += tail[i] + "\n";
	}
	return text;	
};
//显示合计及各种支付方式金额
function formattotal(order,gatherb,oddchange){ 
	var text = "合计";
	var formattotal = accounting.formatMoney(order.salemoney,formatOptions);
	for (var i = 0 ; i < 28 - utils.getLength(formattotal) ; i ++){ 
		text += " ";
	}
	text += formattotal;
	for(var i = 0 ; i < gatherb.length ; i ++){ 
		text += gatherb[i].balatypename;
		var formatbalamoney = accounting.formatMoney(gatherb[i].balamoney,formatOptions);
		for(var j = 0; j < 32 - utils.getLength(gatherb[i].balatypename) - utils.getLength(formatbalamoney) ; j++){ 
			text += " ";
		}
		text += formatbalamoney;			
	}
	text += "找零";
	var formatodd = accounting.formatMoney(oddchange,formatOptions);
	for(var i = 0 ; i < 28 - utils.getLength(formatodd) ; i++){ 
		text += " ";
	}
	text += accounting.formatMoney(oddchange,formatOptions);
	return text;
} 

exports.printImage = function(dirname,tail,content){ 
	var dir = dirname;
	try{
		escpos.Image.load(dir,function(image){
			device.open(function(){
				printer
				.align('ct')
				.image(image)
				.font('c')
			    .style('BU')
			    .size(1,1)
				.text(gettail(tail))
				.cut()
				.close(); 
			});
		});
	}catch(e){
		global.isPrinting = 0;
		content.code = 998;
		content.message = "打印失败，请检查打印机是否开启";
	}
		
}
//检查数据是否是undefined
function checkNull(data){
	for(var i = 0; i < data.length; i++ ){
		if(data[i].length != undefined ){
			checkNull(data[i])
		}else{
			if(data[i].value == undefined){
				data[i].value = "";
			}
		}
	}
}



function getFontSizeStr(fontSize)
{
	//该语句目前只是调用了芯烨的打印机放大字体指令
	if(fontSize <16)
	{
		return "\x1d\x21\x00";
	}
	else if(fontSize>=16 && fontSize<=20)
	{
		return "\x1d\x21\x11";
	}
    else if(fontSize>20 && fontSize<=28)
	{
		return "\x1d\x21\x22";
	}
	else if(fontSize==36)
	{
		return "\x1d\x21\x33";
	}
	else if(fontSize==48)
	{
		return "\x1d\x21\x44";
	}
	else if(fontSize==72)
	{
	   return "\x1d\x21\x55";
	}
	else 
	{
		return "\x1d\x21\x00";
	}
	/*if(fontSize <=16)
	{
		return "\x1b\x21\x00";
	}
    else if(fontSize>16 && fontSize>24)
	{
		return "\x1b\x21\x01";
	}
	else
	{
	   return "\x1b\x21\x11";
	}*/
}



exports.print_for_temp = function(dir,tempArr,data,res,Parent){ 
	var text = "";
	
	checkNull(data);
	var newLineArray = new Array();
	var previousValue="";
	var imageContent="";
	try{
		for(var i = 0 ; i < tempArr.length ; i ++ ) { 
			if(tempArr[i].isprint == undefined){ 
				if(tempArr[i].ImageType != undefined){ 
					imageContent=tempArr[i].Image;
					text=text+"@";
					continue;
				}
			}
			if( i > 0){ 
				if(tempArr[i].isprint == undefined){ 
				//	if(tempArr[i].ImageType != undefined){ 
				//		imageContent=tempArr[i].Image;
				//		continue;
				//	}
					var value = tempArr[i].text;
					if(isContains(value,"{")){ 
						//当前不支持没有实体的参数 
						if(value.split("{")[1].split("}")[0].split(".").length == 1){
							if(value=="{当前时间}")
							{
								for(var j = 0 ; j < data.length ; j ++ ){
													if(data[j].name == value.split("{")[1].split("}")[0] ){ 
														text=text+ '\n';
														if(tempArr[i].font > 14){ 
															//text += "\x1b\x21\x30";	
															text += getFontSizeStr(parseInt(tempArr[i].font));		
														}else{ 
															//text += "\x1b\x21\x00";
															text += getFontSizeStr(parseInt(tempArr[i].font));
														}
														text=text+data[j].value;
							
							}
							}
							previousValue="";
							//text=+utils.getNowFormatDate();
							}
							continue;
						}
						
						value = value.split("{")[1].split("}")[0].split(".")[1];
						var flag1 = 0;
						//判断是否有上一行长度过长需要换行打印的
						if(tempArr[i].neednewline == true){
							do{
								tempArr[i].neednewline = false;
								for(let k = 0; k < newLineArray.length ; k ++){
									//先换行
									if(k == 0){
										text += '\n';
										for(let l = 0; l < Math.ceil(newLineArray[k].left * 6.8) ;l ++ ){
											text+= ' ';
										}
									}else{
										for(let l = 0; l < Math.ceil(newLineArray[k].left * 6.8) - Math.ceil(newLineArray[k-1].left * 6.8); l++ ){
											text += ' ';
										}
									}
									
									if(Math.ceil(utils.getLength(newLineArray[k].value)) > Math.ceil(newLineArray[k].width * 6.8)){
										tempArr[i].neednewline = true;
										//目前行要输出的值
										var subStrCN = utils.subStringCN(newLineArray[k].value,Math.ceil(newLineArray[k].width * 6.8));
										let value1 = subStrCN.str;
										//let value1 = newLineArray[k].value.substring(0,Math.ceil(newLineArray[k].width * 6.8));
										//下一行要输出的值
										let value2 = newLineArray[k].value.substring(subStrCN.index,utils.getLength(newLineArray[j].value));
										
										text += value1;
										newLineArray[k].value = value2;
									}else{
										text += newLineArray[k].value;
										newLineArray[k].value = '';
										//newLineArray.splice(0,1);
									}
								}
							}
							while(tempArr[i].neednewline == true)
							newLineArray.splice(0,newLineArray.length);
						}
						for(var j = 0 ; j < data.length ; j ++ ){
							//判断是否是子表
							if(tempArr[i].text.split("{")[1].split("}")[0].split(".").length == 2){ 
								if(data[j].name == value ){ 
									if (tempArr[i].barcodeType) {
										if (!isContains(data[j].value+'', '$')) {
											continue;
										}
										text += '\n';
										text += getFontSizeStr(tempArr[i]);
									}
									else {
										if (isContains(data[j].value+'', '$')) {
											continue;
										}
									}
									var textlength = Math.ceil(utils.getLength(data[j].value));
									if (tempArr[i].barcodeType) {
										//电子发票二维码网址不作处理
									}
									else
									{
									//如果值长度大于限制范围，在下一行同样距离左边的位置继续输出
									if(textlength > Math.ceil(tempArr[i].width * 6.8)){
										//目前行要输出的值
										var subStrCN = utils.subStringCN(data[j].value,Math.ceil(tempArr[i].width * 6.8));
										let value1 = subStrCN.str;
										//let value1 = data[j].value.substring(0,Math.ceil(tempArr[i].width * 6.8));
										//下一行要输出的值
										let value2 = data[j].value.substring(subStrCN.index+1,textlength);
										var obj = new Object();
										obj.left = tempArr[i].left;
										obj.width = tempArr[i].width;
										obj.value = value2;
										newLineArray.push(obj);
										for(var k = i+1; k< tempArr.length; k ++ ){
											if(tempArr[k].top - tempArr[i].top > 0.2){
												tempArr[k].neednewline = true;
												break;
											}
										}
										data[j].value = value1;
									}
								}
									//判断同行,离顶点距离差异小于0.2默认为同一行
									if(tempArr[i].top - tempArr[i-1].top < 0.2){ 
										if(isContains(tempArr[i-1].text,"{")){ 
										if(previousValue=="")
										{
										for( var k = 0; k < Math.ceil(tempArr[i].left * 6.8) - Math.ceil(tempArr[i-1].left * 6.8) -utils.getLength(tempArr[i-1].text) ; k ++){ 
											text += " ";
										}
									   }
									   else
									   {
										for( var k = 0; k < Math.ceil(tempArr[i].left * 6.8) - Math.ceil(tempArr[i-1].left * 6.8) -utils.getLength(previousValue) ; k ++){ 
											text += " ";
										}
									   }
									}
									else
									{
										for( var k = 0; k < Math.ceil(tempArr[i].left * 6.8) - Math.ceil(tempArr[i-1].left * 6.8) -utils.getLength(tempArr[i-1].text) ; k ++){ 
											text += " ";
										}
									}
									   previousValue="";
										text += data[j].value;
										previousValue=data[j].value;
										flag1 = 1;
										break;
									}else{ 
										//设置字体，为标准或者两倍
										if(parseInt(tempArr[i].font ) > 14){ 
											text += "\n";
											//text += "\x1b\x21\x30";	
											text += getFontSizeStr(parseInt(tempArr[i].font));
											for(var k = 0 ; k < Math.ceil(tempArr[i].left * 6.8 / 2); k ++ ){ 
												text += " ";
											}
										}else{ 
											text += "\n";
											//text += "\x1b\x21\x00";
											text += getFontSizeStr(parseInt(tempArr[i].font));
											for(var k = 0 ; k < Math.ceil(tempArr[i].left * 6.8); k ++ ){ 
												text += " ";
											}
										}
									
										
										text += data[j].value;
										flag1 = 1;
										break;
									}
								}
							}else{ 
								value = tempArr[i].text.split("{")[1].split("}")[0].split(".")[2]
								//获取要打印的子表所处的单据数据的位置
								var index = 0;
								var isExits=false;
								for(index ; index < data.length;index ++ ){
									if(data[index].length != undefined && data[index].isPrint == undefined){
                                                                                if(data[index][0]==undefined || data[index][0][0]==undefined)
{
continue;
}
										if(data[index][0][0].name == value){
											isExits=true;
											break;
										}
										
									}
								}
								if(isExits==false)
								{
									//data里面没有对应字段数据信息
									continue;
								}
								//循环子表第k行
								for( var k = 0 ; k < data[index].length ; k ++ ){ 
									//子表循环要打印的列数，从拿到判断到时子表数据的第i行模板数据开始，接下来的子表列循环打印出来，并标志为已打印
									for( var m = i ; m < i + data[index][0].length ; m ++ ){ 
										//
										var value1 = tempArr[m].text.split("{")[1].split("}")[0].split(".")[2];
										//子表具体行的列循环打印
										for(var l = 0 ; l < data[index][k].length; l ++ ){
											if(isContains(tempArr[m].text,"{")){ 
												
												if(value1 == data[index][k][l].name){ 
													//判断是否有上一行长度过长需要换行打印的
													if(tempArr[m].neednewline == true){
														do{
															tempArr[m].neednewline = false;
															for(let k = 0; k < newLineArray.length ; k ++){
																//先换行
																if(k == 0){
																	text += '\n';
																	for(let l = 0; l < Math.ceil(newLineArray[k].left * 6.8) ;l ++ ){
																		text+= ' ';
																	}
																}else{
																	for(let l = 0; l < Math.ceil(newLineArray[k].left * 6.8) - Math.ceil(newLineArray[k-1].left * 6.8); l++ ){
																		text += ' ';
																	}
																}
																
																if(Math.ceil(utils.getLength(newLineArray[k].value)) > Math.ceil(newLineArray[k].width * 6.8)){
																	tempArr[m].neednewline = true;
																	//目前行要输出的值
																	var subStrCN = utils.subStringCN(newLineArray[k].value,Math.ceil(newLineArray[k].width * 6.8));
																	let value1 = subStrCN.str;
																	//let value1 = newLineArray[k].value.substring(0,Math.ceil(newLineArray[k].width * 6.8));
																	//下一行要输出的值 caihw
																	let value2 = newLineArray[k].value.substring(subStrCN.index+1,utils.getLength(newLineArray[j].value));
																	
																	text += value1;
																	newLineArray[k].value = value2;
																}else{
																	text += newLineArray[k].value;
																	newLineArray[k].value = '';
																	//newLineArray.splice(0,1);
																}
															}
														}
														while(tempArr[m].neednewline == true)
														newLineArray.splice(0,newLineArray.length);
													}
													tempArr[m].isprint = 1;
													
													var textlength = Math.ceil(utils.getLength(data[index][k][l].value));
													//如果值长度大于限制范围，在下一行同样距离左边的位置继续输出
													if(textlength > Math.ceil(tempArr[i].width * 6.8)){
														//目前行要输出的值
														var subStrCN = utils.subStringCN(data[index][k][l].value,Math.ceil(tempArr[i].width * 6.8));
														let value2 = subStrCN.str;
														//let value2 = data[index][k][l].value.substring(0,Math.ceil(tempArr[i].width * 6.8));
														//下一行要输出的值
														//let value3 = data[index][k][l].value.substring(Math.ceil(tempArr[i].width * 6.8),textlength);
														let value3 = data[index][k][l].value.substring(subStrCN.index+1,textlength);
														var obj = new Object();
														obj.left = tempArr[i].left;
														obj.width = tempArr[i].width;
														obj.value = value3;
														newLineArray.push(obj);

														tempArr[m].neednewline = true;
														
														//子表有可能循环，所以换行输出与主表的不一样
														
														for(var n = m+1; n< tempArr.length; n ++ ){
															if(tempArr[n].top - tempArr[i].top > 0.2){
																tempArr[n].neednewline = true;
																break;
															}
														}
														data[index][k][l].value = value2;
													}
													
													if(m > 0){
														//判断同行,离顶点距离差异小于0.2默认为同一行
														if( tempArr[m].top - tempArr[m-1].top < 0.2 ){ 
															//
															//if( l >= 1){
																var dataIndex=l-1;
																if(dataIndex<0)
																   dataIndex=0;
																if( (utils.getLength(data[index][k][dataIndex].value.toString()) *(tempArr[m-1].font > 14 ? 2 : 1)) > Math.ceil(tempArr[m].left * 6.8) ){ 
																	text += data[index][k][l].value;
																}else{ 
																	/*for(var o = 0 ; o < Math.ceil(tempArr[m].left * 6.8) - (utils.getLength(data[index][k][l-1].value) *(tempArr[m-1].font > 14 ? 2 : 1)); o++){ 
																		text += " ";
																	}*/
																	for(var o = 0 ; o < Math.ceil(tempArr[m].left * 6.8) - Math.ceil(tempArr[m-1].left * 6.8) - (utils.getLength(data[index][k][dataIndex].value.toString()) *(tempArr[m-1].font > 14 ? 2 : 1)); o++){ 
																		text += " ";
																	}
																	text += data[index][k][l].value;
																	previousValue=data[index][k][l].value;
																}
															/*}else{ 
																for( var o = 0 ; o < Math.ceil(tempArr[m].left * 6.8) ; o ++){ 
																	text += " ";
																}
																text += data[index][k][l].value;
																previousValue=data[index][k][l].value;
															}*/
														
														}else{ 
															//判断出不同行的话，自动换行	
															text += "\n";
															for( var n = 0; n < Math.ceil(tempArr[m].left * 6.8); n ++ ){ 
																text += " ";
															}
															text += getFontSizeStr(parseInt(tempArr[i].font));
															text += data[index][k][l].value;
															previousValue=data[index][k][l].value;
															break;
														}
													}else{ 
														text += "\n";
														for( var n = 0; n < Math.ceil(tempArr[i].left * 6.8); n ++ ){ 
															text += " ";
														}
														text += getFontSizeStr(parseInt(tempArr[i].font));
														text += data[index][k][l].value;
														previousValue=data[index][k][l].value;
														break;
													}
												}
											}
										}
									}
								}
								break;
							}
						}
					}else{ 
						//判断是否有上一行长度过长需要换行打印的
						if(tempArr[i].neednewline == true){
							do{
								tempArr[i].neednewline = false;
								for(let j = 0; j < newLineArray.length ; j ++){
									//先换行
									if(j == 0){
										text += '\n';
										for(let k = 0; k < Math.ceil(newLineArray[j].left * 6.8) ;k ++ ){
											text+= ' ';
										}
									}else{
										for(let k = 0; k < Math.ceil(newLineArray[j].left * 6.8) - Math.ceil(newLineArray[j-1].left * 6.8); k++ ){
											text += ' ';
										}
									}
									//如果换行长度还不够打，则需要继续换行，neednewline继续为true
									if(Math.ceil(utils.getLength(newLineArray[j].value)) > Math.ceil(newLineArray[j].width * 6.8)){
										tempArr[i].neednewline = true;
										//目前行要输出的值
										var subStrCN = utils.subStringCN(newLineArray[j].value,Math.ceil(newLineArray[j].width * 6.8));
										let value1 = subStrCN.str;
										//let value1 = newLineArray[j].value.substring(0,Math.ceil(newLineArray[j].width * 6.8));
										//下一行要输出的值
										let value2 = newLineArray[j].value.substring(subStrCN.index,utils.getLength(newLineArray[j].value));
										
										text += value1;
										newLineArray[j].value = value2;
									}else{
										text += newLineArray[j].value;
										newLineArray[j].value = '';
										//newLineArray.splice(0,1);
									}
								}
							}
							while(tempArr[i].neednewline == true)
							newLineArray.splice(0,newLineArray.length);
						}
						//判断同行,离顶点距离差异小于0.2默认为同一行
						if( tempArr[i].top - tempArr[i-1].top < 0.2){
							
							if(tempArr[i].font != tempArr[i-1].font){ 
								var font = parseInt(tempArr[i].font);
								if(font > 14){ 
									//text += "\x1b\x21\x30";
									text += getFontSizeStr(parseInt(tempArr[i].font));			
									for(var j = 0 ; j < Math.ceil(Math.ceil((tempArr[i].left * 6.8) - utils.getLength(tempArr[i-1].text))/2) ; j ++){ 
										text += " ";
									}
								}else{
									//text += "\x1b\x21\x00";
									text += getFontSizeStr(parseInt(tempArr[i].font));
									for(var j = 0 ; j < Math.ceil(tempArr[i].left * 6.8) - utils.getLength(tempArr[i-1].text) ; j ++){ 
										text += " ";
									}
								}
							}
							/*for(var j = 0 ; j < Math.ceil(tempArr[i].left * 6.8) - utils.getLength(tempArr[i-1].text) ; j ++){ 
								text += " ";
							}*/

						if(isContains(tempArr[i-1].text,"{")){ 
							if(previousValue=="")
							{
								for(var j = 0 ; j < Math.ceil(tempArr[i].left * 6.8) - Math.ceil(tempArr[i-1].left * 6.8) - utils.getLength(tempArr[i-1].text) ; j ++){ 
									text += " ";
								}
							}
							else
							{
						    	for(var j = 0 ; j < Math.ceil(tempArr[i].left * 6.8) - Math.ceil(tempArr[i-1].left * 6.8) - utils.getLength(previousValue) ; j ++){ 
								   text += " ";
							  }
						   }
						   previousValue="";
						}
						else
					    {
							for(var j = 0 ; j < Math.ceil(tempArr[i].left * 6.8) - Math.ceil(tempArr[i-1].left * 6.8) - utils.getLength(tempArr[i-1].text) ; j ++){ 
								text += " ";
						    }
						}
							text += value;
						//不同一行
						}else{ 
							text += "\n";
							if(tempArr[i].font > 14){ 
								//text += "\x1b\x21\x30";	
								text += getFontSizeStr(parseInt(tempArr[i].font));		
							}else{ 
								//text += "\x1b\x21\x00";
								text += getFontSizeStr(parseInt(tempArr[i].font));
							}
							for(var j = 0 ; j < Math.ceil(tempArr[i].left * 6.8); j ++ ){ 
								text += " ";
							}
							text += value;
						}
					}
				}else{ 
					continue;
				}
			}else{ 
				var font = parseInt(tempArr[i].font);
				var left = Math.ceil(tempArr[i].left * 6.8);
				//判断字体大小，并且空行
				if(font > 14){
					//text += "\x1b\x21\x30";
					text += getFontSizeStr(parseInt(tempArr[i].font));
					if(parseInt(tempArr[i].font<=20))
					{
					  for(var j = 0 ; j < Math.ceil(left/2) ; j ++ ) {
						text += " ";
					  }
					}
					else
					{
						for(var j = 0 ; j < Math.ceil(left/4) ; j ++ ) {
							text += " ";
						}
					}
				}else{ 
					//text += "\x1b\x21\x00";
					text += getFontSizeStr(parseInt(tempArr[i].font));
					for(var j = 0 ; j < left ; j ++ ) {
						text += " ";
					}
				}
				
				
				
				var value = tempArr[i].text;
				if(isContains(value,"{")){ 
					value = value.split("{")[1].split("}")[0].split(".")[1];
					flag1 = 0;
					for(var j = 0 ; j < data.length ; j ++ ){ 
						if(data[j].length == undefined){ 
							if(data[j].name == value ){ 
								text += data[j].value;
								flag1 = 1;
								break;
							}
						}else{ 
	
							for( var k = 0 ; k < data[j].length ; k ++ ){ 
								for(var l = 0 ; l < data[j][k].length; l ++ ){ 
									for( var m = i ; m < tempArr.length ; m ++ ){ 
										
										if(isContains(tempArr[m].text,"{")){ 
											value1 = tempArr[m].text.split("{")[1].split("}")[0].split(".")[2];
											if(value1 == data[j][k][l].name){ 
												tempArr[m].isprint = 1;
												if(m > 0){ 
													//判断同行,离顶点距离差异小于0.2默认为同一行
													if( tempArr[m].top - tempArr[m-1].top < 0.2 ){ 
														if( (utils.getLength(data[j][k][l-1].value) *(tempArr[m-1].font > 14 ? 2 : 1)) > Math.ceil(tempArr[m].left * 6.8) ){ 
															text += data[j][k][l].value;
														}else{ 
															for(var o = 0 ; o < Math.ceil(tempArr[m].left * 6.8) - (utils.getLength(data[j][k][l-1].value) *(tempArr[m-1].font > 14 ? 2 : 1)); o++){ 
																text += " ";
															}
															text += data[j][k][l].value;
														}
													}
												}else{ 
													text += "\n";
													for( var n = 0; n < Math.ceil(tempArr[i].left * 6.8); n ++ ){ 
														text += " ";
													}
													text += data[j][k][l].value;
													break;
												}
	
											}
											
										}
									}
								}
								
							}
						}
					}
				}else{ 
					text += tempArr[i].text;	
					if(font>14)
					{
						text += "\n";
					}
				}
				
	
			}
		}
		text += "\n";
		//var image1=getImage(imageContent);
		var array=text.split('$');
		if(array.length==1)
		{
	text=array[0];
   //配置是否自动切纸
 if(config.isCutPaper){
	 if(imageContent!="")
	 {
	    if(isContains(text,"@")){ 
			var arrayImage=text.split('@');
			printImageAndText(imageContent,arrayImage[0],arrayImage[1]);
		}
		else
		{
			printImageAndText(imageContent,text,"");
		}
	 }
	 else
	{
	 device.open(function(){
	  printer
	  .font('a')
	  .align('lt')
	  .style('bu')
	  .size(1, 1)
	  .text(text)
	  .text("")
	  .text("")
	  .align('ct')
	  .font('c')
	  .cut()
		.close();
	 });
   }
}else{
	if(imageContent!="")
	{
		if(isContains(text,"@")){ 
			var arrayImage=text.split('@');
			printImageAndText(imageContent,arrayImage[0],arrayImage[1]);
		}
		else
		{
			printImageAndText(imageContent,text,"");
		}
	}
	else
   {
	device.open(function(){
	  printer
	  .font('a')
	  .align('lt')
	  .style('bu')
	  .size(1, 1)
	  .text(text)
	  .text("")
	  .text("")
		.close();
	});
			 }
			}
		}
	  else
		 {
if(utils.isContains(array[1],"undefined"))
{
	text=array[0];
	var tail=array[2];
//配置是否自动切纸
 if(config.isCutPaper){


	device.open(function(){
	  printer
	  .font('a')
	  .align('lt')
	  .style('bu')
	  .size(1, 1)
	  .text(text)
	  .text(tail)
	  .text("")
	  .text("")
	  .cut()
		.close();
	});
}else{
	device.open(function(){
	  printer
	  .font('a')
	  .align('lt')
	  .style('bu')
	  .size(1, 1)
	  .text(text)
	  .text(tail)
	  .text("")
	  .text("")
		.close();
	});
}
}
else
{
	if(imageContent!="")
	{
	   if(isContains(text,"@")){ 
		   var arrayImage=array[0].split('@');
		  // printImageAndText(imageContent,arrayImage[0],arrayImage[1]);

              printImageAndTextAndCode(array[1],imageContent,arrayImage[0],arrayImage[1],array[2]);
	
	   }
	   else
	   {
		   printImageAndText(imageContent,text,"");
	   }
	}
	else
	{
       printqrcode(array[1],array[0],array[2]);
	}
}
		}
		setTimeout(function(){global.isPrinting = 0;},5000)
		//global.isPrinting = 0;
		let content= {
			code:200,
			message: "打印成功!"
		 };
	 res(content);
	}catch(e){
		global.isPrinting = 0;
		let content= {
			code:999,
			message: "打印失败，打印机未启动或打印驱动未安装"
	    };
		res(content);
	}
/*	device.open(function(){
		  printer
		  .font('a')
		  .align('ct')
		  .style('bu')
		  .size(1, 1)
		  .text(text)
	 	  .qrimage('12345677', function(err){
		     this.cut();
		     this.close();
		  });	
	});*/

}



exports.print_for_refund = function(dir,order,orderb,gatherb,shopinfo,oddchange){ 
	var shopinfo = JSON.parse(shopinfo);
  	var order = JSON.parse(order);
  	var orderb = JSON.parse(orderb);
 	var gatherb = JSON.parse(gatherb);
	  
	  //确认价格的精度
  	formatOptions.precision = shopinfo.moneyBitNum;
  	var oddchange = JSON.parse(oddchange);
  	escpos.Image.load(dir,function(image){
  		device.open(function(){
		   printer
		  .align('ct')
		  .image(image)
		  .font('c')
		  .style('BU')
		  .size(1,1)
		  .text(shopinfo.shopName) 
		  .text("销售退货单")
		  .size(1,1)
		  .font('a')
		  .align('lt')
		  .style('NORMAL')
		  .text("日期 : " + utils.getNowFormatDate())	
		  .text("收银员 : " + shopinfo.currentSellerName)
		  .text("--------------------------------")
		  .text("数量     单价      金额         ")
		  .text("--------------------------------")
		  .text(getGoods(orderb,shopinfo))
		  .text("--------------------------------")
		  .text(formattotal(order,gatherb,oddchange))
		  .text("--------------------------------")
		  .text("请保留此单据，作为退、换货凭证  ")	
		  .text("若开发票三个月内有效            ")
		  .text("            谢谢惠顾            ")	
		  .cut()	
		  .cashdraw()
		  .cut()
		  .close(); 
  		});
	
	});
}

exports.openCashDraw = function(dir,resolve,content){ 
		try{
			device.open(function(){
				  printer
				  .style('bu')
				  .cashdraw()
				  .font('a')
					.close();
			});
			/*device.open(function(){
			  printer.cashdraw()
			});*/
		}catch(e){
			global.isPrinting = 0;
			 content= {
				   code:999,
				   message: "钱箱设备未连接，或者打印驱动未安装"
				};
		}
		if(content == undefined){
			content= {
				   code:200,
				   message: "开箱成功"
				};
		}
		resolve(content);	
	
	}

exports.openCashDrawNew = function(){ 
	var content="";
	try{
		device.open(function(){
			printer
			.style('bu')
			.cashdraw()
			.font('a')
                        .close();
	  });

		/*device.open(function(){
			  printer
			  .style('bu')
			  .cashdraw()
			  .font('a')
	  		  .close();
		});*/
		/*device.open(function(){
		  printer.cashdraw(5)
		});*/
	}catch(e){
		global.isPrinting = 0;
		content = {
		  	code:998,
		    message: "钱箱设备未连接，或者打印驱动未安装"
		};
	}
	if(content == undefined){
		content = {
		  	code:200,
		    message: "开箱成功"
		};
	}

}


exports.openCashDraw1 = function(dir,res,content){ 
	device.open(function(){
	  printer
	  .font('a')
	  .align('ct')
	  .style('bu')
	  .size(1, 1)
	  .close();
	});
	/*escpos.Image.load(dir,function(image){
	  device.open(function(){
	   printer
	  .cashdraw()
	  .cut()
	  .close(); 
	  });
	});*/
	if(content == undefined){
		content = {
		  	code:200,
		    message: "开箱成功"
		};
	}
	res.send(content);	
}

const close = function(){
	console.log('usb----close')
}

exports.print = function(dir,order,orderb,gatherb,shopinfo,oddchange){
  var shopinfo = JSON.parse(shopinfo);
  var order = JSON.parse(order);
  var orderb = JSON.parse(orderb);
  var gatherb = JSON.parse(gatherb);
  //确认价格的精度
  formatOptions.precision = shopinfo.moneyBitNum;
  var oddchange = JSON.parse(oddchange);
  escpos.Image.load(dir,function(image){
  device.open(function(){
   printer
  .align('ct')
  .image(image)
  .font('c')
  .style('BU')
  .size(1,1)
  .text(shopinfo.shopName) 
  .size(1,1)
  .font('a')
  .align('lt')
  .style('NORMAL')
  .text("日期 : " + utils.getNowFormatDate())	
  .text("收银员 : " + shopinfo.currentSellerName)
  .text("--------------------------------")
  .text("数量     单价      金额         ")
  .text("--------------------------------")
  .text(getGoods(orderb,shopinfo))
  .text("--------------------------------")
  .text(formattotal(order,gatherb,oddchange))
  .text("--------------------------------")
  .text("请保留此单据，作为退、换货凭证  ")	
  .text("若开发票三个月内有效            ")
  .text("            谢谢惠顾            ")	
  .cut()	
  .cashdraw()
  .cut()
  .close(this.close()); 
  });
});
};
exports.print11 = function(dir,res,content){
  
  device.open(function(){
	  printer
	  .font('a')
	  .align('ct')
	  .text("日期 : ")	
	  .text("收银员 : ")
	  .text("请保留此单据，作为退、换货凭证  ")	
  	  .text("若开发票三个月内有效            ")
  	  .text("            谢谢惠顾            ")	
	  .style('bu')
	  .size(1, 1)
	  .text("")	
	  .text("")	
	  .text("")	
	  .cashdraw()
	  .text("")	
	  .close();
	});
  	if(content == undefined){
		content = {
		  	code:200,
		    message: "开箱成功"
		};
	}
	res.send(content);	
};
exports.print22 = function(){
	device.open(function(){
		printer
		.font('a')
		.align('ct')
		.text("日期 : ")	
		.text("收银员 : ")
		.text("请保留此单据，作为退、换货凭证  ")	
		  .text("若开发票三个月内有效            ")
		  .text("            谢谢惠顾            ")	
		.style('bu')
		.size(1, 1)
		.text("")	
		.text("")	
		.text("")	
		.cashdraw()
		.text("")	
		.close();
	  });
  };

  exports.print33 = function(){
	escpos.Image.load(function(image){
	device.open(function(){
		printer
		.font('a')
		.image(image)
		.align('ct')
		.text("日期 : ")	
		.text("收银员 : ")
		.text("请保留此单据，作为退、换货凭证  ")	
		  .text("若开发票三个月内有效            ")
		  .text("            谢谢惠顾            ")	
		.style('bu')
		.size(1, 1)
		.text("")	
		.text("")	
		.text("")	
		.cashdraw()
		.text("")	
		.close();
	  });
	});
  };

  exports.print33 = function(){
	escpos.Image.load(function(image){
	device.open(function(){
		printer
		.font('a')
		.image(image)
		.align('ct')
		.text("日期 : ")	
		.text("收银员 : ")
		.text("请保留此单据，作为退、换货凭证  ")	
		  .text("若开发票三个月内有效            ")
		  .text("            谢谢惠顾            ")	
		.style('bu')
		.size(1, 1)
		.text("")	
		.text("")	
		.text("")	
		.cashdraw()
		.text("")	
		.close();
	  });
	});
  };

  exports.print44= function(text){
	device.open(function(){
		printer
		.font('a')
		.align('lt')
		.style('bu')
		.size(1, 1)
		.text(text)
		.text("")
		.close();
	  });
  };

  exports.print55= function(text){
	device.open(function(){
		printer
		.font('a')
		.align('lt')
		.style('bu')
		.size(1, 1)
		.text(text)
		.text("")
		.cut()
		.close();
	  });
  };

  function printImageAndTextAndCode(code,img,text,text1,tail){
	//img = 'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAIIAAACCAQAAAACieC1QAAAABGdBTUEAALGPC/xhBQAAACBjSFJNAAB6JgAAgIQAAPoAAACA6AAAdTAAAOpgAAA6mAAAF3CculE8AAAAAmJLR0QAAd2KE6QAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAAHdElNRQfhBwMIJAanwQRSAAAEmUlEQVRIS82VT2hcRRzHf7OTMBsLmU0RzSHkxVhIsQiilxyW7KaIij1UqhIkSC7Skoq0J4mw5L0QYVMvrQerBiSIQpr0UC9N8bQv1EsRUcQgKppJLFTw0Em08SV5O+PvN/M2+yoIHn2X9/Yzv9/392d+Mwv2H08M/v2NtWv3E3wt30eSQmjXTuaJGgjt/FqexF2hvfF6nkRQsZPzeQLvLtjLK2GbGICKOfX5RJuk8NCCbZxr5EgHTJjJNxfaJIHj0nx061yOsM6J5spb63kbCMyJXxbbRLNLQ+bDxe9zBDovNt+4PtQmCo6P7T3/41jeBmTz+o2rLXLHKvbYmearj4/ZfU9+JRuxt/ztkt315KZVRXh4e/zsuN32hKHNM/XdT9c+sSp0BDDW4Rd3JtHmVoWIgRB1Du1efm/RxsEBGTy2/fJLizZyJIUK2pzYXb5wxvZKIgkEuhCJew8ced98LDyRCbBHbn/307MGHNFEoL7VdXYsPVr3RKTwYM+90x9c2wOeEfRi6kku9ClGZANYCjC0c+G1c3+CI8oRvnV6Tm56EgMzUF26DU81VMmTDpiGAv/tlaeDeBS8DRJg2z2D4Qy0SAVgRh2+UrlSapEAoGfn7cGwcGATRAW2+UIXOkPYItClOqu1YuRjFUFEwDYvzaVQzLyqAnPCRPeiakuH40/FerBxka/Ckc3nRvXRVl3ORcEh+soI6ALbOPLoFxlBb8AGqQERlXzHsKUwRcoYEbLOV6FMOhKYJ9guJD2qhNWB2y8ceOgnGyK0pwsW83Kkr0CHIYY6HhyQEZIylZ5UXQYk6olVVawEUxRkM0UJRiSGCfGYqSKmKnBXgPbYEYZEUnIRN9DBFFfo11GhIlENSmSBBJCgF1Swg5orHtMiPhEEuJgwLeYABZwNR+kprrD9QhdI2Y1GmWvprYlAiGRUYaGVKCMoPcJ1v5sIiIkI7ATXI8ATRzAmfslZXcN5LAFzBAwSlZI3Ecq7EsmbOqEIRLA+jCqQMOov90RqfmcrccIZYSn/Y19LFCjgptHmgGX7fykSBpmRyqq1G67wIAbj3ltIaK2KxK3w1NqvSbg1mbgH7vYAP73+w90YufnB6xDPPZSKB7OBE2B9CCLOWlq3wrL75641d/HVtO0bKf/8C/n5h6UAlecbGdkd8LFIuXfiIJ/QWldONr0ZiVokzdd1ML2ciG7lbHzKXtrdY9aH8tKVVl2hIxGAzQjz6aoWUV6YpLkniRcmaeGJyWRQOsgq3cgAXbT/vT//K7JuG9dso7n+u71q15sr+zGeMiGMTOUq/m/gAUloPySSRCrLDI7ueYBZT0SMRAKNt3BeWqgQTDeMH3hprqfB9Aurq9haImoWSdov3R+XcWRVT5dqfY7Mko7YWE1GHHFzQTarcVIuTZVdLE9mVVIeHkZy3k0REZ32Dg/XvE0H2cxUa73lJ2p0e2JdRAAccbHqVjgyArWSJy7nbiTFGqSSchZW8LS787MAbw0jrNeZSbqDNMDzaQr73iuCviCVYJjNuiFjGM5IRBnWrdQwFRgRYVsVkUV7sSlMaE9+Zb+05p1m9W9t/7dAjOLrOgAAACV0RVh0ZGF0ZTpjcmVhdGUAMjAxNy0wNy0wM1QwODozNjowNiswMjowMHtwZqwAAAAldEVYdGRhdGU6bW9kaWZ5ADIwMTctMDctMDNUMDg6MzY6MDYrMDI6MDAKLd4QAAAAAElFTkSuQmCC';
	var imgType="png";
	if(img.indexOf("data:image/jpeg;base64") >= 0)
	{
		imgType="jpg";
	}
	else if(img.indexOf("data:image/jpg;base64") >= 0)
	{
		imgType="jpg";
	}
	else if(img.indexOf("data:image/png;base64") >= 0)
	{
		imgType="png";
	}
	else if(img.indexOf("data:image/bmp;base64") >= 0)
	{
		imgType="bmp";
	}
	else if(img.indexOf("data:image/gif;base64") >= 0)
	{
		imgType="gif";
	}

	var base64Data = img.replace(/^data:image\/\w+;base64,/, "");
    var dataBuffer = new Buffer(base64Data, 'base64');
    fs.writeFile(__dirname +"qr1."+imgType, dataBuffer, function(err) {
        if(err){
          //res.send(err);
        }else{
			//printImageNew2(__dirname +'qr.'+imgType,text,tail);

			var img = qr.image(code,{size :6});
			
			img.pipe(require('fs').createWriteStream(__dirname +'qr.png').on('finish', function(){
				 //let printer1 = require('./printer1.js');
				 // printer1.printImageNew(__dirname +'qr.png',config.tail);
				 printImageNew3(__dirname +'qr1.png',__dirname +'qr.'+imgType,text,text1,tail);
				  }))
        }
	});

  };

  function printImageNew3(dirname,dirname1,text,text1,tail){ 
	var dir = dirname;
	try{
		//配置是否自动切纸
 if(  global.isCashBox==0){
		escpos.Image.load(dir,function(image){
			device.open(function(){
				printer
                                 .cashdraw()
				.font('a')
				.align('lt')	
				.style('bu')
				.size(1, 1)
				.text(text)
				.text("")
				.align('ct')
				.font('c')
				.image(image)
				.close(); 
			});
		});
		setTimeout(function(){
		escpos.Image.load(dirname1,function(image1){
			device.open(function(){
				printer
				.font('a')
				.align('lt')
				.style('bu')
				.size(1, 1)
				.text(text1)
				.text("")
				.align('ct')
				.font('c')
				.image(image1)
				.font('a')
				.align('lt')
				.style('bu')
				.size(1, 1)
				.text("")
				.text(tail)
				.cut()
                                .style('bu')
				.font('a')
				.close(); 
			});
		});
	   },1000)
	}
	else
	{
		escpos.Image.load(dir,function(image){
			device.open(function(){
				printer
                                .cashdraw()
				.font('a')
				.align('lt')
				.style('bu')
				.size(1, 1)
				.text(text)
				.text("")
				.align('ct')
				.font('c')
				.image(image)
				.close(); 
			});
		});
		setTimeout(function(){
			escpos.Image.load(dirname1,function(image){
				device.open(function(){
					printer
					.font('a')
					.align('lt')
					.style('bu')
					.size(1, 1)
					.text(text1)
					.text("")
					.align('ct')
					.font('c')
					.image(image)
					.font('a')
					.align('lt')
					.style('bu')
					.size(1, 1)
					.text("")
					.text(tail)
                                        .cut()
                                        .style('bu')
				        .font('a')
					.close(); 
				});
			});
		   },1000)
	}
	}catch(e){
		global.isPrinting = 0;
	}
		
}


//打印图片和文本
function printImageAndText(img,text,tail){
	//img = 'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAIIAAACCAQAAAACieC1QAAAABGdBTUEAALGPC/xhBQAAACBjSFJNAAB6JgAAgIQAAPoAAACA6AAAdTAAAOpgAAA6mAAAF3CculE8AAAAAmJLR0QAAd2KE6QAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAAHdElNRQfhBwMIJAanwQRSAAAEmUlEQVRIS82VT2hcRRzHf7OTMBsLmU0RzSHkxVhIsQiilxyW7KaIij1UqhIkSC7Skoq0J4mw5L0QYVMvrQerBiSIQpr0UC9N8bQv1EsRUcQgKppJLFTw0Em08SV5O+PvN/M2+yoIHn2X9/Yzv9/392d+Mwv2H08M/v2NtWv3E3wt30eSQmjXTuaJGgjt/FqexF2hvfF6nkRQsZPzeQLvLtjLK2GbGICKOfX5RJuk8NCCbZxr5EgHTJjJNxfaJIHj0nx061yOsM6J5spb63kbCMyJXxbbRLNLQ+bDxe9zBDovNt+4PtQmCo6P7T3/41jeBmTz+o2rLXLHKvbYmearj4/ZfU9+JRuxt/ztkt315KZVRXh4e/zsuN32hKHNM/XdT9c+sSp0BDDW4Rd3JtHmVoWIgRB1Du1efm/RxsEBGTy2/fJLizZyJIUK2pzYXb5wxvZKIgkEuhCJew8ced98LDyRCbBHbn/307MGHNFEoL7VdXYsPVr3RKTwYM+90x9c2wOeEfRi6kku9ClGZANYCjC0c+G1c3+CI8oRvnV6Tm56EgMzUF26DU81VMmTDpiGAv/tlaeDeBS8DRJg2z2D4Qy0SAVgRh2+UrlSapEAoGfn7cGwcGATRAW2+UIXOkPYItClOqu1YuRjFUFEwDYvzaVQzLyqAnPCRPeiakuH40/FerBxka/Ckc3nRvXRVl3ORcEh+soI6ALbOPLoFxlBb8AGqQERlXzHsKUwRcoYEbLOV6FMOhKYJ9guJD2qhNWB2y8ceOgnGyK0pwsW83Kkr0CHIYY6HhyQEZIylZ5UXQYk6olVVawEUxRkM0UJRiSGCfGYqSKmKnBXgPbYEYZEUnIRN9DBFFfo11GhIlENSmSBBJCgF1Swg5orHtMiPhEEuJgwLeYABZwNR+kprrD9QhdI2Y1GmWvprYlAiGRUYaGVKCMoPcJ1v5sIiIkI7ATXI8ATRzAmfslZXcN5LAFzBAwSlZI3Ecq7EsmbOqEIRLA+jCqQMOov90RqfmcrccIZYSn/Y19LFCjgptHmgGX7fykSBpmRyqq1G67wIAbj3ltIaK2KxK3w1NqvSbg1mbgH7vYAP73+w90YufnB6xDPPZSKB7OBE2B9CCLOWlq3wrL75641d/HVtO0bKf/8C/n5h6UAlecbGdkd8LFIuXfiIJ/QWldONr0ZiVokzdd1ML2ciG7lbHzKXtrdY9aH8tKVVl2hIxGAzQjz6aoWUV6YpLkniRcmaeGJyWRQOsgq3cgAXbT/vT//K7JuG9dso7n+u71q15sr+zGeMiGMTOUq/m/gAUloPySSRCrLDI7ueYBZT0SMRAKNt3BeWqgQTDeMH3hprqfB9Aurq9haImoWSdov3R+XcWRVT5dqfY7Mko7YWE1GHHFzQTarcVIuTZVdLE9mVVIeHkZy3k0REZ32Dg/XvE0H2cxUa73lJ2p0e2JdRAAccbHqVjgyArWSJy7nbiTFGqSSchZW8LS787MAbw0jrNeZSbqDNMDzaQr73iuCviCVYJjNuiFjGM5IRBnWrdQwFRgRYVsVkUV7sSlMaE9+Zb+05p1m9W9t/7dAjOLrOgAAACV0RVh0ZGF0ZTpjcmVhdGUAMjAxNy0wNy0wM1QwODozNjowNiswMjowMHtwZqwAAAAldEVYdGRhdGU6bW9kaWZ5ADIwMTctMDctMDNUMDg6MzY6MDYrMDI6MDAKLd4QAAAAAElFTkSuQmCC';
	var imgType="png";
	if(img.indexOf("data:image/jpeg;base64") >= 0)
	{
		imgType="jpg";
	}
	else if(img.indexOf("data:image/jpg;base64") >= 0)
	{
		imgType="jpg";
	}
	else if(img.indexOf("data:image/png;base64") >= 0)
	{
		imgType="png";
	}
	else if(img.indexOf("data:image/bmp;base64") >= 0)
	{
		imgType="bmp";
	}
	else if(img.indexOf("data:image/gif;base64") >= 0)
	{
		imgType="gif";
	}

	var base64Data = img.replace(/^data:image\/\w+;base64,/, "");
    var dataBuffer = new Buffer(base64Data, 'base64');
    fs.writeFile(__dirname +"qr."+imgType, dataBuffer, function(err) {
        if(err){
          //res.send(err);
        }else{
			printImageNew2(__dirname +'qr.'+imgType,text,tail);
        }
	});

  };

//打印二维码
  function printqrcode(code,text,tail){
	var img = qr.image(code,{size :6});
	
	img.pipe(require('fs').createWriteStream(__dirname +'qr.bmp').on('finish', function(){
		 //let printer1 = require('./printer1.js');
		 // printer1.printImageNew(__dirname +'qr.png',config.tail);
		 printImageNew2(__dirname +'qr.png',text,tail);
		  }))
	
  };

function printImageNew2(dirname,text,tail){ 
	var dir = dirname;
	try{
		//配置是否自动切纸
 if(config.isCutPaper){
		escpos.Image.load(dir,function(image){
			device.open(function(){
				printer
				.font('a')
				.align('lt')
				.style('bu')
				.size(1, 1)
				.text(text)
				.text("")
				.align('ct')
				.font('c')
				.image(image)
				.font('a')
				.align('lt')
				.style('bu')
				.size(1, 1)
				.text("")
				.text(tail)
				.cut()
				.close(); 
			});
		});
	}
	else
	{
		escpos.Image.load(dir,function(image){
			device.open(function(){
				printer
				.font('a')
				.align('lt')
				.style('bu')
				.size(1, 1)
				.text(text)
				.text("")
				.text("")
				.align('ct')
				.font('c')
				.image(image)
				.align('lt')
				.style('bu')
				.text(tail)
				.close(); 
			});
		});
	}
	}catch(e){
		global.isPrinting = 0;
	}
		
}

exports.printImageNew = function(dirname){ 
	var dir = dirname;
	try{
		escpos.Image.load(dir,function(image){
			device.open(function(){
				printer
				.align('ct')
				.image(image)
				.font('c')
			    .style('BU')
			    .size(1,1)
				.cut()
				.close(); 
			});
		});
	}catch(e){
		global.isPrinting = 0;
	}
		
}