﻿var scaleconfig = require('./scaleconfig.json');
let utils = require("./utils.js");
var edge = require('electron-edge-js');
var dllPath = __dirname + '/Print/Print.dll';
//const config = require('./config.json');
var qr = require('qr-image');
var fs = require('fs');

var config ;
const path = require('path');
const urlpath = path.resolve(__dirname, '../../../uretailurl');
const configPath = `${urlpath}/config.json`;
fs.exists(urlpath, function (exists) {
       fs.exists(configPath, function (existss) {
           if (existss) {
            config = require(configPath)
           }
       });
});

function getFontSizeStr(temp) {
    let content = new Object();
    //content.fontSize = temp.font;
    if (temp.font < 16) {
        content.fontSize = 1;
    }
    else if (temp.font >= 16 && temp.font <= 20) {
        content.fontSize = 2;
    }
    else if (temp.font > 20 && temp.font <= 28) {
        content.fontSize = 3;
    }
    else if (temp.font == 36) {
        content.fontSize = 4;
    }
    else if (temp.font == 48) {
        content.fontSize = 5;
    }
    else if (temp.font == 72) {
        content.fontSize = 6;
    }
    else {
        content.fontSize = 1;
    }
    content.top = temp.top;
    // content.width = temp.width;
    //content.height = temp.height;
    if (temp.left) {
        content.left = temp.left;
    }
    //  if(temp.Alignment)
    // {
    //     content.Alignment = temp.Alignment;
    // }
    if (temp.ImageType) {
        content.printtype = "image";
    }
    else if (temp.barcodeType) {
        content.printtype = "barcode";
        content.width = temp.width;
        content.height = temp.height;
    }
    else {
        content.printtype = "text";
    }
    return "!" + JSON.stringify(content) + "^";
}


function getDetailValueFontSizeStr(temp, left) {
    let content = new Object();
    //content.fontSize = temp.font;
    if (temp.font < 16) {
        content.fontSize = 1;
    }
    else if (temp.font >= 16 && temp.font <= 20) {
        content.fontSize = 2;
    }
    else if (temp.font > 20 && temp.font <= 28) {
        content.fontSize = 3;
    }
    else if (temp.font == 36) {
        content.fontSize = 4;
    }
    else if (temp.font == 48) {
        content.fontSize = 5;
    }
    else if (temp.font == 72) {
        content.fontSize = 6;
    }
    else {
        content.fontSize = 1;
    }
    content.top = temp.top;
    content.left = left;
    // content.width = temp.width;
    //content.height = temp.height;
    // if(temp.Alignment)
    //{
    //     content.Alignment = temp.Alignment;
    // }
    if (temp.ImageType) {
        content.printtype = "image";
    }
    else if (temp.barcodeType) {
        content.printtype = "barcode";
        content.width = temp.width;
        content.height = temp.height;
    }
    else {
        content.printtype = "text";
    }
    return "!" + JSON.stringify(content) + "^";
}



function isContains(str, substr) {
    return str.indexOf(substr) >= 0;
}

var print_for_temp = function (dir, tempArr, data, resolve,Parent) {

    var text = "";

    utils.checkNull(data);
    var newLineArray = new Array();
    var previousValue = "";
    var imageContent = "";

    for (var i = 0; i < tempArr.length; i++) {
        if (i > 0) {
            if (tempArr[i].isprint == undefined) {
                if (tempArr[i].ImageType != undefined) {
                    // imageContent = tempArr[i].Image;
                    text += '\n';
                    text += getFontSizeStr(tempArr[i]);
                    var base64Data = tempArr[i].Image.replace(/^data:image\/\w+;base64,/, "");
                    text = text + base64Data;
                    continue;
                }
                var value = tempArr[i].text;
                if (utils.isContains(value, "{")) {
                    //当前不支持没有实体的参数 
                    if (value.split("{")[1].split("}")[0].split(".").length == 1) {

                        if (value == "{当前时间}") {

                            for (let k = 0; k < newLineArray.length; k++) {
                                //先换行
                                if (k == 0) {
                                    text += '\n';
                                    for (let l = 0; l < Math.ceil(newLineArray[k].left * 6.8); l++) {
                                        text += ' ';
                                    }
                                } else {
                                    for (let l = 0; l < Math.ceil(newLineArray[k].left * 6.8) - Math.ceil(newLineArray[k - 1].left * 6.8); l++) {
                                        text += ' ';
                                    }
                                }

                                if (Math.ceil(utils.getLength(newLineArray[k].value)) > Math.ceil(newLineArray[k].width * 6.8)) {
                                    //目前行要输出的值
                                    var subStrCN = utils.subStringCN(newLineArray[k].value, Math.ceil(newLineArray[k].width * 6.8));
                                    let value1 = subStrCN.str;
                                    //let value1 = newLineArray[k].value.substring(0,Math.ceil(newLineArray[k].width * 6.8));
                                    text += value1;
                                    text += '\n';
                                    for (let l = 0; l < Math.ceil(newLineArray[k].left * 6.8); l++) {
                                        text += ' ';
                                    }
                                    let txt = newLineArray[k].value.replace(value1, '');
                                    if (Math.ceil(utils.getLength(txt)) > Math.ceil(newLineArray[k].width * 6.8)) {
                                        var subStrCN1 = utils.subStringCN(txt, Math.ceil(newLineArray[k].width * 6.8));
                                        let value2 = subStrCN1.str;
                                        text += value2;
                                        text += '\n';
                                        for (let l = 0; l < Math.ceil(newLineArray[k].left * 6.8); l++) {
                                            text += ' ';
                                        }
                                        text += txt.replace(value2, '');
                                    }
                                    else {
                                        text += newLineArray[k].value.replace(value1, '');
                                    }
                                } else {
                                    text += newLineArray[k].value;
                                    newLineArray[k].value = '';
                                    //newLineArray.splice(0,1);
                                }
                            }
                            newLineArray.splice(0, newLineArray.length);

                            for (var j = 0; j < data.length; j++) {
                                if (data[j].name == value.split("{")[1].split("}")[0]) {
                                    if (tempArr[i].top - tempArr[i - 1].top < 0.2) {
                                        for (var k = 0; k < Math.ceil(tempArr[i].left * 6.8) - Math.ceil(tempArr[i - 1].left * 6.8) - utils.getLength(tempArr[i - 1].text); k++) {
                                            text += " ";
                                        }
                                    }
                                    else {
                                        text = text + '\n';
                                        if (tempArr[i].font > 14) {
                                            //text += "\x1b\x21\x30";	
                                            text += getFontSizeStr(tempArr[i]);
                                        } else {
                                            //text += "\x1b\x21\x00";
                                            text += getFontSizeStr(tempArr[i]);
                                        }
                                    }

                                    text = text + data[j].value;

                                }
                            }
                            previousValue = "";
                            //text=+utils.getNowFormatDate();
                        }

                        continue;
                    }

                    value = value.split("{")[1].split("}")[0].split(".")[1];
                    var flag1 = 0;
                    //判断是否有上一行长度过长需要换行打印的
                    if (tempArr[i].neednewline == true) {
                        do {
                            tempArr[i].neednewline = false;
                            for (let k = 0; k < newLineArray.length; k++) {
                                //先换行
                                if (k == 0) {
                                    text += '\n';
                                    for (let l = 0; l < Math.ceil(newLineArray[k].left * 6.8); l++) {
                                        text += ' ';
                                    }
                                } else {
                                    for (let l = 0; l < Math.ceil(newLineArray[k].left * 6.8) - Math.ceil(newLineArray[k - 1].left * 6.8); l++) {
                                        text += ' ';
                                    }
                                }

                                if (Math.ceil(utils.getLength(newLineArray[k].value)) > Math.ceil(newLineArray[k].width * 6.8)) {
                                    tempArr[i].neednewline = true;
                                    //目前行要输出的值
                                    var subStrCN = utils.subStringCN(newLineArray[k].value, Math.ceil(newLineArray[k].width * 6.8));
                                    let value1 = subStrCN.str;
                                    //let value1 = newLineArray[k].value.substring(0,Math.ceil(newLineArray[k].width * 6.8));
                                    //下一行要输出的值
                                    let value2 = newLineArray[k].value.substring(subStrCN.index + 1, utils.getLength(newLineArray[j].value));

                                    text += value1;
                                    newLineArray[k].value = value2;
                                } else {
                                    text += newLineArray[k].value;
                                    newLineArray[k].value = '';
                                    //newLineArray.splice(0,1);
                                }
                            }
                        }
                        while (tempArr[i].neednewline == true)
                        newLineArray.splice(0, newLineArray.length);
                    }




                    for (var j = 0; j < data.length; j++) {
                        //判断是否是子表
                        if (tempArr[i].text.split("{")[1].split("}")[0].split(".").length == 2) {
                            if (data[j].name == value) {
                                if (tempArr[i].barcodeType) {
                                    if (!isContains(data[j].value + '', '$')) {
                                        continue;
                                    }
                                    text += '\n';
                                    text += getFontSizeStr(tempArr[i]);
                                    text += data[j].value;
                                    flag1 = 1;
                                    continue;
                                }
                                else {
                                    if (isContains(data[j].value + '', '$')) {
                                        continue;
                                    }
                                }
                                var textlength = Math.ceil(utils.getLength(data[j].value));
                                let rate=1;
                                if(parseInt(tempArr[i].font) > 14)
                                {
                                    rate=2;
                                }
                                //如果值长度大于限制范围，在下一行同样距离左边的位置继续输出
                                if (textlength * rate > Math.ceil(tempArr[i].width * 6.8)) {
                                    //目前行要输出的值
                                    //var subStrCN = utils.subStringCN(data[j].value, Math.ceil(tempArr[i].width * 6.8));
                                    var subStrCN = utils.subStringCN(data[j].value, Math.ceil(tempArr[i].width * 6.8/rate));
                                    let value1 = subStrCN.str;
                                    //let value1 = data[j].value.substring(0,Math.ceil(tempArr[i].width * 6.8));
                                    //下一行要输出的值
                                    let value2 = data[j].value.substring(subStrCN.index + 1, textlength);
                                    var obj = new Object();
                                    obj.left = tempArr[i].left;
                                    obj.width = tempArr[i].width;
                                    obj.value = value2;
                                    newLineArray.push(obj);
                                    for (var k = i + 1; k < tempArr.length; k++) {
                                        if (tempArr[k].top - tempArr[i].top > 0.2) {
                                            tempArr[k].neednewline = true;
                                            break;
                                        }
                                    }
                                    data[j].value = value1;
                                }
                                //判断同行,离顶点距离差异小于0.2默认为同一行
                                if (tempArr[i].top - tempArr[i - 1].top < 0.2) {
                                    if (isContains(tempArr[i - 1].text, "{")) {
                                        if (previousValue == "") {
                                            let length = utils.getLength(tempArr[i - 1].text) * (tempArr[i].font > 14 ? 2 : 1);
                                            length=Math.ceil(tempArr[i].left * 6.8) - Math.ceil(tempArr[i - 1].left * 6.8) - length;
                                            length=length/rate;
                                            //for (var k = 0; k < Math.ceil(tempArr[i].left * 6.8) - Math.ceil(tempArr[i - 1].left * 6.8) - utils.getLength(tempArr[i - 1].text); k++) {
                                            for (var k = 0; k < length; k++) {  
                                              text += " ";
                                            }
                                        }
                                        else {
                                            let length = utils.getLength(previousValue) * (tempArr[i].font > 14 ? 2 : 1);
                                            length=Math.ceil(tempArr[i].left * 6.8) - Math.ceil(tempArr[i - 1].left * 6.8) - length;
                                            length=length/rate;
                                            // for (var k = 0; k < Math.ceil(tempArr[i].left * 6.8) - Math.ceil(tempArr[i - 1].left * 6.8) - utils.getLength(previousValue); k++) {
                                            // for (var k = 0; k < Math.ceil(tempArr[i].left * 6.8) - Math.ceil(tempArr[i - 1].left * 6.8) - length; k++) {
                                            for (var k = 0; k < length; k++) {  
                                               text += " ";
                                             }
                                        }
                                    }
                                    else {
                                        if (tempArr[i].Alignment == "Left") {
                                            let length = utils.getLength(tempArr[i - 1].text) * (tempArr[i].font > 14 ? 2 : 1);
                                            length=Math.ceil(tempArr[i].left * 6.8) - Math.ceil(tempArr[i - 1].left * 6.8) - length;
                                            length=length/rate;
                                            for (var k = 0; k < length; k++) {
                                                text += " ";
                                            }
                                        }
                                        else {
                                            let length = utils.getLength(previousValue) * (tempArr[i].font > 14 ? 2 : 1);
                                            length=Math.ceil(tempArr[i].left * 6.8) - Math.ceil(tempArr[i - 1].left * 6.8) - length;
                                            length=length/rate;
                                            for (var k = 0; k < length; k++) {
                                                text += " ";
                                            }
                                        }

                                    }
                                    previousValue = "";
                                    // text += getFontSizeStr(tempArr[i]);
                                    text += data[j].value;
                                    previousValue = data[j].value;
                                    flag1 = 1;
                                    break;
                                } else {
                                    //设置字体，为标准或者两倍
                                    if (parseInt(tempArr[i].font) > 14) {
                                        text += "\n";
                                        //text += "\x1b\x21\x30";	
                                        text += getFontSizeStr(tempArr[i]);
                                        for (var k = 0; k < Math.ceil(tempArr[i].left * 6.8 / 2); k++) {
                                            text += " ";
                                        }
                                    } else {
                                        text += "\n";
                                        //text += "\x1b\x21\x00";
                                        text += getFontSizeStr(tempArr[i]);
                                        for (var k = 0; k < Math.ceil(tempArr[i].left * 6.8); k++) {
                                            text += " ";
                                        }
                                    }


                                    text += data[j].value;
                                    previousValue = data[j].value;
                                    flag1 = 1;

                                    break;
                                }
                            }
                        } else {
                            value = tempArr[i].text.split("{")[1].split("}")[0].split(".")[2]
                            //获取要打印的子表所处的单据数据的位置
                            var index = 0;
                            var isExits = false;
                            for (index; index < data.length; index++) {
                                if (data[index].length != undefined && data[index].isPrint == undefined && data[index][0] != undefined && data[index][0][0] != undefined) {
                                    if (data[index][0][0].name == value) {
                                        isExits = true;
                                        break;
                                    }

                                }
                            }
                            if (isExits == false) {
                                //data里面没有对应字段数据信息
                                continue;
                            }
                            //循环子表第k行
                            for (var k = 0; k < data[index].length; k++) {

                                
                                if(k>0)
                                {
                                    //子表循环时候  中间行商品名称超长时显示不全
                                    let kIndex=k-1;
                                //子表循环要打印的列数，从拿到判断到时子表数据的第i行模板数据开始，接下来的子表列循环打印出来，并标志为已打印
                                for (var m = i; m < i + data[index][0].length; m++) {
                                    //
                                    var value1 = tempArr[m].text.split("{")[1].split("}")[0].split(".")[2];
                                    //子表具体行的列循环打印
                                    for (var l = 0; l < data[index][kIndex].length; l++) {
                                        if (utils.isContains(tempArr[m].text, "{")) {

                                            if (value1 == data[index][kIndex][l].name) {
                                                //判断是否有上一行长度过长需要换行打印的
                                                if (tempArr[m].neednewline == true) {
                                                    do {
                                                        tempArr[m].neednewline = false;
                                                        for (let k = 0; k < newLineArray.length; k++) {
                                                            //先换行
                                                            if (k == 0) {
                                                                text += '\n';
                                                                for (let l = 0; l < Math.ceil(newLineArray[k].left * 6.8); l++) {
                                                                    text += ' ';
                                                                }
                                                            } else {
                                                                for (let l = 0; l < Math.ceil(newLineArray[k].left * 6.8) - Math.ceil(newLineArray[k - 1].left * 6.8); l++) {
                                                                    text += ' ';
                                                                }
                                                            }

                                                            if (Math.ceil(utils.getLength(newLineArray[k].value)) > Math.ceil(newLineArray[k].width * 6.8)) {
                                                                tempArr[m].neednewline = true;
                                                                //目前行要输出的值
                                                                var subStrCN = utils.subStringCN(newLineArray[k].value, Math.ceil(newLineArray[k].width * 6.8));
                                                                let value1 = subStrCN.str;
                                                                //let value1 = newLineArray[k].value.substring(0,Math.ceil(newLineArray[k].width * 6.8));
                                                                //下一行要输出的值
                                                                let value2 = newLineArray[k].value.substring(subStrCN.index, utils.getLength(newLineArray[j].value));

                                                                text += value1;
                                                                newLineArray[k].value = value2;
                                                            } else {
                                                                text += newLineArray[k].value;
                                                                newLineArray[k].value = '';
                                                                //newLineArray.splice(0,1);
                                                            }
                                                        }
                                                    }
                                                    while (tempArr[m].neednewline == true)
                                                    newLineArray.splice(0, newLineArray.length);
                                                }
                                            }
                                        }
                                    }
                                }
                            
                                }

                                //子表循环要打印的列数，从拿到判断到时子表数据的第i行模板数据开始，接下来的子表列循环打印出来，并标志为已打印
                                for (var m = i; m < i + data[index][0].length; m++) {
                                    //
                                    var value1 = tempArr[m].text.split("{")[1].split("}")[0].split(".")[2];
                                    //子表具体行的列循环打印
                                    for (var l = 0; l < data[index][k].length; l++) {
                                        if (utils.isContains(tempArr[m].text, "{")) {

                                            if (value1 == data[index][k][l].name) {
                                                //判断是否有上一行长度过长需要换行打印的
                                                if (tempArr[m].neednewline == true) {
                                                    do {
                                                        tempArr[m].neednewline = false;

                                                        let strpreview='';
                                                        for (let k = 0; k < newLineArray.length; k++) {
                                                            //先换行
                                                            if (k == 0) {
                                                                text += '\n';
                                                                for (let l = 0; l < Math.ceil(newLineArray[k].left * 6.8); l++) {
                                                                    text += ' ';
                                                                }
                                                            } else {
                                                                let newLinepreviewLeft= newLineArray[k - 1].left;
                                                                if(newLinepreviewLeft<0)
                                                                {
                                                                    newLinepreviewLeft=0;
                                                                }
                                                                  
                                                               // for (let l = 0; l < Math.ceil(newLineArray[k].left * 6.8) - Math.ceil(newLineArray[k - 1].left * 6.8); l++) {
                                                                for (let l = 0; l < Math.ceil(newLineArray[k].left * 6.8) - Math.ceil(newLineArray[k - 1].left * 6.8)- utils.getLength(strpreview); l++) {
                                                               text += ' ';
                                                                }
                                                            }

                                                            if (Math.ceil(utils.getLength(newLineArray[k].value)) > Math.ceil(newLineArray[k].width * 6.8)) {
                                                                tempArr[m].neednewline = true;
                                                                //目前行要输出的值
                                                                var subStrCN = utils.subStringCN(newLineArray[k].value, Math.ceil(newLineArray[k].width * 6.8));
                                                                let value1 = subStrCN.str;
                                                                //let value1 = newLineArray[k].value.substring(0,Math.ceil(newLineArray[k].width * 6.8));
                                                                //下一行要输出的值
                                                                let value2 = newLineArray[k].value.substring(subStrCN.index+1, utils.getLength(newLineArray[j].value));

                                                                text += value1;
                                                                strpreview=value1;
                                                                newLineArray[k].value = value2;
                                                            } else {
                                                                text += newLineArray[k].value;
                                                                strpreview=newLineArray[k].value;
                                                                newLineArray[k].value = '';
                                                                //newLineArray.splice(0,1);
                                                            }
                                                        }
                                                    }
                                                    while (tempArr[m].neednewline == true)
                                                    newLineArray.splice(0, newLineArray.length);
                                                }
                                                tempArr[m].isprint = 1;

                                                var textlength = Math.ceil(utils.getLength(data[index][k][l].value));
                                                //如果值长度大于限制范围，在下一行同样距离左边的位置继续输出
                                                if (textlength > Math.ceil(tempArr[m].width * 6.8)) {
                                                    //目前行要输出的值
                                                    var subStrCN = utils.subStringCN(data[index][k][l].value, Math.ceil(tempArr[m].width * 6.8));
                                                    let value2 = subStrCN.str;
                                                    //let value2 = data[index][k][l].value.substring(0,Math.ceil(tempArr[i].width * 6.8));
                                                    //下一行要输出的值
                                                    //let value3 = data[index][k][l].value.substring(Math.ceil(tempArr[i].width * 6.8),textlength);
                                                    let value3 = data[index][k][l].value.substring(subStrCN.index + 1, textlength);
                                                    var obj = new Object();
                                                    obj.left = tempArr[m].left;
                                                    obj.width = tempArr[m].width;
                                                    obj.value = value3;
                                                    newLineArray.push(obj);

                                                    tempArr[m].neednewline = true;

                                                    //子表有可能循环，所以换行输出与主表的不一样

                                                    for (var n = m + 1; n < tempArr.length; n++) {
                                                        if (tempArr[n].top - tempArr[m].top > 0.2) {
                                                            tempArr[n].neednewline = true;
                                                            break;
                                                        }
                                                    }
                                                    data[index][k][l].value = value2;
                                                }

                                                if (m > 0) {
                                                    //判断同行,离顶点距离差异小于0.2默认为同一行
                                                    if (tempArr[m].top - tempArr[m - 1].top < 0.2) {
                                                        //
                                                        if (l >= 1) {
                                                            var dataIndex = l - 1;
                                                            if (dataIndex < 0)
                                                                dataIndex = 0;
                                                            if ((utils.getLength(data[index][k][dataIndex].value.toString()) * (tempArr[m - 1].font > 14 ? 2 : 1)) > Math.ceil(tempArr[m].left * 6.8)) {
                                                                text += data[index][k][l].value;
                                                            } else {
                                                                /*for(var o = 0 ; o < Math.ceil(tempArr[m].left * 6.8) - (utils.getLength(data[index][k][l-1].value) *(tempArr[m-1].font > 14 ? 2 : 1)); o++){ 
                                                                    text += " ";
                                                                }*/

                                                                if (tempArr[m].Alignment == "Left") {
                                                                    for (var o = 0; o < Math.ceil(tempArr[m].left * 6.8) - Math.ceil(tempArr[m - 1].left * 6.8) - (utils.getLength(data[index][k][dataIndex].value.toString()) * (tempArr[m - 1].font > 14 ? 2 : 1)); o++) {
                                                                        text += " ";
                                                                    }
                                                                }
                                                                else {
                                                                    //右对齐处理
                                                                    let left = tempArr[m].left + tempArr[m].width;
                                                                    let length = utils.getLength(data[index][k][l].value.toString()) * (tempArr[m].font > 14 ? 2 : 1);

                                                                    if (tempArr[m - 1].Alignment == "Left") {
                                                                        for (var o = 0; o < Math.ceil(left * 6.8) - Math.ceil(tempArr[m - 1].left * 6.8) - length - (utils.getLength(data[index][k][dataIndex].value.toString()) * (tempArr[m - 1].font > 14 ? 2 : 1)); o++) {
                                                                            text += " ";
                                                                        }
                                                                    }
                                                                    else {
                                                                        let previousLength = tempArr[m - 1].left + tempArr[m - 1].width;
                                                                        for (var o = 0; o < Math.ceil(left * 6.8) - Math.ceil(previousLength * 6.8) - length; o++) {
                                                                            text += " ";
                                                                        }
                                                                    }
                                                                }


                                                                // text += getDetailValueFontSizeStr(tempArr[i],tempArr[m].left);
                                                                text += data[index][k][l].value;
                                                                previousValue = data[index][k][l].value;
                                                            }
                                                        } else {
                                                            if (previousValue != '') {
                                                                if(tempArr[m].DataSourceName!=Parent)
                                                                {
                                                                for (var o = 0; o < Math.ceil(tempArr[m].left * 6.8); o++) {
                                                                    text += " ";
                                                                }
                                                              }
                                                              else
                                                              {
                                                                  //表体行字段放表头区域先特殊处理
                                                                  let previousLength = tempArr[m - 1].left + tempArr[m - 1].width;
                                                                  for (var o = 0; o < Math.ceil(tempArr[m].left * 6.8) - Math.ceil(previousLength * 6.8); o++) {
                                                                      text += " ";
                                                                  }
                                                              }
                                                            }
                                                            else
                                                            {
                                                                let previousLength = tempArr[m - 1].left + tempArr[m - 1].width;
                                                                for (var o = 0; o < Math.ceil(tempArr[m].left * 6.8) - Math.ceil(previousLength * 6.8); o++) {
                                                                    text += " ";
                                                                }
                                                            }
                                                            // text += getDetailValueFontSizeStr(tempArr[i],tempArr[m].left);
                                                            text += data[index][k][l].value;
                                                            previousValue = data[index][k][l].value;
                                                        }

                                                    } else {
                                                        //判断出不同行的话，自动换行	
                                                        text += "\n";
                                                        text += getFontSizeStr(tempArr[i + l]);
                                                        for (var n = 0; n < Math.ceil(tempArr[i + l].left * 6.8); n++) {
                                                            text += " ";
                                                        }



                                                       
                                                        text += data[index][k][l].value;
                                                        previousValue = data[index][k][l].value;
                                                        break;
                                                    }
                                                } else {
                                                    text += "\n";
                                                    for (var n = 0; n < Math.ceil(tempArr[i + l].left * 6.8); n++) {
                                                        text += " ";
                                                    }
                                                    text += getFontSizeStr(tempArr[i + l]);
                                                    text += data[index][k][l].value;
                                                    previousValue = data[index][k][l].value;
                                                    break;
                                                }
                                            }
                                        }
                                    }
                                }
                            }

                            //子表循环时候  最后一行商品名称超长时显示不全
                            for (var k = data[index].length - 1; k < data[index].length; k++) {
                                //子表循环要打印的列数，从拿到判断到时子表数据的第i行模板数据开始，接下来的子表列循环打印出来，并标志为已打印
                                for (var m = i; m < i + data[index][0].length; m++) {
                                    //
                                    var value1 = tempArr[m].text.split("{")[1].split("}")[0].split(".")[2];
                                    //子表具体行的列循环打印
                                    for (var l = 0; l < data[index][k].length; l++) {
                                        if (utils.isContains(tempArr[m].text, "{")) {

                                            if (value1 == data[index][k][l].name) {
                                                //判断是否有上一行长度过长需要换行打印的
                                                if (tempArr[m].neednewline == true) {
                                                    do {
                                                        tempArr[m].neednewline = false;
                                                        for (let k = 0; k < newLineArray.length; k++) {
                                                            //先换行
                                                            if (k == 0) {
                                                                text += '\n';
                                                                for (let l = 0; l < Math.ceil(newLineArray[k].left * 6.8); l++) {
                                                                    text += ' ';
                                                                }
                                                            } else {
                                                                for (let l = 0; l < Math.ceil(newLineArray[k].left * 6.8) - Math.ceil(newLineArray[k - 1].left * 6.8); l++) {
                                                                    text += ' ';
                                                                }
                                                            }

                                                            if (Math.ceil(utils.getLength(newLineArray[k].value)) > Math.ceil(newLineArray[k].width * 6.8)) {
                                                                tempArr[m].neednewline = true;
                                                                //目前行要输出的值
                                                                var subStrCN = utils.subStringCN(newLineArray[k].value, Math.ceil(newLineArray[k].width * 6.8));
                                                                let value1 = subStrCN.str;
                                                                //let value1 = newLineArray[k].value.substring(0,Math.ceil(newLineArray[k].width * 6.8));
                                                                //下一行要输出的值
                                                                let value2 = newLineArray[k].value.substring(subStrCN.index, utils.getLength(newLineArray[j].value));

                                                                text += value1;
                                                                newLineArray[k].value = value2;
                                                            } else {
                                                                text += newLineArray[k].value;
                                                                newLineArray[k].value = '';
                                                                //newLineArray.splice(0,1);
                                                            }
                                                        }
                                                    }
                                                    while (tempArr[m].neednewline == true)
                                                    newLineArray.splice(0, newLineArray.length);
                                                }
                                            }
                                        }
                                    }
                                }
                            }


                            break;
                        }
                    }
                } else {
                    //判断是否有上一行长度过长需要换行打印的
                    if (tempArr[i].neednewline == true) {
                        do {
                            tempArr[i].neednewline = false;
                            for (let j = 0; j < newLineArray.length; j++) {
                                //先换行
                                if (j == 0) {
                                    text += '\n';
                                    for (let k = 0; k < Math.ceil(newLineArray[j].left * 6.8); k++) {
                                        text += ' ';
                                    }
                                } else {
                                    for (let k = 0; k < Math.ceil(newLineArray[j].left * 6.8) - Math.ceil(newLineArray[j - 1].left * 6.8); k++) {
                                        text += ' ';
                                    }
                                }
                                //如果换行长度还不够打，则需要继续换行，neednewline继续为true
                                if (Math.ceil(utils.getLength(newLineArray[j].value)) > Math.ceil(newLineArray[j].width * 6.8)) {
                                    tempArr[i].neednewline = true;
                                    //目前行要输出的值
                                    var subStrCN = utils.subStringCN(newLineArray[j].value, Math.ceil(newLineArray[j].width * 6.8));
                                    let value1 = subStrCN.str;
                                    //let value1 = newLineArray[j].value.substring(0,Math.ceil(newLineArray[j].width * 6.8));
                                    //下一行要输出的值
                                    let value2 = newLineArray[j].value.substring(subStrCN.index, utils.getLength(newLineArray[j].value));

                                    text += value1;
                                    newLineArray[j].value = value2;
                                } else {
                                    text += newLineArray[j].value;
                                    newLineArray[j].value = '';
                                    //newLineArray.splice(0,1);
                                }
                            }
                        }
                        while (tempArr[i].neednewline == true)
                        newLineArray.splice(0, newLineArray.length);
                    }
                    //判断同行,离顶点距离差异小于0.2默认为同一行
                    if (tempArr[i].top - tempArr[i - 1].top < 0.2) {

                        if (tempArr[i].font != tempArr[i - 1].font) {
                            var font = parseInt(tempArr[i].font);
                            if (font > 14) {
                                //text += "\x1b\x21\x30";	
                               // text += getFontSizeStr(tempArr[i]);
                               // for (var j = 0; j < Math.ceil(Math.ceil((tempArr[i].left * 6.8) - utils.getLength(tempArr[i - 1].text)) / 2); j++) {
                                //    text += " ";
                               // }
                            } else {
                                //text += "\x1b\x21\x00";
                               // text += getFontSizeStr(tempArr[i]);
                                //for (var j = 0; j < Math.ceil(tempArr[i].left * 6.8) - utils.getLength(tempArr[i - 1].text); j++) {
                                //    text += " ";
                               // }
                            }
                        }
                        /*for(var j = 0 ; j < Math.ceil(tempArr[i].left * 6.8) - utils.getLength(tempArr[i-1].text) ; j ++){ 
                            text += " ";
                        }*/
                        if (isContains(tempArr[i - 1].text, "{")) {
                            if (previousValue == "") {
                                for (var j = 0; j < Math.ceil(tempArr[i].left * 6.8) - Math.ceil(tempArr[i - 1].left * 6.8) - utils.getLength(tempArr[i - 1].text); j++) {
                                    text += " ";
                                }
                            }
                            else {
                                for (var j = 0; j < Math.ceil(tempArr[i].left * 6.8) - Math.ceil(tempArr[i - 1].left * 6.8) - utils.getLength(previousValue); j++) {
                                    text += " ";
                                }
                            }
                            previousValue = "";
                        }
                        else {
                            for (var j = 0; j < Math.ceil(tempArr[i].left * 6.8) - Math.ceil(tempArr[i - 1].left * 6.8) - utils.getLength(tempArr[i - 1].text); j++) {
                                text += " ";
                            }
                        }
                        // text += getFontSizeStr(tempArr[i]);
                        text += value;
                        //不同一行
                    } else {
                        text += "\n";
                        if (tempArr[i].font > 14) {
                            //text += "\x1b\x21\x30";		
                            text += getFontSizeStr(tempArr[i]);
                        } else {
                            //text += "\x1b\x21\x00";
                            text += getFontSizeStr(tempArr[i]);
                        }
                        for (var j = 0; j < Math.ceil(tempArr[i].left * 6.8); j++) {
                            text += " ";
                        }
                        text += value;
                    }
                }
            } else {
                continue;
            }
        } else {
            var font = parseInt(tempArr[i].font);
            var left = Math.ceil(tempArr[i].left * 6.8);
            //判断字体大小，并且空行
            if (font > 14) {
                //text += "\x1b\x21\x30";
                text += getFontSizeStr(tempArr[i]);
                // for (var j = 0; j < Math.ceil(left / 2); j++) {
                for (var j = 0; j < Math.ceil(left / 2.5); j++) {
               // for (var j = 0; j < Math.ceil(left / 4); j++) {
                    text += " ";
                }
            } else {
                //text += "\x1b\x21\x00";
                text += getFontSizeStr(tempArr[i]);
                for (var j = 0; j < left; j++) {
                    text += " ";
                }
            }



            var value = tempArr[i].text;
            if (utils.isContains(value, "{")) {
                value = value.split("{")[1].split("}")[0].split(".")[1];
                flag1 = 0;
                for (var j = 0; j < data.length; j++) {
                    if (data[j].length == undefined) {
                        if (data[j].name == value) {
                            text += data[j].value;
                            flag1 = 1;
                            break;
                        }
                    } else {

                        for (var k = 0; k < data[j].length; k++) {
                            for (var l = 0; l < data[j][k].length; l++) {
                                for (var m = i; m < tempArr.length; m++) {

                                    if (utils.isContains(tempArr[m].text, "{")) {
                                        value1 = tempArr[m].text.split("{")[1].split("}")[0].split(".")[2];
                                        if (value1 == data[j][k][l].name) {
                                            tempArr[m].isprint = 1;
                                            if (m > 0) {
                                                //判断同行,离顶点距离差异小于0.2默认为同一行
                                                if (tempArr[m].top - tempArr[m - 1].top < 0.2) {
                                                    if ((utils.getLength(data[j][k][l - 1].value) * (tempArr[m - 1].font > 14 ? 2 : 1)) > Math.ceil(tempArr[m].left * 6.8)) {
                                                        text += data[j][k][l].value;
                                                    } else {
                                                        for (var o = 0; o < Math.ceil(tempArr[m].left * 6.8) - (utils.getLength(data[j][k][l - 1].value) * (tempArr[m - 1].font > 14 ? 2 : 1)); o++) {
                                                            text += " ";
                                                        }
                                                        // text += getDetailValueFontSizeStr(tempArr[i],tempArr[m].left);
                                                        text += data[j][k][l].value;
                                                    }
                                                }
                                            } else {
                                                text += "\n";
                                                for (var n = 0; n < Math.ceil(tempArr[i].left * 6.8); n++) {
                                                    text += " ";
                                                }
                                                text += getFontSizeStr(tempArr[i]);
                                                text += data[j][k][l].value;
                                                break;
                                            }

                                        }

                                    }
                                }
                            }

                        }
                    }
                }
            } else {
                text += tempArr[i].text;
            }


        }
    }


    //表头最后一行超长处理

    for (let k = 0; k < newLineArray.length; k++) {
        //先换行
        if (k == 0) {
            text += '\n';
            for (let l = 0; l < Math.ceil(newLineArray[k].left * 6.8); l++) {
                text += ' ';
            }
        } else {
            for (let l = 0; l < Math.ceil(newLineArray[k].left * 6.8) - Math.ceil(newLineArray[k - 1].left * 6.8); l++) {
                text += ' ';
            }
        }

        if (Math.ceil(utils.getLength(newLineArray[k].value)) > Math.ceil(newLineArray[k].width * 6.8)) {
            //目前行要输出的值
            var subStrCN = utils.subStringCN(newLineArray[k].value, Math.ceil(newLineArray[k].width * 6.8));
            let value1 = subStrCN.str;
            //let value1 = newLineArray[k].value.substring(0,Math.ceil(newLineArray[k].width * 6.8));
            text += value1;
            text += '\n';
            for (let l = 0; l < Math.ceil(newLineArray[k].left * 6.8); l++) {
                text += ' ';
            }
            let txt = newLineArray[k].value.replace(value1, '');
            if (Math.ceil(utils.getLength(txt)) > Math.ceil(newLineArray[k].width * 6.8)) {
                var subStrCN1 = utils.subStringCN(txt, Math.ceil(newLineArray[k].width * 6.8));
                let value2 = subStrCN1.str;
                text += value2;
                text += '\n';
                for (let l = 0; l < Math.ceil(newLineArray[k].left * 6.8); l++) {
                    text += ' ';
                }
                text += txt.replace(value2, '');
            }
            else {
                text += newLineArray[k].value.replace(value1, '');
            }

        } else {
            text += newLineArray[k].value;
            newLineArray[k].value = '';
            //newLineArray.splice(0,1);
        }
    }


    
    text += "\n";

    var reg1 = new RegExp('\n', "g")
    var text3 = text.replace(reg1, '`');
    var array = text3.split('`');

    var methodValue = "ESCPrintLineAndCode";
    var dllPath = __dirname + '/Print/Print.dll';


    if (imageContent != "") {
        var text4 = array[0];
        printImageAndText(imageContent, text4, methodValue);
    }
    else {
        var input = [text3, 'printerName'];
        var getPrinter = edge.func({
            assemblyFile: dllPath,
            typeName: "print.Print",
            methodName: methodValue
        });
        getPrinter(input, function (err, result) {
            console.log(result);
        });

    }


    // setTimeout(function () { global.isPrinting = 0; }, 1000);
    global.isPrinting = 0;
    let response

    response = {
        code: 200,
        message: '打印成功',
        data: null
    };

    resolve(response);
}


//打印图片和文本
function printImageAndText(img, text, methodValue) {
    //img = 'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAIIAAACCAQAAAACieC1QAAAABGdBTUEAALGPC/xhBQAAACBjSFJNAAB6JgAAgIQAAPoAAACA6AAAdTAAAOpgAAA6mAAAF3CculE8AAAAAmJLR0QAAd2KE6QAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAAHdElNRQfhBwMIJAanwQRSAAAEmUlEQVRIS82VT2hcRRzHf7OTMBsLmU0RzSHkxVhIsQiilxyW7KaIij1UqhIkSC7Skoq0J4mw5L0QYVMvrQerBiSIQpr0UC9N8bQv1EsRUcQgKppJLFTw0Em08SV5O+PvN/M2+yoIHn2X9/Yzv9/392d+Mwv2H08M/v2NtWv3E3wt30eSQmjXTuaJGgjt/FqexF2hvfF6nkRQsZPzeQLvLtjLK2GbGICKOfX5RJuk8NCCbZxr5EgHTJjJNxfaJIHj0nx061yOsM6J5spb63kbCMyJXxbbRLNLQ+bDxe9zBDovNt+4PtQmCo6P7T3/41jeBmTz+o2rLXLHKvbYmearj4/ZfU9+JRuxt/ztkt315KZVRXh4e/zsuN32hKHNM/XdT9c+sSp0BDDW4Rd3JtHmVoWIgRB1Du1efm/RxsEBGTy2/fJLizZyJIUK2pzYXb5wxvZKIgkEuhCJew8ced98LDyRCbBHbn/307MGHNFEoL7VdXYsPVr3RKTwYM+90x9c2wOeEfRi6kku9ClGZANYCjC0c+G1c3+CI8oRvnV6Tm56EgMzUF26DU81VMmTDpiGAv/tlaeDeBS8DRJg2z2D4Qy0SAVgRh2+UrlSapEAoGfn7cGwcGATRAW2+UIXOkPYItClOqu1YuRjFUFEwDYvzaVQzLyqAnPCRPeiakuH40/FerBxka/Ckc3nRvXRVl3ORcEh+soI6ALbOPLoFxlBb8AGqQERlXzHsKUwRcoYEbLOV6FMOhKYJ9guJD2qhNWB2y8ceOgnGyK0pwsW83Kkr0CHIYY6HhyQEZIylZ5UXQYk6olVVawEUxRkM0UJRiSGCfGYqSKmKnBXgPbYEYZEUnIRN9DBFFfo11GhIlENSmSBBJCgF1Swg5orHtMiPhEEuJgwLeYABZwNR+kprrD9QhdI2Y1GmWvprYlAiGRUYaGVKCMoPcJ1v5sIiIkI7ATXI8ATRzAmfslZXcN5LAFzBAwSlZI3Ecq7EsmbOqEIRLA+jCqQMOov90RqfmcrccIZYSn/Y19LFCjgptHmgGX7fykSBpmRyqq1G67wIAbj3ltIaK2KxK3w1NqvSbg1mbgH7vYAP73+w90YufnB6xDPPZSKB7OBE2B9CCLOWlq3wrL75641d/HVtO0bKf/8C/n5h6UAlecbGdkd8LFIuXfiIJ/QWldONr0ZiVokzdd1ML2ciG7lbHzKXtrdY9aH8tKVVl2hIxGAzQjz6aoWUV6YpLkniRcmaeGJyWRQOsgq3cgAXbT/vT//K7JuG9dso7n+u71q15sr+zGeMiGMTOUq/m/gAUloPySSRCrLDI7ueYBZT0SMRAKNt3BeWqgQTDeMH3hprqfB9Aurq9haImoWSdov3R+XcWRVT5dqfY7Mko7YWE1GHHFzQTarcVIuTZVdLE9mVVIeHkZy3k0REZ32Dg/XvE0H2cxUa73lJ2p0e2JdRAAccbHqVjgyArWSJy7nbiTFGqSSchZW8LS787MAbw0jrNeZSbqDNMDzaQr73iuCviCVYJjNuiFjGM5IRBnWrdQwFRgRYVsVkUV7sSlMaE9+Zb+05p1m9W9t/7dAjOLrOgAAACV0RVh0ZGF0ZTpjcmVhdGUAMjAxNy0wNy0wM1QwODozNjowNiswMjowMHtwZqwAAAAldEVYdGRhdGU6bW9kaWZ5ADIwMTctMDctMDNUMDg6MzY6MDYrMDI6MDAKLd4QAAAAAElFTkSuQmCC';
    var imgType = "png";
    if (img.indexOf("data:image/jpeg;base64") >= 0) {
        imgType = "jpg";
    }
    else if (img.indexOf("data:image/jpg;base64") >= 0) {
        imgType = "jpg";
    }
    else if (img.indexOf("data:image/png;base64") >= 0) {
        imgType = "png";
    }
    else if (img.indexOf("data:image/bmp;base64") >= 0) {
        imgType = "bmp";
    }
    else if (img.indexOf("data:image/gif;base64") >= 0) {
        imgType = "gif";
    }

    var base64Data = img.replace(/^data:image\/\w+;base64,/, "");
    var dataBuffer = new Buffer(base64Data, 'base64');
    fs.writeFile(__dirname + "qr." + imgType, dataBuffer, function (err) {
        if (err) {

        } else {

            var getPrinter = edge.func({
                assemblyFile: dllPath,
                typeName: "print.Print",
                methodName: methodValue
            });
            getPrinter(text, function (err, result) {
                console.log(result);
            });



        }
    });

};






//打开钱箱  
var openCashDrawNoCheck = function (resolve, devicetype) {
    var input = "";
    var methodValue = "ESCOpenCashDrawer";

    var getPrinter = edge.func({
        assemblyFile: dllPath,
        typeName: "print.Print",
        methodName: methodValue
    });
    getPrinter(input, function (err, result) {
        console.log(result);
    });


    let response

    response = {
        code: 200,
        message: '打开钱箱成功',
        data: null
    };

    resolve(response);
}



module.exports = {
    print_for_temp: print_for_temp,
    openCashDrawNoCheck: openCashDrawNoCheck
}



