﻿var edge = require('electron-edge-js');
var dllPath=__dirname + '/Print/Print.dll';
const utils = require("./utils.js");
//const config = require('./config.json')
const scaleconfig = require('./scaleconfig.json')
const screen = require("./screen.js");
//const cashbox = require("./cashbox.js");
var cashbox;
const deviceconfig = require("./config.js");
var config;
var scale;
const path = require('path');
const fs = require('fs');
const urlpath = path.resolve(__dirname, '../../../uretailurl');
const configPath = `${urlpath}/config.json`;
fs.exists(urlpath, function (exists) {
	fs.exists(configPath, function (existss) {
		if (existss) {
			config = require(configPath)
			global.devicetype = config.devicetype;
			if (config.devicetype == "寺冈") {
				//scale = require('./scale.js');  
				//以后寺冈称重打印不走串口  直接调用sdk
				scale = require('./freshway.js');
			}
			else if (config.devicetype == "托利多" || config.devicetype == "顶尖" || config.devicetype == "海信" || config.devicetype == "爱普生" || config.devicetype == "滢浦通" || config.devicetype == "芯烨") {
				scale = require('./freshway.js');
			}
			else if (config.devicetype == "中崎" || config.devicetype == "托利多iSmart") {
				scale = require('./freshwayOld.js');
			} 				
			else {
				scale = require('./freshway.js');
			}

			if(config.devicetype == "ISPORTMO")
			{
				cashbox = require("./cashboxSportMO.js");
			}
			else
			{
				cashbox = require("./cashbox.js");
			}

		}
	});
});

global.isPrinting = 0;
var card = require("./card.js");



const doPrint = function (tempdata, reladata, entdata, res, times) {
	if (global.isPrinting == 1 && times > 0) {
		console.log(times);
		times--;

		setTimeout(function () {
			doPrint(tempdata, reladata, entdata, res, times);
		}, 1000);
	} else if (global.isPrinting != 1) {
		global.isPrinting = 1;
		let printer = require('./printer1.js');
		let pages = Object.getOwnPropertyNames(tempdata.tempContent.Pages).length;
		//解析过后的打印模板
		let printtemp = utils.resolveTemp(tempdata, pages);
		//解析后对应模板的实体数据
		let dataarray = utils.getRealData(printtemp, reladata, entdata);
		printer.print_for_temp(null, printtemp, dataarray, res);
		//let response;
		//printer.print11("",res,response);
	} else {
		global.isPrinting = 0;
		response = {
			status: "fail",
			msg: "打印失败，请重新发起"
		};
		res.send(response);
	}
}


const doPrint_for_temp = function (res, json, times, keys) {
	if (global.isPrinting == 1 && times > 0) {
		times--;
		setTimeout(function () {
			console.log(times);
			doPrint_for_temp(res, json, times, keys);

		}, 1000);
	} else if (global.isPrinting != 1) {
		global.isPrinting = 1;
		let printer;
		let response;

		if (config.devicetype == "寺冈" || config.devicetype == "托利多" || config.devicetype == "顶尖" || config.devicetype == "海信" || config.devicetype == "中崎" || config.devicetype == "爱普生" || config.devicetype == "北洋价签打印机" || config.devicetype == "滢浦通" || config.devicetype == "芯烨" || 
		config.devicetype == "托利多iSmart") {
		}
		else {
			if (config.PrintType == "USB") {
				if (config.VID && config.PID) {
					try {
						if(config.devicetype == "ISPORTMO")
						{
							printer = require('./printer1SPORTMO.js');
						}
						else
						{
						printer = require('./printer1.js');
						}
					}
					catch (e) {
						global.isPrinting = 0;
						response = {
							code: 999,
							message: "打印机没有接好或者驱动没有正常安装!" + e.message,
							data: null
						};
						return res(response);
					}
				}
				else {
					printer = require('./printerESC.js');
				}
			}
			else if (config.PrintType == "并口") {
				printer = require('./printerLPT.js');
			}
			else if (config.PrintType == "串口") {
				printer = require('./printerSerial.js');
			}
			else
			{
				//如果硬件适配没有配全 找不到对应打印设备  默认走ESC打印
				printer = require('./printerESC.js');
			}
		}
		//let keys;
		//try
		//{
		//keys =JSON.parse(json);
		//}
		//catch(err)
		//{
		//keys =json;
		//}

		let tempdata = JSON.parse(keys.tempJson);


		let reladata = JSON.parse(keys.dataSource);

		let entdata = JSON.parse(keys.data);

		if (tempdata.tempContent == "" || tempdata.tempContent == undefined) {
			response = {
				code: 999,
				message: "打印失败，打印模板为空!",
				data: null
			};
			res(response);
		} else {
			//模板块长度
			try {

				let pages = Object.getOwnPropertyNames(tempdata.tempContent.Pages).length;
				if (keys.isPriceTag != undefined) {
					printer = require('./printerLabelTag.js');
					//解析过后的打印模板
					let printtemp = utils.resolveTempPriceTag(tempdata, pages);
					var text = "";
					for (var k = 0; k < entdata.pricetagDetails.length; k++) {
						var printtempnew = JSON.parse(JSON.stringify(printtemp));
						let dataarray = utils.getRealDataRow(printtempnew, reladata, entdata, k);

						text = text + printer.print_for_temp(null, printtempnew, dataarray) + "~";

					}
					if (config.devicetype == "北洋价签打印机") {
						let pagewidth = tempdata.tempContent.Pages[0].PageWidth;
						let pageheight = tempdata.tempContent.Pages[0].PageHeight;
						printtbytext(text, res, pagewidth, pageheight);
					}
					else if (config.devicetype == "科诚价签打印机") {
						let pagewidth = tempdata.tempContent.Pages[0].PageWidth;
						let pageheight = tempdata.tempContent.Pages[0].PageHeight;
						printgodextext(text, res, pagewidth, pageheight,false);
					}
				}
				else {
					//解析过后的打印模板
					let printtemp = utils.resolveTemp(tempdata, pages);
					//模板主表名称
					let Parent="";
					if(reladata.Parent)
					{
						Parent=reladata.Parent;
					}
					//解析后对应模板的实体数据
					let dataarray = utils.getRealData(printtemp, reladata, entdata);
					if (config.devicetype == "寺冈" || config.devicetype == "托利多" || config.devicetype == "顶尖" || config.devicetype == "海信" || config.devicetype == "中崎" || config.devicetype == "爱普生" || config.devicetype == "滢浦通" || config.devicetype == "芯烨" || config.devicetype == "托利多iSmart") {
						let pagewidth = tempdata.tempContent.Pages[0].PageWidth;
						let supMidOfPrint = false;
						if(keys.supMidOfPrint){
							supMidOfPrint = keys.supMidOfPrint;
						}
						scale.print_for_temp(null, printtemp, dataarray, res, pagewidth,supMidOfPrint);
					}
					else {
						printer.print_for_temp(null, printtemp, dataarray, res,Parent);
					}
				}
			} catch (e) {
				global.isPrinting = 0;
				response = {
					code: 999,
					message: "模板解析出错!" + e.message,
					data: null
				};
				return res(response);
			}

		}
	} else {
		global.isPrinting = 0;
		response = {
			code: 999,
			message: "打印失败，请重新发起",
			data: null
		};
		res(response);
	}

}

//打印测试
var printtest = function (res, json, callback) {
	let printer;
	if (json.cDeviceBrand == "寺冈" || json.cDeviceBrand == "托利多" || json.cDeviceBrand == "顶尖" || json.cDeviceBrand == "海信" || json.cDeviceBrand == "中崎" || json.cDeviceBrand == "爱普生" || json.cDeviceBrand == "爱普生" || config.devicetype == "托利多iSmart") {
		var scaleNew = require('./freshway.js');
		scaleNew.printtest(res, json);
	}
	else {
		if (json.cPrinterPortType == "USB") {
			if (json.cPrinterVID && json.cPrinterPID) {
				printer = require('./printerTEST.js');
				printer.printtest(res, json);
			}
			else {
				printer = require('./printerESC.js');
				printer.printtest(res, json);
			}
		}
		else if (json.cPrinterPortType == "并口") {
			printer = require('./printerLPT.js');
			printer.printtest(res, json);
		}
		else if (json.cPrinterPortType == "串口") {
			printer = require('./printerSerial.js');
			printer.printtest(res, json);
		}
	}
}

//打印
var print = function (res, json, callback) {
	global.isPrinting = 0;
	var jsonstr = JSON.stringify(json);
	let keys;
	try {
		// keys =JSON.parse(req.body);
		keys = JSON.parse(JSON.stringify(json));
	}
	catch (err) {
		// keys =req.body;
		keys = JSON.stringify(json);
	}
	let billingcopiesofprintcopies = 1;
	if (json.billingcopiesofprintcopies != undefined) {
		billingcopiesofprintcopies = json.billingcopiesofprintcopies;
	};
	for (var k = 0; k < billingcopiesofprintcopies; k++) {
		doPrint_for_temp(res, jsonstr, 10, json);
	}

}


var getWeight = function (callback) {
	if (config.devicetype == "海信") {

	}
	else {
		scale.getWeight(callback);
		scale.zeroReset();
	}
}



var match = function (res, json, callback) {
	if (json.cDeviceBrand == "海信") {

	}
	else if (json.cDeviceBrand == "寺冈" || json.cDeviceBrand == "托利多" || json.cDeviceBrand == "顶尖" || json.cDeviceBrand == "中崎" || json.cDeviceBrand == "爱普生" || config.devicetype == "滢浦通" || config.devicetype == "芯烨" || config.devicetype == "托利多iSmart") {
		var scaleNew = require('./freshway.js');
		scaleNew.match(res, json, callback);
	}
	else {
		scale.match(res, json, callback);
	}
}


//电子秤配置文件保存
var save = function (resolve, jsonObject) {
	deviceconfig.save(resolve, jsonObject);
	if (scale != undefined) {
		scale.save(resolve, jsonObject);
	}

}


//电子秤配置文件清空
var clear = function (resolve) {
	scale.clear(resolve);
}


//实物去皮  
var tare = function (resolve) {
	scale.tare(resolve);
}

//清零
var zeroReset = function (resolve) {
	scale.zeroReset(resolve);
}


//关称
var close = function (resolve) {
	scale.close(resolve);
}

//数字去皮  
var digitalTare = function (resolve, tare) {
	scale.digitalTare(resolve, tare);
}

//显示副屏信息 
var showOnSecondaryScreen = function (resolve, url) {
	screen.showOnSecondaryScreen(resolve, url);
}


//刷新副屏信息 
var refreshSecondaryScreen = function (resolve, json) {
	screen.refreshSecondaryScreen(resolve, json.type, json.message);
}


//关闭副屏信息 
var closeSecondaryScreen = function (resolve) {
	screen.closeSecondaryScreen(resolve);
}

//需要验证用户名和密码 开启钱箱
var openCashDraw = function (resolve, keys) {
	cashbox.openCashDraw(resolve, keys);
	if (config.devicetype == "寺冈" || config.devicetype == "托利多" || config.devicetype == "顶尖" || config.devicetype == "海信" || config.devicetype == "中崎" || config.devicetype === "爱普生" || config.devicetype == "滢浦通" || config.devicetype == "芯烨" || config.devicetype == "托利多iSmart") {
		scale.openCashDraw(resolve, keys);
	}
	else {
		cashbox.openCashDraw(resolve, keys);
	}
}

//直接开启钱箱
var openCashDrawNoCheck = function (resolve) {
	if (config.devicetype == "寺冈" || config.devicetype == "托利多" || config.devicetype == "顶尖" || config.devicetype == "海信" || config.devicetype == "中崎" || config.devicetype === "爱普生" || config.devicetype == "滢浦通" || config.devicetype == "芯烨" || config.devicetype == "托利多iSmart") {
		scale.openCashDrawNoCheck(resolve, config.devicetype);
	}
	else {
		if (config.VID && config.PID) {
			cashbox.openCashDrawNoCheck(resolve);
		}
		else {
			let printerESC = require('./printerESC.js');
			printerESC.openCashDrawNoCheck(resolve, config.devicetype);
		}
	}
}

//钱箱测试
var openCashDrawTest = function (resolve, json) {
	if (json.cDeviceBrand == "寺冈" || json.cDeviceBrand == "托利多" || json.cDeviceBrand == "顶尖" || json.cDeviceBrand == "海信" || json.cDeviceBrand == "中崎" || config.devicetype === "爱普生" || config.devicetype == "托利多iSmart") {
		scale.openCashDrawNoCheck(resolve, json.cDeviceBrand);
	}
	else {
		cashbox.openCashDrawNoCheck(resolve);
	}
}

//打开储值卡设备
var openCard = function (resolve) {
	card.openCard(resolve);
}

//关闭储值卡设备
var closeCard = function (resolve) {
	card.closeCard(resolve);
}

//读取储值卡
var readCard = function (resolve) {
	card.readCard(resolve);
}

//读取储值卡传参
var readCardWithParam = function (resolve, data) {
	utils.logger("data = " + data);
	card.readCardWithParam(resolve, data);
}

//写储值卡
var writeCard = function (resolve, cardNumber) {
	card.writeCard(resolve, cardNumber);
}

//打印储值卡
var printCard = function (resolve, cardNumber, discount, balance, points, duedate) {
	card.printCard(resolve, cardNumber, discount, balance, points, duedate);
}

//储值卡打印初始化
var cardCshPrint = function (resolve, json) {
	card.cardCshPrint(resolve, json.cardNum, json.discount, json.balance, json.points, json.duedate);
}


//北洋价签打印，解决第一次打印报小票打印失败的错误问题
var printtbytext = function(text,res,pagewidth, pageheight){ 
	try{
	var reg = new RegExp( '\n' , "g" )
	var input =text.replace( reg , '@' );
	var cDeviceModel=config.cDeviceModel;
	var array = [cDeviceModel,input,pagewidth,pageheight];
	var methodValue = "PrintBYPriceTag";
	var getPrinter = edge.func({
	 assemblyFile:dllPath,
	 typeName:"print.Print",
	  methodName: methodValue
	 });
 	utils.logger("进入var getPrinter");
	 getPrinter(array,function(err,result)
	{
	 console.log(result);
	});

	global.isPrinting = 0;

	let content = {
		code:200,
		message: "打印成功",
		status: "success"
  	};
	res(content);
}catch(e){
	global.isPrinting = 0;
	let content = {
		code:998,
		message: "打印失败，打印机未启动或打印驱动未安装",
  	};
	res(content);
}
}


var printgodextext = function(text,res,pagewidth, pageheight,isLabelPrint){ 
	try{
	var reg = new RegExp( '\n' , "g" )
	var input =text.replace( reg , '@' );
	var cDeviceModel=config.cDeviceModel;
	pagewidth=pagewidth*10;
	pageheight=pageheight*10;
	var array = [cDeviceModel,input,pagewidth,pageheight,isLabelPrint];
	var methodValue = "PrintGodexPriceTag";
	var path=__dirname + '/Printer/Printer.dll';
	var getPrinter = edge.func({
	 assemblyFile:path,
	 typeName:"Printer.Print",
	  methodName: methodValue
	 });
 	utils.logger("进入var getPrinter");
	 getPrinter(array,function(err,result)
	{
	 console.log(result);
	});

	global.isPrinting = 0;

	let content = {
		code:200,
		message: "打印成功",
		status: "success"
  	};
	res(content);
}catch(e){
	global.isPrinting = 0;
	let content = {
		code:998,
		message: "打印失败，打印机未启动或打印驱动未安装",
  	};
	res(content);
}
}

module.exports = {
	print: print,
	printtest: printtest,
	getWeight: getWeight,
	match: match,
	clear: clear,
	zeroReset: zeroReset,
	tare: tare,
	close: close,
	save: save,
	digitalTare: digitalTare,
	openCashDrawTest: openCashDrawTest,
	openCashDraw: openCashDraw,
	openCashDrawNoCheck: openCashDrawNoCheck,
	showOnSecondaryScreen: showOnSecondaryScreen,
	refreshSecondaryScreen: refreshSecondaryScreen,
	closeSecondaryScreen: closeSecondaryScreen,
	openCard: openCard,
	closeCard: closeCard,
	readCard: readCard,
	writeCard: writeCard,
	printCard: printCard,
	cardCshPrint: cardCshPrint,
	readCardWithParam: readCardWithParam
}
