const SerialPort = require('serialport');
const utils = require("./utils.js");

SerialPort.list((err, ports) => {
	console.log(ports);
    ports.forEach((port) => {
        console.log(port.comName);
    });
});
var ports = "";

var restype = {
	"success" : "300307",
	"cancel" : "310306",
	"networkerror" : "320305"
};

var options = {
  	autoOpen: false,
  	lock: false,
  	baudRate: 9600,
  	dataBits: 8,
//  stopBits: 1,
  	parser: SerialPort.parsers.raw,
  	rtscts: false,
  	xon: false,
  	xoff: false,
  	xany: false,
};

var getPort = function () { 
    SerialPort.list(function (err, ports) {
		if(ports.length == 1){ 
			comName = ports[0].comName;
		}else{ 
			ports.forEach(function(p) {
			    if(!p.vendorId) {return;}
			    if(p.comName != 'COM1'){ 
			    	comName = p.comName;
			    }
			});
		}
		  
	})
}

var getPorts = function (res) { 
    SerialPort.list(function (err, ports) {
    	this.ports = ports;
		if(ports.length == 1){ 
			comName = ports[0].comName;
		}else{ 
			ports.forEach(function(p) {
			    if(!p.vendorId) {return;}
			    if(p.comName != 'COM1'){ 
			    	comName = p.comName;
			    }
			});
		}
		let response = {
		  	code:200,
		    message: "获取串口号成功",
		    data: this.ports
		};
		res.send(response);  
	})
}

/**
 * Description:支付接口
 * @author zhuanghl6
 * @date 2018年2月26日  上午10:24:07
 * @param balatype 支付方式
 * @param balamoney 支付金额
 * @param orderid 订单号
 * @param res 异步请求的response
 */
var paybind = function(balatype,balamoney,orderid,res,com){
	//找到后开始给串口绑定方法,并传输数据
	balatype = parseInt(balatype);
	balamoney = parseFloat(balamoney);

	let port = new SerialPort(com, options);
	port.on('error', function(err) {
		global.returndata = "";
	  	global.globalport = "";
	  	cnt = "POS串口线程已放开";
	  	console.log('Error: ', err.message);
	  	response = {
	  		code: 999,
	  		message: err.message + " POS机连接异常"
	  	};
		
	  	res.send(response);
	  	port.close();
	});
  	port.on('data', function (data) {
	  
	    console.log("data.length--->"+data.length);
	    console.log('Data: ' + data.toString('hex'));
	    
	    global.returndata += data.toString('hex');
	    console.log('globalData: ' + global.returndata);
	    //判断收到的数据是否已经结束
	    if(global.returndata.length > 16){
	    	let code , msg;
		    let realresu = null;
	    	//支付失败或取消
	    	if(global.returndata.slice(6,14) != "30303030"){
	    		cnt = "POS串口线程已放开";
	    		let resu = global.returndata.slice(6,14); 
		    	global.returndata = "";
		    	if(resu == "30303031" ){ 
			      code = 999; 
			      msg = '用户取消'; 
			    }else if(resu == "30303032" ){ 
			      code = 999;
			      msg = '网络问题';
			    }else{ 
			      code = 999;
			      msg = '支付未知错误';
			    }
			    let response = {
				  	code:code,
				    message: msg,
				    data:realresu
				};
			    port.close();
			    global.globalport = "";
			    res.send(response);
	    	}
	    	if(global.returndata.slice(14,16) == "7b" && global.returndata.slice(global.returndata.length -6,global.returndata.length -4) == "7d"){
		    	cnt = "POS串口线程已放开";
		    	let reslength = global.returndata.length; 
			    let resu;
			    		    
		    	resu = global.returndata.slice(14,reslength - 4);
		    	global.returndata = "";
		        code = 200;
		        msg = '成功支付';
		        let jsonresu = utils.hexCharCodeToStr(resu);
		        try{
		        	realresu = JSON.parse(jsonresu);
		        }catch(e){
					let response = {
					  	code:998,
					    message: "返回的数据错误!"
					};
					return res.send(response);
				}
				let response = {
				  	code:code,
				    message: msg,
				    data:realresu
				};
			    port.close();
			    global.globalport = "";
			    res.send(response);
	    	}

	    }		
  	});
  	port.on('open', function () {
  		global.returndata = "";
	  	cnt = "POS机串口被占用中，若异常请重启打印应用程序";
	  	var values = "";
	  	var pushdata = "02";
	  	var balatype_id;
	  	switch (balatype){ 
	  		case 6:
	  			balatype_id = '1';
	  			break;
			case 7:
				balatype_id = '5';
				break;
			case 8:
				balatype_id = '3';
				break;
			default:
				res.send({ 
		  			code:999,
		  			message:"传入的支付方式不合法"
		  		});
		  		port.close();
		  		return ;
	  	}
	
	  	var paytype = "0" + balatype_id;
	  	var money = balamoney.toString().split('.');
	  	if(money.length == 1){ 
			for(var i = 0; i < 12 - balamoney.toString().length-2 ; i++){ 
	  			values += "30";
		  	}
		  	for(var i = 0; i < balamoney.toString().length ; i++ ){ 
		  		var currentposition = "3" + balamoney.toString().slice(i,i+1);
		  		values += currentposition;
		  	}
		  	values += "3030";
	  	}else{ 
	  		
			for(var i = 0; i < 10 - money[0].toString().length ; i++){ 
	  			values += "30";
		  	}
		  	for(var i = 0; i < money[0].length ; i++){ 
		  		var currentposition = "3" + money[0].toString().slice(i,i+1);
		  		values += currentposition;
		  	}
		  	if( money[1].toString().length == 2){ 
			  	for(var i = 0; i < 2 ; i++){ 
			  		var currentposition = "3" + money[1].toString().slice(i,i+1);
			  		values += currentposition;
			  	}
	  		}else{ 
	  			var currentposition = "3" + money[1] +"30";
		  		values += currentposition;		
	  		}
	  	}
	  	var strOrderid = '{"orderid":"'+ orderid + '"}';
	  	var strlength = strOrderid.length + 13;
	  	for(var i = 0 ; i < 4 - strlength.toString().length ; i ++ ){ 
	  		pushdata += "0";
	  	} 
	  	pushdata += strlength.toString();
	  	pushdata += paytype;
	  	pushdata += values;
	  	var hexOrderid = utils.StringtoHex(strOrderid).toUpperCase();
	  	pushdata += hexOrderid;
	  	pushdata += "0339";
	  	console.log(pushdata);
	    const buffer = new Buffer(pushdata,"hex");
		try{
			port.write(buffer);
		}catch(e){
			let response = {
			  	code:998,
			    message: "POS设备未连接"
			};
			return res.send(response);
		}
  	});
  	global.globalport = port;
  	port.open();  	

}

/**
 * Description:退款接口
 * @author zhuanghl6
 * @date 2018年2月26日  上午10:50:07
 * @param balamoney 退款金额
 * @param orderid 订单号
 * @param refund_orderid 退款单号
 * @param res 异步请求的response
 */
var refundbind = function (balamoney,orderid,refund_orderid,res,com){
	

 		
	balamoney = parseFloat(balamoney);
	let port = new SerialPort(com, options);
  	port.on('error', function(err) {
  		global.globalport = "";
  		global.returndata = "";
	    console.log('Error: ', err.message);
		response = {
		  	code:999,
		    message: err.message
		};
	    res.send(response);
	    //port.close();
  	});   
  	port.on('data', function (data) {
    
	    console.log("data.length--->"+data.length);
	    console.log('Data: ' + data.toString('hex'));
	    
	    global.returndata += data.toString('hex');
		console.log('globalData: ' + global.returndata);

	    //判断收到的数据是否已经结束
	    if(global.returndata.length > 16){
	    	let code , msg;
		    let realresu = null;
	    	//支付失败或取消
	    	if(global.returndata.slice(6,14) != "30303030"){
				cnt = "POS串口线程已放开";
	    		let resu = global.returndata.slice(6,14); 
		    	global.returndata = "";
		    	if(resu == "30303031" ){ 
			      code = 999; 
			      msg = '用户取消'; 
			    }else if(resu == "30303032" ){ 
			      code = 999;
			      msg = '网络问题';
			    }else{ 
			      code = 999;
			      msg = '支付未知错误';
			    }
			    let response = {
				  	code:code,
				    message: msg,
				    data:realresu
				};
			    port.close();
			    global.globalport = "";
			    res.send(response);
	    	}
	    	if(global.returndata.slice(14,16) == "7b" && global.returndata.slice(global.returndata.length -6,global.returndata.length -4) == "7d"){
		    	let reslength = global.returndata.length; 
			    let resu;
			    cnt = "POS串口线程已放开";
		    
		    	resu = global.returndata.slice(14,reslength - 4);
		    	global.returndata = "";
		        code = 200;
		        msg = '退款支付';
		        let jsonresu = utils.hexCharCodeToStr(resu);
		        try{
		        	realresu = JSON.parse(jsonresu);
		        }catch(e){
					let response = {
					  	code:998,
					    message: "返回的数据错误!"
					};
					return res.send(response);
				}
				let response = {
				  	code:code,
				    message: msg,
				    data:realresu
				};
			    port.close();
			    global.globalport = "";
			    res.send(response);
	    	}

	    }

 	});
  	port.on('open', function () {
	  	cnt = "POS机串口被占用中，若异常请重启打印应用程序";
	  	var values = "02";
	  	var str = '{"orderid":"'+orderid+'","refundAmount":"'+balamoney+'","mertype":"default","refund_orderid":"'+refund_orderid+'"}';
	  	var strlength = (str.length+1).toString();
	  	for(var i = 0 ; i < 4 -strlength.length ; i++){ 
	  		values += "0";
	  	}
	  	values += strlength + '08';
	  	var hexStr = utils.StringtoHex(str);
	  	values += hexStr;
	  	values += '0339';
	  	console.log(values);
	    const buffer = new Buffer(values,"hex");
	   // console.log('**************** BUFFER DETAILS **************');
	   // console.log('buffer.toString("hex") = ', buffer.toString("hex"));
	    //console.log("buffer no toString____"+buffer);
		try{
			port.write(buffer);
		}catch(e){
			let response = {
			  	code:998,
			    message: "POS设备未连接"
			};
			return res.send(response);
		}
	
  	}); 
  	global.globalport = port;
  	port.open();
 
		
}

module.exports = {
	paybind : paybind,
	refundbind : refundbind,
	getPort : getPort,
	getPorts : getPorts
}
