/**
 * Copyright (c) Facebook, Inc. and its affiliates.
 *
 * This source code is licensed under the MIT license found in the LICENSE
 * file in the root directory of this source tree.
 */
// @Generated by gentest/gentest.rb from gentest/fixtures/YGAlignItemsTest.html

using System;
using NUnit.Framework;

namespace Facebook.Yoga
{
    [TestFixture]
    public class YGAlignItemsTest
    {
        [Test]
        public void Test_align_items_stretch()
        {
            YogaConfig config = new YogaConfig();

            YogaNode root = new YogaNode(config);
            root.Width = 100;
            root.Height = 100;

            YogaNode root_child0 = new YogaNode(config);
            root_child0.Height = 10;
            root.Insert(0, root_child0);
            root.StyleDirection = YogaDirection.LTR;
            root.CalculateLayout();

            Assert.AreEqual(0f, root.LayoutX);
            Assert.AreEqual(0f, root.LayoutY);
            Assert.AreEqual(100f, root.LayoutWidth);
            Assert.AreEqual(100f, root.LayoutHeight);

            Assert.AreEqual(0f, root_child0.LayoutX);
            Assert.AreEqual(0f, root_child0.LayoutY);
            Assert.AreEqual(100f, root_child0.LayoutWidth);
            Assert.AreEqual(10f, root_child0.LayoutHeight);

            root.StyleDirection = YogaDirection.RTL;
            root.CalculateLayout();

            Assert.AreEqual(0f, root.LayoutX);
            Assert.AreEqual(0f, root.LayoutY);
            Assert.AreEqual(100f, root.LayoutWidth);
            Assert.AreEqual(100f, root.LayoutHeight);

            Assert.AreEqual(0f, root_child0.LayoutX);
            Assert.AreEqual(0f, root_child0.LayoutY);
            Assert.AreEqual(100f, root_child0.LayoutWidth);
            Assert.AreEqual(10f, root_child0.LayoutHeight);
        }

        [Test]
        public void Test_align_items_center()
        {
            YogaConfig config = new YogaConfig();

            YogaNode root = new YogaNode(config);
            root.AlignItems = YogaAlign.Center;
            root.Width = 100;
            root.Height = 100;

            YogaNode root_child0 = new YogaNode(config);
            root_child0.Width = 10;
            root_child0.Height = 10;
            root.Insert(0, root_child0);
            root.StyleDirection = YogaDirection.LTR;
            root.CalculateLayout();

            Assert.AreEqual(0f, root.LayoutX);
            Assert.AreEqual(0f, root.LayoutY);
            Assert.AreEqual(100f, root.LayoutWidth);
            Assert.AreEqual(100f, root.LayoutHeight);

            Assert.AreEqual(45f, root_child0.LayoutX);
            Assert.AreEqual(0f, root_child0.LayoutY);
            Assert.AreEqual(10f, root_child0.LayoutWidth);
            Assert.AreEqual(10f, root_child0.LayoutHeight);

            root.StyleDirection = YogaDirection.RTL;
            root.CalculateLayout();

            Assert.AreEqual(0f, root.LayoutX);
            Assert.AreEqual(0f, root.LayoutY);
            Assert.AreEqual(100f, root.LayoutWidth);
            Assert.AreEqual(100f, root.LayoutHeight);

            Assert.AreEqual(45f, root_child0.LayoutX);
            Assert.AreEqual(0f, root_child0.LayoutY);
            Assert.AreEqual(10f, root_child0.LayoutWidth);
            Assert.AreEqual(10f, root_child0.LayoutHeight);
        }

        [Test]
        public void Test_align_items_flex_start()
        {
            YogaConfig config = new YogaConfig();

            YogaNode root = new YogaNode(config);
            root.AlignItems = YogaAlign.FlexStart;
            root.Width = 100;
            root.Height = 100;

            YogaNode root_child0 = new YogaNode(config);
            root_child0.Width = 10;
            root_child0.Height = 10;
            root.Insert(0, root_child0);
            root.StyleDirection = YogaDirection.LTR;
            root.CalculateLayout();

            Assert.AreEqual(0f, root.LayoutX);
            Assert.AreEqual(0f, root.LayoutY);
            Assert.AreEqual(100f, root.LayoutWidth);
            Assert.AreEqual(100f, root.LayoutHeight);

            Assert.AreEqual(0f, root_child0.LayoutX);
            Assert.AreEqual(0f, root_child0.LayoutY);
            Assert.AreEqual(10f, root_child0.LayoutWidth);
            Assert.AreEqual(10f, root_child0.LayoutHeight);

            root.StyleDirection = YogaDirection.RTL;
            root.CalculateLayout();

            Assert.AreEqual(0f, root.LayoutX);
            Assert.AreEqual(0f, root.LayoutY);
            Assert.AreEqual(100f, root.LayoutWidth);
            Assert.AreEqual(100f, root.LayoutHeight);

            Assert.AreEqual(90f, root_child0.LayoutX);
            Assert.AreEqual(0f, root_child0.LayoutY);
            Assert.AreEqual(10f, root_child0.LayoutWidth);
            Assert.AreEqual(10f, root_child0.LayoutHeight);
        }

        [Test]
        public void Test_align_items_flex_end()
        {
            YogaConfig config = new YogaConfig();

            YogaNode root = new YogaNode(config);
            root.AlignItems = YogaAlign.FlexEnd;
            root.Width = 100;
            root.Height = 100;

            YogaNode root_child0 = new YogaNode(config);
            root_child0.Width = 10;
            root_child0.Height = 10;
            root.Insert(0, root_child0);
            root.StyleDirection = YogaDirection.LTR;
            root.CalculateLayout();

            Assert.AreEqual(0f, root.LayoutX);
            Assert.AreEqual(0f, root.LayoutY);
            Assert.AreEqual(100f, root.LayoutWidth);
            Assert.AreEqual(100f, root.LayoutHeight);

            Assert.AreEqual(90f, root_child0.LayoutX);
            Assert.AreEqual(0f, root_child0.LayoutY);
            Assert.AreEqual(10f, root_child0.LayoutWidth);
            Assert.AreEqual(10f, root_child0.LayoutHeight);

            root.StyleDirection = YogaDirection.RTL;
            root.CalculateLayout();

            Assert.AreEqual(0f, root.LayoutX);
            Assert.AreEqual(0f, root.LayoutY);
            Assert.AreEqual(100f, root.LayoutWidth);
            Assert.AreEqual(100f, root.LayoutHeight);

            Assert.AreEqual(0f, root_child0.LayoutX);
            Assert.AreEqual(0f, root_child0.LayoutY);
            Assert.AreEqual(10f, root_child0.LayoutWidth);
            Assert.AreEqual(10f, root_child0.LayoutHeight);
        }

        [Test]
        public void Test_align_baseline()
        {
            YogaConfig config = new YogaConfig();

            YogaNode root = new YogaNode(config);
            root.FlexDirection = YogaFlexDirection.Row;
            root.AlignItems = YogaAlign.Baseline;
            root.Width = 100;
            root.Height = 100;

            YogaNode root_child0 = new YogaNode(config);
            root_child0.Width = 50;
            root_child0.Height = 50;
            root.Insert(0, root_child0);

            YogaNode root_child1 = new YogaNode(config);
            root_child1.Width = 50;
            root_child1.Height = 20;
            root.Insert(1, root_child1);
            root.StyleDirection = YogaDirection.LTR;
            root.CalculateLayout();

            Assert.AreEqual(0f, root.LayoutX);
            Assert.AreEqual(0f, root.LayoutY);
            Assert.AreEqual(100f, root.LayoutWidth);
            Assert.AreEqual(100f, root.LayoutHeight);

            Assert.AreEqual(0f, root_child0.LayoutX);
            Assert.AreEqual(0f, root_child0.LayoutY);
            Assert.AreEqual(50f, root_child0.LayoutWidth);
            Assert.AreEqual(50f, root_child0.LayoutHeight);

            Assert.AreEqual(50f, root_child1.LayoutX);
            Assert.AreEqual(30f, root_child1.LayoutY);
            Assert.AreEqual(50f, root_child1.LayoutWidth);
            Assert.AreEqual(20f, root_child1.LayoutHeight);

            root.StyleDirection = YogaDirection.RTL;
            root.CalculateLayout();

            Assert.AreEqual(0f, root.LayoutX);
            Assert.AreEqual(0f, root.LayoutY);
            Assert.AreEqual(100f, root.LayoutWidth);
            Assert.AreEqual(100f, root.LayoutHeight);

            Assert.AreEqual(50f, root_child0.LayoutX);
            Assert.AreEqual(0f, root_child0.LayoutY);
            Assert.AreEqual(50f, root_child0.LayoutWidth);
            Assert.AreEqual(50f, root_child0.LayoutHeight);

            Assert.AreEqual(0f, root_child1.LayoutX);
            Assert.AreEqual(30f, root_child1.LayoutY);
            Assert.AreEqual(50f, root_child1.LayoutWidth);
            Assert.AreEqual(20f, root_child1.LayoutHeight);
        }

        [Test]
        public void Test_align_baseline_child()
        {
            YogaConfig config = new YogaConfig();

            YogaNode root = new YogaNode(config);
            root.FlexDirection = YogaFlexDirection.Row;
            root.AlignItems = YogaAlign.Baseline;
            root.Width = 100;
            root.Height = 100;

            YogaNode root_child0 = new YogaNode(config);
            root_child0.Width = 50;
            root_child0.Height = 50;
            root.Insert(0, root_child0);

            YogaNode root_child1 = new YogaNode(config);
            root_child1.Width = 50;
            root_child1.Height = 20;
            root.Insert(1, root_child1);

            YogaNode root_child1_child0 = new YogaNode(config);
            root_child1_child0.Width = 50;
            root_child1_child0.Height = 10;
            root_child1.Insert(0, root_child1_child0);
            root.StyleDirection = YogaDirection.LTR;
            root.CalculateLayout();

            Assert.AreEqual(0f, root.LayoutX);
            Assert.AreEqual(0f, root.LayoutY);
            Assert.AreEqual(100f, root.LayoutWidth);
            Assert.AreEqual(100f, root.LayoutHeight);

            Assert.AreEqual(0f, root_child0.LayoutX);
            Assert.AreEqual(0f, root_child0.LayoutY);
            Assert.AreEqual(50f, root_child0.LayoutWidth);
            Assert.AreEqual(50f, root_child0.LayoutHeight);

            Assert.AreEqual(50f, root_child1.LayoutX);
            Assert.AreEqual(40f, root_child1.LayoutY);
            Assert.AreEqual(50f, root_child1.LayoutWidth);
            Assert.AreEqual(20f, root_child1.LayoutHeight);

            Assert.AreEqual(0f, root_child1_child0.LayoutX);
            Assert.AreEqual(0f, root_child1_child0.LayoutY);
            Assert.AreEqual(50f, root_child1_child0.LayoutWidth);
            Assert.AreEqual(10f, root_child1_child0.LayoutHeight);

            root.StyleDirection = YogaDirection.RTL;
            root.CalculateLayout();

            Assert.AreEqual(0f, root.LayoutX);
            Assert.AreEqual(0f, root.LayoutY);
            Assert.AreEqual(100f, root.LayoutWidth);
            Assert.AreEqual(100f, root.LayoutHeight);

            Assert.AreEqual(50f, root_child0.LayoutX);
            Assert.AreEqual(0f, root_child0.LayoutY);
            Assert.AreEqual(50f, root_child0.LayoutWidth);
            Assert.AreEqual(50f, root_child0.LayoutHeight);

            Assert.AreEqual(0f, root_child1.LayoutX);
            Assert.AreEqual(40f, root_child1.LayoutY);
            Assert.AreEqual(50f, root_child1.LayoutWidth);
            Assert.AreEqual(20f, root_child1.LayoutHeight);

            Assert.AreEqual(0f, root_child1_child0.LayoutX);
            Assert.AreEqual(0f, root_child1_child0.LayoutY);
            Assert.AreEqual(50f, root_child1_child0.LayoutWidth);
            Assert.AreEqual(10f, root_child1_child0.LayoutHeight);
        }

        [Test]
        public void Test_align_baseline_child_multiline()
        {
            YogaConfig config = new YogaConfig();

            YogaNode root = new YogaNode(config);
            root.FlexDirection = YogaFlexDirection.Row;
            root.AlignItems = YogaAlign.Baseline;
            root.Width = 100;
            root.Height = 100;

            YogaNode root_child0 = new YogaNode(config);
            root_child0.Width = 50;
            root_child0.Height = 60;
            root.Insert(0, root_child0);

            YogaNode root_child1 = new YogaNode(config);
            root_child1.FlexDirection = YogaFlexDirection.Row;
            root_child1.Wrap = YogaWrap.Wrap;
            root_child1.Width = 50;
            root_child1.Height = 25;
            root.Insert(1, root_child1);

            YogaNode root_child1_child0 = new YogaNode(config);
            root_child1_child0.Width = 25;
            root_child1_child0.Height = 20;
            root_child1.Insert(0, root_child1_child0);

            YogaNode root_child1_child1 = new YogaNode(config);
            root_child1_child1.Width = 25;
            root_child1_child1.Height = 10;
            root_child1.Insert(1, root_child1_child1);

            YogaNode root_child1_child2 = new YogaNode(config);
            root_child1_child2.Width = 25;
            root_child1_child2.Height = 20;
            root_child1.Insert(2, root_child1_child2);

            YogaNode root_child1_child3 = new YogaNode(config);
            root_child1_child3.Width = 25;
            root_child1_child3.Height = 10;
            root_child1.Insert(3, root_child1_child3);
            root.StyleDirection = YogaDirection.LTR;
            root.CalculateLayout();

            Assert.AreEqual(0f, root.LayoutX);
            Assert.AreEqual(0f, root.LayoutY);
            Assert.AreEqual(100f, root.LayoutWidth);
            Assert.AreEqual(100f, root.LayoutHeight);

            Assert.AreEqual(0f, root_child0.LayoutX);
            Assert.AreEqual(0f, root_child0.LayoutY);
            Assert.AreEqual(50f, root_child0.LayoutWidth);
            Assert.AreEqual(60f, root_child0.LayoutHeight);

            Assert.AreEqual(50f, root_child1.LayoutX);
            Assert.AreEqual(40f, root_child1.LayoutY);
            Assert.AreEqual(50f, root_child1.LayoutWidth);
            Assert.AreEqual(25f, root_child1.LayoutHeight);

            Assert.AreEqual(0f, root_child1_child0.LayoutX);
            Assert.AreEqual(0f, root_child1_child0.LayoutY);
            Assert.AreEqual(25f, root_child1_child0.LayoutWidth);
            Assert.AreEqual(20f, root_child1_child0.LayoutHeight);

            Assert.AreEqual(25f, root_child1_child1.LayoutX);
            Assert.AreEqual(0f, root_child1_child1.LayoutY);
            Assert.AreEqual(25f, root_child1_child1.LayoutWidth);
            Assert.AreEqual(10f, root_child1_child1.LayoutHeight);

            Assert.AreEqual(0f, root_child1_child2.LayoutX);
            Assert.AreEqual(20f, root_child1_child2.LayoutY);
            Assert.AreEqual(25f, root_child1_child2.LayoutWidth);
            Assert.AreEqual(20f, root_child1_child2.LayoutHeight);

            Assert.AreEqual(25f, root_child1_child3.LayoutX);
            Assert.AreEqual(20f, root_child1_child3.LayoutY);
            Assert.AreEqual(25f, root_child1_child3.LayoutWidth);
            Assert.AreEqual(10f, root_child1_child3.LayoutHeight);

            root.StyleDirection = YogaDirection.RTL;
            root.CalculateLayout();

            Assert.AreEqual(0f, root.LayoutX);
            Assert.AreEqual(0f, root.LayoutY);
            Assert.AreEqual(100f, root.LayoutWidth);
            Assert.AreEqual(100f, root.LayoutHeight);

            Assert.AreEqual(50f, root_child0.LayoutX);
            Assert.AreEqual(0f, root_child0.LayoutY);
            Assert.AreEqual(50f, root_child0.LayoutWidth);
            Assert.AreEqual(60f, root_child0.LayoutHeight);

            Assert.AreEqual(0f, root_child1.LayoutX);
            Assert.AreEqual(40f, root_child1.LayoutY);
            Assert.AreEqual(50f, root_child1.LayoutWidth);
            Assert.AreEqual(25f, root_child1.LayoutHeight);

            Assert.AreEqual(25f, root_child1_child0.LayoutX);
            Assert.AreEqual(0f, root_child1_child0.LayoutY);
            Assert.AreEqual(25f, root_child1_child0.LayoutWidth);
            Assert.AreEqual(20f, root_child1_child0.LayoutHeight);

            Assert.AreEqual(0f, root_child1_child1.LayoutX);
            Assert.AreEqual(0f, root_child1_child1.LayoutY);
            Assert.AreEqual(25f, root_child1_child1.LayoutWidth);
            Assert.AreEqual(10f, root_child1_child1.LayoutHeight);

            Assert.AreEqual(25f, root_child1_child2.LayoutX);
            Assert.AreEqual(20f, root_child1_child2.LayoutY);
            Assert.AreEqual(25f, root_child1_child2.LayoutWidth);
            Assert.AreEqual(20f, root_child1_child2.LayoutHeight);

            Assert.AreEqual(0f, root_child1_child3.LayoutX);
            Assert.AreEqual(20f, root_child1_child3.LayoutY);
            Assert.AreEqual(25f, root_child1_child3.LayoutWidth);
            Assert.AreEqual(10f, root_child1_child3.LayoutHeight);
        }

        [Test]
        public void Test_align_baseline_child_multiline_override()
        {
            YogaConfig config = new YogaConfig();

            YogaNode root = new YogaNode(config);
            root.FlexDirection = YogaFlexDirection.Row;
            root.AlignItems = YogaAlign.Baseline;
            root.Width = 100;
            root.Height = 100;

            YogaNode root_child0 = new YogaNode(config);
            root_child0.Width = 50;
            root_child0.Height = 60;
            root.Insert(0, root_child0);

            YogaNode root_child1 = new YogaNode(config);
            root_child1.FlexDirection = YogaFlexDirection.Row;
            root_child1.Wrap = YogaWrap.Wrap;
            root_child1.Width = 50;
            root_child1.Height = 25;
            root.Insert(1, root_child1);

            YogaNode root_child1_child0 = new YogaNode(config);
            root_child1_child0.Width = 25;
            root_child1_child0.Height = 20;
            root_child1.Insert(0, root_child1_child0);

            YogaNode root_child1_child1 = new YogaNode(config);
            root_child1_child1.AlignSelf = YogaAlign.Baseline;
            root_child1_child1.Width = 25;
            root_child1_child1.Height = 10;
            root_child1.Insert(1, root_child1_child1);

            YogaNode root_child1_child2 = new YogaNode(config);
            root_child1_child2.Width = 25;
            root_child1_child2.Height = 20;
            root_child1.Insert(2, root_child1_child2);

            YogaNode root_child1_child3 = new YogaNode(config);
            root_child1_child3.AlignSelf = YogaAlign.Baseline;
            root_child1_child3.Width = 25;
            root_child1_child3.Height = 10;
            root_child1.Insert(3, root_child1_child3);
            root.StyleDirection = YogaDirection.LTR;
            root.CalculateLayout();

            Assert.AreEqual(0f, root.LayoutX);
            Assert.AreEqual(0f, root.LayoutY);
            Assert.AreEqual(100f, root.LayoutWidth);
            Assert.AreEqual(100f, root.LayoutHeight);

            Assert.AreEqual(0f, root_child0.LayoutX);
            Assert.AreEqual(0f, root_child0.LayoutY);
            Assert.AreEqual(50f, root_child0.LayoutWidth);
            Assert.AreEqual(60f, root_child0.LayoutHeight);

            Assert.AreEqual(50f, root_child1.LayoutX);
            Assert.AreEqual(50f, root_child1.LayoutY);
            Assert.AreEqual(50f, root_child1.LayoutWidth);
            Assert.AreEqual(25f, root_child1.LayoutHeight);

            Assert.AreEqual(0f, root_child1_child0.LayoutX);
            Assert.AreEqual(0f, root_child1_child0.LayoutY);
            Assert.AreEqual(25f, root_child1_child0.LayoutWidth);
            Assert.AreEqual(20f, root_child1_child0.LayoutHeight);

            Assert.AreEqual(25f, root_child1_child1.LayoutX);
            Assert.AreEqual(0f, root_child1_child1.LayoutY);
            Assert.AreEqual(25f, root_child1_child1.LayoutWidth);
            Assert.AreEqual(10f, root_child1_child1.LayoutHeight);

            Assert.AreEqual(0f, root_child1_child2.LayoutX);
            Assert.AreEqual(20f, root_child1_child2.LayoutY);
            Assert.AreEqual(25f, root_child1_child2.LayoutWidth);
            Assert.AreEqual(20f, root_child1_child2.LayoutHeight);

            Assert.AreEqual(25f, root_child1_child3.LayoutX);
            Assert.AreEqual(20f, root_child1_child3.LayoutY);
            Assert.AreEqual(25f, root_child1_child3.LayoutWidth);
            Assert.AreEqual(10f, root_child1_child3.LayoutHeight);

            root.StyleDirection = YogaDirection.RTL;
            root.CalculateLayout();

            Assert.AreEqual(0f, root.LayoutX);
            Assert.AreEqual(0f, root.LayoutY);
            Assert.AreEqual(100f, root.LayoutWidth);
            Assert.AreEqual(100f, root.LayoutHeight);

            Assert.AreEqual(50f, root_child0.LayoutX);
            Assert.AreEqual(0f, root_child0.LayoutY);
            Assert.AreEqual(50f, root_child0.LayoutWidth);
            Assert.AreEqual(60f, root_child0.LayoutHeight);

            Assert.AreEqual(0f, root_child1.LayoutX);
            Assert.AreEqual(50f, root_child1.LayoutY);
            Assert.AreEqual(50f, root_child1.LayoutWidth);
            Assert.AreEqual(25f, root_child1.LayoutHeight);

            Assert.AreEqual(25f, root_child1_child0.LayoutX);
            Assert.AreEqual(0f, root_child1_child0.LayoutY);
            Assert.AreEqual(25f, root_child1_child0.LayoutWidth);
            Assert.AreEqual(20f, root_child1_child0.LayoutHeight);

            Assert.AreEqual(0f, root_child1_child1.LayoutX);
            Assert.AreEqual(0f, root_child1_child1.LayoutY);
            Assert.AreEqual(25f, root_child1_child1.LayoutWidth);
            Assert.AreEqual(10f, root_child1_child1.LayoutHeight);

            Assert.AreEqual(25f, root_child1_child2.LayoutX);
            Assert.AreEqual(20f, root_child1_child2.LayoutY);
            Assert.AreEqual(25f, root_child1_child2.LayoutWidth);
            Assert.AreEqual(20f, root_child1_child2.LayoutHeight);

            Assert.AreEqual(0f, root_child1_child3.LayoutX);
            Assert.AreEqual(20f, root_child1_child3.LayoutY);
            Assert.AreEqual(25f, root_child1_child3.LayoutWidth);
            Assert.AreEqual(10f, root_child1_child3.LayoutHeight);
        }

        [Test]
        public void Test_align_baseline_child_multiline_no_override_on_secondline()
        {
            YogaConfig config = new YogaConfig();

            YogaNode root = new YogaNode(config);
            root.FlexDirection = YogaFlexDirection.Row;
            root.AlignItems = YogaAlign.Baseline;
            root.Width = 100;
            root.Height = 100;

            YogaNode root_child0 = new YogaNode(config);
            root_child0.Width = 50;
            root_child0.Height = 60;
            root.Insert(0, root_child0);

            YogaNode root_child1 = new YogaNode(config);
            root_child1.FlexDirection = YogaFlexDirection.Row;
            root_child1.Wrap = YogaWrap.Wrap;
            root_child1.Width = 50;
            root_child1.Height = 25;
            root.Insert(1, root_child1);

            YogaNode root_child1_child0 = new YogaNode(config);
            root_child1_child0.Width = 25;
            root_child1_child0.Height = 20;
            root_child1.Insert(0, root_child1_child0);

            YogaNode root_child1_child1 = new YogaNode(config);
            root_child1_child1.Width = 25;
            root_child1_child1.Height = 10;
            root_child1.Insert(1, root_child1_child1);

            YogaNode root_child1_child2 = new YogaNode(config);
            root_child1_child2.Width = 25;
            root_child1_child2.Height = 20;
            root_child1.Insert(2, root_child1_child2);

            YogaNode root_child1_child3 = new YogaNode(config);
            root_child1_child3.AlignSelf = YogaAlign.Baseline;
            root_child1_child3.Width = 25;
            root_child1_child3.Height = 10;
            root_child1.Insert(3, root_child1_child3);
            root.StyleDirection = YogaDirection.LTR;
            root.CalculateLayout();

            Assert.AreEqual(0f, root.LayoutX);
            Assert.AreEqual(0f, root.LayoutY);
            Assert.AreEqual(100f, root.LayoutWidth);
            Assert.AreEqual(100f, root.LayoutHeight);

            Assert.AreEqual(0f, root_child0.LayoutX);
            Assert.AreEqual(0f, root_child0.LayoutY);
            Assert.AreEqual(50f, root_child0.LayoutWidth);
            Assert.AreEqual(60f, root_child0.LayoutHeight);

            Assert.AreEqual(50f, root_child1.LayoutX);
            Assert.AreEqual(40f, root_child1.LayoutY);
            Assert.AreEqual(50f, root_child1.LayoutWidth);
            Assert.AreEqual(25f, root_child1.LayoutHeight);

            Assert.AreEqual(0f, root_child1_child0.LayoutX);
            Assert.AreEqual(0f, root_child1_child0.LayoutY);
            Assert.AreEqual(25f, root_child1_child0.LayoutWidth);
            Assert.AreEqual(20f, root_child1_child0.LayoutHeight);

            Assert.AreEqual(25f, root_child1_child1.LayoutX);
            Assert.AreEqual(0f, root_child1_child1.LayoutY);
            Assert.AreEqual(25f, root_child1_child1.LayoutWidth);
            Assert.AreEqual(10f, root_child1_child1.LayoutHeight);

            Assert.AreEqual(0f, root_child1_child2.LayoutX);
            Assert.AreEqual(20f, root_child1_child2.LayoutY);
            Assert.AreEqual(25f, root_child1_child2.LayoutWidth);
            Assert.AreEqual(20f, root_child1_child2.LayoutHeight);

            Assert.AreEqual(25f, root_child1_child3.LayoutX);
            Assert.AreEqual(20f, root_child1_child3.LayoutY);
            Assert.AreEqual(25f, root_child1_child3.LayoutWidth);
            Assert.AreEqual(10f, root_child1_child3.LayoutHeight);

            root.StyleDirection = YogaDirection.RTL;
            root.CalculateLayout();

            Assert.AreEqual(0f, root.LayoutX);
            Assert.AreEqual(0f, root.LayoutY);
            Assert.AreEqual(100f, root.LayoutWidth);
            Assert.AreEqual(100f, root.LayoutHeight);

            Assert.AreEqual(50f, root_child0.LayoutX);
            Assert.AreEqual(0f, root_child0.LayoutY);
            Assert.AreEqual(50f, root_child0.LayoutWidth);
            Assert.AreEqual(60f, root_child0.LayoutHeight);

            Assert.AreEqual(0f, root_child1.LayoutX);
            Assert.AreEqual(40f, root_child1.LayoutY);
            Assert.AreEqual(50f, root_child1.LayoutWidth);
            Assert.AreEqual(25f, root_child1.LayoutHeight);

            Assert.AreEqual(25f, root_child1_child0.LayoutX);
            Assert.AreEqual(0f, root_child1_child0.LayoutY);
            Assert.AreEqual(25f, root_child1_child0.LayoutWidth);
            Assert.AreEqual(20f, root_child1_child0.LayoutHeight);

            Assert.AreEqual(0f, root_child1_child1.LayoutX);
            Assert.AreEqual(0f, root_child1_child1.LayoutY);
            Assert.AreEqual(25f, root_child1_child1.LayoutWidth);
            Assert.AreEqual(10f, root_child1_child1.LayoutHeight);

            Assert.AreEqual(25f, root_child1_child2.LayoutX);
            Assert.AreEqual(20f, root_child1_child2.LayoutY);
            Assert.AreEqual(25f, root_child1_child2.LayoutWidth);
            Assert.AreEqual(20f, root_child1_child2.LayoutHeight);

            Assert.AreEqual(0f, root_child1_child3.LayoutX);
            Assert.AreEqual(20f, root_child1_child3.LayoutY);
            Assert.AreEqual(25f, root_child1_child3.LayoutWidth);
            Assert.AreEqual(10f, root_child1_child3.LayoutHeight);
        }

        [Test]
        public void Test_align_baseline_child_top()
        {
            YogaConfig config = new YogaConfig();

            YogaNode root = new YogaNode(config);
            root.FlexDirection = YogaFlexDirection.Row;
            root.AlignItems = YogaAlign.Baseline;
            root.Width = 100;
            root.Height = 100;

            YogaNode root_child0 = new YogaNode(config);
            root_child0.Top = 10;
            root_child0.Width = 50;
            root_child0.Height = 50;
            root.Insert(0, root_child0);

            YogaNode root_child1 = new YogaNode(config);
            root_child1.Width = 50;
            root_child1.Height = 20;
            root.Insert(1, root_child1);

            YogaNode root_child1_child0 = new YogaNode(config);
            root_child1_child0.Width = 50;
            root_child1_child0.Height = 10;
            root_child1.Insert(0, root_child1_child0);
            root.StyleDirection = YogaDirection.LTR;
            root.CalculateLayout();

            Assert.AreEqual(0f, root.LayoutX);
            Assert.AreEqual(0f, root.LayoutY);
            Assert.AreEqual(100f, root.LayoutWidth);
            Assert.AreEqual(100f, root.LayoutHeight);

            Assert.AreEqual(0f, root_child0.LayoutX);
            Assert.AreEqual(10f, root_child0.LayoutY);
            Assert.AreEqual(50f, root_child0.LayoutWidth);
            Assert.AreEqual(50f, root_child0.LayoutHeight);

            Assert.AreEqual(50f, root_child1.LayoutX);
            Assert.AreEqual(40f, root_child1.LayoutY);
            Assert.AreEqual(50f, root_child1.LayoutWidth);
            Assert.AreEqual(20f, root_child1.LayoutHeight);

            Assert.AreEqual(0f, root_child1_child0.LayoutX);
            Assert.AreEqual(0f, root_child1_child0.LayoutY);
            Assert.AreEqual(50f, root_child1_child0.LayoutWidth);
            Assert.AreEqual(10f, root_child1_child0.LayoutHeight);

            root.StyleDirection = YogaDirection.RTL;
            root.CalculateLayout();

            Assert.AreEqual(0f, root.LayoutX);
            Assert.AreEqual(0f, root.LayoutY);
            Assert.AreEqual(100f, root.LayoutWidth);
            Assert.AreEqual(100f, root.LayoutHeight);

            Assert.AreEqual(50f, root_child0.LayoutX);
            Assert.AreEqual(10f, root_child0.LayoutY);
            Assert.AreEqual(50f, root_child0.LayoutWidth);
            Assert.AreEqual(50f, root_child0.LayoutHeight);

            Assert.AreEqual(0f, root_child1.LayoutX);
            Assert.AreEqual(40f, root_child1.LayoutY);
            Assert.AreEqual(50f, root_child1.LayoutWidth);
            Assert.AreEqual(20f, root_child1.LayoutHeight);

            Assert.AreEqual(0f, root_child1_child0.LayoutX);
            Assert.AreEqual(0f, root_child1_child0.LayoutY);
            Assert.AreEqual(50f, root_child1_child0.LayoutWidth);
            Assert.AreEqual(10f, root_child1_child0.LayoutHeight);
        }

        [Test]
        public void Test_align_baseline_child_top2()
        {
            YogaConfig config = new YogaConfig();

            YogaNode root = new YogaNode(config);
            root.FlexDirection = YogaFlexDirection.Row;
            root.AlignItems = YogaAlign.Baseline;
            root.Width = 100;
            root.Height = 100;

            YogaNode root_child0 = new YogaNode(config);
            root_child0.Width = 50;
            root_child0.Height = 50;
            root.Insert(0, root_child0);

            YogaNode root_child1 = new YogaNode(config);
            root_child1.Top = 5;
            root_child1.Width = 50;
            root_child1.Height = 20;
            root.Insert(1, root_child1);

            YogaNode root_child1_child0 = new YogaNode(config);
            root_child1_child0.Width = 50;
            root_child1_child0.Height = 10;
            root_child1.Insert(0, root_child1_child0);
            root.StyleDirection = YogaDirection.LTR;
            root.CalculateLayout();

            Assert.AreEqual(0f, root.LayoutX);
            Assert.AreEqual(0f, root.LayoutY);
            Assert.AreEqual(100f, root.LayoutWidth);
            Assert.AreEqual(100f, root.LayoutHeight);

            Assert.AreEqual(0f, root_child0.LayoutX);
            Assert.AreEqual(0f, root_child0.LayoutY);
            Assert.AreEqual(50f, root_child0.LayoutWidth);
            Assert.AreEqual(50f, root_child0.LayoutHeight);

            Assert.AreEqual(50f, root_child1.LayoutX);
            Assert.AreEqual(45f, root_child1.LayoutY);
            Assert.AreEqual(50f, root_child1.LayoutWidth);
            Assert.AreEqual(20f, root_child1.LayoutHeight);

            Assert.AreEqual(0f, root_child1_child0.LayoutX);
            Assert.AreEqual(0f, root_child1_child0.LayoutY);
            Assert.AreEqual(50f, root_child1_child0.LayoutWidth);
            Assert.AreEqual(10f, root_child1_child0.LayoutHeight);

            root.StyleDirection = YogaDirection.RTL;
            root.CalculateLayout();

            Assert.AreEqual(0f, root.LayoutX);
            Assert.AreEqual(0f, root.LayoutY);
            Assert.AreEqual(100f, root.LayoutWidth);
            Assert.AreEqual(100f, root.LayoutHeight);

            Assert.AreEqual(50f, root_child0.LayoutX);
            Assert.AreEqual(0f, root_child0.LayoutY);
            Assert.AreEqual(50f, root_child0.LayoutWidth);
            Assert.AreEqual(50f, root_child0.LayoutHeight);

            Assert.AreEqual(0f, root_child1.LayoutX);
            Assert.AreEqual(45f, root_child1.LayoutY);
            Assert.AreEqual(50f, root_child1.LayoutWidth);
            Assert.AreEqual(20f, root_child1.LayoutHeight);

            Assert.AreEqual(0f, root_child1_child0.LayoutX);
            Assert.AreEqual(0f, root_child1_child0.LayoutY);
            Assert.AreEqual(50f, root_child1_child0.LayoutWidth);
            Assert.AreEqual(10f, root_child1_child0.LayoutHeight);
        }

        [Test]
        public void Test_align_baseline_double_nested_child()
        {
            YogaConfig config = new YogaConfig();

            YogaNode root = new YogaNode(config);
            root.FlexDirection = YogaFlexDirection.Row;
            root.AlignItems = YogaAlign.Baseline;
            root.Width = 100;
            root.Height = 100;

            YogaNode root_child0 = new YogaNode(config);
            root_child0.Width = 50;
            root_child0.Height = 50;
            root.Insert(0, root_child0);

            YogaNode root_child0_child0 = new YogaNode(config);
            root_child0_child0.Width = 50;
            root_child0_child0.Height = 20;
            root_child0.Insert(0, root_child0_child0);

            YogaNode root_child1 = new YogaNode(config);
            root_child1.Width = 50;
            root_child1.Height = 20;
            root.Insert(1, root_child1);

            YogaNode root_child1_child0 = new YogaNode(config);
            root_child1_child0.Width = 50;
            root_child1_child0.Height = 15;
            root_child1.Insert(0, root_child1_child0);
            root.StyleDirection = YogaDirection.LTR;
            root.CalculateLayout();

            Assert.AreEqual(0f, root.LayoutX);
            Assert.AreEqual(0f, root.LayoutY);
            Assert.AreEqual(100f, root.LayoutWidth);
            Assert.AreEqual(100f, root.LayoutHeight);

            Assert.AreEqual(0f, root_child0.LayoutX);
            Assert.AreEqual(0f, root_child0.LayoutY);
            Assert.AreEqual(50f, root_child0.LayoutWidth);
            Assert.AreEqual(50f, root_child0.LayoutHeight);

            Assert.AreEqual(0f, root_child0_child0.LayoutX);
            Assert.AreEqual(0f, root_child0_child0.LayoutY);
            Assert.AreEqual(50f, root_child0_child0.LayoutWidth);
            Assert.AreEqual(20f, root_child0_child0.LayoutHeight);

            Assert.AreEqual(50f, root_child1.LayoutX);
            Assert.AreEqual(5f, root_child1.LayoutY);
            Assert.AreEqual(50f, root_child1.LayoutWidth);
            Assert.AreEqual(20f, root_child1.LayoutHeight);

            Assert.AreEqual(0f, root_child1_child0.LayoutX);
            Assert.AreEqual(0f, root_child1_child0.LayoutY);
            Assert.AreEqual(50f, root_child1_child0.LayoutWidth);
            Assert.AreEqual(15f, root_child1_child0.LayoutHeight);

            root.StyleDirection = YogaDirection.RTL;
            root.CalculateLayout();

            Assert.AreEqual(0f, root.LayoutX);
            Assert.AreEqual(0f, root.LayoutY);
            Assert.AreEqual(100f, root.LayoutWidth);
            Assert.AreEqual(100f, root.LayoutHeight);

            Assert.AreEqual(50f, root_child0.LayoutX);
            Assert.AreEqual(0f, root_child0.LayoutY);
            Assert.AreEqual(50f, root_child0.LayoutWidth);
            Assert.AreEqual(50f, root_child0.LayoutHeight);

            Assert.AreEqual(0f, root_child0_child0.LayoutX);
            Assert.AreEqual(0f, root_child0_child0.LayoutY);
            Assert.AreEqual(50f, root_child0_child0.LayoutWidth);
            Assert.AreEqual(20f, root_child0_child0.LayoutHeight);

            Assert.AreEqual(0f, root_child1.LayoutX);
            Assert.AreEqual(5f, root_child1.LayoutY);
            Assert.AreEqual(50f, root_child1.LayoutWidth);
            Assert.AreEqual(20f, root_child1.LayoutHeight);

            Assert.AreEqual(0f, root_child1_child0.LayoutX);
            Assert.AreEqual(0f, root_child1_child0.LayoutY);
            Assert.AreEqual(50f, root_child1_child0.LayoutWidth);
            Assert.AreEqual(15f, root_child1_child0.LayoutHeight);
        }

        [Test]
        public void Test_align_baseline_column()
        {
            YogaConfig config = new YogaConfig();

            YogaNode root = new YogaNode(config);
            root.AlignItems = YogaAlign.Baseline;
            root.Width = 100;
            root.Height = 100;

            YogaNode root_child0 = new YogaNode(config);
            root_child0.Width = 50;
            root_child0.Height = 50;
            root.Insert(0, root_child0);

            YogaNode root_child1 = new YogaNode(config);
            root_child1.Width = 50;
            root_child1.Height = 20;
            root.Insert(1, root_child1);
            root.StyleDirection = YogaDirection.LTR;
            root.CalculateLayout();

            Assert.AreEqual(0f, root.LayoutX);
            Assert.AreEqual(0f, root.LayoutY);
            Assert.AreEqual(100f, root.LayoutWidth);
            Assert.AreEqual(100f, root.LayoutHeight);

            Assert.AreEqual(0f, root_child0.LayoutX);
            Assert.AreEqual(0f, root_child0.LayoutY);
            Assert.AreEqual(50f, root_child0.LayoutWidth);
            Assert.AreEqual(50f, root_child0.LayoutHeight);

            Assert.AreEqual(0f, root_child1.LayoutX);
            Assert.AreEqual(50f, root_child1.LayoutY);
            Assert.AreEqual(50f, root_child1.LayoutWidth);
            Assert.AreEqual(20f, root_child1.LayoutHeight);

            root.StyleDirection = YogaDirection.RTL;
            root.CalculateLayout();

            Assert.AreEqual(0f, root.LayoutX);
            Assert.AreEqual(0f, root.LayoutY);
            Assert.AreEqual(100f, root.LayoutWidth);
            Assert.AreEqual(100f, root.LayoutHeight);

            Assert.AreEqual(50f, root_child0.LayoutX);
            Assert.AreEqual(0f, root_child0.LayoutY);
            Assert.AreEqual(50f, root_child0.LayoutWidth);
            Assert.AreEqual(50f, root_child0.LayoutHeight);

            Assert.AreEqual(50f, root_child1.LayoutX);
            Assert.AreEqual(50f, root_child1.LayoutY);
            Assert.AreEqual(50f, root_child1.LayoutWidth);
            Assert.AreEqual(20f, root_child1.LayoutHeight);
        }

        [Test]
        public void Test_align_baseline_child_margin()
        {
            YogaConfig config = new YogaConfig();

            YogaNode root = new YogaNode(config);
            root.FlexDirection = YogaFlexDirection.Row;
            root.AlignItems = YogaAlign.Baseline;
            root.Width = 100;
            root.Height = 100;

            YogaNode root_child0 = new YogaNode(config);
            root_child0.MarginLeft = 5;
            root_child0.MarginTop = 5;
            root_child0.MarginRight = 5;
            root_child0.MarginBottom = 5;
            root_child0.Width = 50;
            root_child0.Height = 50;
            root.Insert(0, root_child0);

            YogaNode root_child1 = new YogaNode(config);
            root_child1.Width = 50;
            root_child1.Height = 20;
            root.Insert(1, root_child1);

            YogaNode root_child1_child0 = new YogaNode(config);
            root_child1_child0.MarginLeft = 1;
            root_child1_child0.MarginTop = 1;
            root_child1_child0.MarginRight = 1;
            root_child1_child0.MarginBottom = 1;
            root_child1_child0.Width = 50;
            root_child1_child0.Height = 10;
            root_child1.Insert(0, root_child1_child0);
            root.StyleDirection = YogaDirection.LTR;
            root.CalculateLayout();

            Assert.AreEqual(0f, root.LayoutX);
            Assert.AreEqual(0f, root.LayoutY);
            Assert.AreEqual(100f, root.LayoutWidth);
            Assert.AreEqual(100f, root.LayoutHeight);

            Assert.AreEqual(5f, root_child0.LayoutX);
            Assert.AreEqual(5f, root_child0.LayoutY);
            Assert.AreEqual(50f, root_child0.LayoutWidth);
            Assert.AreEqual(50f, root_child0.LayoutHeight);

            Assert.AreEqual(60f, root_child1.LayoutX);
            Assert.AreEqual(44f, root_child1.LayoutY);
            Assert.AreEqual(50f, root_child1.LayoutWidth);
            Assert.AreEqual(20f, root_child1.LayoutHeight);

            Assert.AreEqual(1f, root_child1_child0.LayoutX);
            Assert.AreEqual(1f, root_child1_child0.LayoutY);
            Assert.AreEqual(50f, root_child1_child0.LayoutWidth);
            Assert.AreEqual(10f, root_child1_child0.LayoutHeight);

            root.StyleDirection = YogaDirection.RTL;
            root.CalculateLayout();

            Assert.AreEqual(0f, root.LayoutX);
            Assert.AreEqual(0f, root.LayoutY);
            Assert.AreEqual(100f, root.LayoutWidth);
            Assert.AreEqual(100f, root.LayoutHeight);

            Assert.AreEqual(45f, root_child0.LayoutX);
            Assert.AreEqual(5f, root_child0.LayoutY);
            Assert.AreEqual(50f, root_child0.LayoutWidth);
            Assert.AreEqual(50f, root_child0.LayoutHeight);

            Assert.AreEqual(-10f, root_child1.LayoutX);
            Assert.AreEqual(44f, root_child1.LayoutY);
            Assert.AreEqual(50f, root_child1.LayoutWidth);
            Assert.AreEqual(20f, root_child1.LayoutHeight);

            Assert.AreEqual(-1f, root_child1_child0.LayoutX);
            Assert.AreEqual(1f, root_child1_child0.LayoutY);
            Assert.AreEqual(50f, root_child1_child0.LayoutWidth);
            Assert.AreEqual(10f, root_child1_child0.LayoutHeight);
        }

        [Test]
        public void Test_align_baseline_child_padding()
        {
            YogaConfig config = new YogaConfig();

            YogaNode root = new YogaNode(config);
            root.FlexDirection = YogaFlexDirection.Row;
            root.AlignItems = YogaAlign.Baseline;
            root.PaddingLeft = 5;
            root.PaddingTop = 5;
            root.PaddingRight = 5;
            root.PaddingBottom = 5;
            root.Width = 100;
            root.Height = 100;

            YogaNode root_child0 = new YogaNode(config);
            root_child0.Width = 50;
            root_child0.Height = 50;
            root.Insert(0, root_child0);

            YogaNode root_child1 = new YogaNode(config);
            root_child1.PaddingLeft = 5;
            root_child1.PaddingTop = 5;
            root_child1.PaddingRight = 5;
            root_child1.PaddingBottom = 5;
            root_child1.Width = 50;
            root_child1.Height = 20;
            root.Insert(1, root_child1);

            YogaNode root_child1_child0 = new YogaNode(config);
            root_child1_child0.Width = 50;
            root_child1_child0.Height = 10;
            root_child1.Insert(0, root_child1_child0);
            root.StyleDirection = YogaDirection.LTR;
            root.CalculateLayout();

            Assert.AreEqual(0f, root.LayoutX);
            Assert.AreEqual(0f, root.LayoutY);
            Assert.AreEqual(100f, root.LayoutWidth);
            Assert.AreEqual(100f, root.LayoutHeight);

            Assert.AreEqual(5f, root_child0.LayoutX);
            Assert.AreEqual(5f, root_child0.LayoutY);
            Assert.AreEqual(50f, root_child0.LayoutWidth);
            Assert.AreEqual(50f, root_child0.LayoutHeight);

            Assert.AreEqual(55f, root_child1.LayoutX);
            Assert.AreEqual(40f, root_child1.LayoutY);
            Assert.AreEqual(50f, root_child1.LayoutWidth);
            Assert.AreEqual(20f, root_child1.LayoutHeight);

            Assert.AreEqual(5f, root_child1_child0.LayoutX);
            Assert.AreEqual(5f, root_child1_child0.LayoutY);
            Assert.AreEqual(50f, root_child1_child0.LayoutWidth);
            Assert.AreEqual(10f, root_child1_child0.LayoutHeight);

            root.StyleDirection = YogaDirection.RTL;
            root.CalculateLayout();

            Assert.AreEqual(0f, root.LayoutX);
            Assert.AreEqual(0f, root.LayoutY);
            Assert.AreEqual(100f, root.LayoutWidth);
            Assert.AreEqual(100f, root.LayoutHeight);

            Assert.AreEqual(45f, root_child0.LayoutX);
            Assert.AreEqual(5f, root_child0.LayoutY);
            Assert.AreEqual(50f, root_child0.LayoutWidth);
            Assert.AreEqual(50f, root_child0.LayoutHeight);

            Assert.AreEqual(-5f, root_child1.LayoutX);
            Assert.AreEqual(40f, root_child1.LayoutY);
            Assert.AreEqual(50f, root_child1.LayoutWidth);
            Assert.AreEqual(20f, root_child1.LayoutHeight);

            Assert.AreEqual(-5f, root_child1_child0.LayoutX);
            Assert.AreEqual(5f, root_child1_child0.LayoutY);
            Assert.AreEqual(50f, root_child1_child0.LayoutWidth);
            Assert.AreEqual(10f, root_child1_child0.LayoutHeight);
        }

        [Test]
        public void Test_align_baseline_multiline()
        {
            YogaConfig config = new YogaConfig();

            YogaNode root = new YogaNode(config);
            root.FlexDirection = YogaFlexDirection.Row;
            root.AlignItems = YogaAlign.Baseline;
            root.Wrap = YogaWrap.Wrap;
            root.Width = 100;
            root.Height = 100;

            YogaNode root_child0 = new YogaNode(config);
            root_child0.Width = 50;
            root_child0.Height = 50;
            root.Insert(0, root_child0);

            YogaNode root_child1 = new YogaNode(config);
            root_child1.Width = 50;
            root_child1.Height = 20;
            root.Insert(1, root_child1);

            YogaNode root_child1_child0 = new YogaNode(config);
            root_child1_child0.Width = 50;
            root_child1_child0.Height = 10;
            root_child1.Insert(0, root_child1_child0);

            YogaNode root_child2 = new YogaNode(config);
            root_child2.Width = 50;
            root_child2.Height = 20;
            root.Insert(2, root_child2);

            YogaNode root_child2_child0 = new YogaNode(config);
            root_child2_child0.Width = 50;
            root_child2_child0.Height = 10;
            root_child2.Insert(0, root_child2_child0);

            YogaNode root_child3 = new YogaNode(config);
            root_child3.Width = 50;
            root_child3.Height = 50;
            root.Insert(3, root_child3);
            root.StyleDirection = YogaDirection.LTR;
            root.CalculateLayout();

            Assert.AreEqual(0f, root.LayoutX);
            Assert.AreEqual(0f, root.LayoutY);
            Assert.AreEqual(100f, root.LayoutWidth);
            Assert.AreEqual(100f, root.LayoutHeight);

            Assert.AreEqual(0f, root_child0.LayoutX);
            Assert.AreEqual(0f, root_child0.LayoutY);
            Assert.AreEqual(50f, root_child0.LayoutWidth);
            Assert.AreEqual(50f, root_child0.LayoutHeight);

            Assert.AreEqual(50f, root_child1.LayoutX);
            Assert.AreEqual(40f, root_child1.LayoutY);
            Assert.AreEqual(50f, root_child1.LayoutWidth);
            Assert.AreEqual(20f, root_child1.LayoutHeight);

            Assert.AreEqual(0f, root_child1_child0.LayoutX);
            Assert.AreEqual(0f, root_child1_child0.LayoutY);
            Assert.AreEqual(50f, root_child1_child0.LayoutWidth);
            Assert.AreEqual(10f, root_child1_child0.LayoutHeight);

            Assert.AreEqual(0f, root_child2.LayoutX);
            Assert.AreEqual(100f, root_child2.LayoutY);
            Assert.AreEqual(50f, root_child2.LayoutWidth);
            Assert.AreEqual(20f, root_child2.LayoutHeight);

            Assert.AreEqual(0f, root_child2_child0.LayoutX);
            Assert.AreEqual(0f, root_child2_child0.LayoutY);
            Assert.AreEqual(50f, root_child2_child0.LayoutWidth);
            Assert.AreEqual(10f, root_child2_child0.LayoutHeight);

            Assert.AreEqual(50f, root_child3.LayoutX);
            Assert.AreEqual(60f, root_child3.LayoutY);
            Assert.AreEqual(50f, root_child3.LayoutWidth);
            Assert.AreEqual(50f, root_child3.LayoutHeight);

            root.StyleDirection = YogaDirection.RTL;
            root.CalculateLayout();

            Assert.AreEqual(0f, root.LayoutX);
            Assert.AreEqual(0f, root.LayoutY);
            Assert.AreEqual(100f, root.LayoutWidth);
            Assert.AreEqual(100f, root.LayoutHeight);

            Assert.AreEqual(50f, root_child0.LayoutX);
            Assert.AreEqual(0f, root_child0.LayoutY);
            Assert.AreEqual(50f, root_child0.LayoutWidth);
            Assert.AreEqual(50f, root_child0.LayoutHeight);

            Assert.AreEqual(0f, root_child1.LayoutX);
            Assert.AreEqual(40f, root_child1.LayoutY);
            Assert.AreEqual(50f, root_child1.LayoutWidth);
            Assert.AreEqual(20f, root_child1.LayoutHeight);

            Assert.AreEqual(0f, root_child1_child0.LayoutX);
            Assert.AreEqual(0f, root_child1_child0.LayoutY);
            Assert.AreEqual(50f, root_child1_child0.LayoutWidth);
            Assert.AreEqual(10f, root_child1_child0.LayoutHeight);

            Assert.AreEqual(50f, root_child2.LayoutX);
            Assert.AreEqual(100f, root_child2.LayoutY);
            Assert.AreEqual(50f, root_child2.LayoutWidth);
            Assert.AreEqual(20f, root_child2.LayoutHeight);

            Assert.AreEqual(0f, root_child2_child0.LayoutX);
            Assert.AreEqual(0f, root_child2_child0.LayoutY);
            Assert.AreEqual(50f, root_child2_child0.LayoutWidth);
            Assert.AreEqual(10f, root_child2_child0.LayoutHeight);

            Assert.AreEqual(0f, root_child3.LayoutX);
            Assert.AreEqual(60f, root_child3.LayoutY);
            Assert.AreEqual(50f, root_child3.LayoutWidth);
            Assert.AreEqual(50f, root_child3.LayoutHeight);
        }

        [Test]
        public void Test_align_baseline_multiline_column()
        {
            YogaConfig config = new YogaConfig();

            YogaNode root = new YogaNode(config);
            root.AlignItems = YogaAlign.Baseline;
            root.Wrap = YogaWrap.Wrap;
            root.Width = 100;
            root.Height = 100;

            YogaNode root_child0 = new YogaNode(config);
            root_child0.Width = 50;
            root_child0.Height = 50;
            root.Insert(0, root_child0);

            YogaNode root_child1 = new YogaNode(config);
            root_child1.Width = 30;
            root_child1.Height = 50;
            root.Insert(1, root_child1);

            YogaNode root_child1_child0 = new YogaNode(config);
            root_child1_child0.Width = 20;
            root_child1_child0.Height = 20;
            root_child1.Insert(0, root_child1_child0);

            YogaNode root_child2 = new YogaNode(config);
            root_child2.Width = 40;
            root_child2.Height = 70;
            root.Insert(2, root_child2);

            YogaNode root_child2_child0 = new YogaNode(config);
            root_child2_child0.Width = 10;
            root_child2_child0.Height = 10;
            root_child2.Insert(0, root_child2_child0);

            YogaNode root_child3 = new YogaNode(config);
            root_child3.Width = 50;
            root_child3.Height = 20;
            root.Insert(3, root_child3);
            root.StyleDirection = YogaDirection.LTR;
            root.CalculateLayout();

            Assert.AreEqual(0f, root.LayoutX);
            Assert.AreEqual(0f, root.LayoutY);
            Assert.AreEqual(100f, root.LayoutWidth);
            Assert.AreEqual(100f, root.LayoutHeight);

            Assert.AreEqual(0f, root_child0.LayoutX);
            Assert.AreEqual(0f, root_child0.LayoutY);
            Assert.AreEqual(50f, root_child0.LayoutWidth);
            Assert.AreEqual(50f, root_child0.LayoutHeight);

            Assert.AreEqual(0f, root_child1.LayoutX);
            Assert.AreEqual(50f, root_child1.LayoutY);
            Assert.AreEqual(30f, root_child1.LayoutWidth);
            Assert.AreEqual(50f, root_child1.LayoutHeight);

            Assert.AreEqual(0f, root_child1_child0.LayoutX);
            Assert.AreEqual(0f, root_child1_child0.LayoutY);
            Assert.AreEqual(20f, root_child1_child0.LayoutWidth);
            Assert.AreEqual(20f, root_child1_child0.LayoutHeight);

            Assert.AreEqual(50f, root_child2.LayoutX);
            Assert.AreEqual(0f, root_child2.LayoutY);
            Assert.AreEqual(40f, root_child2.LayoutWidth);
            Assert.AreEqual(70f, root_child2.LayoutHeight);

            Assert.AreEqual(0f, root_child2_child0.LayoutX);
            Assert.AreEqual(0f, root_child2_child0.LayoutY);
            Assert.AreEqual(10f, root_child2_child0.LayoutWidth);
            Assert.AreEqual(10f, root_child2_child0.LayoutHeight);

            Assert.AreEqual(50f, root_child3.LayoutX);
            Assert.AreEqual(70f, root_child3.LayoutY);
            Assert.AreEqual(50f, root_child3.LayoutWidth);
            Assert.AreEqual(20f, root_child3.LayoutHeight);

            root.StyleDirection = YogaDirection.RTL;
            root.CalculateLayout();

            Assert.AreEqual(0f, root.LayoutX);
            Assert.AreEqual(0f, root.LayoutY);
            Assert.AreEqual(100f, root.LayoutWidth);
            Assert.AreEqual(100f, root.LayoutHeight);

            Assert.AreEqual(50f, root_child0.LayoutX);
            Assert.AreEqual(0f, root_child0.LayoutY);
            Assert.AreEqual(50f, root_child0.LayoutWidth);
            Assert.AreEqual(50f, root_child0.LayoutHeight);

            Assert.AreEqual(70f, root_child1.LayoutX);
            Assert.AreEqual(50f, root_child1.LayoutY);
            Assert.AreEqual(30f, root_child1.LayoutWidth);
            Assert.AreEqual(50f, root_child1.LayoutHeight);

            Assert.AreEqual(10f, root_child1_child0.LayoutX);
            Assert.AreEqual(0f, root_child1_child0.LayoutY);
            Assert.AreEqual(20f, root_child1_child0.LayoutWidth);
            Assert.AreEqual(20f, root_child1_child0.LayoutHeight);

            Assert.AreEqual(10f, root_child2.LayoutX);
            Assert.AreEqual(0f, root_child2.LayoutY);
            Assert.AreEqual(40f, root_child2.LayoutWidth);
            Assert.AreEqual(70f, root_child2.LayoutHeight);

            Assert.AreEqual(30f, root_child2_child0.LayoutX);
            Assert.AreEqual(0f, root_child2_child0.LayoutY);
            Assert.AreEqual(10f, root_child2_child0.LayoutWidth);
            Assert.AreEqual(10f, root_child2_child0.LayoutHeight);

            Assert.AreEqual(0f, root_child3.LayoutX);
            Assert.AreEqual(70f, root_child3.LayoutY);
            Assert.AreEqual(50f, root_child3.LayoutWidth);
            Assert.AreEqual(20f, root_child3.LayoutHeight);
        }

        [Test]
        public void Test_align_baseline_multiline_column2()
        {
            YogaConfig config = new YogaConfig();

            YogaNode root = new YogaNode(config);
            root.AlignItems = YogaAlign.Baseline;
            root.Wrap = YogaWrap.Wrap;
            root.Width = 100;
            root.Height = 100;

            YogaNode root_child0 = new YogaNode(config);
            root_child0.Width = 50;
            root_child0.Height = 50;
            root.Insert(0, root_child0);

            YogaNode root_child1 = new YogaNode(config);
            root_child1.Width = 30;
            root_child1.Height = 50;
            root.Insert(1, root_child1);

            YogaNode root_child1_child0 = new YogaNode(config);
            root_child1_child0.Width = 20;
            root_child1_child0.Height = 20;
            root_child1.Insert(0, root_child1_child0);

            YogaNode root_child2 = new YogaNode(config);
            root_child2.Width = 40;
            root_child2.Height = 70;
            root.Insert(2, root_child2);

            YogaNode root_child2_child0 = new YogaNode(config);
            root_child2_child0.Width = 10;
            root_child2_child0.Height = 10;
            root_child2.Insert(0, root_child2_child0);

            YogaNode root_child3 = new YogaNode(config);
            root_child3.Width = 50;
            root_child3.Height = 20;
            root.Insert(3, root_child3);
            root.StyleDirection = YogaDirection.LTR;
            root.CalculateLayout();

            Assert.AreEqual(0f, root.LayoutX);
            Assert.AreEqual(0f, root.LayoutY);
            Assert.AreEqual(100f, root.LayoutWidth);
            Assert.AreEqual(100f, root.LayoutHeight);

            Assert.AreEqual(0f, root_child0.LayoutX);
            Assert.AreEqual(0f, root_child0.LayoutY);
            Assert.AreEqual(50f, root_child0.LayoutWidth);
            Assert.AreEqual(50f, root_child0.LayoutHeight);

            Assert.AreEqual(0f, root_child1.LayoutX);
            Assert.AreEqual(50f, root_child1.LayoutY);
            Assert.AreEqual(30f, root_child1.LayoutWidth);
            Assert.AreEqual(50f, root_child1.LayoutHeight);

            Assert.AreEqual(0f, root_child1_child0.LayoutX);
            Assert.AreEqual(0f, root_child1_child0.LayoutY);
            Assert.AreEqual(20f, root_child1_child0.LayoutWidth);
            Assert.AreEqual(20f, root_child1_child0.LayoutHeight);

            Assert.AreEqual(50f, root_child2.LayoutX);
            Assert.AreEqual(0f, root_child2.LayoutY);
            Assert.AreEqual(40f, root_child2.LayoutWidth);
            Assert.AreEqual(70f, root_child2.LayoutHeight);

            Assert.AreEqual(0f, root_child2_child0.LayoutX);
            Assert.AreEqual(0f, root_child2_child0.LayoutY);
            Assert.AreEqual(10f, root_child2_child0.LayoutWidth);
            Assert.AreEqual(10f, root_child2_child0.LayoutHeight);

            Assert.AreEqual(50f, root_child3.LayoutX);
            Assert.AreEqual(70f, root_child3.LayoutY);
            Assert.AreEqual(50f, root_child3.LayoutWidth);
            Assert.AreEqual(20f, root_child3.LayoutHeight);

            root.StyleDirection = YogaDirection.RTL;
            root.CalculateLayout();

            Assert.AreEqual(0f, root.LayoutX);
            Assert.AreEqual(0f, root.LayoutY);
            Assert.AreEqual(100f, root.LayoutWidth);
            Assert.AreEqual(100f, root.LayoutHeight);

            Assert.AreEqual(50f, root_child0.LayoutX);
            Assert.AreEqual(0f, root_child0.LayoutY);
            Assert.AreEqual(50f, root_child0.LayoutWidth);
            Assert.AreEqual(50f, root_child0.LayoutHeight);

            Assert.AreEqual(70f, root_child1.LayoutX);
            Assert.AreEqual(50f, root_child1.LayoutY);
            Assert.AreEqual(30f, root_child1.LayoutWidth);
            Assert.AreEqual(50f, root_child1.LayoutHeight);

            Assert.AreEqual(10f, root_child1_child0.LayoutX);
            Assert.AreEqual(0f, root_child1_child0.LayoutY);
            Assert.AreEqual(20f, root_child1_child0.LayoutWidth);
            Assert.AreEqual(20f, root_child1_child0.LayoutHeight);

            Assert.AreEqual(10f, root_child2.LayoutX);
            Assert.AreEqual(0f, root_child2.LayoutY);
            Assert.AreEqual(40f, root_child2.LayoutWidth);
            Assert.AreEqual(70f, root_child2.LayoutHeight);

            Assert.AreEqual(30f, root_child2_child0.LayoutX);
            Assert.AreEqual(0f, root_child2_child0.LayoutY);
            Assert.AreEqual(10f, root_child2_child0.LayoutWidth);
            Assert.AreEqual(10f, root_child2_child0.LayoutHeight);

            Assert.AreEqual(0f, root_child3.LayoutX);
            Assert.AreEqual(70f, root_child3.LayoutY);
            Assert.AreEqual(50f, root_child3.LayoutWidth);
            Assert.AreEqual(20f, root_child3.LayoutHeight);
        }

        [Test]
        public void Test_align_baseline_multiline_row_and_column()
        {
            YogaConfig config = new YogaConfig();

            YogaNode root = new YogaNode(config);
            root.FlexDirection = YogaFlexDirection.Row;
            root.AlignItems = YogaAlign.Baseline;
            root.Wrap = YogaWrap.Wrap;
            root.Width = 100;
            root.Height = 100;

            YogaNode root_child0 = new YogaNode(config);
            root_child0.Width = 50;
            root_child0.Height = 50;
            root.Insert(0, root_child0);

            YogaNode root_child1 = new YogaNode(config);
            root_child1.Width = 50;
            root_child1.Height = 50;
            root.Insert(1, root_child1);

            YogaNode root_child1_child0 = new YogaNode(config);
            root_child1_child0.Width = 50;
            root_child1_child0.Height = 10;
            root_child1.Insert(0, root_child1_child0);

            YogaNode root_child2 = new YogaNode(config);
            root_child2.Width = 50;
            root_child2.Height = 20;
            root.Insert(2, root_child2);

            YogaNode root_child2_child0 = new YogaNode(config);
            root_child2_child0.Width = 50;
            root_child2_child0.Height = 10;
            root_child2.Insert(0, root_child2_child0);

            YogaNode root_child3 = new YogaNode(config);
            root_child3.Width = 50;
            root_child3.Height = 20;
            root.Insert(3, root_child3);
            root.StyleDirection = YogaDirection.LTR;
            root.CalculateLayout();

            Assert.AreEqual(0f, root.LayoutX);
            Assert.AreEqual(0f, root.LayoutY);
            Assert.AreEqual(100f, root.LayoutWidth);
            Assert.AreEqual(100f, root.LayoutHeight);

            Assert.AreEqual(0f, root_child0.LayoutX);
            Assert.AreEqual(0f, root_child0.LayoutY);
            Assert.AreEqual(50f, root_child0.LayoutWidth);
            Assert.AreEqual(50f, root_child0.LayoutHeight);

            Assert.AreEqual(50f, root_child1.LayoutX);
            Assert.AreEqual(40f, root_child1.LayoutY);
            Assert.AreEqual(50f, root_child1.LayoutWidth);
            Assert.AreEqual(50f, root_child1.LayoutHeight);

            Assert.AreEqual(0f, root_child1_child0.LayoutX);
            Assert.AreEqual(0f, root_child1_child0.LayoutY);
            Assert.AreEqual(50f, root_child1_child0.LayoutWidth);
            Assert.AreEqual(10f, root_child1_child0.LayoutHeight);

            Assert.AreEqual(0f, root_child2.LayoutX);
            Assert.AreEqual(100f, root_child2.LayoutY);
            Assert.AreEqual(50f, root_child2.LayoutWidth);
            Assert.AreEqual(20f, root_child2.LayoutHeight);

            Assert.AreEqual(0f, root_child2_child0.LayoutX);
            Assert.AreEqual(0f, root_child2_child0.LayoutY);
            Assert.AreEqual(50f, root_child2_child0.LayoutWidth);
            Assert.AreEqual(10f, root_child2_child0.LayoutHeight);

            Assert.AreEqual(50f, root_child3.LayoutX);
            Assert.AreEqual(90f, root_child3.LayoutY);
            Assert.AreEqual(50f, root_child3.LayoutWidth);
            Assert.AreEqual(20f, root_child3.LayoutHeight);

            root.StyleDirection = YogaDirection.RTL;
            root.CalculateLayout();

            Assert.AreEqual(0f, root.LayoutX);
            Assert.AreEqual(0f, root.LayoutY);
            Assert.AreEqual(100f, root.LayoutWidth);
            Assert.AreEqual(100f, root.LayoutHeight);

            Assert.AreEqual(50f, root_child0.LayoutX);
            Assert.AreEqual(0f, root_child0.LayoutY);
            Assert.AreEqual(50f, root_child0.LayoutWidth);
            Assert.AreEqual(50f, root_child0.LayoutHeight);

            Assert.AreEqual(0f, root_child1.LayoutX);
            Assert.AreEqual(40f, root_child1.LayoutY);
            Assert.AreEqual(50f, root_child1.LayoutWidth);
            Assert.AreEqual(50f, root_child1.LayoutHeight);

            Assert.AreEqual(0f, root_child1_child0.LayoutX);
            Assert.AreEqual(0f, root_child1_child0.LayoutY);
            Assert.AreEqual(50f, root_child1_child0.LayoutWidth);
            Assert.AreEqual(10f, root_child1_child0.LayoutHeight);

            Assert.AreEqual(50f, root_child2.LayoutX);
            Assert.AreEqual(100f, root_child2.LayoutY);
            Assert.AreEqual(50f, root_child2.LayoutWidth);
            Assert.AreEqual(20f, root_child2.LayoutHeight);

            Assert.AreEqual(0f, root_child2_child0.LayoutX);
            Assert.AreEqual(0f, root_child2_child0.LayoutY);
            Assert.AreEqual(50f, root_child2_child0.LayoutWidth);
            Assert.AreEqual(10f, root_child2_child0.LayoutHeight);

            Assert.AreEqual(0f, root_child3.LayoutX);
            Assert.AreEqual(90f, root_child3.LayoutY);
            Assert.AreEqual(50f, root_child3.LayoutWidth);
            Assert.AreEqual(20f, root_child3.LayoutHeight);
        }

        [Test]
        public void Test_align_items_center_child_with_margin_bigger_than_parent()
        {
            YogaConfig config = new YogaConfig();

            YogaNode root = new YogaNode(config);
            root.JustifyContent = YogaJustify.Center;
            root.AlignItems = YogaAlign.Center;
            root.Width = 52;
            root.Height = 52;

            YogaNode root_child0 = new YogaNode(config);
            root_child0.AlignItems = YogaAlign.Center;
            root.Insert(0, root_child0);

            YogaNode root_child0_child0 = new YogaNode(config);
            root_child0_child0.MarginLeft = 10;
            root_child0_child0.MarginRight = 10;
            root_child0_child0.Width = 52;
            root_child0_child0.Height = 52;
            root_child0.Insert(0, root_child0_child0);
            root.StyleDirection = YogaDirection.LTR;
            root.CalculateLayout();

            Assert.AreEqual(0f, root.LayoutX);
            Assert.AreEqual(0f, root.LayoutY);
            Assert.AreEqual(52f, root.LayoutWidth);
            Assert.AreEqual(52f, root.LayoutHeight);

            Assert.AreEqual(-10f, root_child0.LayoutX);
            Assert.AreEqual(0f, root_child0.LayoutY);
            Assert.AreEqual(72f, root_child0.LayoutWidth);
            Assert.AreEqual(52f, root_child0.LayoutHeight);

            Assert.AreEqual(10f, root_child0_child0.LayoutX);
            Assert.AreEqual(0f, root_child0_child0.LayoutY);
            Assert.AreEqual(52f, root_child0_child0.LayoutWidth);
            Assert.AreEqual(52f, root_child0_child0.LayoutHeight);

            root.StyleDirection = YogaDirection.RTL;
            root.CalculateLayout();

            Assert.AreEqual(0f, root.LayoutX);
            Assert.AreEqual(0f, root.LayoutY);
            Assert.AreEqual(52f, root.LayoutWidth);
            Assert.AreEqual(52f, root.LayoutHeight);

            Assert.AreEqual(-10f, root_child0.LayoutX);
            Assert.AreEqual(0f, root_child0.LayoutY);
            Assert.AreEqual(72f, root_child0.LayoutWidth);
            Assert.AreEqual(52f, root_child0.LayoutHeight);

            Assert.AreEqual(10f, root_child0_child0.LayoutX);
            Assert.AreEqual(0f, root_child0_child0.LayoutY);
            Assert.AreEqual(52f, root_child0_child0.LayoutWidth);
            Assert.AreEqual(52f, root_child0_child0.LayoutHeight);
        }

        [Test]
        public void Test_align_items_flex_end_child_with_margin_bigger_than_parent()
        {
            YogaConfig config = new YogaConfig();

            YogaNode root = new YogaNode(config);
            root.JustifyContent = YogaJustify.Center;
            root.AlignItems = YogaAlign.Center;
            root.Width = 52;
            root.Height = 52;

            YogaNode root_child0 = new YogaNode(config);
            root_child0.AlignItems = YogaAlign.FlexEnd;
            root.Insert(0, root_child0);

            YogaNode root_child0_child0 = new YogaNode(config);
            root_child0_child0.MarginLeft = 10;
            root_child0_child0.MarginRight = 10;
            root_child0_child0.Width = 52;
            root_child0_child0.Height = 52;
            root_child0.Insert(0, root_child0_child0);
            root.StyleDirection = YogaDirection.LTR;
            root.CalculateLayout();

            Assert.AreEqual(0f, root.LayoutX);
            Assert.AreEqual(0f, root.LayoutY);
            Assert.AreEqual(52f, root.LayoutWidth);
            Assert.AreEqual(52f, root.LayoutHeight);

            Assert.AreEqual(-10f, root_child0.LayoutX);
            Assert.AreEqual(0f, root_child0.LayoutY);
            Assert.AreEqual(72f, root_child0.LayoutWidth);
            Assert.AreEqual(52f, root_child0.LayoutHeight);

            Assert.AreEqual(10f, root_child0_child0.LayoutX);
            Assert.AreEqual(0f, root_child0_child0.LayoutY);
            Assert.AreEqual(52f, root_child0_child0.LayoutWidth);
            Assert.AreEqual(52f, root_child0_child0.LayoutHeight);

            root.StyleDirection = YogaDirection.RTL;
            root.CalculateLayout();

            Assert.AreEqual(0f, root.LayoutX);
            Assert.AreEqual(0f, root.LayoutY);
            Assert.AreEqual(52f, root.LayoutWidth);
            Assert.AreEqual(52f, root.LayoutHeight);

            Assert.AreEqual(-10f, root_child0.LayoutX);
            Assert.AreEqual(0f, root_child0.LayoutY);
            Assert.AreEqual(72f, root_child0.LayoutWidth);
            Assert.AreEqual(52f, root_child0.LayoutHeight);

            Assert.AreEqual(10f, root_child0_child0.LayoutX);
            Assert.AreEqual(0f, root_child0_child0.LayoutY);
            Assert.AreEqual(52f, root_child0_child0.LayoutWidth);
            Assert.AreEqual(52f, root_child0_child0.LayoutHeight);
        }

        [Test]
        public void Test_align_items_center_child_without_margin_bigger_than_parent()
        {
            YogaConfig config = new YogaConfig();

            YogaNode root = new YogaNode(config);
            root.JustifyContent = YogaJustify.Center;
            root.AlignItems = YogaAlign.Center;
            root.Width = 52;
            root.Height = 52;

            YogaNode root_child0 = new YogaNode(config);
            root_child0.AlignItems = YogaAlign.Center;
            root.Insert(0, root_child0);

            YogaNode root_child0_child0 = new YogaNode(config);
            root_child0_child0.Width = 72;
            root_child0_child0.Height = 72;
            root_child0.Insert(0, root_child0_child0);
            root.StyleDirection = YogaDirection.LTR;
            root.CalculateLayout();

            Assert.AreEqual(0f, root.LayoutX);
            Assert.AreEqual(0f, root.LayoutY);
            Assert.AreEqual(52f, root.LayoutWidth);
            Assert.AreEqual(52f, root.LayoutHeight);

            Assert.AreEqual(-10f, root_child0.LayoutX);
            Assert.AreEqual(-10f, root_child0.LayoutY);
            Assert.AreEqual(72f, root_child0.LayoutWidth);
            Assert.AreEqual(72f, root_child0.LayoutHeight);

            Assert.AreEqual(0f, root_child0_child0.LayoutX);
            Assert.AreEqual(0f, root_child0_child0.LayoutY);
            Assert.AreEqual(72f, root_child0_child0.LayoutWidth);
            Assert.AreEqual(72f, root_child0_child0.LayoutHeight);

            root.StyleDirection = YogaDirection.RTL;
            root.CalculateLayout();

            Assert.AreEqual(0f, root.LayoutX);
            Assert.AreEqual(0f, root.LayoutY);
            Assert.AreEqual(52f, root.LayoutWidth);
            Assert.AreEqual(52f, root.LayoutHeight);

            Assert.AreEqual(-10f, root_child0.LayoutX);
            Assert.AreEqual(-10f, root_child0.LayoutY);
            Assert.AreEqual(72f, root_child0.LayoutWidth);
            Assert.AreEqual(72f, root_child0.LayoutHeight);

            Assert.AreEqual(0f, root_child0_child0.LayoutX);
            Assert.AreEqual(0f, root_child0_child0.LayoutY);
            Assert.AreEqual(72f, root_child0_child0.LayoutWidth);
            Assert.AreEqual(72f, root_child0_child0.LayoutHeight);
        }

        [Test]
        public void Test_align_items_flex_end_child_without_margin_bigger_than_parent()
        {
            YogaConfig config = new YogaConfig();

            YogaNode root = new YogaNode(config);
            root.JustifyContent = YogaJustify.Center;
            root.AlignItems = YogaAlign.Center;
            root.Width = 52;
            root.Height = 52;

            YogaNode root_child0 = new YogaNode(config);
            root_child0.AlignItems = YogaAlign.FlexEnd;
            root.Insert(0, root_child0);

            YogaNode root_child0_child0 = new YogaNode(config);
            root_child0_child0.Width = 72;
            root_child0_child0.Height = 72;
            root_child0.Insert(0, root_child0_child0);
            root.StyleDirection = YogaDirection.LTR;
            root.CalculateLayout();

            Assert.AreEqual(0f, root.LayoutX);
            Assert.AreEqual(0f, root.LayoutY);
            Assert.AreEqual(52f, root.LayoutWidth);
            Assert.AreEqual(52f, root.LayoutHeight);

            Assert.AreEqual(-10f, root_child0.LayoutX);
            Assert.AreEqual(-10f, root_child0.LayoutY);
            Assert.AreEqual(72f, root_child0.LayoutWidth);
            Assert.AreEqual(72f, root_child0.LayoutHeight);

            Assert.AreEqual(0f, root_child0_child0.LayoutX);
            Assert.AreEqual(0f, root_child0_child0.LayoutY);
            Assert.AreEqual(72f, root_child0_child0.LayoutWidth);
            Assert.AreEqual(72f, root_child0_child0.LayoutHeight);

            root.StyleDirection = YogaDirection.RTL;
            root.CalculateLayout();

            Assert.AreEqual(0f, root.LayoutX);
            Assert.AreEqual(0f, root.LayoutY);
            Assert.AreEqual(52f, root.LayoutWidth);
            Assert.AreEqual(52f, root.LayoutHeight);

            Assert.AreEqual(-10f, root_child0.LayoutX);
            Assert.AreEqual(-10f, root_child0.LayoutY);
            Assert.AreEqual(72f, root_child0.LayoutWidth);
            Assert.AreEqual(72f, root_child0.LayoutHeight);

            Assert.AreEqual(0f, root_child0_child0.LayoutX);
            Assert.AreEqual(0f, root_child0_child0.LayoutY);
            Assert.AreEqual(72f, root_child0_child0.LayoutWidth);
            Assert.AreEqual(72f, root_child0_child0.LayoutHeight);
        }

        [Test]
        public void Test_align_center_should_size_based_on_content()
        {
            YogaConfig config = new YogaConfig();

            YogaNode root = new YogaNode(config);
            root.AlignItems = YogaAlign.Center;
            root.MarginTop = 20;
            root.Width = 100;
            root.Height = 100;

            YogaNode root_child0 = new YogaNode(config);
            root_child0.JustifyContent = YogaJustify.Center;
            root_child0.FlexShrink = 1;
            root.Insert(0, root_child0);

            YogaNode root_child0_child0 = new YogaNode(config);
            root_child0_child0.FlexGrow = 1;
            root_child0_child0.FlexShrink = 1;
            root_child0.Insert(0, root_child0_child0);

            YogaNode root_child0_child0_child0 = new YogaNode(config);
            root_child0_child0_child0.Width = 20;
            root_child0_child0_child0.Height = 20;
            root_child0_child0.Insert(0, root_child0_child0_child0);
            root.StyleDirection = YogaDirection.LTR;
            root.CalculateLayout();

            Assert.AreEqual(0f, root.LayoutX);
            Assert.AreEqual(20f, root.LayoutY);
            Assert.AreEqual(100f, root.LayoutWidth);
            Assert.AreEqual(100f, root.LayoutHeight);

            Assert.AreEqual(40f, root_child0.LayoutX);
            Assert.AreEqual(0f, root_child0.LayoutY);
            Assert.AreEqual(20f, root_child0.LayoutWidth);
            Assert.AreEqual(20f, root_child0.LayoutHeight);

            Assert.AreEqual(0f, root_child0_child0.LayoutX);
            Assert.AreEqual(0f, root_child0_child0.LayoutY);
            Assert.AreEqual(20f, root_child0_child0.LayoutWidth);
            Assert.AreEqual(20f, root_child0_child0.LayoutHeight);

            Assert.AreEqual(0f, root_child0_child0_child0.LayoutX);
            Assert.AreEqual(0f, root_child0_child0_child0.LayoutY);
            Assert.AreEqual(20f, root_child0_child0_child0.LayoutWidth);
            Assert.AreEqual(20f, root_child0_child0_child0.LayoutHeight);

            root.StyleDirection = YogaDirection.RTL;
            root.CalculateLayout();

            Assert.AreEqual(0f, root.LayoutX);
            Assert.AreEqual(20f, root.LayoutY);
            Assert.AreEqual(100f, root.LayoutWidth);
            Assert.AreEqual(100f, root.LayoutHeight);

            Assert.AreEqual(40f, root_child0.LayoutX);
            Assert.AreEqual(0f, root_child0.LayoutY);
            Assert.AreEqual(20f, root_child0.LayoutWidth);
            Assert.AreEqual(20f, root_child0.LayoutHeight);

            Assert.AreEqual(0f, root_child0_child0.LayoutX);
            Assert.AreEqual(0f, root_child0_child0.LayoutY);
            Assert.AreEqual(20f, root_child0_child0.LayoutWidth);
            Assert.AreEqual(20f, root_child0_child0.LayoutHeight);

            Assert.AreEqual(0f, root_child0_child0_child0.LayoutX);
            Assert.AreEqual(0f, root_child0_child0_child0.LayoutY);
            Assert.AreEqual(20f, root_child0_child0_child0.LayoutWidth);
            Assert.AreEqual(20f, root_child0_child0_child0.LayoutHeight);
        }

        [Test]
        public void Test_align_strech_should_size_based_on_parent()
        {
            YogaConfig config = new YogaConfig();

            YogaNode root = new YogaNode(config);
            root.MarginTop = 20;
            root.Width = 100;
            root.Height = 100;

            YogaNode root_child0 = new YogaNode(config);
            root_child0.JustifyContent = YogaJustify.Center;
            root_child0.FlexShrink = 1;
            root.Insert(0, root_child0);

            YogaNode root_child0_child0 = new YogaNode(config);
            root_child0_child0.FlexGrow = 1;
            root_child0_child0.FlexShrink = 1;
            root_child0.Insert(0, root_child0_child0);

            YogaNode root_child0_child0_child0 = new YogaNode(config);
            root_child0_child0_child0.Width = 20;
            root_child0_child0_child0.Height = 20;
            root_child0_child0.Insert(0, root_child0_child0_child0);
            root.StyleDirection = YogaDirection.LTR;
            root.CalculateLayout();

            Assert.AreEqual(0f, root.LayoutX);
            Assert.AreEqual(20f, root.LayoutY);
            Assert.AreEqual(100f, root.LayoutWidth);
            Assert.AreEqual(100f, root.LayoutHeight);

            Assert.AreEqual(0f, root_child0.LayoutX);
            Assert.AreEqual(0f, root_child0.LayoutY);
            Assert.AreEqual(100f, root_child0.LayoutWidth);
            Assert.AreEqual(20f, root_child0.LayoutHeight);

            Assert.AreEqual(0f, root_child0_child0.LayoutX);
            Assert.AreEqual(0f, root_child0_child0.LayoutY);
            Assert.AreEqual(100f, root_child0_child0.LayoutWidth);
            Assert.AreEqual(20f, root_child0_child0.LayoutHeight);

            Assert.AreEqual(0f, root_child0_child0_child0.LayoutX);
            Assert.AreEqual(0f, root_child0_child0_child0.LayoutY);
            Assert.AreEqual(20f, root_child0_child0_child0.LayoutWidth);
            Assert.AreEqual(20f, root_child0_child0_child0.LayoutHeight);

            root.StyleDirection = YogaDirection.RTL;
            root.CalculateLayout();

            Assert.AreEqual(0f, root.LayoutX);
            Assert.AreEqual(20f, root.LayoutY);
            Assert.AreEqual(100f, root.LayoutWidth);
            Assert.AreEqual(100f, root.LayoutHeight);

            Assert.AreEqual(0f, root_child0.LayoutX);
            Assert.AreEqual(0f, root_child0.LayoutY);
            Assert.AreEqual(100f, root_child0.LayoutWidth);
            Assert.AreEqual(20f, root_child0.LayoutHeight);

            Assert.AreEqual(0f, root_child0_child0.LayoutX);
            Assert.AreEqual(0f, root_child0_child0.LayoutY);
            Assert.AreEqual(100f, root_child0_child0.LayoutWidth);
            Assert.AreEqual(20f, root_child0_child0.LayoutHeight);

            Assert.AreEqual(80f, root_child0_child0_child0.LayoutX);
            Assert.AreEqual(0f, root_child0_child0_child0.LayoutY);
            Assert.AreEqual(20f, root_child0_child0_child0.LayoutWidth);
            Assert.AreEqual(20f, root_child0_child0_child0.LayoutHeight);
        }

        [Test]
        public void Test_align_flex_start_with_shrinking_children()
        {
            YogaConfig config = new YogaConfig();

            YogaNode root = new YogaNode(config);
            root.Width = 500;
            root.Height = 500;

            YogaNode root_child0 = new YogaNode(config);
            root_child0.AlignItems = YogaAlign.FlexStart;
            root.Insert(0, root_child0);

            YogaNode root_child0_child0 = new YogaNode(config);
            root_child0_child0.FlexGrow = 1;
            root_child0_child0.FlexShrink = 1;
            root_child0.Insert(0, root_child0_child0);

            YogaNode root_child0_child0_child0 = new YogaNode(config);
            root_child0_child0_child0.FlexGrow = 1;
            root_child0_child0_child0.FlexShrink = 1;
            root_child0_child0.Insert(0, root_child0_child0_child0);
            root.StyleDirection = YogaDirection.LTR;
            root.CalculateLayout();

            Assert.AreEqual(0f, root.LayoutX);
            Assert.AreEqual(0f, root.LayoutY);
            Assert.AreEqual(500f, root.LayoutWidth);
            Assert.AreEqual(500f, root.LayoutHeight);

            Assert.AreEqual(0f, root_child0.LayoutX);
            Assert.AreEqual(0f, root_child0.LayoutY);
            Assert.AreEqual(500f, root_child0.LayoutWidth);
            Assert.AreEqual(0f, root_child0.LayoutHeight);

            Assert.AreEqual(0f, root_child0_child0.LayoutX);
            Assert.AreEqual(0f, root_child0_child0.LayoutY);
            Assert.AreEqual(0f, root_child0_child0.LayoutWidth);
            Assert.AreEqual(0f, root_child0_child0.LayoutHeight);

            Assert.AreEqual(0f, root_child0_child0_child0.LayoutX);
            Assert.AreEqual(0f, root_child0_child0_child0.LayoutY);
            Assert.AreEqual(0f, root_child0_child0_child0.LayoutWidth);
            Assert.AreEqual(0f, root_child0_child0_child0.LayoutHeight);

            root.StyleDirection = YogaDirection.RTL;
            root.CalculateLayout();

            Assert.AreEqual(0f, root.LayoutX);
            Assert.AreEqual(0f, root.LayoutY);
            Assert.AreEqual(500f, root.LayoutWidth);
            Assert.AreEqual(500f, root.LayoutHeight);

            Assert.AreEqual(0f, root_child0.LayoutX);
            Assert.AreEqual(0f, root_child0.LayoutY);
            Assert.AreEqual(500f, root_child0.LayoutWidth);
            Assert.AreEqual(0f, root_child0.LayoutHeight);

            Assert.AreEqual(500f, root_child0_child0.LayoutX);
            Assert.AreEqual(0f, root_child0_child0.LayoutY);
            Assert.AreEqual(0f, root_child0_child0.LayoutWidth);
            Assert.AreEqual(0f, root_child0_child0.LayoutHeight);

            Assert.AreEqual(0f, root_child0_child0_child0.LayoutX);
            Assert.AreEqual(0f, root_child0_child0_child0.LayoutY);
            Assert.AreEqual(0f, root_child0_child0_child0.LayoutWidth);
            Assert.AreEqual(0f, root_child0_child0_child0.LayoutHeight);
        }

        [Test]
        public void Test_align_flex_start_with_stretching_children()
        {
            YogaConfig config = new YogaConfig();

            YogaNode root = new YogaNode(config);
            root.Width = 500;
            root.Height = 500;

            YogaNode root_child0 = new YogaNode(config);
            root.Insert(0, root_child0);

            YogaNode root_child0_child0 = new YogaNode(config);
            root_child0_child0.FlexGrow = 1;
            root_child0_child0.FlexShrink = 1;
            root_child0.Insert(0, root_child0_child0);

            YogaNode root_child0_child0_child0 = new YogaNode(config);
            root_child0_child0_child0.FlexGrow = 1;
            root_child0_child0_child0.FlexShrink = 1;
            root_child0_child0.Insert(0, root_child0_child0_child0);
            root.StyleDirection = YogaDirection.LTR;
            root.CalculateLayout();

            Assert.AreEqual(0f, root.LayoutX);
            Assert.AreEqual(0f, root.LayoutY);
            Assert.AreEqual(500f, root.LayoutWidth);
            Assert.AreEqual(500f, root.LayoutHeight);

            Assert.AreEqual(0f, root_child0.LayoutX);
            Assert.AreEqual(0f, root_child0.LayoutY);
            Assert.AreEqual(500f, root_child0.LayoutWidth);
            Assert.AreEqual(0f, root_child0.LayoutHeight);

            Assert.AreEqual(0f, root_child0_child0.LayoutX);
            Assert.AreEqual(0f, root_child0_child0.LayoutY);
            Assert.AreEqual(500f, root_child0_child0.LayoutWidth);
            Assert.AreEqual(0f, root_child0_child0.LayoutHeight);

            Assert.AreEqual(0f, root_child0_child0_child0.LayoutX);
            Assert.AreEqual(0f, root_child0_child0_child0.LayoutY);
            Assert.AreEqual(500f, root_child0_child0_child0.LayoutWidth);
            Assert.AreEqual(0f, root_child0_child0_child0.LayoutHeight);

            root.StyleDirection = YogaDirection.RTL;
            root.CalculateLayout();

            Assert.AreEqual(0f, root.LayoutX);
            Assert.AreEqual(0f, root.LayoutY);
            Assert.AreEqual(500f, root.LayoutWidth);
            Assert.AreEqual(500f, root.LayoutHeight);

            Assert.AreEqual(0f, root_child0.LayoutX);
            Assert.AreEqual(0f, root_child0.LayoutY);
            Assert.AreEqual(500f, root_child0.LayoutWidth);
            Assert.AreEqual(0f, root_child0.LayoutHeight);

            Assert.AreEqual(0f, root_child0_child0.LayoutX);
            Assert.AreEqual(0f, root_child0_child0.LayoutY);
            Assert.AreEqual(500f, root_child0_child0.LayoutWidth);
            Assert.AreEqual(0f, root_child0_child0.LayoutHeight);

            Assert.AreEqual(0f, root_child0_child0_child0.LayoutX);
            Assert.AreEqual(0f, root_child0_child0_child0.LayoutY);
            Assert.AreEqual(500f, root_child0_child0_child0.LayoutWidth);
            Assert.AreEqual(0f, root_child0_child0_child0.LayoutHeight);
        }

        [Test]
        public void Test_align_flex_start_with_shrinking_children_with_stretch()
        {
            YogaConfig config = new YogaConfig();

            YogaNode root = new YogaNode(config);
            root.Width = 500;
            root.Height = 500;

            YogaNode root_child0 = new YogaNode(config);
            root_child0.AlignItems = YogaAlign.FlexStart;
            root.Insert(0, root_child0);

            YogaNode root_child0_child0 = new YogaNode(config);
            root_child0_child0.FlexGrow = 1;
            root_child0_child0.FlexShrink = 1;
            root_child0.Insert(0, root_child0_child0);

            YogaNode root_child0_child0_child0 = new YogaNode(config);
            root_child0_child0_child0.FlexGrow = 1;
            root_child0_child0_child0.FlexShrink = 1;
            root_child0_child0.Insert(0, root_child0_child0_child0);
            root.StyleDirection = YogaDirection.LTR;
            root.CalculateLayout();

            Assert.AreEqual(0f, root.LayoutX);
            Assert.AreEqual(0f, root.LayoutY);
            Assert.AreEqual(500f, root.LayoutWidth);
            Assert.AreEqual(500f, root.LayoutHeight);

            Assert.AreEqual(0f, root_child0.LayoutX);
            Assert.AreEqual(0f, root_child0.LayoutY);
            Assert.AreEqual(500f, root_child0.LayoutWidth);
            Assert.AreEqual(0f, root_child0.LayoutHeight);

            Assert.AreEqual(0f, root_child0_child0.LayoutX);
            Assert.AreEqual(0f, root_child0_child0.LayoutY);
            Assert.AreEqual(0f, root_child0_child0.LayoutWidth);
            Assert.AreEqual(0f, root_child0_child0.LayoutHeight);

            Assert.AreEqual(0f, root_child0_child0_child0.LayoutX);
            Assert.AreEqual(0f, root_child0_child0_child0.LayoutY);
            Assert.AreEqual(0f, root_child0_child0_child0.LayoutWidth);
            Assert.AreEqual(0f, root_child0_child0_child0.LayoutHeight);

            root.StyleDirection = YogaDirection.RTL;
            root.CalculateLayout();

            Assert.AreEqual(0f, root.LayoutX);
            Assert.AreEqual(0f, root.LayoutY);
            Assert.AreEqual(500f, root.LayoutWidth);
            Assert.AreEqual(500f, root.LayoutHeight);

            Assert.AreEqual(0f, root_child0.LayoutX);
            Assert.AreEqual(0f, root_child0.LayoutY);
            Assert.AreEqual(500f, root_child0.LayoutWidth);
            Assert.AreEqual(0f, root_child0.LayoutHeight);

            Assert.AreEqual(500f, root_child0_child0.LayoutX);
            Assert.AreEqual(0f, root_child0_child0.LayoutY);
            Assert.AreEqual(0f, root_child0_child0.LayoutWidth);
            Assert.AreEqual(0f, root_child0_child0.LayoutHeight);

            Assert.AreEqual(0f, root_child0_child0_child0.LayoutX);
            Assert.AreEqual(0f, root_child0_child0_child0.LayoutY);
            Assert.AreEqual(0f, root_child0_child0_child0.LayoutWidth);
            Assert.AreEqual(0f, root_child0_child0_child0.LayoutHeight);
        }

    }
}
