class Scientist_Staff_Slots extends X2StrategyElement_DefaultStaffSlots;
//---------------------------------------------------------------------------------------
//#############################################################################################
//----------------  MODDED PSI CHAMBER   ------------------------------------------------------------
//#############################################################################################

static function X2DataTemplate CreatePsiChamberEngineerStaffSlotTemplate()
{
	local X2StaffSlotTemplate Template;

	`CREATE_X2TEMPLATE(class'X2StaffSlotTemplate', Template, 'PsiChamberScientistStaffSlot');
	Template.bEngineerSlot = false;
	Template.bScientistSlot = true;
	Template.FillFn = FillPsiChamberEngSlot;
	Template.EmptyFn = EmptyPsiChamberEngSlot;
	Template.ShouldDisplayToDoWarningFn = ShouldDisplayPsiChamberEngToDoWarning;
	Template.GetContributionFromSkillFn = GetContributionDefault;
	Template.GetAvengerBonusAmountFn = GetPsiChamberScientistAvengerBonus;
	Template.GetNameDisplayStringFn = GetNameDisplayStringDefault;
	Template.GetSkillDisplayStringFn = GetSkillDisplayStringDefault;
	Template.GetBonusDisplayStringFn = GetPsiChamberScientistBonusDisplayString;
	Template.GetLocationDisplayStringFn = GetLocationDisplayStringDefault;
	Template.IsUnitValidForSlotFn = IsUnitValidForSlotDefault;
	Template.IsStaffSlotBusyFn = IsStaffSlotBusyDefault;
	Template.MatineeSlotName = "Scientist";

	return Template;
}

static function int GetPsiChamberScientistAvengerBonus(XComGameState_Unit Unit, optional bool bPreview)
{
	local XComGameState_HeadquartersXCom XComHQ;
	local float PercentIncrease;
	local int NewWorkPerHour;

	XComHQ = class'UIUtilities_Strategy'.static.GetXComHQ();

	// Need to return the percent increase in overall training speed provided by this unit
	NewWorkPerHour = GetContributionDefault(Unit) + XComHQ.XComHeadquarters_DefaultPsiTrainingWorkPerHour;
	PercentIncrease = (GetContributionDefault(Unit) * 100.0) / NewWorkPerHour;

	return Round(PercentIncrease);
}

static function FillPsiChamberEngSlot(XComGameState NewGameState, StateObjectReference SlotRef, StaffUnitInfo UnitInfo)
{
	local XComGameState_HeadquartersXCom NewXComHQ;
	local XComGameState_Unit NewUnitState;
	local XComGameState_StaffSlot NewSlotState;

	FillSlot(NewGameState, SlotRef, UnitInfo, NewSlotState, NewUnitState);
	NewUnitState.SkillLevelBonus += -1;
	NewXComHQ = GetNewXComHQState(NewGameState);

	NewXComHQ.PsiTrainingRate += NewSlotState.GetMyTemplate().GetContributionFromSkillFn(NewUnitState);
}

static function EmptyPsiChamberEngSlot(XComGameState NewGameState, StateObjectReference SlotRef)
{
	local XComGameState_HeadquartersXCom NewXComHQ;
	local XComGameState_StaffSlot NewSlotState;
	local XComGameState_Unit NewUnitState;

	EmptySlot(NewGameState, SlotRef, NewSlotState, NewUnitState);
	NewUnitState.SkillLevelBonus += 1;
	NewXComHQ = GetNewXComHQState(NewGameState);

	NewXComHQ.PsiTrainingRate -= NewSlotState.GetMyTemplate().GetContributionFromSkillFn(NewUnitState);
}

static function bool ShouldDisplayPsiChamberEngToDoWarning(StateObjectReference SlotRef)
{
	local XComGameState_StaffSlot SlotState;
	
	SlotState = XComGameState_StaffSlot(`XCOMHISTORY.GetGameStateForObjectID(SlotRef.ObjectID));

	return (SlotState.GetFacility().HasFilledSoldierSlot());
}

static function string GetPsiChamberScientistBonusDisplayString(XComGameState_StaffSlot SlotState, optional bool bPreview)
{
	local string Contribution;

	if (SlotState.IsSlotFilled())
	{
		Contribution = string(GetPsiChamberScientistAvengerBonus(SlotState.GetAssignedStaff(), bPreview));
	}

	return GetBonusDisplayString(SlotState, "%AVENGERBONUS", Contribution);
}
//#############################################################################################
//----------------  MODDED ADVANCED WARFARE CENTER   ------------------------------------------------
//#############################################################################################

static function X2DataTemplate CreateAWCEngineerStaffSlotTemplate()
{
	local X2StaffSlotTemplate Template;

	`CREATE_X2TEMPLATE(class'X2StaffSlotTemplate', Template, 'AWCScientistStaffSlot');
	Template.bEngineerSlot = false;
	Template.bScientistSlot = true;
	Template.FillFn = FillAWCEngSlot;
	Template.EmptyFn = EmptyAWCEngSlot;
	Template.ShouldDisplayToDoWarningFn = ShouldDisplayAWCEngToDoWarning;
	Template.GetContributionFromSkillFn = GetAWCContribution;
	Template.GetAvengerBonusAmountFn = GetAWCAvengerBonus;
	Template.GetNameDisplayStringFn = GetNameDisplayStringDefault;
	Template.GetSkillDisplayStringFn = GetSkillDisplayStringDefault;
	Template.GetBonusDisplayStringFn = GetAWCBonusDisplayString;
	Template.GetLocationDisplayStringFn = GetLocationDisplayStringDefault;
	Template.IsUnitValidForSlotFn = IsUnitValidForSlotDefault;
	Template.IsStaffSlotBusyFn = IsStaffSlotBusyDefault;
	Template.MatineeSlotName = "Scientist";

	return Template;
}

static function int GetAWCContribution(XComGameState_Unit UnitState)
{
	local XComGameState_HeadquartersXCom XComHQ;

	XComHQ = class'UIUtilities_Strategy'.static.GetXComHQ();
	
	return GetContributionDefault(UnitState) * (XComHQ.XComHeadquarters_BaseHealRate / 5);
}

static function int GetAWCAvengerBonus(XComGameState_Unit UnitState, optional bool bPreview)
{
	local XComGameState_HeadquartersXCom XComHQ;
	local float PercentIncrease;

	XComHQ = class'UIUtilities_Strategy'.static.GetXComHQ();

	// Need to return the percent increase in overall healing speed provided by this unit
	PercentIncrease = (GetAWCContribution(UnitState) * 100.0) / (XComHQ.XComHeadquarters_BaseHealRate);

	return Round(PercentIncrease);
}

static function FillAWCEngSlot(XComGameState NewGameState, StateObjectReference SlotRef, StaffUnitInfo UnitInfo)
{
	local XComGameState_HeadquartersXCom NewXComHQ;
	local XComGameState_Unit NewUnitState;
	local XComGameState_StaffSlot NewSlotState;

	FillSlot(NewGameState, SlotRef, UnitInfo, NewSlotState, NewUnitState);
	NewUnitState.SkillLevelBonus += -1;
	NewXComHQ = GetNewXComHQState(NewGameState);
	
	NewXComHQ.HealingRate += GetAWCContribution(NewUnitState);
}

static function EmptyAWCEngSlot(XComGameState NewGameState, StateObjectReference SlotRef)
{
	local XComGameState_HeadquartersXCom NewXComHQ;
	local XComGameState_StaffSlot NewSlotState;
	local XComGameState_Unit NewUnitState;

	EmptySlot(NewGameState, SlotRef, NewSlotState, NewUnitState);
	NewXComHQ = GetNewXComHQState(NewGameState);

	NewXComHQ.HealingRate -= GetAWCContribution(NewUnitState);
	NewUnitState.SkillLevelBonus += 1;

	if (NewXComHQ.HealingRate < NewXComHQ.XComHeadquarters_BaseHealRate)
	{
		NewXComHQ.HealingRate = NewXComHQ.XComHeadquarters_BaseHealRate;
	}
}

static function bool ShouldDisplayAWCEngToDoWarning(StateObjectReference SlotRef)
{
	local XComGameState_HeadquartersXCom XComHQ;
	
	XComHQ = class'UIUtilities_Strategy'.static.GetXComHQ();

	return (XComHQ.GetNumberOfInjuredSoldiers() > 0);
}

static function string GetAWCBonusDisplayString(XComGameState_StaffSlot SlotState, optional bool bPreview)
{
	local string Contribution;

	if (SlotState.IsSlotFilled())
	{
		Contribution = string(GetAWCAvengerBonus(SlotState.GetAssignedStaff(), bPreview));
	}

	return GetBonusDisplayString(SlotState, "%AVENGERBONUS", Contribution);
}